# 80+ Python Projects by MRayan Asim 🐍🚀

<p align="center">
  <img src="https://github.com/mrayanasim09/python-projects/raw/main/MRayan.png" alt="My Logo" style="max-width: 100%; max-height: 100%;">
</p>

## Table of Contents

- [Repository Structure 📂](#repository-structure-)
- [Categories 🗂️](#categories-%EF%B8%8F)
- [Projects 🔥](#projects-)
  - [*GUI 🖥️*](#gui-️)
  - [*Calculator 🧮*](#calculator-)
  - [*Games 🎮*](#games-)
  - [*Machine Learning 🤖📚🧠*](#machine-learning-)
  - [*Utilities 🛠️*](#utilities-️)
- [Skill Level Tags ⭐](#skill-level-tags-)
- [Installation ⚙️](#installation-️)
- [About the Author 👤](#about-the-author-)
- [License 📝](#license-)
- [Note 📌](#note-)
- [FAQ 🗒️](#frequently-asked-questions-faq-%EF%B8%8F)

**🚀 Welcome to the mesmerizing realm of the Python Projects repository, curated by MRayan Asim! Get ready to embark on an exhilarating coding odyssey, where a trove of captivating Python creations awaits to inspire and empower developers of all levels. Whether you're taking your first coding steps or you're a seasoned programmer crafting intricate algorithms, this repository serves as your gateway to a world of endless possibilities. Discover gems that boost your resume's brilliance and engage in student projects that foster learning. Uncover a wealth of resources, expert guidance, and hands-on code examples that breathe life into your Python-based projects. Join us on this thrilling journey as we unveil the extraordinary potential of Python together! 💡🔥**

<p align="center">
  <a href="https://forms.gle/SzJ4VA1zWZ3ehqGC6">
    <img src="https://img.shields.io/badge/Google%20Forms-Give%20Your%20Feedback-red?style=for-the-badge&logo=google-forms" alt="Give me your feedback">
  </a>
</p>

## Repository Structure 📂

The repository is organized into different categories, each containing specific project folders. This structure allows for easy navigation and helps you find projects that align with your interests. Each project is tagged with appropriate labels to indicate the recommended skill level. Let's take a look at the categories available:

## Categories 🗂️

* [GUI](https://github.com/drik493/python\_projects/tree/main/GUI) 🖥️
* [Calculator](https://github.com/drik493/python\_projects/tree/main/Calculator) 🧮
* [Games](https://github.com/drik493/python\_projects/tree/main/Game) 🎮
* [Machine learning](https://github.com/mrayanasim09/python-projects/tree/main/machine\_learning) 🤖📚🧠
* [Utilities](https://github.com/drik493/python\_projects/tree/main/Utilities) 🛠️

## Projects 🔥

Explore the projects in each category to find detailed information, documentation, and code examples. Here's a glimpse of the projects available within each category:

## *GUI 🖥️*

* [Form](https://github.com/drik493/python\_projects/blob/main/GUI/Form.py) 📝
* [A basic GUI calculator](https://github.com/drik493/python\_projects/blob/main/GUI/A\_basic\_gui\_calculator.py) 🧮
* [A working GUI clock also download the clock image](GUI/clock.py) 🕤
* [Tick cross (with GUI) ](GUI/tick\_cross.py)✔️❌
* [Todo list (with GUI)](GUI/todo.py) ✅📝
* [Notepad](https://github.com/drik493/python\_projects/blob/main/GUI/notepad.py) 📄
* [A snake and ladder game ](GUI/snake\_ladder.py)and [(also download the images with it)](GUI/ezgif-5-ad15f112d4.gif) 🐍🪜
* [A paint application](GUI/paint.py)🖌️🎨
* [A file explorer](GUI/file\_explorer.py) 📂🔎
* [Youtube video downloader](GUI/youtube\_download.py) 📺🔽💾
* [spelling correction](GUI/spelling.py) 🔤📏🔍
* [Figet spinner (use it on windows with space bar)](GUI/spinner.py) ߷
* [A beautiful design using turtle](GUI/graphics.py) 🐢🎨
* [A quiz application for asking common questions ](https://github.com/mrayanasim09/python-projects/blob/main/GUI/Quiz.py) 👉📜
* [Pikachu using turtle](GUI/Pikachu.py) (っ◔◡◔)っ
* [Doraemon using turtle](GUI/doramon.py)🐱‍🚀
* [Rainbow with turtle ](GUI/rainbow.py)🌈
* [A happy birthday message to the user with its name](GUI/happy\_birth\_day.py)🎂
* [Search installed applications](GUI/search\_applications.py) 🔍
* [A GUI calendar ](GUI/clender.py)📅

## *Calculator 🧮*

* [Quadratic Equation (with graph)](https://github.com/drik493/python\_projects/blob/main/Calculator/Quadratic\_Equation.py) 📈
* [A mega calculator with all operations](https://github.com/drik493/python\_projects/blob/main/Calculator/mega\_calculator.py) 🖩
* [A stock analyzer with its short form](Calculator/stock.py) 💵📊📈
* [Number base converter](https://github.com/drik493/python\_projects/blob/main/Calculator/number\_base.py) 🔢
* [Integration and differentiation](https://github.com/drik493/python\_projects/blob/main/Calculator/int\_diff.py) ∫
* [BMI calculator](https://github.com/drik493/python\_projects/blob/main/Calculator/bmi.py) 🏋️
* [Roman number convertor to decimal number](Calculator/roman\_number.py) 🧠
* [Time calculator](https://github.com/mrayanasim09/python-projects/blob/main/Calculator/time_calulator.py) ☀️🌙
* [special theory of relativity calculator](Calculator/special\_relativity\_calculator.py) ⌛📏⚡
* [Collatz Conjecture (3x+1) (with GUI)](https://github.com/drik493/python\_projects/blob/main/Calculator/conject.py) 📐
* [Fibonacci sequence](https://github.com/drik493/python\_projects/blob/main/Calculator/sequence.py) 🐇
* [Graph calculator from equation (with graph)](https://github.com/drik493/python\_projects/blob/main/Calculator/graph.py) 📊
* [Montly Mortgage calculator](Calculator/Mortgage.py) 📈💴
* [12 hour time into 24 hour time](Calculator/12\_to\_24.py) 🕰️🕛
* [Grade calculator](https://github.com/drik493/python\_projects/blob/main/Calculator/grade.py) 🎓
* [Sudoku solver](https://github.com/drik493/python\_projects/blob/main/Calculator/sudukko.py) 🧩
* [A program to find the ASCII value of characters](Calculator/ASCII%20.py) 💻🔧

## *Games 🎮*

* [2048 game (without GUI)](https://github.com/drik493/python\_projects/blob/main/Game/2048.py) 🎲
* [Snake game (with GUI)](https://github.com/drik493/python\_projects/blob/main/Game/snake\_game.py) 🐍
* [Hangman](https://github.com/drik493/python\_projects/blob/main/Game/hangman.py) 🪓
* [Colox (a box colliding game with GUI)](Game/colox.py) 📦❄️
* [A color guessing game with GUI](Game/color\_guessing.py) 🎨🔍🌈
* [Master Mind](https://github.com/drik493/python\_projects/blob/main/Game/master\_mid.py) 🔐
* [A number details (prime, odd, co-prime, etc)](https://github.com/drik493/python\_projects/blob/main/Game/number\_details.py) 🔢
* Tick cross [(with GUI)](https://github.com/drik493/python\_projects/blob/main/Game/tick\_cross.py) or [(without GUI)](Game/tick\_cross\_gui.py) ❌⭕
* [Rock, paper, and scissors (without GUI)](https://github.com/drik493/python\_projects/blob/main/Game/rock,paper,scissors.py) ✊🖐✌️
* [A snake and ladder game ](Game/snake\_ladder.py)and [(also download the images with it)](Game/ezgif-5-ad15f112d4.gif) 🐍🪜
* [21 or 20 plus game](https://github.com/drik493/python\_projects/blob/main/Game/21.py) 🃏
* [Typing speed test](Game/typing\_speed.py) 🎮
* [Star patterns (7 types of patterns)](https://github.com/drik493/python\_projects/blob/main/Game/star.py) ✨
* [Dice rolling (With user guess without GUI)](https://github.com/drik493/python\_projects/blob/main/Game/dice.py) 🎲
* [Number guessing game](https://github.com/drik493/python\_projects/blob/main/Game/number\_guessing.py) 🔢❓

## *Machine Learning 🤖📚🧠*

* [Brightness controller with your hand](machine\_learning/brightness\_controllor.py) 🌞💡🎛️
* [Eye blink detection (also download the . XML files)](machine\_learning/eye\_blink.py) 👁️🔍😴
* [Text to speech](machine\_learning/text\_to\_speech.py) 🔤🔉
* [A language detector ](machine\_learning/lang\_dect.py)🔍🌐
* [A spam message delectation using machine learning ](machine\_learning/spam\_dect.py)🎁🎉🎈
* [Crypto price predictions (for days ahead of days entered by the user)](machine\_learning/crypto\_prices.py) 🚀🌕
* [Gold price predictions (for days ahead of days entered by the user)](machine\_learning/gold\_price.py) 💰🪙
* [Your phone camera on your PC ](machine\_learning/camera.py)you can check more about it [here](https://www.makeuseof.com/tag/ip-webcam-android-phone-as-a-web-cam/) 📱💻📸
* [A sentiments checker](machine\_learning/sentiments.py) 🤔💬💭
* [A sketch maker of image ](machine\_learning/sketch.py)🖌️

## *Utilities 🛠️*

* [Network passwords (only for the networks you have been connected to)](https://github.com/drik493/python\_projects/blob/main/Utilities/network.py) 🔐
* [Your own browser](Utilities/browser.py) 🌐
* [A site connection checker and timer](https://github.com/mrayanasim09/python-projects/blob/main/Utilities/connectivity.py) 🔗🌐
* [Count down (timer)](https://github.com/drik493/python\_projects/blob/main/Utilities/count\_down.py) ⏳
* [Tells basic information of an Instagram account only from user name](Utilities/inta.py) 📸
* [Transfer file (generate QR code for easy access)](https://github.com/drik493/python\_projects/blob/main/Utilities/transfer.py) 📁
* [Google search (from terminal)](https://github.com/drik493/python\_projects/blob/main/Utilities/google.py) 🔍
* [A password manager with a master key and encryption and decryption of passwords](Utilities/password\_manager.py) 🔐
* [bitcoin mining simulator](Utilities/btc.py) ₿
* [QR code generator](https://github.com/drik493/python\_projects/blob/main/Utilities/url.py) 🔗
* [Wattsapp spam messages sender (you should click on the message bar of WhatsApp after running it)](Utilities/whatsapp\_spam.py) 📧🔁📧🔁📧🔁
* [Github repository details finder (only with username and name of the repository)](Utilities/github.py) :octocat:
* [Secret code generator (with decoding support)](https://github.com/drik493/python\_projects/blob/main/Utilities/secret\_code.py) 🤐
* [Password to hash form (md5)](https://github.com/drik493/python\_projects/blob/main/Utilities/password\_hash.py) 🔒
* [Hash password cracking (md5 only, using rockyou.txt)](https://github.com/drik493/python\_projects/blob/main/Utilities/password.py) 🚫🔍
* [Password generator](https://github.com/drik493/python\_projects/blob/main/Utilities/passwrd\_generator.py) 🔐🔢
* [Birth Day Finder (also zodiac sign, life path number, your birth date according to Islam and birthstone and birth flower)](https://github.com/drik493/python\_projects/blob/main/Utilities/birthday.py) 🎂🎉
* [words and letter count of given text](Utilities/word\_count.py) 🔢🔄️
* [A program to make short forms for the entered words](Utilities/short\_form.py) 🔤🔄

## Skill Level Tags ⭐

Projects are labeled with the following tags to help you identify their recommended skill level:

* Beginner: Suitable for beginners who are new to Python programming. 🌱
* Intermediate: Projects that require a moderate level of Python programming knowledge. 🚀
* Advanced: Projects that involve advanced concepts and techniques in Python. 🧠

## Installation ⚙️

we used these packages in our repository:

* Pygame 🎮
* Tkinter 🖼️
* GoogleSearch 🔍
* qrcode 📷
* Matplotlib 📊
* yfinance 💵📈
* Turtle 🐢
* Random 🎲
* Time ⏰
* Pillow 🖼️
* NumPy 🔢
* openpyxl 📄
* Datetime ⌚
* math ➗
* requests 🌐
* hijri\_converter 🌙
* threading 🧵
* instaloader 📥
* string 🔡
* hashlib 🔒
* socketserver 🖧
* socket 🧦
* http.server 🌐
* os 🖥️
* opencv 📷👁️
* langdetect 🌍
* sys 🔄💻
* json 🧩📄🔍
* re 🧩
* pyshorteners 🧹
* PyQt5 🐍🖼️🔌
* PyQtWebEngine: 🕸️🖼️🔌
* Panda 🐼🎉🐾
* textblob 📝📊🔍
* vaderSentiment 🤖💭📈
* pyttsx3 🔊🗣️
* winapps 👁️📂
* pytube 📼
* screen-brightness-control 🌞🖥️🔆
* pyautogui 📦🔧💻🐍
* mediapipe 🎥📡🤝
* prophet 🔮📈
* seaborn 📊🌈

You can install these packages using pip, the Python package manager. Open your terminal or command prompt and run the following commands:

```shell
pip install pygame
pip install googlesearch-python
pip install qrcode
pip install pyautogui
pip install pyttsx3
pip install winapps
pip install matplotlib
pip install tkcalendar
pip install pyqt5
pip install pyqtwebengine
pip install yfinance
pip install pillow
pip install openpyxl
pip install sympy
pip install pytube
pip install hijri_converter
pip install requests
pip install instaloader
pip install opencv-python
pip install textblob
pip install vaderSentiment
pip install langdetect
pip install screen-brightness-control
pip install numpy
pip install prophet
pip install seaborn
pip install mediapipe  
pip install pyshorteners
```

### *To view more details on how to use this repository you can go* [_**here**_](How\_to\_use.md)

If you encounter any issues running the code, please report an issue, and I will respond as quickly as possible. 🐞

# About the Author 👤

MRayan Asim maintains this repository. As a passionate Python enthusiast, MRayan Asim is dedicated to developing practical and innovative projects. Whether you're a beginner or an experienced developer, MRayan Asim strives to provide projects that cater to various skill levels. If you have any questions or suggestions regarding the projects in this repository, feel free to reach out. 🚀\
[![Join our Discord](https://img.shields.io/badge/Join%20our%20Discord-7289DA?style=flat\&logo=discord\&logoColor=white)](https://discord.gg/uRfXYjub) [![Join Our Reddit Community](https://img.shields.io/badge/Join%20the%20Community-Reddit-orange)](https://www.reddit.com/r/Python\_projects\_rayan/) [![Email](https://img.shields.io/badge/Email-mrayanasim09%40gmail.com-%23D14836?logo=gmail)](mailto:mrayanasim09@gmail.com) [![LinkedIn](https://img.shields.io/badge/LinkedIn-View%20Profile-blue?logo=linkedin)](https://www.linkedin.com/in/mrayan-asim-044836275/) [![GitHub](https://img.shields.io/badge/GitHub-mrayanasim09-blue?logo=github)](https://github.com/mrayanasim09)

### *If you are thinking about how to start learning programming so you can check out my* [_roadmap on medium_](https://mrayanasim09.medium.com/how-to-start-learning-programming-from-beginners-to-advance-14248dcc7afa)

# License 📝

### *⚠️ DISCLAIMER: For educational purposes only. Code provided under* [![MIT License](https://img.shields.io/badge/License-MIT-blue.svg)](LICENSE/) ⚖️

# **Note 📌**

#### Feeling inspired to be a part of our dynamic community? Begin your journey by familiarizing yourself with our [**Code of Conduct**](code\_of\_conduct.md). We believe in a supportive and inclusive environment where everyone can thrive.

#### Ready to make your mark on our projects? Check out our [**How to Contribute**](CONTRIBUTING.md) guide, and embark on your coding adventure with us!

#### Excited to play a vital role in securing our projects? Explore the essential steps and best practices in our [**Security Policies**](SECURITY.md) to safeguard our coding community. Join hands with us on this crucial mission!

#### Discover a treasure trove of Python projects! From GUIs to machine learning, this repository offers many practical code examples and resources. **[Check out the summary](summary.md)** to explore our diverse collection and embark on your coding adventure with us!

###  🔍 To view the requirements for the system and Python version, you can check out the [prerequisites](https://github.com/mrayanasim09/python-projects/blob/main/prerequisites.md) 📋

# Frequently Asked Questions (FAQ) 🗒️

## *For common questions and troubleshooting tips, please check our [FAQ](FAQ.md)*

### *Remember, the world of coding is full of wonders, and your journey starts right here! 🌟*

# 🌟 **Sponsor Me and Fuel My Creativity** 🌟

If you find my Python projects valuable and would like to show your support, consider sponsoring me! Your generous contribution empowers me to continue developing innovative and practical projects for the coding community. A simple gesture like buying me a coffee goes a long way in keeping me fueled for more coding sessions. ☕️ 

<p align="center">
  <a href="https://www.buymeacoffee.com/mrayanasim" target="_blank">
    <img src="https://cdn.buymeacoffee.com/buttons/v2/default-yellow.png" alt="Buy Me A Coffee" height="50px">
  </a>
</p>

💎 For those who prefer cryptocurrency, you can send some Ether (ETH) to my Ethereum wallet address: _**0xEC55fFf7a8387eeaa0Ef886305350Ab3578CE5D3**_. Your sponsorship means the world to me and serves as a powerful motivation to keep creating exciting Python projects for everyone to enjoy. 🚀🐍

🙏 Thank you for your incredible support! Your contributions inspire me to reach new heights and make a positive impact in the coding community. Let's create something amazing together! 🌟

![GitHub code size in bytes](https://img.shields.io/github/languages/code-size/mrayanasim09/python-projects)    ![GitHub repo size](https://img.shields.io/github/repo-size/mrayanasim09/python-projects)    ![GitHub top language](https://img.shields.io/github/languages/top/mrayanasim09/python-projects)    ![GitHub contributors](https://img.shields.io/github/contributors-anon/mrayanasim09/python-projects)    ![Visitors](https://api.visitorbadge.io/api/visitors?path=https%3A%2F%2Fgithub.com%2Fmrayanasim09%2Fpython-projects\&label=Views\&countColor=%23555555\&style=flat-square)    [![codebeat badge](https://codebeat.co/badges/6fdc6dd9-f8b4-4af7-82bf-5dfc44c69273)](https://codebeat.co/projects/github-com-mrayanasim09-python-projects-main)    [![CodeFactor](https://www.codefactor.io/repository/github/mrayanasim09/python-projects/badge)](https://www.codefactor.io/repository/github/mrayanasim09/python-projects)    [![DeepSource](https://app.deepsource.com/gh/mrayanasim09/python-projects.svg/?label=active+issues&show_trend=true&token=R4sWBGxzRPv6AjY4YoLiE-wT)](https://app.deepsource.com/gh/mrayanasim09/python-projects/?ref=repository-badge)    [![Backup Status](https://cloudback.it/badge/mrayanasim09/python-projects)](https://cloudback.it)  ![GitHub last commit (branch)](https://img.shields.io/github/last-commit/mrayanasim09/python-projects/main)    ![GitHub commit activity (branch)](https://img.shields.io/github/commit-activity/w/mrayanasim09/python-projects/main)    ![GitHub release (with filter)](https://img.shields.io/github/v/release/mrayanasim09/python-projects)

## *To View full Documentations you can go  [here](https://mrayans.gitbook.io/python--projects/)*

<script src="//code.tidio.co/ytw5wbhm91dwsvp9mv9gdiob6za99eer.js" async></script>

<script src="https://cdn.ingest-lr.com/LogRocket.min.js" crossorigin="anonymous"></script>
<script>window.LogRocket && window.LogRocket.init('93y3w1/python-projects');</script>


