# coding: utf-8

"""
    42videobricks

    42videobricks is a Video Platform As A Service (VPaaS)

    The version of the OpenAPI document: 1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist, constr, validator

class Webhook(BaseModel):
    """
    Webhook Object  # noqa: E501
    """
    url: constr(strict=True, max_length=2048) = Field(..., description="Url of the application wich is receiving Notifications")
    token: Optional[constr(strict=True, max_length=256)] = Field(None, description="Optionnal Secret token to validate notifications. Sent with the request in the X-Vpass-Token HTTP header.")
    event_type: conlist(StrictStr, unique_items=True) = Field(..., alias="eventType", description="List of event to be notified:   * VIDEO_STATUS: Get Video object status modification notifications   Status values: REQUESTED, CREATED, TRANSCODING, AVAILABLE, DELETED   * VIDEO_TRANSCODING_PROGRESS: Get transcoding progression notifications")
    id: StrictStr = Field(..., description="id of the webhook")
    ctime: Optional[StrictInt] = Field(None, description="Creation date (timestamp)")
    mtime: Optional[StrictInt] = Field(None, description="Modification date (timestamp)")
    __properties = ["url", "token", "eventType", "id", "ctime", "mtime"]

    @validator('event_type')
    def event_type_validate_enum(cls, value):
        """Validates the enum"""
        for i in value:
            if i not in ('VIDEO_STATUS', 'VIDEO_TRANSCODING_PROGRESS'):
                raise ValueError("each list item must be one of ('VIDEO_STATUS', 'VIDEO_TRANSCODING_PROGRESS')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Webhook:
        """Create an instance of Webhook from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Webhook:
        """Create an instance of Webhook from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Webhook.parse_obj(obj)

        _obj = Webhook.parse_obj({
            "url": obj.get("url"),
            "token": obj.get("token"),
            "event_type": obj.get("eventType"),
            "id": obj.get("id"),
            "ctime": obj.get("ctime"),
            "mtime": obj.get("mtime")
        })
        return _obj


