# coding: utf-8

"""
    42videobricks

    42videobricks is a Video Platform As A Service (VPaaS)

    The version of the OpenAPI document: 1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr

class DataVideoUsage(BaseModel):
    """
    Video Usage KPIs  # noqa: E501
    """
    month_id: StrictStr = Field(..., alias="monthId", description="month of the kpis")
    transcoding: Union[StrictFloat, StrictInt] = Field(..., description="total of transcoding second since the begining of the month")
    hosting: Union[StrictFloat, StrictInt] = Field(..., description="total of hosting second since the begining of the month")
    delivery: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="total of delivery (stream) second since the begining of the month")
    drm: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="total of delivery (stream) second since the begining of the month")
    __properties = ["monthId", "transcoding", "hosting", "delivery", "drm"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DataVideoUsage:
        """Create an instance of DataVideoUsage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DataVideoUsage:
        """Create an instance of DataVideoUsage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DataVideoUsage.parse_obj(obj)

        _obj = DataVideoUsage.parse_obj({
            "month_id": obj.get("monthId"),
            "transcoding": obj.get("transcoding"),
            "hosting": obj.get("hosting"),
            "delivery": obj.get("delivery"),
            "drm": obj.get("drm")
        })
        return _obj


