# coding: utf-8

"""
    42videobricks

    42videobricks is a Video Platform As A Service (VPaaS)

    The version of the OpenAPI document: 1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist, constr, validator
from Api42Vb.models.video_assets import VideoAssets

class Video(BaseModel):
    """
    Video Object  # noqa: E501
    """
    title: Optional[constr(strict=True, max_length=256)] = Field(None, description="title of the video")
    description: Optional[constr(strict=True, max_length=2048)] = Field(None, description="description of the video")
    public: Optional[StrictBool] = Field(None, description="Define if the video is public (it can be accessible by anybody with the video url). Default = tue")
    tags: Optional[conlist(StrictStr)] = Field(None, description="tags list linked to video")
    id: StrictStr = Field(..., description="id of the video (null when adding a new video)")
    status: Optional[StrictStr] = Field(None, description="Status of the video : * 'REQUESTED': video as been submited, waiting for its creation * 'CREATED': video has been created and file can be uploaded          * 'TRANSCODING': video is unvailable because still in the creation  & in encoding process * 'AVAILABLE': video is ready to be stream")
    duration: Optional[StrictInt] = Field(None, description="video duration in second")
    ctime: Optional[StrictInt] = Field(None, description="Creation date (timestamp)")
    mtime: Optional[StrictInt] = Field(None, description="Modification date (timestamp)")
    assets: Optional[VideoAssets] = None
    metas: Optional[Dict[str, Any]] = Field(None, description="metas data  free-form object: refere to the documentation")
    __properties = ["title", "description", "public", "tags", "id", "status", "duration", "ctime", "mtime", "assets", "metas"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('REQUESTED', 'CREATED', 'TRANSCODING', 'AVAILABLE'):
            raise ValueError("must be one of enum values ('REQUESTED', 'CREATED', 'TRANSCODING', 'AVAILABLE')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Video:
        """Create an instance of Video from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of assets
        if self.assets:
            _dict['assets'] = self.assets.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Video:
        """Create an instance of Video from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Video.parse_obj(obj)

        _obj = Video.parse_obj({
            "title": obj.get("title"),
            "description": obj.get("description"),
            "public": obj.get("public"),
            "tags": obj.get("tags"),
            "id": obj.get("id"),
            "status": obj.get("status"),
            "duration": obj.get("duration"),
            "ctime": obj.get("ctime"),
            "mtime": obj.get("mtime"),
            "assets": VideoAssets.from_dict(obj.get("assets")) if obj.get("assets") is not None else None,
            "metas": obj.get("metas")
        })
        return _obj


