# coding: utf-8

"""
    42videobricks

    42videobricks is a Video Platform As A Service (VPaaS)

    The version of the OpenAPI document: 1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class VideoAssets(BaseModel):
    """
    Video Assets Object  # noqa: E501
    """
    thumbnail: Optional[StrictStr] = Field(None, description="Url of the video thumbnail (cann be empty ?)")
    player: Optional[StrictStr] = Field(None, description="Url to the video player code")
    stream: Optional[StrictStr] = Field(None, description="Url to the video player stream")
    iframe: Optional[StrictStr] = Field(None, description="html code to integrate the player in an iframe")
    __properties = ["thumbnail", "player", "stream", "iframe"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VideoAssets:
        """Create an instance of VideoAssets from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VideoAssets:
        """Create an instance of VideoAssets from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VideoAssets.parse_obj(obj)

        _obj = VideoAssets.parse_obj({
            "thumbnail": obj.get("thumbnail"),
            "player": obj.get("player"),
            "stream": obj.get("stream"),
            "iframe": obj.get("iframe")
        })
        return _obj


