# coding: utf-8

"""
    42videobricks

    42videobricks is a Video Platform As A Service (VPaaS)

    The version of the OpenAPI document: 1.2
    Contact: code@42videobricks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List
from pydantic import BaseModel, StrictStr
from pydantic import Field
from Api42Vb.models.video_multipart_upload_finalize_parts_inner import VideoMultipartUploadFinalizePartsInner
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class VideoMultipartUploadFinalize(BaseModel):
    """
    Video Multipart upload finalization
    """ # noqa: E501
    file_id: StrictStr = Field(description="file id", alias="fileId")
    file_key: StrictStr = Field(description="file key", alias="fileKey")
    parts: List[VideoMultipartUploadFinalizePartsInner]
    __properties: ClassVar[List[str]] = ["fileId", "fileKey", "parts"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of VideoMultipartUploadFinalize from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in parts (list)
        _items = []
        if self.parts:
            for _item in self.parts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['parts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of VideoMultipartUploadFinalize from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fileId": obj.get("fileId"),
            "fileKey": obj.get("fileKey"),
            "parts": [VideoMultipartUploadFinalizePartsInner.from_dict(_item) for _item in obj.get("parts")] if obj.get("parts") is not None else None
        })
        return _obj


