# coding: utf-8

"""
    42videobricks

    42videobricks is a Video Platform As A Service (VPaaS)

    The version of the OpenAPI document: 1.2
    Contact: code@42videobricks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr, field_validator
from pydantic import Field
from typing_extensions import Annotated
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class Webhook(BaseModel):
    """
    Webhook Object
    """ # noqa: E501
    url: Annotated[str, Field(strict=True, max_length=2048)] = Field(description="Url of the application wich is receiving Notifications")
    token: Optional[Annotated[str, Field(strict=True, max_length=256)]] = Field(default=None, description="Optionnal Secret token to validate notifications. Sent with the request in the X-Vpass-Token HTTP header.")
    event_type: List[StrictStr] = Field(description="List of event to be notified:   * VIDEO_STATUS: Get Video object status modification notifications   Status values: REQUESTED, CREATED, TRANSCODING, TRANSCODING_ERROR, AVAILABLE, DELETED   * VIDEO_TRANSCODING_PROGRESS: Get transcoding progression notifications", alias="eventType")
    id: StrictStr = Field(description="id of the webhook")
    ctime: Optional[StrictInt] = Field(default=None, description="Creation date (timestamp)")
    mtime: Optional[StrictInt] = Field(default=None, description="Modification date (timestamp)")
    __properties: ClassVar[List[str]] = ["url", "token", "eventType", "id", "ctime", "mtime"]

    @field_validator('event_type')
    def event_type_validate_enum(cls, value):
        """Validates the enum"""
        for i in value:
            if i not in ('VIDEO_STATUS', 'VIDEO_TRANSCODING_PROGRESS'):
                raise ValueError("each list item must be one of ('VIDEO_STATUS', 'VIDEO_TRANSCODING_PROGRESS')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Webhook from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of Webhook from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "token": obj.get("token"),
            "eventType": obj.get("eventType"),
            "id": obj.get("id"),
            "ctime": obj.get("ctime"),
            "mtime": obj.get("mtime")
        })
        return _obj


