# coding: utf-8

"""
    42videobricks

    42videobricks is a Video Platform As A Service (VPaaS)

    The version of the OpenAPI document: 1.2
    Contact: code@42videobricks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional, Union
from pydantic import BaseModel, StrictFloat, StrictInt, StrictStr
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DataVideoUsage(BaseModel):
    """
    Video Usage KPIs
    """ # noqa: E501
    date_key: Optional[StrictStr] = Field(default=None, description="Date of the kpis.  Format:  - day:YYYY-MM-DD (2023-10-16) - week: YYYY-Www (2023-W42) - month: YYYY-MM (2023-10)", alias="dateKey")
    interval: Optional[StrictStr] = Field(default=None, description="Unit of the period (day|month|week)")
    transcoding: Union[StrictFloat, StrictInt] = Field(description="total of transcoding second since the begining of the month")
    hosting: Union[StrictFloat, StrictInt] = Field(description="total of hosting second since the begining of the month")
    delivery: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="total of delivery (stream) second since the begining of the month")
    drm: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="total of delivery (stream) second since the begining of the month")
    __properties: ClassVar[List[str]] = ["dateKey", "interval", "transcoding", "hosting", "delivery", "drm"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DataVideoUsage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DataVideoUsage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dateKey": obj.get("dateKey"),
            "interval": obj.get("interval"),
            "transcoding": obj.get("transcoding"),
            "hosting": obj.get("hosting"),
            "delivery": obj.get("delivery"),
            "drm": obj.get("drm")
        })
        return _obj


