import uuid
from typing import Union

from ..utils.service_provider import ServiceProvider
from ..utils.services_list import Services


class PracticeService:
    SERVICE = Services.practice

    def __init__(self, service_provider: ServiceProvider):
        self.service_provider = service_provider

    def get_expert(
            self,
            expert_id: Union[uuid.UUID, None] = None,
            user_id: Union[uuid.UUID, None] = None
    ) -> dict:
        if expert_id is None and user_id is None:
            raise ValueError("Either expert_id or user_id must be provided")
        if expert_id is not None and user_id is not None:
            raise ValueError(
                "Only one of expert_id or user_id should be provided")

        if expert_id is not None:
            request_path = f"/experts/{str(expert_id)}"
        else:
            request_path = f"/experts/by_user_id/{str(user_id)}"

        return self.service_provider.fetch_data(
            service=self.SERVICE,
            request_path=request_path
        )
