# a360-python-libraries

Python shared libraries for a360 applications

## License
This software is proprietary and is intended solely for use by Aesthetics-360 Inc.. Unauthorized use, distribution, or modification of this software outside of Aesthetics-360 Inc. is strictly prohibited.

## Add package into your project

```bash
poetry add a360-python-libraries
```

## Usage

* 🔒 Security
  * [Role based access control](docs/a360_security/role-based-access-control.md)
  * [User valid practice dependency](docs/a360_security/user-valid-practice-dependency.md)
  * [User dependency](docs/a360_security/user-dependency.md)
  * [Client platform](docs/a360_security/client-platform.md)
* ⚙️ Services
  * [Dictionary service](docs/a360_services/dict/home.md)
    * [Geolocation data](docs/a360_services/dict/geo.md)
    * [Allergies](docs/a360_services/dict/allergies.md)
    * [Medical Conditions](docs/a360_services/dict/allergies.md)
    * [Tags Global Library](docs/a360_services/dict/tags.md)
    * [Services Global Library](docs/a360_services/dict/services.md)
    * [Products Global Library](docs/a360_services/dict/products.md)
    * [Visit Workflows Global Library](docs/a360_services/dict/visit_workflows.md)
  * [Practice service](docs/a360_services/practice/home.md)
    * [Experts](docs/a360_services/practice/experts.md)
    * [Practices](docs/a360_services/practice/practices.md)
  * [Patient service](docs/a360_services/practice/home.md)
    * [Patients](docs/a360_services/patient/patients.md)
    * [Visits](docs/a360_services/patient/visits.md)
    * [Attachments](docs/a360_services/patient/attachments.md)
* 📧 Notification
  * [Email notification](docs/a360_notification/email-notification.md)
* 🔧 Utils
  * [Image tools](docs/a360_utils/image_tools.md)
