# aas-python-http-client
Mostly generated python client for AAS API based on models from [Basyx-Python-SDK](https://github.com/eclipse-basyx/basyx-python-sdk). 

All APIs of the Specification of the [Specification of the Asset Administration Shell: Part 2](http://industrialdigitaltwin.org/en/content-hub) in one collection. 

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: V3.0.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

You can install the python package directly from Github

```sh
pip install aas-python-http-client
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/rwth-iat/aas-python-http-client.git`)

Then import the package:

```python
import aas_python_http_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:

```python
import aas_python_http_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from aas_python_http_client import ApiClient, Configuration, AssetAdministrationShellRepositoryAPIApi,
    SubmodelRepositoryAPIApi
from aas_python_http_client.util import string_to_base64url
from basyx.aas import model

configuration = Configuration()
configuration.host = "http://localhost:8080/api/v3.0"

api_client = ApiClient(configuration=configuration)

aasRepoClient = AssetAdministrationShellRepositoryAPIApi(api_client=api_client)

# query all asset administration shells
all_aas = aasRepoClient.get_all_asset_administration_shells().result
print(all_aas)

# query specific asset administration shell
aas = aasRepoClient.get_asset_administration_shell_by_id(
    string_to_base64url('https://acplt.org/Test_AssetAdministrationShell'))
print(aas)

# query asset information
aas_info = aasRepoClient.get_asset_information_aas_repository(
    string_to_base64url('https://acplt.org/Test_AssetAdministrationShell'))
print(aas_info)

# create a new asset administration shell
new_aas = model.AssetAdministrationShell(aas_info, "https://acplt.org/Test_AAS")
aasRepoClient.post_asset_administration_shell(new_aas)

submodelRepoClient = SubmodelRepositoryAPIApi(api_client=api_client)

# query all submodels
all_submodels = submodelRepoClient.get_all_submodels().result
print(all_submodels)

# modify a submodel
test_submodel = all_submodels[0]
test_submodel.id_short = "Test123"
submodelRepoClient.put_submodel_by_id(test_submodel, string_to_base64url(test_submodel.id))

# delete a submodel
submodelRepoClient.delete_submodel_by_id(string_to_base64url(test_submodel.id))

# create a new submodel
new_submodel = model.Submodel("https://acplt.org/TestSubmodel")
submodelRepoClient.post_submodel(new_submodel)


```

## Documentation for API Endpoints

All URIs are relative to *{protocol}://{host_name}:{port}/api/{version_prefix}*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AASXFileServerAPIApi* | [**delete_aasxby_package_id**](docs/AASXFileServerAPIApi.md#delete_aasxby_package_id) | **DELETE** /packages/{packageId} | Deletes a specific AASX package from the server
*AASXFileServerAPIApi* | [**get_aasxby_package_id**](docs/AASXFileServerAPIApi.md#get_aasxby_package_id) | **GET** /packages/{packageId} | Returns a specific AASX package from the server
*AASXFileServerAPIApi* | [**get_all_aasx_package_ids**](docs/AASXFileServerAPIApi.md#get_all_aasx_package_ids) | **GET** /packages | Returns a list of available AASX packages at the server
*AASXFileServerAPIApi* | [**post_aasx_package**](docs/AASXFileServerAPIApi.md#post_aasx_package) | **POST** /packages | Stores the AASX package at the server
*AASXFileServerAPIApi* | [**put_aasxby_package_id**](docs/AASXFileServerAPIApi.md#put_aasxby_package_id) | **PUT** /packages/{packageId} | Updates the AASX package at the server
*AssetAdministrationShellAPIApi* | [**delete_file_by_path_aas**](docs/AssetAdministrationShellAPIApi.md#delete_file_by_path_aas) | **DELETE** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/attachment | Deletes file content of an existing submodel element at a specified path within submodel elements hierarchy
*AssetAdministrationShellAPIApi* | [**delete_submodel_by_id_aas**](docs/AssetAdministrationShellAPIApi.md#delete_submodel_by_id_aas) | **DELETE** /aas/submodels/{submodelIdentifier} | Deletes the submodel from the Asset Administration Shell.
*AssetAdministrationShellAPIApi* | [**delete_submodel_element_by_path_aas**](docs/AssetAdministrationShellAPIApi.md#delete_submodel_element_by_path_aas) | **DELETE** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath} | Deletes a submodel element at a specified path within the submodel elements hierarchy
*AssetAdministrationShellAPIApi* | [**delete_submodel_reference_by_id**](docs/AssetAdministrationShellAPIApi.md#delete_submodel_reference_by_id) | **DELETE** /aas/submodel-refs/{submodelIdentifier} | Deletes the submodel reference from the Asset Administration Shell. Does not delete the submodel itself!
*AssetAdministrationShellAPIApi* | [**delete_thumbnail**](docs/AssetAdministrationShellAPIApi.md#delete_thumbnail) | **DELETE** /aas/asset-information/thumbnail | 
*AssetAdministrationShellAPIApi* | [**get_all_submodel_elements_aas**](docs/AssetAdministrationShellAPIApi.md#get_all_submodel_elements_aas) | **GET** /aas/submodels/{submodelIdentifier}/submodel-elements | Returns all submodel elements including their hierarchy
*AssetAdministrationShellAPIApi* | [**get_all_submodel_elements_metadata_aas**](docs/AssetAdministrationShellAPIApi.md#get_all_submodel_elements_metadata_aas) | **GET** /aas/submodels/{submodelIdentifier}/submodel-elements/$metadata | Returns all submodel elements including their hierarchy
*AssetAdministrationShellAPIApi* | [**get_all_submodel_elements_path_aas**](docs/AssetAdministrationShellAPIApi.md#get_all_submodel_elements_path_aas) | **GET** /aas/submodels/{submodelIdentifier}/submodel-elements/$path | Returns all submodel elements including their hierarchy
*AssetAdministrationShellAPIApi* | [**get_all_submodel_elements_reference_aas**](docs/AssetAdministrationShellAPIApi.md#get_all_submodel_elements_reference_aas) | **GET** /aas/submodels/{submodelIdentifier}/submodel-elements/$reference | Returns all submodel elements as a list of References
*AssetAdministrationShellAPIApi* | [**get_all_submodel_elements_value_only_aas**](docs/AssetAdministrationShellAPIApi.md#get_all_submodel_elements_value_only_aas) | **GET** /aas/submodels/{submodelIdentifier}/submodel-elements/$value | Returns all submodel elements including their hierarchy in the ValueOnly representation
*AssetAdministrationShellAPIApi* | [**get_all_submodel_references**](docs/AssetAdministrationShellAPIApi.md#get_all_submodel_references) | **GET** /aas/submodel-refs | Returns all submodel references
*AssetAdministrationShellAPIApi* | [**get_asset_administration_shell**](docs/AssetAdministrationShellAPIApi.md#get_asset_administration_shell) | **GET** /aas | Returns a specific Asset Administration Shell
*AssetAdministrationShellAPIApi* | [**get_asset_administration_shell_reference**](docs/AssetAdministrationShellAPIApi.md#get_asset_administration_shell_reference) | **GET** /aas/$reference | Returns a specific Asset Administration Shell as a Reference
*AssetAdministrationShellAPIApi* | [**get_asset_information**](docs/AssetAdministrationShellAPIApi.md#get_asset_information) | **GET** /aas/asset-information | Returns the Asset Information
*AssetAdministrationShellAPIApi* | [**get_file_by_path_aas**](docs/AssetAdministrationShellAPIApi.md#get_file_by_path_aas) | **GET** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/attachment | Downloads file content from a specific submodel element from the Submodel at a specified path
*AssetAdministrationShellAPIApi* | [**get_operation_async_result_aas**](docs/AssetAdministrationShellAPIApi.md#get_operation_async_result_aas) | **GET** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/operation-results/{handleId} | Returns the Operation result of an asynchronous invoked Operation
*AssetAdministrationShellAPIApi* | [**get_operation_async_result_value_only_aas**](docs/AssetAdministrationShellAPIApi.md#get_operation_async_result_value_only_aas) | **GET** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/operation-results/{handleId}/$value | Returns the value of the Operation result of an asynchronous invoked Operation
*AssetAdministrationShellAPIApi* | [**get_operation_async_status_aas**](docs/AssetAdministrationShellAPIApi.md#get_operation_async_status_aas) | **GET** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/operation-status/{handleId} | Returns the Operation status of an asynchronous invoked Operation
*AssetAdministrationShellAPIApi* | [**get_submodel_aas**](docs/AssetAdministrationShellAPIApi.md#get_submodel_aas) | **GET** /aas/submodels/{submodelIdentifier} | Returns the Submodel
*AssetAdministrationShellAPIApi* | [**get_submodel_element_by_path_aas**](docs/AssetAdministrationShellAPIApi.md#get_submodel_element_by_path_aas) | **GET** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath} | Returns a specific submodel element from the Submodel at a specified path
*AssetAdministrationShellAPIApi* | [**get_submodel_element_by_path_metadata_aas**](docs/AssetAdministrationShellAPIApi.md#get_submodel_element_by_path_metadata_aas) | **GET** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$metadata | Returns the metadata attributes if a specific submodel element from the Submodel at a specified path
*AssetAdministrationShellAPIApi* | [**get_submodel_element_by_path_path_aas**](docs/AssetAdministrationShellAPIApi.md#get_submodel_element_by_path_path_aas) | **GET** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$path | Returns a specific submodel element from the Submodel at a specified path in the Path notation
*AssetAdministrationShellAPIApi* | [**get_submodel_element_by_path_reference_aas**](docs/AssetAdministrationShellAPIApi.md#get_submodel_element_by_path_reference_aas) | **GET** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$reference | Returns the Reference of a specific submodel element from the Submodel at a specified path in the ValueOnly representation
*AssetAdministrationShellAPIApi* | [**get_submodel_element_by_path_value_only_aas**](docs/AssetAdministrationShellAPIApi.md#get_submodel_element_by_path_value_only_aas) | **GET** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$value | Returns a specific submodel element from the Submodel at a specified path in the ValueOnly representation
*AssetAdministrationShellAPIApi* | [**get_submodel_metadata_aas**](docs/AssetAdministrationShellAPIApi.md#get_submodel_metadata_aas) | **GET** /aas/submodels/{submodelIdentifier}/$metadata | Returns the Submodel&#x27;s metadata elements
*AssetAdministrationShellAPIApi* | [**get_submodel_metadata_reference_aas**](docs/AssetAdministrationShellAPIApi.md#get_submodel_metadata_reference_aas) | **GET** /aas/submodels/{submodelIdentifier}/$reference | Returns the Submodel as a Reference
*AssetAdministrationShellAPIApi* | [**get_submodel_path_aas**](docs/AssetAdministrationShellAPIApi.md#get_submodel_path_aas) | **GET** /aas/submodels/{submodelIdentifier}/$path | Returns the Submodel&#x27;s metadata elements
*AssetAdministrationShellAPIApi* | [**get_submodel_value_only_aas**](docs/AssetAdministrationShellAPIApi.md#get_submodel_value_only_aas) | **GET** /aas/submodels/{submodelIdentifier}/$value | Returns the Submodel&#x27;s ValueOnly representation
*AssetAdministrationShellAPIApi* | [**get_thumbnail**](docs/AssetAdministrationShellAPIApi.md#get_thumbnail) | **GET** /aas/asset-information/thumbnail | 
*AssetAdministrationShellAPIApi* | [**invoke_operation_async_aas**](docs/AssetAdministrationShellAPIApi.md#invoke_operation_async_aas) | **POST** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke-async | Synchronously invokes an Operation at a specified path
*AssetAdministrationShellAPIApi* | [**invoke_operation_async_value_only_aas**](docs/AssetAdministrationShellAPIApi.md#invoke_operation_async_value_only_aas) | **POST** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke-asnyc/$value | Asynchronously invokes an Operation at a specified path
*AssetAdministrationShellAPIApi* | [**invoke_operation_sync_aas**](docs/AssetAdministrationShellAPIApi.md#invoke_operation_sync_aas) | **POST** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke | Synchronously invokes an Operation at a specified path
*AssetAdministrationShellAPIApi* | [**invoke_operation_sync_value_only_aas**](docs/AssetAdministrationShellAPIApi.md#invoke_operation_sync_value_only_aas) | **POST** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke/$value | Synchronously invokes an Operation at a specified path
*AssetAdministrationShellAPIApi* | [**patch_submodel_aas**](docs/AssetAdministrationShellAPIApi.md#patch_submodel_aas) | **PATCH** /aas/submodels/{submodelIdentifier} | Updates the Submodel
*AssetAdministrationShellAPIApi* | [**patch_submodel_element_value_by_path_aas**](docs/AssetAdministrationShellAPIApi.md#patch_submodel_element_value_by_path_aas) | **PATCH** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath} | Updates an existing submodel element value at a specified path within submodel elements hierarchy
*AssetAdministrationShellAPIApi* | [**patch_submodel_element_value_by_path_metadata_aas**](docs/AssetAdministrationShellAPIApi.md#patch_submodel_element_value_by_path_metadata_aas) | **PATCH** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$metadata | Updates the metadata attributes of an existing submodel element value at a specified path within submodel elements hierarchy
*AssetAdministrationShellAPIApi* | [**patch_submodel_element_value_by_path_value_only_aas**](docs/AssetAdministrationShellAPIApi.md#patch_submodel_element_value_by_path_value_only_aas) | **PATCH** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$value | Updates the value of an existing submodel element value at a specified path within submodel elements hierarchy
*AssetAdministrationShellAPIApi* | [**patch_submodel_metadata_aas**](docs/AssetAdministrationShellAPIApi.md#patch_submodel_metadata_aas) | **PATCH** /aas/submodels/{submodelIdentifier}/$metadata | Updates the metadata attributes of the Submodel
*AssetAdministrationShellAPIApi* | [**patch_submodel_value_only_aas**](docs/AssetAdministrationShellAPIApi.md#patch_submodel_value_only_aas) | **PATCH** /aas/submodels/{submodelIdentifier}/$value | Updates teh values of the Submodel
*AssetAdministrationShellAPIApi* | [**post_submodel_element_aas**](docs/AssetAdministrationShellAPIApi.md#post_submodel_element_aas) | **POST** /aas/submodels/{submodelIdentifier}/submodel-elements | Creates a new submodel element
*AssetAdministrationShellAPIApi* | [**post_submodel_element_by_path_aas**](docs/AssetAdministrationShellAPIApi.md#post_submodel_element_by_path_aas) | **POST** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath} | Creates a new submodel element at a specified path within submodel elements hierarchy
*AssetAdministrationShellAPIApi* | [**post_submodel_reference**](docs/AssetAdministrationShellAPIApi.md#post_submodel_reference) | **POST** /aas/submodel-refs | Creates a submodel reference at the Asset Administration Shell
*AssetAdministrationShellAPIApi* | [**put_asset_administration_shell**](docs/AssetAdministrationShellAPIApi.md#put_asset_administration_shell) | **PUT** /aas | Updates an existing Asset Administration Shell
*AssetAdministrationShellAPIApi* | [**put_asset_information**](docs/AssetAdministrationShellAPIApi.md#put_asset_information) | **PUT** /aas/asset-information | Updates the Asset Information
*AssetAdministrationShellAPIApi* | [**put_file_by_path_aas**](docs/AssetAdministrationShellAPIApi.md#put_file_by_path_aas) | **PUT** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/attachment | Uploads file content to an existing submodel element at a specified path within submodel elements hierarchy
*AssetAdministrationShellAPIApi* | [**put_submodel_aas**](docs/AssetAdministrationShellAPIApi.md#put_submodel_aas) | **PUT** /aas/submodels/{submodelIdentifier} | Updates the Submodel
*AssetAdministrationShellAPIApi* | [**put_submodel_element_by_path_aas**](docs/AssetAdministrationShellAPIApi.md#put_submodel_element_by_path_aas) | **PUT** /aas/submodels/{submodelIdentifier}/submodel-elements/{idShortPath} | Updates an existing submodel element at a specified path within submodel elements hierarchy
*AssetAdministrationShellAPIApi* | [**put_thumbnail**](docs/AssetAdministrationShellAPIApi.md#put_thumbnail) | **PUT** /aas/asset-information/thumbnail | 
*AssetAdministrationShellBasicDiscoveryAPIApi* | [**delete_all_asset_links_by_id**](docs/AssetAdministrationShellBasicDiscoveryAPIApi.md#delete_all_asset_links_by_id) | **DELETE** /lookup/shells/{aasIdentifier} | Deletes all specific Asset identifiers linked to an Asset Administration Shell to edit discoverable content
*AssetAdministrationShellBasicDiscoveryAPIApi* | [**get_all_asset_administration_shell_ids_by_asset_link**](docs/AssetAdministrationShellBasicDiscoveryAPIApi.md#get_all_asset_administration_shell_ids_by_asset_link) | **GET** /lookup/shells | Returns a list of Asset Administration Shell ids linked to specific Asset identifiers
*AssetAdministrationShellBasicDiscoveryAPIApi* | [**get_all_asset_links_by_id**](docs/AssetAdministrationShellBasicDiscoveryAPIApi.md#get_all_asset_links_by_id) | **GET** /lookup/shells/{aasIdentifier} | Returns a list of specific Asset identifiers based on an Asset Administration Shell id to edit discoverable content
*AssetAdministrationShellBasicDiscoveryAPIApi* | [**post_all_asset_links_by_id**](docs/AssetAdministrationShellBasicDiscoveryAPIApi.md#post_all_asset_links_by_id) | **POST** /lookup/shells/{aasIdentifier} | Creates specific Asset identifiers linked to an Asset Administration Shell to edit discoverable content
*AssetAdministrationShellRegistryAPIApi* | [**delete_asset_administration_shell_descriptor_by_id**](docs/AssetAdministrationShellRegistryAPIApi.md#delete_asset_administration_shell_descriptor_by_id) | **DELETE** /shell-descriptors/{aasIdentifier} | Deletes an Asset Administration Shell Descriptor, i.e. de-registers an AAS
*AssetAdministrationShellRegistryAPIApi* | [**delete_submodel_descriptor_by_id_through_superpath**](docs/AssetAdministrationShellRegistryAPIApi.md#delete_submodel_descriptor_by_id_through_superpath) | **DELETE** /shell-descriptors/{aasIdentifier}/submodel-descriptors/{submodelIdentifier} | Deletes a Submodel Descriptor, i.e. de-registers a submodel
*AssetAdministrationShellRegistryAPIApi* | [**get_all_asset_administration_shell_descriptors**](docs/AssetAdministrationShellRegistryAPIApi.md#get_all_asset_administration_shell_descriptors) | **GET** /shell-descriptors | Returns all Asset Administration Shell Descriptors
*AssetAdministrationShellRegistryAPIApi* | [**get_all_submodel_descriptors_through_superpath**](docs/AssetAdministrationShellRegistryAPIApi.md#get_all_submodel_descriptors_through_superpath) | **GET** /shell-descriptors/{aasIdentifier}/submodel-descriptors | Returns all Submodel Descriptors
*AssetAdministrationShellRegistryAPIApi* | [**get_asset_administration_shell_descriptor_by_id**](docs/AssetAdministrationShellRegistryAPIApi.md#get_asset_administration_shell_descriptor_by_id) | **GET** /shell-descriptors/{aasIdentifier} | Returns a specific Asset Administration Shell Descriptor
*AssetAdministrationShellRegistryAPIApi* | [**get_submodel_descriptor_by_id_through_superpath**](docs/AssetAdministrationShellRegistryAPIApi.md#get_submodel_descriptor_by_id_through_superpath) | **GET** /shell-descriptors/{aasIdentifier}/submodel-descriptors/{submodelIdentifier} | Returns a specific Submodel Descriptor
*AssetAdministrationShellRegistryAPIApi* | [**post_asset_administration_shell_descriptor**](docs/AssetAdministrationShellRegistryAPIApi.md#post_asset_administration_shell_descriptor) | **POST** /shell-descriptors | Creates a new Asset Administration Shell Descriptor, i.e. registers an AAS
*AssetAdministrationShellRegistryAPIApi* | [**post_submodel_descriptor_through_superpath**](docs/AssetAdministrationShellRegistryAPIApi.md#post_submodel_descriptor_through_superpath) | **POST** /shell-descriptors/{aasIdentifier}/submodel-descriptors | Creates a new Submodel Descriptor, i.e. registers a submodel
*AssetAdministrationShellRegistryAPIApi* | [**put_asset_administration_shell_descriptor_by_id**](docs/AssetAdministrationShellRegistryAPIApi.md#put_asset_administration_shell_descriptor_by_id) | **PUT** /shell-descriptors/{aasIdentifier} | Updates an existing Asset Administration Shell Descriptor
*AssetAdministrationShellRegistryAPIApi* | [**put_submodel_descriptor_by_id_through_superpath**](docs/AssetAdministrationShellRegistryAPIApi.md#put_submodel_descriptor_by_id_through_superpath) | **PUT** /shell-descriptors/{aasIdentifier}/submodel-descriptors/{submodelIdentifier} | Updates an existing Submodel Descriptor
*AssetAdministrationShellRepositoryAPIApi* | [**delete_asset_administration_shell_by_id**](docs/AssetAdministrationShellRepositoryAPIApi.md#delete_asset_administration_shell_by_id) | **DELETE** /shells/{aasIdentifier} | Deletes an Asset Administration Shell
*AssetAdministrationShellRepositoryAPIApi* | [**delete_file_by_path_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#delete_file_by_path_aas_repository) | **DELETE** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/attachment | Deletes file content of an existing submodel element at a specified path within submodel elements hierarchy
*AssetAdministrationShellRepositoryAPIApi* | [**delete_submodel_by_id_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#delete_submodel_by_id_aas_repository) | **DELETE** /shells/{aasIdentifier}/submodels/{submodelIdentifier} | Deletes the submodel from the Asset Administration Shell and the Repository.
*AssetAdministrationShellRepositoryAPIApi* | [**delete_submodel_element_by_path_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#delete_submodel_element_by_path_aas_repository) | **DELETE** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath} | Deletes a submodel element at a specified path within the submodel elements hierarchy
*AssetAdministrationShellRepositoryAPIApi* | [**delete_submodel_reference_by_id_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#delete_submodel_reference_by_id_aas_repository) | **DELETE** /shells/{aasIdentifier}/submodel-refs/{submodelIdentifier} | Deletes the submodel reference from the Asset Administration Shell. Does not delete the submodel itself!
*AssetAdministrationShellRepositoryAPIApi* | [**delete_thumbnail_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#delete_thumbnail_aas_repository) | **DELETE** /shells/{aasIdentifier}/asset-information/thumbnail | 
*AssetAdministrationShellRepositoryAPIApi* | [**get_all_asset_administration_shells**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_all_asset_administration_shells) | **GET** /shells | Returns all Asset Administration Shells
*AssetAdministrationShellRepositoryAPIApi* | [**get_all_asset_administration_shells_reference**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_all_asset_administration_shells_reference) | **GET** /shells/$reference | Returns References to all Asset Administration Shells
*AssetAdministrationShellRepositoryAPIApi* | [**get_all_submodel_elements_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_all_submodel_elements_aas_repository) | **GET** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements | Returns all submodel elements including their hierarchy
*AssetAdministrationShellRepositoryAPIApi* | [**get_all_submodel_elements_metadata_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_all_submodel_elements_metadata_aas_repository) | **GET** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/$metadata | Returns all submodel elements including their hierarchy
*AssetAdministrationShellRepositoryAPIApi* | [**get_all_submodel_elements_path_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_all_submodel_elements_path_aas_repository) | **GET** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/$path | Returns all submodel elements including their hierarchy
*AssetAdministrationShellRepositoryAPIApi* | [**get_all_submodel_elements_reference_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_all_submodel_elements_reference_aas_repository) | **GET** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/$reference | Returns all submodel elements as a list of References
*AssetAdministrationShellRepositoryAPIApi* | [**get_all_submodel_elements_value_only_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_all_submodel_elements_value_only_aas_repository) | **GET** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/$value | Returns all submodel elements including their hierarchy in the ValueOnly representation
*AssetAdministrationShellRepositoryAPIApi* | [**get_all_submodel_references_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_all_submodel_references_aas_repository) | **GET** /shells/{aasIdentifier}/submodel-refs | Returns all submodel references
*AssetAdministrationShellRepositoryAPIApi* | [**get_asset_administration_shell_by_id**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_asset_administration_shell_by_id) | **GET** /shells/{aasIdentifier} | Returns a specific Asset Administration Shell
*AssetAdministrationShellRepositoryAPIApi* | [**get_asset_administration_shell_by_id_reference_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_asset_administration_shell_by_id_reference_aas_repository) | **GET** /shells/{aasIdentifier}/$reference | Returns a specific Asset Administration Shell as a Reference
*AssetAdministrationShellRepositoryAPIApi* | [**get_asset_information_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_asset_information_aas_repository) | **GET** /shells/{aasIdentifier}/asset-information | Returns the Asset Information
*AssetAdministrationShellRepositoryAPIApi* | [**get_file_by_path_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_file_by_path_aas_repository) | **GET** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/attachment | Downloads file content from a specific submodel element from the Submodel at a specified path
*AssetAdministrationShellRepositoryAPIApi* | [**get_operation_async_result_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_operation_async_result_aas_repository) | **GET** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/operation-results/{handleId} | Returns the Operation result of an asynchronous invoked Operation
*AssetAdministrationShellRepositoryAPIApi* | [**get_operation_async_result_value_only_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_operation_async_result_value_only_aas_repository) | **GET** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/operation-results/{handleId}/$value | Returns the ValueOnly notation of the Operation result of an asynchronous invoked Operation
*AssetAdministrationShellRepositoryAPIApi* | [**get_operation_async_status_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_operation_async_status_aas_repository) | **GET** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/operation-status/{handleId} | Returns the Operation status of an asynchronous invoked Operation
*AssetAdministrationShellRepositoryAPIApi* | [**get_submodel_by_id_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_submodel_by_id_aas_repository) | **GET** /shells/{aasIdentifier}/submodels/{submodelIdentifier} | Returns the Submodel
*AssetAdministrationShellRepositoryAPIApi* | [**get_submodel_by_id_metadata_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_submodel_by_id_metadata_aas_repository) | **GET** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/$metadata | Returns the Submodel&#x27;s metadata elements
*AssetAdministrationShellRepositoryAPIApi* | [**get_submodel_by_id_path_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_submodel_by_id_path_aas_repository) | **GET** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/$path | Returns the Submodel&#x27;s metadata elements
*AssetAdministrationShellRepositoryAPIApi* | [**get_submodel_by_id_reference_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_submodel_by_id_reference_aas_repository) | **GET** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/$reference | Returns the Submodel as a Reference
*AssetAdministrationShellRepositoryAPIApi* | [**get_submodel_by_id_value_only_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_submodel_by_id_value_only_aas_repository) | **GET** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/$value | Returns the Submodel&#x27;s ValueOnly representation
*AssetAdministrationShellRepositoryAPIApi* | [**get_submodel_element_by_path_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_submodel_element_by_path_aas_repository) | **GET** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath} | Returns a specific submodel element from the Submodel at a specified path
*AssetAdministrationShellRepositoryAPIApi* | [**get_submodel_element_by_path_metadata_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_submodel_element_by_path_metadata_aas_repository) | **GET** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$metadata | Returns the metadata attributes if a specific submodel element from the Submodel at a specified path
*AssetAdministrationShellRepositoryAPIApi* | [**get_submodel_element_by_path_path_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_submodel_element_by_path_path_aas_repository) | **GET** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$path | Returns a specific submodel element from the Submodel at a specified path in the Path notation
*AssetAdministrationShellRepositoryAPIApi* | [**get_submodel_element_by_path_reference_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_submodel_element_by_path_reference_aas_repository) | **GET** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$reference | Returns the Reference of a specific submodel element from the Submodel at a specified path
*AssetAdministrationShellRepositoryAPIApi* | [**get_submodel_element_by_path_value_only_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_submodel_element_by_path_value_only_aas_repository) | **GET** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$value | Returns a specific submodel element from the Submodel at a specified path in the ValueOnly representation
*AssetAdministrationShellRepositoryAPIApi* | [**get_thumbnail_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#get_thumbnail_aas_repository) | **GET** /shells/{aasIdentifier}/asset-information/thumbnail | 
*AssetAdministrationShellRepositoryAPIApi* | [**invoke_operation_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#invoke_operation_aas_repository) | **POST** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke | Synchronously invokes an Operation at a specified path
*AssetAdministrationShellRepositoryAPIApi* | [**invoke_operation_async_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#invoke_operation_async_aas_repository) | **POST** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke-async | Asynchronously invokes an Operation at a specified path
*AssetAdministrationShellRepositoryAPIApi* | [**invoke_operation_async_value_only_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#invoke_operation_async_value_only_aas_repository) | **POST** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke-async/$value | Asynchronously invokes an Operation at a specified path
*AssetAdministrationShellRepositoryAPIApi* | [**invoke_operation_value_only_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#invoke_operation_value_only_aas_repository) | **POST** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke/$value | Synchronously invokes an Operation at a specified path
*AssetAdministrationShellRepositoryAPIApi* | [**patch_submodel_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#patch_submodel_aas_repository) | **PATCH** /shells/{aasIdentifier}/submodels/{submodelIdentifier} | Updates the Submodel
*AssetAdministrationShellRepositoryAPIApi* | [**patch_submodel_by_id_metadata_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#patch_submodel_by_id_metadata_aas_repository) | **PATCH** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/$metadata | Updates the metadata attributes of the Submodel
*AssetAdministrationShellRepositoryAPIApi* | [**patch_submodel_by_id_value_only_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#patch_submodel_by_id_value_only_aas_repository) | **PATCH** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/$value | Updates teh values of the Submodel
*AssetAdministrationShellRepositoryAPIApi* | [**patch_submodel_element_value_by_path_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#patch_submodel_element_value_by_path_aas_repository) | **PATCH** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath} | Updates an existing submodel element value at a specified path within submodel elements hierarchy
*AssetAdministrationShellRepositoryAPIApi* | [**patch_submodel_element_value_by_path_metadata**](docs/AssetAdministrationShellRepositoryAPIApi.md#patch_submodel_element_value_by_path_metadata) | **PATCH** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$metadata | Updates the metadata attributes of an existing submodel element value at a specified path within submodel elements hierarchy
*AssetAdministrationShellRepositoryAPIApi* | [**patch_submodel_element_value_by_path_value_only**](docs/AssetAdministrationShellRepositoryAPIApi.md#patch_submodel_element_value_by_path_value_only) | **PATCH** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$value | Updates the value of an existing submodel element value at a specified path within submodel elements hierarchy
*AssetAdministrationShellRepositoryAPIApi* | [**post_asset_administration_shell**](docs/AssetAdministrationShellRepositoryAPIApi.md#post_asset_administration_shell) | **POST** /shells | Creates a new Asset Administration Shell
*AssetAdministrationShellRepositoryAPIApi* | [**post_submodel_element_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#post_submodel_element_aas_repository) | **POST** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements | Creates a new submodel element
*AssetAdministrationShellRepositoryAPIApi* | [**post_submodel_element_by_path_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#post_submodel_element_by_path_aas_repository) | **POST** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath} | Creates a new submodel element at a specified path within submodel elements hierarchy
*AssetAdministrationShellRepositoryAPIApi* | [**post_submodel_reference_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#post_submodel_reference_aas_repository) | **POST** /shells/{aasIdentifier}/submodel-refs | Creates a submodel reference at the Asset Administration Shell
*AssetAdministrationShellRepositoryAPIApi* | [**put_asset_administration_shell_by_id**](docs/AssetAdministrationShellRepositoryAPIApi.md#put_asset_administration_shell_by_id) | **PUT** /shells/{aasIdentifier} | Updates an existing Asset Administration Shell
*AssetAdministrationShellRepositoryAPIApi* | [**put_asset_information_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#put_asset_information_aas_repository) | **PUT** /shells/{aasIdentifier}/asset-information | Updates the Asset Information
*AssetAdministrationShellRepositoryAPIApi* | [**put_file_by_path_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#put_file_by_path_aas_repository) | **PUT** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/attachment | Uploads file content to an existing submodel element at a specified path within submodel elements hierarchy
*AssetAdministrationShellRepositoryAPIApi* | [**put_submodel_by_id_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#put_submodel_by_id_aas_repository) | **PUT** /shells/{aasIdentifier}/submodels/{submodelIdentifier} | Updates the Submodel
*AssetAdministrationShellRepositoryAPIApi* | [**put_submodel_element_by_path_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#put_submodel_element_by_path_aas_repository) | **PUT** /shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath} | Updates an existing submodel element at a specified path within submodel elements hierarchy
*AssetAdministrationShellRepositoryAPIApi* | [**put_thumbnail_aas_repository**](docs/AssetAdministrationShellRepositoryAPIApi.md#put_thumbnail_aas_repository) | **PUT** /shells/{aasIdentifier}/asset-information/thumbnail | 
*ConceptDescriptionRepositoryAPIApi* | [**delete_concept_description_by_id**](docs/ConceptDescriptionRepositoryAPIApi.md#delete_concept_description_by_id) | **DELETE** /concept-descriptions/{cdIdentifier} | Deletes a Concept Description
*ConceptDescriptionRepositoryAPIApi* | [**get_all_concept_descriptions**](docs/ConceptDescriptionRepositoryAPIApi.md#get_all_concept_descriptions) | **GET** /concept-descriptions | Returns all Concept Descriptions
*ConceptDescriptionRepositoryAPIApi* | [**get_concept_description_by_id**](docs/ConceptDescriptionRepositoryAPIApi.md#get_concept_description_by_id) | **GET** /concept-descriptions/{cdIdentifier} | Returns a specific Concept Description
*ConceptDescriptionRepositoryAPIApi* | [**post_concept_description**](docs/ConceptDescriptionRepositoryAPIApi.md#post_concept_description) | **POST** /concept-descriptions | Creates a new Concept Description
*ConceptDescriptionRepositoryAPIApi* | [**put_concept_description_by_id**](docs/ConceptDescriptionRepositoryAPIApi.md#put_concept_description_by_id) | **PUT** /concept-descriptions/{cdIdentifier} | Updates an existing Concept Description
*DescriptionAPIApi* | [**get_description**](docs/DescriptionAPIApi.md#get_description) | **GET** /description | Returns the self-describing information of a network resource (ServiceDescription)
*SerializationAPIApi* | [**generate_serialization_by_ids**](docs/SerializationAPIApi.md#generate_serialization_by_ids) | **GET** /serialization | Returns an appropriate serialization based on the specified format (see SerializationFormat)
*SubmodelAPIApi* | [**delete_file_by_path**](docs/SubmodelAPIApi.md#delete_file_by_path) | **DELETE** /submodel/submodel-elements/{idShortPath}/attachment | Deletes file content of an existing submodel element at a specified path within submodel elements hierarchy
*SubmodelAPIApi* | [**delete_submodel_element_by_path**](docs/SubmodelAPIApi.md#delete_submodel_element_by_path) | **DELETE** /submodel/submodel-elements/{idShortPath} | Deletes a submodel element at a specified path within the submodel elements hierarchy
*SubmodelAPIApi* | [**get_all_submodel_elements**](docs/SubmodelAPIApi.md#get_all_submodel_elements) | **GET** /submodel/submodel-elements | Returns all submodel elements including their hierarchy
*SubmodelAPIApi* | [**get_all_submodel_elements_metadata**](docs/SubmodelAPIApi.md#get_all_submodel_elements_metadata) | **GET** /submodel/submodel-elements/$metadata | Returns the metadata attributes of all submodel elements including their hierarchy
*SubmodelAPIApi* | [**get_all_submodel_elements_path**](docs/SubmodelAPIApi.md#get_all_submodel_elements_path) | **GET** /submodel/submodel-elements/$path | Returns all submodel elements including their hierarchy in the Path notation
*SubmodelAPIApi* | [**get_all_submodel_elements_reference**](docs/SubmodelAPIApi.md#get_all_submodel_elements_reference) | **GET** /submodel/submodel-elements/$reference | Returns the References of all submodel elements
*SubmodelAPIApi* | [**get_all_submodel_elements_value_only**](docs/SubmodelAPIApi.md#get_all_submodel_elements_value_only) | **GET** /submodel/submodel-elements/$value | Returns all submodel elements including their hierarchy in the ValueOnly representation
*SubmodelAPIApi* | [**get_file_by_path**](docs/SubmodelAPIApi.md#get_file_by_path) | **GET** /submodel/submodel-elements/{idShortPath}/attachment | Downloads file content from a specific submodel element from the Submodel at a specified path
*SubmodelAPIApi* | [**get_operation_async_result**](docs/SubmodelAPIApi.md#get_operation_async_result) | **GET** /submodel/submodel-elements/{idShortPath}/operation-results/{handleId} | Returns the Operation result of an asynchronous invoked Operation
*SubmodelAPIApi* | [**get_operation_async_result_value_only**](docs/SubmodelAPIApi.md#get_operation_async_result_value_only) | **GET** /submodel/submodel-elements/{idShortPath}/operation-results/{handleId}/$value | Returns the value of the Operation result of an asynchronous invoked Operation
*SubmodelAPIApi* | [**get_operation_async_status**](docs/SubmodelAPIApi.md#get_operation_async_status) | **GET** /submodel/submodel-elements/{idShortPath}/operation-status/{handleId} | Returns the Operation status of an asynchronous invoked Operation
*SubmodelAPIApi* | [**get_submodel**](docs/SubmodelAPIApi.md#get_submodel) | **GET** /submodel | Returns the Submodel
*SubmodelAPIApi* | [**get_submodel_element_by_path**](docs/SubmodelAPIApi.md#get_submodel_element_by_path) | **GET** /submodel/submodel-elements/{idShortPath} | Returns a specific submodel element from the Submodel at a specified path
*SubmodelAPIApi* | [**get_submodel_element_by_path_metadata**](docs/SubmodelAPIApi.md#get_submodel_element_by_path_metadata) | **GET** /submodel/submodel-elements/{idShortPath}/$metadata | Returns the matadata attributes of a specific submodel element from the Submodel at a specified path
*SubmodelAPIApi* | [**get_submodel_element_by_path_path**](docs/SubmodelAPIApi.md#get_submodel_element_by_path_path) | **GET** /submodel/submodel-elements/{idShortPath}/$path | Returns a specific submodel element from the Submodel at a specified path in the Path notation
*SubmodelAPIApi* | [**get_submodel_element_by_path_reference**](docs/SubmodelAPIApi.md#get_submodel_element_by_path_reference) | **GET** /submodel/submodel-elements/{idShortPath}/$reference | Returns the Referene of a specific submodel element from the Submodel at a specified path
*SubmodelAPIApi* | [**get_submodel_element_by_path_value_only**](docs/SubmodelAPIApi.md#get_submodel_element_by_path_value_only) | **GET** /submodel/submodel-elements/{idShortPath}/$value | Returns a specific submodel element from the Submodel at a specified path in the ValueOnly representation
*SubmodelAPIApi* | [**get_submodel_metadata**](docs/SubmodelAPIApi.md#get_submodel_metadata) | **GET** /submodel/$metadata | Returns the metadata attributes of a specific Submodel
*SubmodelAPIApi* | [**get_submodel_path**](docs/SubmodelAPIApi.md#get_submodel_path) | **GET** /submodel/$path | Returns the Submodel in the Path notation
*SubmodelAPIApi* | [**get_submodel_reference**](docs/SubmodelAPIApi.md#get_submodel_reference) | **GET** /submodel/$reference | Returns the Reference of the Submodel
*SubmodelAPIApi* | [**get_submodel_value_only**](docs/SubmodelAPIApi.md#get_submodel_value_only) | **GET** /submodel/$value | Returns the Submodel in the ValueOnly representation
*SubmodelAPIApi* | [**invoke_operation**](docs/SubmodelAPIApi.md#invoke_operation) | **POST** /submodel/submodel-elements/{idShortPath}/invoke | Synchronously invokes an Operation at a specified path
*SubmodelAPIApi* | [**invoke_operation_async**](docs/SubmodelAPIApi.md#invoke_operation_async) | **POST** /submodel/submodel-elements/{idShortPath}/invoke-async | Asynchronously invokes an Operation at a specified path
*SubmodelAPIApi* | [**invoke_operation_async_value_only**](docs/SubmodelAPIApi.md#invoke_operation_async_value_only) | **POST** /submodel/submodel-elements/{idShortPath}/invoke-async/$value | Asynchronously invokes an Operation at a specified path
*SubmodelAPIApi* | [**invoke_operation_sync_value_only**](docs/SubmodelAPIApi.md#invoke_operation_sync_value_only) | **POST** /submodel/submodel-elements/{idShortPath}/invoke/$value | Synchronously invokes an Operation at a specified path
*SubmodelAPIApi* | [**patch_submodel**](docs/SubmodelAPIApi.md#patch_submodel) | **PATCH** /submodel | Updates the Submodel
*SubmodelAPIApi* | [**patch_submodel_element_by_path**](docs/SubmodelAPIApi.md#patch_submodel_element_by_path) | **PATCH** /submodel/submodel-elements/{idShortPath} | Updates an existing SubmodelElement
*SubmodelAPIApi* | [**patch_submodel_element_by_path_metadata**](docs/SubmodelAPIApi.md#patch_submodel_element_by_path_metadata) | **PATCH** /submodel/submodel-elements/{idShortPath}/$metadata | Updates the metadata attributes an existing SubmodelElement
*SubmodelAPIApi* | [**patch_submodel_element_by_path_value_only**](docs/SubmodelAPIApi.md#patch_submodel_element_by_path_value_only) | **PATCH** /submodel/submodel-elements/{idShortPath}/$value | Updates the value of an existing SubmodelElement
*SubmodelAPIApi* | [**patch_submodel_metadata**](docs/SubmodelAPIApi.md#patch_submodel_metadata) | **PATCH** /submodel/$metadata | Updates the metadata attributes of the Submodel
*SubmodelAPIApi* | [**patch_submodel_value_only**](docs/SubmodelAPIApi.md#patch_submodel_value_only) | **PATCH** /submodel/$value | Updates the values of the Submodel
*SubmodelAPIApi* | [**post_submodel_element**](docs/SubmodelAPIApi.md#post_submodel_element) | **POST** /submodel/submodel-elements | Creates a new submodel element
*SubmodelAPIApi* | [**post_submodel_element_by_path**](docs/SubmodelAPIApi.md#post_submodel_element_by_path) | **POST** /submodel/submodel-elements/{idShortPath} | Creates a new submodel element at a specified path within submodel elements hierarchy
*SubmodelAPIApi* | [**put_file_by_path**](docs/SubmodelAPIApi.md#put_file_by_path) | **PUT** /submodel/submodel-elements/{idShortPath}/attachment | Uploads file content to an existing submodel element at a specified path within submodel elements hierarchy
*SubmodelAPIApi* | [**put_submodel**](docs/SubmodelAPIApi.md#put_submodel) | **PUT** /submodel | Updates the Submodel
*SubmodelAPIApi* | [**put_submodel_element_by_path**](docs/SubmodelAPIApi.md#put_submodel_element_by_path) | **PUT** /submodel/submodel-elements/{idShortPath} | Updates an existing submodel element at a specified path within submodel elements hierarchy
*SubmodelRegistryAPIApi* | [**delete_submodel_descriptor_by_id**](docs/SubmodelRegistryAPIApi.md#delete_submodel_descriptor_by_id) | **DELETE** /submodel-descriptors/{submodelIdentifier} | Deletes a Submodel Descriptor, i.e. de-registers a submodel
*SubmodelRegistryAPIApi* | [**get_all_submodel_descriptors**](docs/SubmodelRegistryAPIApi.md#get_all_submodel_descriptors) | **GET** /submodel-descriptors | Returns all Submodel Descriptors
*SubmodelRegistryAPIApi* | [**get_submodel_descriptor_by_id**](docs/SubmodelRegistryAPIApi.md#get_submodel_descriptor_by_id) | **GET** /submodel-descriptors/{submodelIdentifier} | Returns a specific Submodel Descriptor
*SubmodelRegistryAPIApi* | [**post_submodel_descriptor**](docs/SubmodelRegistryAPIApi.md#post_submodel_descriptor) | **POST** /submodel-descriptors | Creates a new Submodel Descriptor, i.e. registers a submodel
*SubmodelRegistryAPIApi* | [**put_submodel_descriptor_by_id**](docs/SubmodelRegistryAPIApi.md#put_submodel_descriptor_by_id) | **PUT** /submodel-descriptors/{submodelIdentifier} | Updates an existing Submodel Descriptor
*SubmodelRepositoryAPIApi* | [**delete_file_by_path_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#delete_file_by_path_submodel_repo) | **DELETE** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/attachment | Deletes file content of an existing submodel element at a specified path within submodel elements hierarchy
*SubmodelRepositoryAPIApi* | [**delete_submodel_by_id**](docs/SubmodelRepositoryAPIApi.md#delete_submodel_by_id) | **DELETE** /submodels/{submodelIdentifier} | Deletes a Submodel
*SubmodelRepositoryAPIApi* | [**delete_submodel_element_by_path_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#delete_submodel_element_by_path_submodel_repo) | **DELETE** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath} | Deletes a submodel element at a specified path within the submodel elements hierarchy
*SubmodelRepositoryAPIApi* | [**get_all_submodel_elements_metadata_submodel_repository**](docs/SubmodelRepositoryAPIApi.md#get_all_submodel_elements_metadata_submodel_repository) | **GET** /submodels/{submodelIdentifier}/submodel-elements/$metadata | Returns the metadata attributes of all submodel elements including their hierarchy
*SubmodelRepositoryAPIApi* | [**get_all_submodel_elements_path_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#get_all_submodel_elements_path_submodel_repo) | **GET** /submodels/{submodelIdentifier}/submodel-elements/$path | Returns all submodel elements including their hierarchy in the Path notation
*SubmodelRepositoryAPIApi* | [**get_all_submodel_elements_reference_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#get_all_submodel_elements_reference_submodel_repo) | **GET** /submodels/{submodelIdentifier}/submodel-elements/$reference | Returns the References of all submodel elements
*SubmodelRepositoryAPIApi* | [**get_all_submodel_elements_submodel_repository**](docs/SubmodelRepositoryAPIApi.md#get_all_submodel_elements_submodel_repository) | **GET** /submodels/{submodelIdentifier}/submodel-elements | Returns all submodel elements including their hierarchy
*SubmodelRepositoryAPIApi* | [**get_all_submodel_elements_value_only_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#get_all_submodel_elements_value_only_submodel_repo) | **GET** /submodels/{submodelIdentifier}/submodel-elements/$value | Returns all submodel elements including their hierarchy in the ValueOnly representation
*SubmodelRepositoryAPIApi* | [**get_all_submodels**](docs/SubmodelRepositoryAPIApi.md#get_all_submodels) | **GET** /submodels | Returns all Submodels
*SubmodelRepositoryAPIApi* | [**get_all_submodels_metadata**](docs/SubmodelRepositoryAPIApi.md#get_all_submodels_metadata) | **GET** /submodels/$metadata | Returns the metadata attributes of all Submodels
*SubmodelRepositoryAPIApi* | [**get_all_submodels_path**](docs/SubmodelRepositoryAPIApi.md#get_all_submodels_path) | **GET** /submodels/$path | Returns all Submodels in the Path notation
*SubmodelRepositoryAPIApi* | [**get_all_submodels_reference**](docs/SubmodelRepositoryAPIApi.md#get_all_submodels_reference) | **GET** /submodels/$reference | Returns the References for all Submodels
*SubmodelRepositoryAPIApi* | [**get_all_submodels_value_only**](docs/SubmodelRepositoryAPIApi.md#get_all_submodels_value_only) | **GET** /submodels/$value | Returns all Submodels in their ValueOnly representation
*SubmodelRepositoryAPIApi* | [**get_file_by_path_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#get_file_by_path_submodel_repo) | **GET** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/attachment | Downloads file content from a specific submodel element from the Submodel at a specified path
*SubmodelRepositoryAPIApi* | [**get_operation_async_result_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#get_operation_async_result_submodel_repo) | **GET** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/operation-results/{handleId} | Returns the Operation result of an asynchronous invoked Operation
*SubmodelRepositoryAPIApi* | [**get_operation_async_result_value_only_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#get_operation_async_result_value_only_submodel_repo) | **GET** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/operation-results/{handleId}/$value | Returns the Operation result of an asynchronous invoked Operation
*SubmodelRepositoryAPIApi* | [**get_operation_async_status_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#get_operation_async_status_submodel_repo) | **GET** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/operation-status/{handleId} | Returns the Operation status of an asynchronous invoked Operation
*SubmodelRepositoryAPIApi* | [**get_submodel_by_id**](docs/SubmodelRepositoryAPIApi.md#get_submodel_by_id) | **GET** /submodels/{submodelIdentifier} | Returns a specific Submodel
*SubmodelRepositoryAPIApi* | [**get_submodel_by_id_metadata**](docs/SubmodelRepositoryAPIApi.md#get_submodel_by_id_metadata) | **GET** /submodels/{submodelIdentifier}/$metadata | Returns the metadata attributes of a specific Submodel
*SubmodelRepositoryAPIApi* | [**get_submodel_by_id_path**](docs/SubmodelRepositoryAPIApi.md#get_submodel_by_id_path) | **GET** /submodels/{submodelIdentifier}/$path | Returns a specific Submodel in the Path notation
*SubmodelRepositoryAPIApi* | [**get_submodel_by_id_reference**](docs/SubmodelRepositoryAPIApi.md#get_submodel_by_id_reference) | **GET** /submodels/{submodelIdentifier}/$reference | Returns the Reference of a specific Submodel
*SubmodelRepositoryAPIApi* | [**get_submodel_by_id_value_only**](docs/SubmodelRepositoryAPIApi.md#get_submodel_by_id_value_only) | **GET** /submodels/{submodelIdentifier}/$value | Returns a specific Submodel in the ValueOnly representation
*SubmodelRepositoryAPIApi* | [**get_submodel_element_by_path_metadata_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#get_submodel_element_by_path_metadata_submodel_repo) | **GET** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$metadata | Returns the matadata attributes of a specific submodel element from the Submodel at a specified path
*SubmodelRepositoryAPIApi* | [**get_submodel_element_by_path_path_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#get_submodel_element_by_path_path_submodel_repo) | **GET** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$path | Returns a specific submodel element from the Submodel at a specified path in the Path notation
*SubmodelRepositoryAPIApi* | [**get_submodel_element_by_path_reference_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#get_submodel_element_by_path_reference_submodel_repo) | **GET** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$reference | Returns the Referene of a specific submodel element from the Submodel at a specified path
*SubmodelRepositoryAPIApi* | [**get_submodel_element_by_path_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#get_submodel_element_by_path_submodel_repo) | **GET** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath} | Returns a specific submodel element from the Submodel at a specified path
*SubmodelRepositoryAPIApi* | [**get_submodel_element_by_path_value_only_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#get_submodel_element_by_path_value_only_submodel_repo) | **GET** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$value | Returns a specific submodel element from the Submodel at a specified path in the ValueOnly representation
*SubmodelRepositoryAPIApi* | [**invoke_operation_async_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#invoke_operation_async_submodel_repo) | **POST** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke-async | Asynchronously invokes an Operation at a specified path
*SubmodelRepositoryAPIApi* | [**invoke_operation_async_value_only_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#invoke_operation_async_value_only_submodel_repo) | **POST** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke-async/$value | Asynchronously invokes an Operation at a specified path
*SubmodelRepositoryAPIApi* | [**invoke_operation_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#invoke_operation_submodel_repo) | **POST** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke | Synchronously invokes an Operation at a specified path
*SubmodelRepositoryAPIApi* | [**invoke_operation_value_only_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#invoke_operation_value_only_submodel_repo) | **POST** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke/$value | Synchronously invokes an Operation at a specified path
*SubmodelRepositoryAPIApi* | [**patch_submodel_by_id**](docs/SubmodelRepositoryAPIApi.md#patch_submodel_by_id) | **PATCH** /submodels/{submodelIdentifier} | Updates an existing Submodel
*SubmodelRepositoryAPIApi* | [**patch_submodel_by_id_metadata**](docs/SubmodelRepositoryAPIApi.md#patch_submodel_by_id_metadata) | **PATCH** /submodels/{submodelIdentifier}/$metadata | Updates the metadata attributes of an existing Submodel
*SubmodelRepositoryAPIApi* | [**patch_submodel_by_id_value_only**](docs/SubmodelRepositoryAPIApi.md#patch_submodel_by_id_value_only) | **PATCH** /submodels/{submodelIdentifier}/$value | Updates the values of an existing Submodel
*SubmodelRepositoryAPIApi* | [**patch_submodel_element_by_path_metadata_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#patch_submodel_element_by_path_metadata_submodel_repo) | **PATCH** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$metadata | Updates the metadata attributes an existing SubmodelElement
*SubmodelRepositoryAPIApi* | [**patch_submodel_element_by_path_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#patch_submodel_element_by_path_submodel_repo) | **PATCH** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath} | Updates an existing SubmodelElement
*SubmodelRepositoryAPIApi* | [**patch_submodel_element_by_path_value_only_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#patch_submodel_element_by_path_value_only_submodel_repo) | **PATCH** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$value | Updates the value of an existing SubmodelElement
*SubmodelRepositoryAPIApi* | [**post_submodel**](docs/SubmodelRepositoryAPIApi.md#post_submodel) | **POST** /submodels | Creates a new Submodel
*SubmodelRepositoryAPIApi* | [**post_submodel_element_by_path_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#post_submodel_element_by_path_submodel_repo) | **POST** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath} | Creates a new submodel element at a specified path within submodel elements hierarchy
*SubmodelRepositoryAPIApi* | [**post_submodel_element_submodel_repository**](docs/SubmodelRepositoryAPIApi.md#post_submodel_element_submodel_repository) | **POST** /submodels/{submodelIdentifier}/submodel-elements | Creates a new submodel element
*SubmodelRepositoryAPIApi* | [**put_file_by_path_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#put_file_by_path_submodel_repo) | **PUT** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/attachment | Uploads file content to an existing submodel element at a specified path within submodel elements hierarchy
*SubmodelRepositoryAPIApi* | [**put_submodel_by_id**](docs/SubmodelRepositoryAPIApi.md#put_submodel_by_id) | **PUT** /submodels/{submodelIdentifier} | Updates an existing Submodel
*SubmodelRepositoryAPIApi* | [**put_submodel_element_by_path_submodel_repo**](docs/SubmodelRepositoryAPIApi.md#put_submodel_element_by_path_submodel_repo) | **PUT** /submodels/{submodelIdentifier}/submodel-elements/{idShortPath} | Updates an existing submodel element at a specified path within submodel elements hierarchy

## Documentation For Models

 - [AasSubmodelElements](docs/AasSubmodelElements.md)
 - [AbstractLangString](docs/AbstractLangString.md)
 - [AdministrativeInformation](docs/AdministrativeInformation.md)
 - [AllOfResourceContentType](docs/AllOfResourceContentType.md)
 - [AllOfResourcePath](docs/AllOfResourcePath.md)
 - [AnnotatedRelationshipElement](docs/AnnotatedRelationshipElement.md)
 - [AnnotatedRelationshipElementMetadata](docs/AnnotatedRelationshipElementMetadata.md)
 - [AnnotatedRelationshipElementValue](docs/AnnotatedRelationshipElementValue.md)
 - [AssetAdministrationShell](docs/AssetAdministrationShell.md)
 - [AssetAdministrationShellDescriptor](docs/AssetAdministrationShellDescriptor.md)
 - [AssetInformation](docs/AssetInformation.md)
 - [AssetKind](docs/AssetKind.md)
 - [AssetinformationThumbnailBody](docs/AssetinformationThumbnailBody.md)
 - [AssetinformationThumbnailBody1](docs/AssetinformationThumbnailBody1.md)
 - [BaseOperationResult](docs/BaseOperationResult.md)
 - [BasicEventElement](docs/BasicEventElement.md)
 - [BasicEventElementMetadata](docs/BasicEventElementMetadata.md)
 - [BasicEventElementValue](docs/BasicEventElementValue.md)
 - [Blob](docs/Blob.md)
 - [BlobMetadata](docs/BlobMetadata.md)
 - [BlobValue](docs/BlobValue.md)
 - [BooleanValue](docs/BooleanValue.md)
 - [Capability](docs/Capability.md)
 - [CapabilityMetadata](docs/CapabilityMetadata.md)
 - [ConceptDescription](docs/ConceptDescription.md)
 - [DataElement](docs/DataElement.md)
 - [DataElementChoice](docs/DataElementChoice.md)
 - [DataSpecificationContent](docs/DataSpecificationContent.md)
 - [DataSpecificationContentChoice](docs/DataSpecificationContentChoice.md)
 - [DataSpecificationIec61360](docs/DataSpecificationIec61360.md)
 - [DataTypeDefXsd](docs/DataTypeDefXsd.md)
 - [DataTypeIec61360](docs/DataTypeIec61360.md)
 - [Descriptor](docs/Descriptor.md)
 - [Direction](docs/Direction.md)
 - [EmbeddedDataSpecification](docs/EmbeddedDataSpecification.md)
 - [Endpoint](docs/Endpoint.md)
 - [Entity](docs/Entity.md)
 - [EntityMetadata](docs/EntityMetadata.md)
 - [EntityType](docs/EntityType.md)
 - [EntityValue](docs/EntityValue.md)
 - [Environment](docs/Environment.md)
 - [EventElement](docs/EventElement.md)
 - [ExecutionState](docs/ExecutionState.md)
 - [Extension](docs/Extension.md)
 - [File](docs/File.md)
 - [FileMetadata](docs/FileMetadata.md)
 - [FileValue](docs/FileValue.md)
 - [GetAssetAdministrationShellDescriptorsResult](docs/GetAssetAdministrationShellDescriptorsResult.md)
 - [GetAssetAdministrationShellsResult](docs/GetAssetAdministrationShellsResult.md)
 - [GetConceptDescriptionsResult](docs/GetConceptDescriptionsResult.md)
 - [GetPackageDescriptionsResult](docs/GetPackageDescriptionsResult.md)
 - [GetPathItemsResult](docs/GetPathItemsResult.md)
 - [GetReferencesResult](docs/GetReferencesResult.md)
 - [GetSubmodelDescriptorsResult](docs/GetSubmodelDescriptorsResult.md)
 - [GetSubmodelElementsMetadataResult](docs/GetSubmodelElementsMetadataResult.md)
 - [GetSubmodelElementsResult](docs/GetSubmodelElementsResult.md)
 - [GetSubmodelElementsValueResult](docs/GetSubmodelElementsValueResult.md)
 - [GetSubmodelsMetadataResult](docs/GetSubmodelsMetadataResult.md)
 - [GetSubmodelsResult](docs/GetSubmodelsResult.md)
 - [GetSubmodelsValueResult](docs/GetSubmodelsValueResult.md)
 - [HasDataSpecification](docs/HasDataSpecification.md)
 - [HasExtensions](docs/HasExtensions.md)
 - [HasKind](docs/HasKind.md)
 - [HasSemantics](docs/HasSemantics.md)
 - [IdShortPathAttachmentBody](docs/IdShortPathAttachmentBody.md)
 - [IdShortPathAttachmentBody1](docs/IdShortPathAttachmentBody1.md)
 - [IdShortPathAttachmentBody2](docs/IdShortPathAttachmentBody2.md)
 - [IdShortPathAttachmentBody3](docs/IdShortPathAttachmentBody3.md)
 - [Identifiable](docs/Identifiable.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [Key](docs/Key.md)
 - [KeyTypes](docs/KeyTypes.md)
 - [LangStringDefinitionTypeIec61360](docs/LangStringDefinitionTypeIec61360.md)
 - [LangStringNameType](docs/LangStringNameType.md)
 - [LangStringPreferredNameTypeIec61360](docs/LangStringPreferredNameTypeIec61360.md)
 - [LangStringShortNameTypeIec61360](docs/LangStringShortNameTypeIec61360.md)
 - [LangStringTextType](docs/LangStringTextType.md)
 - [LevelType](docs/LevelType.md)
 - [Message](docs/Message.md)
 - [ModelProperty](docs/ModelProperty.md)
 - [ModelType](docs/ModelType.md)
 - [ModellingKind](docs/ModellingKind.md)
 - [MultiLanguageProperty](docs/MultiLanguageProperty.md)
 - [MultiLanguagePropertyMetadata](docs/MultiLanguagePropertyMetadata.md)
 - [MultiLanguagePropertyValue](docs/MultiLanguagePropertyValue.md)
 - [NumberValue](docs/NumberValue.md)
 - [OneOfSubmodelElementMetadata](docs/OneOfSubmodelElementMetadata.md)
 - [Operation](docs/Operation.md)
 - [OperationMetadata](docs/OperationMetadata.md)
 - [OperationRequest](docs/OperationRequest.md)
 - [OperationRequestValueOnly](docs/OperationRequestValueOnly.md)
 - [OperationResult](docs/OperationResult.md)
 - [OperationResultValueOnly](docs/OperationResultValueOnly.md)
 - [OperationVariable](docs/OperationVariable.md)
 - [PackageDescription](docs/PackageDescription.md)
 - [PackagesBody](docs/PackagesBody.md)
 - [PackagesPackageIdBody](docs/PackagesPackageIdBody.md)
 - [PagedResult](docs/PagedResult.md)
 - [PagedResultPagingMetadata](docs/PagedResultPagingMetadata.md)
 - [PathItem](docs/PathItem.md)
 - [PropertyMetadata](docs/PropertyMetadata.md)
 - [PropertyValue](docs/PropertyValue.md)
 - [ProtocolInformation](docs/ProtocolInformation.md)
 - [ProtocolInformationSecurityAttributes](docs/ProtocolInformationSecurityAttributes.md)
 - [Qualifiable](docs/Qualifiable.md)
 - [Qualifier](docs/Qualifier.md)
 - [QualifierKind](docs/QualifierKind.md)
 - [Range](docs/Range.md)
 - [RangeMetadata](docs/RangeMetadata.md)
 - [RangeValue](docs/RangeValue.md)
 - [Referable](docs/Referable.md)
 - [Reference](docs/Reference.md)
 - [ReferenceElement](docs/ReferenceElement.md)
 - [ReferenceElementMetadata](docs/ReferenceElementMetadata.md)
 - [ReferenceElementValue](docs/ReferenceElementValue.md)
 - [ReferenceParent](docs/ReferenceParent.md)
 - [ReferenceTypes](docs/ReferenceTypes.md)
 - [ReferenceValue](docs/ReferenceValue.md)
 - [RelationshipElement](docs/RelationshipElement.md)
 - [RelationshipElementAbstract](docs/RelationshipElementAbstract.md)
 - [RelationshipElementMetadata](docs/RelationshipElementMetadata.md)
 - [RelationshipElementValue](docs/RelationshipElementValue.md)
 - [Resource](docs/Resource.md)
 - [Result](docs/Result.md)
 - [ServiceDescription](docs/ServiceDescription.md)
 - [SpecificAssetId](docs/SpecificAssetId.md)
 - [SpecificAssetIdValue](docs/SpecificAssetIdValue.md)
 - [StateOfEvent](docs/StateOfEvent.md)
 - [StringValue](docs/StringValue.md)
 - [Submodel](docs/Submodel.md)
 - [SubmodelDescriptor](docs/SubmodelDescriptor.md)
 - [SubmodelElement](docs/SubmodelElement.md)
 - [SubmodelElementAttributes](docs/SubmodelElementAttributes.md)
 - [SubmodelElementChoice](docs/SubmodelElementChoice.md)
 - [SubmodelElementCollection](docs/SubmodelElementCollection.md)
 - [SubmodelElementCollectionMetadata](docs/SubmodelElementCollectionMetadata.md)
 - [SubmodelElementCollectionValue](docs/SubmodelElementCollectionValue.md)
 - [SubmodelElementList](docs/SubmodelElementList.md)
 - [SubmodelElementListMetadata](docs/SubmodelElementListMetadata.md)
 - [SubmodelElementListValue](docs/SubmodelElementListValue.md)
 - [SubmodelElementMetadata](docs/SubmodelElementMetadata.md)
 - [SubmodelElementValue](docs/SubmodelElementValue.md)
 - [SubmodelMetadata](docs/SubmodelMetadata.md)
 - [SubmodelValue](docs/SubmodelValue.md)
 - [ValueList](docs/ValueList.md)
 - [ValueOnly](docs/ValueOnly.md)
 - [ValueReferencePair](docs/ValueReferencePair.md)

## Documentation For Authorization
