# coding: utf-8

"""
    DotAAS Part 2 | HTTP/REST | Entire API Collection

    All APIs of the Specification of the [Specification of the Asset Administration Shell: Part 2](http://industrialdigitaltwin.org/en/content-hub) in one collection. Please not that this API is not intended to generate productive code but only for overview purposes.   Publisher: Industrial Digital Twin Association (IDTA) 2023\"  # noqa: E501

    OpenAPI spec version: V3.0.1
    Contact: info@idtwin.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from aas_python_http_client.api_client import ApiClient


class AASXFileServerAPIApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_aasxby_package_id(self, package_id, **kwargs):  # noqa: E501
        """Deletes a specific AASX package from the server  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_aasxby_package_id(package_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str package_id: The package Id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_aasxby_package_id_with_http_info(package_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_aasxby_package_id_with_http_info(package_id, **kwargs)  # noqa: E501
            return data

    def delete_aasxby_package_id_with_http_info(self, package_id, **kwargs):  # noqa: E501
        """Deletes a specific AASX package from the server  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_aasxby_package_id_with_http_info(package_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str package_id: The package Id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['package_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_aasxby_package_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params or
                params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `delete_aasxby_package_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'package_id' in params:
            path_params['packageId'] = params['package_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/packages/{packageId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_aasxby_package_id(self, package_id, **kwargs):  # noqa: E501
        """Returns a specific AASX package from the server  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_aasxby_package_id(package_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str package_id: The package Id (UTF8-BASE64-URL-encoded) (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_aasxby_package_id_with_http_info(package_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_aasxby_package_id_with_http_info(package_id, **kwargs)  # noqa: E501
            return data

    def get_aasxby_package_id_with_http_info(self, package_id, **kwargs):  # noqa: E501
        """Returns a specific AASX package from the server  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_aasxby_package_id_with_http_info(package_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str package_id: The package Id (UTF8-BASE64-URL-encoded) (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['package_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_aasxby_package_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params or
                params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `get_aasxby_package_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'package_id' in params:
            path_params['packageId'] = params['package_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/asset-administration-shell-package', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/packages/{packageId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_aasx_package_ids(self, **kwargs):  # noqa: E501
        """Returns a list of available AASX packages at the server  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_aasx_package_ids(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_id: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :return: GetPackageDescriptionsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_aasx_package_ids_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_aasx_package_ids_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_aasx_package_ids_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a list of available AASX packages at the server  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_aasx_package_ids_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_id: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :return: GetPackageDescriptionsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_id', 'limit', 'cursor']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_aasx_package_ids" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'aas_id' in params:
            query_params.append(('aasId', params['aas_id']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/packages', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetPackageDescriptionsResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_aasx_package(self, aas_ids, file, file_name, **kwargs):  # noqa: E501
        """Stores the AASX package at the server  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_aasx_package(aas_ids, file, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] aas_ids: (required)
        :param str file: (required)
        :param str file_name: (required)
        :return: PackageDescription
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_aasx_package_with_http_info(aas_ids, file, file_name, **kwargs)  # noqa: E501
        else:
            (data) = self.post_aasx_package_with_http_info(aas_ids, file, file_name, **kwargs)  # noqa: E501
            return data

    def post_aasx_package_with_http_info(self, aas_ids, file, file_name, **kwargs):  # noqa: E501
        """Stores the AASX package at the server  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_aasx_package_with_http_info(aas_ids, file, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] aas_ids: (required)
        :param str file: (required)
        :param str file_name: (required)
        :return: PackageDescription
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_ids', 'file', 'file_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_aasx_package" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_ids' is set
        if ('aas_ids' not in params or
                params['aas_ids'] is None):
            raise ValueError("Missing the required parameter `aas_ids` when calling `post_aasx_package`")  # noqa: E501
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `post_aasx_package`")  # noqa: E501
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params or
                params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `post_aasx_package`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'aas_ids' in params:
            form_params.append(('aasIds', params['aas_ids']))  # noqa: E501
            collection_formats['aasIds'] = 'multi'  # noqa: E501
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501
        if 'file_name' in params:
            form_params.append(('fileName', params['file_name']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/packages', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PackageDescription',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_aasxby_package_id(self, aas_ids, file, file_name, package_id, **kwargs):  # noqa: E501
        """Updates the AASX package at the server  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_aasxby_package_id(aas_ids, file, file_name, package_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] aas_ids: (required)
        :param str file: (required)
        :param str file_name: (required)
        :param str package_id: The package Id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_aasxby_package_id_with_http_info(aas_ids, file, file_name, package_id, **kwargs)  # noqa: E501
        else:
            (data) = self.put_aasxby_package_id_with_http_info(aas_ids, file, file_name, package_id, **kwargs)  # noqa: E501
            return data

    def put_aasxby_package_id_with_http_info(self, aas_ids, file, file_name, package_id, **kwargs):  # noqa: E501
        """Updates the AASX package at the server  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_aasxby_package_id_with_http_info(aas_ids, file, file_name, package_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] aas_ids: (required)
        :param str file: (required)
        :param str file_name: (required)
        :param str package_id: The package Id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_ids', 'file', 'file_name', 'package_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_aasxby_package_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_ids' is set
        if ('aas_ids' not in params or
                params['aas_ids'] is None):
            raise ValueError("Missing the required parameter `aas_ids` when calling `put_aasxby_package_id`")  # noqa: E501
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `put_aasxby_package_id`")  # noqa: E501
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params or
                params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `put_aasxby_package_id`")  # noqa: E501
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params or
                params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `put_aasxby_package_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'package_id' in params:
            path_params['packageId'] = params['package_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'aas_ids' in params:
            form_params.append(('aasIds', params['aas_ids']))  # noqa: E501
            collection_formats['aasIds'] = 'multi'  # noqa: E501
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501
        if 'file_name' in params:
            form_params.append(('fileName', params['file_name']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/packages/{packageId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
