# coding: utf-8

"""
    DotAAS Part 2 | HTTP/REST | Entire API Collection

    All APIs of the Specification of the [Specification of the Asset Administration Shell: Part 2](http://industrialdigitaltwin.org/en/content-hub) in one collection. Please not that this API is not intended to generate productive code but only for overview purposes.   Publisher: Industrial Digital Twin Association (IDTA) 2023\"  # noqa: E501

    OpenAPI spec version: V3.0.1
    Contact: info@idtwin.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from aas_python_http_client.api_client import ApiClient


class AssetAdministrationShellRepositoryAPIApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_asset_administration_shell_by_id(self, aas_identifier, **kwargs):  # noqa: E501
        """Deletes an Asset Administration Shell  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_asset_administration_shell_by_id(aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_asset_administration_shell_by_id_with_http_info(aas_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_asset_administration_shell_by_id_with_http_info(aas_identifier, **kwargs)  # noqa: E501
            return data

    def delete_asset_administration_shell_by_id_with_http_info(self, aas_identifier, **kwargs):  # noqa: E501
        """Deletes an Asset Administration Shell  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_asset_administration_shell_by_id_with_http_info(aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_asset_administration_shell_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `delete_asset_administration_shell_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()  # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_file_by_path_aas_repository(self, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Deletes file content of an existing submodel element at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file_by_path_aas_repository(aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_file_by_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_file_by_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def delete_file_by_path_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Deletes file content of an existing submodel element at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file_by_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'id_short_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file_by_path_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `delete_file_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `delete_file_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `delete_file_by_path_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/attachment', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_submodel_by_id_aas_repository(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Deletes the submodel from the Asset Administration Shell and the Repository.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_submodel_by_id_aas_repository(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_submodel_by_id_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_submodel_by_id_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def delete_submodel_by_id_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Deletes the submodel from the Asset Administration Shell and the Repository.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_submodel_by_id_aas_repository_with_http_info(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_submodel_by_id_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `delete_submodel_by_id_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `delete_submodel_by_id_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_submodel_element_by_path_aas_repository(self, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Deletes a submodel element at a specified path within the submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_submodel_element_by_path_aas_repository(aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_submodel_element_by_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_submodel_element_by_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def delete_submodel_element_by_path_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Deletes a submodel element at a specified path within the submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_submodel_element_by_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'id_short_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_submodel_element_by_path_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `delete_submodel_element_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `delete_submodel_element_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `delete_submodel_element_by_path_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_submodel_reference_by_id_aas_repository(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Deletes the submodel reference from the Asset Administration Shell. Does not delete the submodel itself!  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_submodel_reference_by_id_aas_repository(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_submodel_reference_by_id_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_submodel_reference_by_id_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def delete_submodel_reference_by_id_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Deletes the submodel reference from the Asset Administration Shell. Does not delete the submodel itself!  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_submodel_reference_by_id_aas_repository_with_http_info(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_submodel_reference_by_id_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `delete_submodel_reference_by_id_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `delete_submodel_reference_by_id_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodel-refs/{submodelIdentifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_thumbnail_aas_repository(self, aas_identifier, **kwargs):  # noqa: E501
        """delete_thumbnail_aas_repository  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_thumbnail_aas_repository(aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_thumbnail_aas_repository_with_http_info(aas_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_thumbnail_aas_repository_with_http_info(aas_identifier, **kwargs)  # noqa: E501
            return data

    def delete_thumbnail_aas_repository_with_http_info(self, aas_identifier, **kwargs):  # noqa: E501
        """delete_thumbnail_aas_repository  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_thumbnail_aas_repository_with_http_info(aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_thumbnail_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `delete_thumbnail_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/asset-information/thumbnail', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_asset_administration_shells(self, **kwargs):  # noqa: E501
        """Returns all Asset Administration Shells  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_asset_administration_shells(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] asset_ids: A list of specific Asset identifiers. Each Asset identifier is a base64-url-encoded [SpecificAssetId](https://api.swaggerhub.com/domains/Plattform_i40/Part1-MetaModel-Schemas/V3.0.1#/components/schemas/SpecificAssetId)
        :param str id_short: The Asset Administration Shell’s IdShort
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :return: GetAssetAdministrationShellsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_asset_administration_shells_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_asset_administration_shells_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_asset_administration_shells_with_http_info(self, **kwargs):  # noqa: E501
        """Returns all Asset Administration Shells  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_asset_administration_shells_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] asset_ids: A list of specific Asset identifiers. Each Asset identifier is a base64-url-encoded [SpecificAssetId](https://api.swaggerhub.com/domains/Plattform_i40/Part1-MetaModel-Schemas/V3.0.1#/components/schemas/SpecificAssetId)
        :param str id_short: The Asset Administration Shell’s IdShort
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :return: GetAssetAdministrationShellsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_ids', 'id_short', 'limit', 'cursor']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_asset_administration_shells" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'asset_ids' in params:
            query_params.append(('assetIds', params['asset_ids']))  # noqa: E501
            collection_formats['assetIds'] = 'multi'  # noqa: E501
        if 'id_short' in params:
            query_params.append(('idShort', params['id_short']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetAssetAdministrationShellsResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_asset_administration_shells_reference(self, **kwargs):  # noqa: E501
        """Returns References to all Asset Administration Shells  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_asset_administration_shells_reference(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] asset_ids: A list of specific Asset identifiers. Each Asset identifier is a base64-url-encoded [SpecificAssetId](https://api.swaggerhub.com/domains/Plattform_i40/Part1-MetaModel-Schemas/V3.0.1#/components/schemas/SpecificAssetId)
        :param str id_short: The Asset Administration Shell’s IdShort
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :return: GetReferencesResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_asset_administration_shells_reference_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_asset_administration_shells_reference_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_asset_administration_shells_reference_with_http_info(self, **kwargs):  # noqa: E501
        """Returns References to all Asset Administration Shells  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_asset_administration_shells_reference_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] asset_ids: A list of specific Asset identifiers. Each Asset identifier is a base64-url-encoded [SpecificAssetId](https://api.swaggerhub.com/domains/Plattform_i40/Part1-MetaModel-Schemas/V3.0.1#/components/schemas/SpecificAssetId)
        :param str id_short: The Asset Administration Shell’s IdShort
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :return: GetReferencesResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_ids', 'id_short', 'limit', 'cursor']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_asset_administration_shells_reference" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'asset_ids' in params:
            query_params.append(('assetIds', params['asset_ids']))  # noqa: E501
            collection_formats['assetIds'] = 'multi'  # noqa: E501
        if 'id_short' in params:
            query_params.append(('idShort', params['id_short']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/$reference', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetReferencesResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_submodel_elements_aas_repository(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns all submodel elements including their hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_aas_repository(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: GetSubmodelElementsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_submodel_elements_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_submodel_elements_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_all_submodel_elements_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns all submodel elements including their hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_aas_repository_with_http_info(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: GetSubmodelElementsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'limit', 'cursor', 'level', 'extent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_submodel_elements_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_all_submodel_elements_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_all_submodel_elements_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501
        if 'extent' in params:
            query_params.append(('extent', params['extent']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSubmodelElementsResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_submodel_elements_metadata_aas_repository(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns all submodel elements including their hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_metadata_aas_repository(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :return: GetSubmodelElementsMetadataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_submodel_elements_metadata_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_submodel_elements_metadata_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_all_submodel_elements_metadata_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns all submodel elements including their hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_metadata_aas_repository_with_http_info(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :return: GetSubmodelElementsMetadataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'limit', 'cursor', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_submodel_elements_metadata_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_all_submodel_elements_metadata_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_all_submodel_elements_metadata_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/$metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSubmodelElementsMetadataResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_submodel_elements_path_aas_repository(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns all submodel elements including their hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_path_aas_repository(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: GetPathItemsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_submodel_elements_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_submodel_elements_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_all_submodel_elements_path_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns all submodel elements including their hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: GetPathItemsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'limit', 'cursor', 'level', 'extent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_submodel_elements_path_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_all_submodel_elements_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_all_submodel_elements_path_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501
        if 'extent' in params:
            query_params.append(('extent', params['extent']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/$path', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetPathItemsResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_submodel_elements_reference_aas_repository(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns all submodel elements as a list of References  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_reference_aas_repository(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :return: GetReferencesResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_submodel_elements_reference_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_submodel_elements_reference_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_all_submodel_elements_reference_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns all submodel elements as a list of References  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_reference_aas_repository_with_http_info(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :return: GetReferencesResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'limit', 'cursor', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_submodel_elements_reference_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_all_submodel_elements_reference_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_all_submodel_elements_reference_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/$reference', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetReferencesResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_submodel_elements_value_only_aas_repository(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns all submodel elements including their hierarchy in the ValueOnly representation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_value_only_aas_repository(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :return: GetSubmodelElementsValueResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_submodel_elements_value_only_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_submodel_elements_value_only_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_all_submodel_elements_value_only_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns all submodel elements including their hierarchy in the ValueOnly representation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_value_only_aas_repository_with_http_info(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :return: GetSubmodelElementsValueResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'limit', 'cursor', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_submodel_elements_value_only_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_all_submodel_elements_value_only_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_all_submodel_elements_value_only_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/$value', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSubmodelElementsValueResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_submodel_references_aas_repository(self, aas_identifier, **kwargs):  # noqa: E501
        """Returns all submodel references  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_references_aas_repository(aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :return: GetReferencesResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_submodel_references_aas_repository_with_http_info(aas_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_submodel_references_aas_repository_with_http_info(aas_identifier, **kwargs)  # noqa: E501
            return data

    def get_all_submodel_references_aas_repository_with_http_info(self, aas_identifier, **kwargs):  # noqa: E501
        """Returns all submodel references  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_references_aas_repository_with_http_info(aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :return: GetReferencesResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'limit', 'cursor']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_submodel_references_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_all_submodel_references_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodel-refs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetReferencesResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_administration_shell_by_id(self, aas_identifier, **kwargs):  # noqa: E501
        """Returns a specific Asset Administration Shell  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_administration_shell_by_id(aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: AssetAdministrationShell
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_administration_shell_by_id_with_http_info(aas_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_administration_shell_by_id_with_http_info(aas_identifier, **kwargs)  # noqa: E501
            return data

    def get_asset_administration_shell_by_id_with_http_info(self, aas_identifier, **kwargs):  # noqa: E501
        """Returns a specific Asset Administration Shell  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_administration_shell_by_id_with_http_info(aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: AssetAdministrationShell
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_administration_shell_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_asset_administration_shell_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetAdministrationShell',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_administration_shell_by_id_reference_aas_repository(self, aas_identifier, **kwargs):  # noqa: E501
        """Returns a specific Asset Administration Shell as a Reference  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_administration_shell_by_id_reference_aas_repository(aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: Reference
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_administration_shell_by_id_reference_aas_repository_with_http_info(aas_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_administration_shell_by_id_reference_aas_repository_with_http_info(aas_identifier, **kwargs)  # noqa: E501
            return data

    def get_asset_administration_shell_by_id_reference_aas_repository_with_http_info(self, aas_identifier, **kwargs):  # noqa: E501
        """Returns a specific Asset Administration Shell as a Reference  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_administration_shell_by_id_reference_aas_repository_with_http_info(aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: Reference
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_administration_shell_by_id_reference_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_asset_administration_shell_by_id_reference_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/$reference', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Reference',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_information_aas_repository(self, aas_identifier, **kwargs):  # noqa: E501
        """Returns the Asset Information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_information_aas_repository(aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: AssetInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_information_aas_repository_with_http_info(aas_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_information_aas_repository_with_http_info(aas_identifier, **kwargs)  # noqa: E501
            return data

    def get_asset_information_aas_repository_with_http_info(self, aas_identifier, **kwargs):  # noqa: E501
        """Returns the Asset Information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_information_aas_repository_with_http_info(aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: AssetInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_information_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_asset_information_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/asset-information', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetInformation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_by_path_aas_repository(self, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Downloads file content from a specific submodel element from the Submodel at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_by_path_aas_repository(aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_by_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_by_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def get_file_by_path_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Downloads file content from a specific submodel element from the Submodel at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_by_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'id_short_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_by_path_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_file_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_file_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `get_file_by_path_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/attachment', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_operation_async_result_aas_repository(self, aas_identifier, submodel_identifier, id_short_path, handle_id, **kwargs):  # noqa: E501
        """Returns the Operation result of an asynchronous invoked Operation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_operation_async_result_aas_repository(aas_identifier, submodel_identifier, id_short_path, handle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str handle_id: The returned handle id of an operation’s asynchronous invocation used to request the current state of the operation’s execution (UTF8-BASE64-URL-encoded) (required)
        :return: OperationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_operation_async_result_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, handle_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_operation_async_result_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, handle_id, **kwargs)  # noqa: E501
            return data

    def get_operation_async_result_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, id_short_path, handle_id, **kwargs):  # noqa: E501
        """Returns the Operation result of an asynchronous invoked Operation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_operation_async_result_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, handle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str handle_id: The returned handle id of an operation’s asynchronous invocation used to request the current state of the operation’s execution (UTF8-BASE64-URL-encoded) (required)
        :return: OperationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'id_short_path', 'handle_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_operation_async_result_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_operation_async_result_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_operation_async_result_aas_repository`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `get_operation_async_result_aas_repository`")  # noqa: E501
        # verify the required parameter 'handle_id' is set
        if ('handle_id' not in params or
                params['handle_id'] is None):
            raise ValueError("Missing the required parameter `handle_id` when calling `get_operation_async_result_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501
        if 'handle_id' in params:
            path_params['handleId'] = params['handle_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/operation-results/{handleId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OperationResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_operation_async_result_value_only_aas_repository(self, aas_identifier, submodel_identifier, id_short_path, handle_id, **kwargs):  # noqa: E501
        """Returns the ValueOnly notation of the Operation result of an asynchronous invoked Operation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_operation_async_result_value_only_aas_repository(aas_identifier, submodel_identifier, id_short_path, handle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str handle_id: The returned handle id of an operation’s asynchronous invocation used to request the current state of the operation’s execution (UTF8-BASE64-URL-encoded) (required)
        :return: OperationResultValueOnly
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_operation_async_result_value_only_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, handle_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_operation_async_result_value_only_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, handle_id, **kwargs)  # noqa: E501
            return data

    def get_operation_async_result_value_only_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, id_short_path, handle_id, **kwargs):  # noqa: E501
        """Returns the ValueOnly notation of the Operation result of an asynchronous invoked Operation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_operation_async_result_value_only_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, handle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str handle_id: The returned handle id of an operation’s asynchronous invocation used to request the current state of the operation’s execution (UTF8-BASE64-URL-encoded) (required)
        :return: OperationResultValueOnly
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'id_short_path', 'handle_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_operation_async_result_value_only_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_operation_async_result_value_only_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_operation_async_result_value_only_aas_repository`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `get_operation_async_result_value_only_aas_repository`")  # noqa: E501
        # verify the required parameter 'handle_id' is set
        if ('handle_id' not in params or
                params['handle_id'] is None):
            raise ValueError("Missing the required parameter `handle_id` when calling `get_operation_async_result_value_only_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501
        if 'handle_id' in params:
            path_params['handleId'] = params['handle_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/operation-results/{handleId}/$value', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OperationResultValueOnly',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_operation_async_status_aas_repository(self, aas_identifier, submodel_identifier, id_short_path, handle_id, **kwargs):  # noqa: E501
        """Returns the Operation status of an asynchronous invoked Operation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_operation_async_status_aas_repository(aas_identifier, submodel_identifier, id_short_path, handle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str handle_id: The returned handle id of an operation’s asynchronous invocation used to request the current state of the operation’s execution (UTF8-BASE64-URL-encoded) (required)
        :return: BaseOperationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_operation_async_status_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, handle_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_operation_async_status_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, handle_id, **kwargs)  # noqa: E501
            return data

    def get_operation_async_status_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, id_short_path, handle_id, **kwargs):  # noqa: E501
        """Returns the Operation status of an asynchronous invoked Operation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_operation_async_status_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, handle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str handle_id: The returned handle id of an operation’s asynchronous invocation used to request the current state of the operation’s execution (UTF8-BASE64-URL-encoded) (required)
        :return: BaseOperationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'id_short_path', 'handle_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_operation_async_status_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_operation_async_status_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_operation_async_status_aas_repository`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `get_operation_async_status_aas_repository`")  # noqa: E501
        # verify the required parameter 'handle_id' is set
        if ('handle_id' not in params or
                params['handle_id'] is None):
            raise ValueError("Missing the required parameter `handle_id` when calling `get_operation_async_status_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501
        if 'handle_id' in params:
            path_params['handleId'] = params['handle_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/operation-status/{handleId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseOperationResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_by_id_aas_repository(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns the Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id_aas_repository(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: Submodel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_by_id_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_by_id_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_submodel_by_id_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns the Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id_aas_repository_with_http_info(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: Submodel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'level', 'extent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_by_id_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_submodel_by_id_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_by_id_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501
        if 'extent' in params:
            query_params.append(('extent', params['extent']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Submodel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_by_id_metadata_aas_repository(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns the Submodel's metadata elements  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id_metadata_aas_repository(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: SubmodelMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_by_id_metadata_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_by_id_metadata_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_submodel_by_id_metadata_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns the Submodel's metadata elements  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id_metadata_aas_repository_with_http_info(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: SubmodelMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_by_id_metadata_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_submodel_by_id_metadata_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_by_id_metadata_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/$metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubmodelMetadata',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_by_id_path_aas_repository(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns the Submodel's metadata elements  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id_path_aas_repository(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: list[PathItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_by_id_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_by_id_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_submodel_by_id_path_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns the Submodel's metadata elements  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: list[PathItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_by_id_path_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_submodel_by_id_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_by_id_path_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/$path', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PathItem]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_by_id_reference_aas_repository(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns the Submodel as a Reference  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id_reference_aas_repository(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: Reference
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_by_id_reference_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_by_id_reference_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_submodel_by_id_reference_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns the Submodel as a Reference  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id_reference_aas_repository_with_http_info(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: Reference
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_by_id_reference_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_submodel_by_id_reference_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_by_id_reference_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/$reference', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Reference',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_by_id_value_only_aas_repository(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns the Submodel's ValueOnly representation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id_value_only_aas_repository(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: SubmodelValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_by_id_value_only_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_by_id_value_only_aas_repository_with_http_info(aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_submodel_by_id_value_only_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Returns the Submodel's ValueOnly representation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id_value_only_aas_repository_with_http_info(aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: SubmodelValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'level', 'extent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_by_id_value_only_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_submodel_by_id_value_only_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_by_id_value_only_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501
        if 'extent' in params:
            query_params.append(('extent', params['extent']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/$value', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubmodelValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_element_by_path_aas_repository(self, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns a specific submodel element from the Submodel at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_aas_repository(aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: SubmodelElement
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_element_by_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_element_by_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def get_submodel_element_by_path_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns a specific submodel element from the Submodel at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: SubmodelElement
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'id_short_path', 'level', 'extent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_element_by_path_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_submodel_element_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_element_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `get_submodel_element_by_path_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501
        if 'extent' in params:
            query_params.append(('extent', params['extent']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubmodelElement',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_element_by_path_metadata_aas_repository(self, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns the metadata attributes if a specific submodel element from the Submodel at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_metadata_aas_repository(aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: SubmodelElementMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_element_by_path_metadata_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_element_by_path_metadata_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def get_submodel_element_by_path_metadata_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns the metadata attributes if a specific submodel element from the Submodel at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_metadata_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: SubmodelElementMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'id_short_path', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_element_by_path_metadata_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_submodel_element_by_path_metadata_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_element_by_path_metadata_aas_repository`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `get_submodel_element_by_path_metadata_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubmodelElementMetadata',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_element_by_path_path_aas_repository(self, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns a specific submodel element from the Submodel at a specified path in the Path notation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_path_aas_repository(aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: PathItem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_element_by_path_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_element_by_path_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def get_submodel_element_by_path_path_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns a specific submodel element from the Submodel at a specified path in the Path notation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_path_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: PathItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'id_short_path', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_element_by_path_path_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_submodel_element_by_path_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_element_by_path_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `get_submodel_element_by_path_path_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$path', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PathItem',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_element_by_path_reference_aas_repository(self, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns the Reference of a specific submodel element from the Submodel at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_reference_aas_repository(aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: Reference
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_element_by_path_reference_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_element_by_path_reference_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def get_submodel_element_by_path_reference_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns the Reference of a specific submodel element from the Submodel at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_reference_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: Reference
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'id_short_path', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_element_by_path_reference_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_submodel_element_by_path_reference_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_element_by_path_reference_aas_repository`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `get_submodel_element_by_path_reference_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$reference', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Reference',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_element_by_path_value_only_aas_repository(self, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns a specific submodel element from the Submodel at a specified path in the ValueOnly representation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_value_only_aas_repository(aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: SubmodelElementValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_element_by_path_value_only_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_element_by_path_value_only_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def get_submodel_element_by_path_value_only_aas_repository_with_http_info(self, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns a specific submodel element from the Submodel at a specified path in the ValueOnly representation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_value_only_aas_repository_with_http_info(aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: SubmodelElementValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier', 'submodel_identifier', 'id_short_path', 'level', 'extent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_element_by_path_value_only_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_submodel_element_by_path_value_only_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_element_by_path_value_only_aas_repository`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `get_submodel_element_by_path_value_only_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501
        if 'extent' in params:
            query_params.append(('extent', params['extent']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$value', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubmodelElementValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_thumbnail_aas_repository(self, aas_identifier, **kwargs):  # noqa: E501
        """get_thumbnail_aas_repository  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_thumbnail_aas_repository(aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_thumbnail_aas_repository_with_http_info(aas_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_thumbnail_aas_repository_with_http_info(aas_identifier, **kwargs)  # noqa: E501
            return data

    def get_thumbnail_aas_repository_with_http_info(self, aas_identifier, **kwargs):  # noqa: E501
        """get_thumbnail_aas_repository  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_thumbnail_aas_repository_with_http_info(aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['aas_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_thumbnail_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `get_thumbnail_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/asset-information/thumbnail', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def invoke_operation_aas_repository(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Synchronously invokes an Operation at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invoke_operation_aas_repository(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OperationRequest body: Operation request object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: OperationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.invoke_operation_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.invoke_operation_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def invoke_operation_aas_repository_with_http_info(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Synchronously invokes an Operation at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invoke_operation_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OperationRequest body: Operation request object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: OperationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'aas_identifier', 'submodel_identifier', 'id_short_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method invoke_operation_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `invoke_operation_aas_repository`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `invoke_operation_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `invoke_operation_aas_repository`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `invoke_operation_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OperationResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def invoke_operation_async_aas_repository(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Asynchronously invokes an Operation at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invoke_operation_async_aas_repository(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OperationRequest body: Operation request object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.invoke_operation_async_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.invoke_operation_async_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def invoke_operation_async_aas_repository_with_http_info(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Asynchronously invokes an Operation at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invoke_operation_async_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OperationRequest body: Operation request object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'aas_identifier', 'submodel_identifier', 'id_short_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method invoke_operation_async_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `invoke_operation_async_aas_repository`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `invoke_operation_async_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `invoke_operation_async_aas_repository`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `invoke_operation_async_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke-async', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def invoke_operation_async_value_only_aas_repository(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Asynchronously invokes an Operation at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invoke_operation_async_value_only_aas_repository(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OperationRequestValueOnly body: Operation request object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.invoke_operation_async_value_only_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.invoke_operation_async_value_only_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def invoke_operation_async_value_only_aas_repository_with_http_info(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Asynchronously invokes an Operation at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invoke_operation_async_value_only_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OperationRequestValueOnly body: Operation request object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'aas_identifier', 'submodel_identifier', 'id_short_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method invoke_operation_async_value_only_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `invoke_operation_async_value_only_aas_repository`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `invoke_operation_async_value_only_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `invoke_operation_async_value_only_aas_repository`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `invoke_operation_async_value_only_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke-async/$value', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def invoke_operation_value_only_aas_repository(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Synchronously invokes an Operation at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invoke_operation_value_only_aas_repository(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OperationRequestValueOnly body: Operation request object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: OperationResultValueOnly
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.invoke_operation_value_only_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.invoke_operation_value_only_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def invoke_operation_value_only_aas_repository_with_http_info(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Synchronously invokes an Operation at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invoke_operation_value_only_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OperationRequestValueOnly body: Operation request object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: OperationResultValueOnly
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'aas_identifier', 'submodel_identifier', 'id_short_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method invoke_operation_value_only_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `invoke_operation_value_only_aas_repository`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `invoke_operation_value_only_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `invoke_operation_value_only_aas_repository`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `invoke_operation_value_only_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke/$value', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OperationResultValueOnly',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_submodel_aas_repository(self, body, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Updates the Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_aas_repository(body, aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Submodel body: Submodel object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_submodel_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_submodel_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def patch_submodel_aas_repository_with_http_info(self, body, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Updates the Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Submodel body: Submodel object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'aas_identifier', 'submodel_identifier', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_submodel_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_submodel_aas_repository`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `patch_submodel_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `patch_submodel_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_submodel_by_id_metadata_aas_repository(self, body, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Updates the metadata attributes of the Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_by_id_metadata_aas_repository(body, aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelMetadata body: Submodel object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_submodel_by_id_metadata_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_submodel_by_id_metadata_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def patch_submodel_by_id_metadata_aas_repository_with_http_info(self, body, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Updates the metadata attributes of the Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_by_id_metadata_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelMetadata body: Submodel object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'aas_identifier', 'submodel_identifier', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_submodel_by_id_metadata_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_submodel_by_id_metadata_aas_repository`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `patch_submodel_by_id_metadata_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `patch_submodel_by_id_metadata_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/$metadata', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_submodel_by_id_value_only_aas_repository(self, body, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Updates teh values of the Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_by_id_value_only_aas_repository(body, aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelValue body: Submodel object in the ValueOnly representation (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_submodel_by_id_value_only_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_submodel_by_id_value_only_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def patch_submodel_by_id_value_only_aas_repository_with_http_info(self, body, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Updates teh values of the Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_by_id_value_only_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelValue body: Submodel object in the ValueOnly representation (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'aas_identifier', 'submodel_identifier', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_submodel_by_id_value_only_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_submodel_by_id_value_only_aas_repository`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `patch_submodel_by_id_value_only_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `patch_submodel_by_id_value_only_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/$value', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_submodel_element_value_by_path_aas_repository(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Updates an existing submodel element value at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_element_value_by_path_aas_repository(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElement body: The updated value of the submodel element (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_submodel_element_value_by_path_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_submodel_element_value_by_path_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def patch_submodel_element_value_by_path_aas_repository_with_http_info(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Updates an existing submodel element value at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_element_value_by_path_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElement body: The updated value of the submodel element (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'aas_identifier', 'submodel_identifier', 'id_short_path', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_submodel_element_value_by_path_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_submodel_element_value_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `patch_submodel_element_value_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `patch_submodel_element_value_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `patch_submodel_element_value_by_path_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_submodel_element_value_by_path_metadata(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Updates the metadata attributes of an existing submodel element value at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_element_value_by_path_metadata(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElementMetadata body: The updated metadata attributes of the submodel element (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_submodel_element_value_by_path_metadata_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_submodel_element_value_by_path_metadata_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def patch_submodel_element_value_by_path_metadata_with_http_info(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Updates the metadata attributes of an existing submodel element value at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_element_value_by_path_metadata_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElementMetadata body: The updated metadata attributes of the submodel element (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'aas_identifier', 'submodel_identifier', 'id_short_path', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_submodel_element_value_by_path_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_submodel_element_value_by_path_metadata`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `patch_submodel_element_value_by_path_metadata`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `patch_submodel_element_value_by_path_metadata`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `patch_submodel_element_value_by_path_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$metadata', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_submodel_element_value_by_path_value_only(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Updates the value of an existing submodel element value at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_element_value_by_path_value_only(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElementValue body: The updated value of the submodel element (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_submodel_element_value_by_path_value_only_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_submodel_element_value_by_path_value_only_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def patch_submodel_element_value_by_path_value_only_with_http_info(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Updates the value of an existing submodel element value at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_element_value_by_path_value_only_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElementValue body: The updated value of the submodel element (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'aas_identifier', 'submodel_identifier', 'id_short_path', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_submodel_element_value_by_path_value_only" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_submodel_element_value_by_path_value_only`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `patch_submodel_element_value_by_path_value_only`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `patch_submodel_element_value_by_path_value_only`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `patch_submodel_element_value_by_path_value_only`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$value', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_asset_administration_shell(self, body, **kwargs):  # noqa: E501
        """Creates a new Asset Administration Shell  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_asset_administration_shell(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetAdministrationShell body: Asset Administration Shell object (required)
        :return: AssetAdministrationShell
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_asset_administration_shell_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_asset_administration_shell_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_asset_administration_shell_with_http_info(self, body, **kwargs):  # noqa: E501
        """Creates a new Asset Administration Shell  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_asset_administration_shell_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetAdministrationShell body: Asset Administration Shell object (required)
        :return: AssetAdministrationShell
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_asset_administration_shell" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_asset_administration_shell`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetAdministrationShell',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_submodel_element_aas_repository(self, body, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Creates a new submodel element  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_submodel_element_aas_repository(body, aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElement body: Requested submodel element (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: SubmodelElement
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_submodel_element_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.post_submodel_element_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def post_submodel_element_aas_repository_with_http_info(self, body, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Creates a new submodel element  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_submodel_element_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElement body: Requested submodel element (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: SubmodelElement
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'aas_identifier', 'submodel_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_submodel_element_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_submodel_element_aas_repository`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `post_submodel_element_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `post_submodel_element_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubmodelElement',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_submodel_element_by_path_aas_repository(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Creates a new submodel element at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_submodel_element_by_path_aas_repository(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElement body: Requested submodel element (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: SubmodelElement
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_submodel_element_by_path_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.post_submodel_element_by_path_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def post_submodel_element_by_path_aas_repository_with_http_info(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Creates a new submodel element at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_submodel_element_by_path_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElement body: Requested submodel element (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: SubmodelElement
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'aas_identifier', 'submodel_identifier', 'id_short_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_submodel_element_by_path_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_submodel_element_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `post_submodel_element_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `post_submodel_element_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `post_submodel_element_by_path_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubmodelElement',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_submodel_reference_aas_repository(self, body, aas_identifier, **kwargs):  # noqa: E501
        """Creates a submodel reference at the Asset Administration Shell  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_submodel_reference_aas_repository(body, aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Reference body: Reference to the Submodel (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: Reference
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_submodel_reference_aas_repository_with_http_info(body, aas_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.post_submodel_reference_aas_repository_with_http_info(body, aas_identifier, **kwargs)  # noqa: E501
            return data

    def post_submodel_reference_aas_repository_with_http_info(self, body, aas_identifier, **kwargs):  # noqa: E501
        """Creates a submodel reference at the Asset Administration Shell  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_submodel_reference_aas_repository_with_http_info(body, aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Reference body: Reference to the Submodel (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: Reference
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'aas_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_submodel_reference_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_submodel_reference_aas_repository`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `post_submodel_reference_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodel-refs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Reference',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_asset_administration_shell_by_id(self, body, aas_identifier, **kwargs):  # noqa: E501
        """Updates an existing Asset Administration Shell  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_asset_administration_shell_by_id(body, aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetAdministrationShell body: Asset Administration Shell object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_asset_administration_shell_by_id_with_http_info(body, aas_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.put_asset_administration_shell_by_id_with_http_info(body, aas_identifier, **kwargs)  # noqa: E501
            return data

    def put_asset_administration_shell_by_id_with_http_info(self, body, aas_identifier, **kwargs):  # noqa: E501
        """Updates an existing Asset Administration Shell  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_asset_administration_shell_by_id_with_http_info(body, aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetAdministrationShell body: Asset Administration Shell object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'aas_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_asset_administration_shell_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_asset_administration_shell_by_id`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `put_asset_administration_shell_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_asset_information_aas_repository(self, body, aas_identifier, **kwargs):  # noqa: E501
        """Updates the Asset Information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_asset_information_aas_repository(body, aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetInformation body: Asset Information object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_asset_information_aas_repository_with_http_info(body, aas_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.put_asset_information_aas_repository_with_http_info(body, aas_identifier, **kwargs)  # noqa: E501
            return data

    def put_asset_information_aas_repository_with_http_info(self, body, aas_identifier, **kwargs):  # noqa: E501
        """Updates the Asset Information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_asset_information_aas_repository_with_http_info(body, aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetInformation body: Asset Information object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'aas_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_asset_information_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_asset_information_aas_repository`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `put_asset_information_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/asset-information', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_file_by_path_aas_repository(self, file_name, file, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Uploads file content to an existing submodel element at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_file_by_path_aas_repository(file_name, file, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_name: (required)
        :param str file: (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_file_by_path_aas_repository_with_http_info(file_name, file, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.put_file_by_path_aas_repository_with_http_info(file_name, file, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def put_file_by_path_aas_repository_with_http_info(self, file_name, file, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Uploads file content to an existing submodel element at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_file_by_path_aas_repository_with_http_info(file_name, file, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_name: (required)
        :param str file: (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_name', 'file', 'aas_identifier', 'submodel_identifier', 'id_short_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_file_by_path_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params or
                params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `put_file_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `put_file_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `put_file_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `put_file_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `put_file_by_path_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file_name' in params:
            form_params.append(('fileName', params['file_name']))  # noqa: E501
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/attachment', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_submodel_by_id_aas_repository(self, body, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Updates the Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_submodel_by_id_aas_repository(body, aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Submodel body: Submodel object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_submodel_by_id_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.put_submodel_by_id_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def put_submodel_by_id_aas_repository_with_http_info(self, body, aas_identifier, submodel_identifier, **kwargs):  # noqa: E501
        """Updates the Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_submodel_by_id_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Submodel body: Submodel object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'aas_identifier', 'submodel_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_submodel_by_id_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_submodel_by_id_aas_repository`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `put_submodel_by_id_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `put_submodel_by_id_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_submodel_element_by_path_aas_repository(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Updates an existing submodel element at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_submodel_element_by_path_aas_repository(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElement body: Requested submodel element (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_submodel_element_by_path_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.put_submodel_element_by_path_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def put_submodel_element_by_path_aas_repository_with_http_info(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Updates an existing submodel element at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_submodel_element_by_path_aas_repository_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElement body: Requested submodel element (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'aas_identifier', 'submodel_identifier', 'id_short_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_submodel_element_by_path_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_submodel_element_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `put_submodel_element_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `put_submodel_element_by_path_aas_repository`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `put_submodel_element_by_path_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_thumbnail_aas_repository(self, file_name, file, aas_identifier, **kwargs):  # noqa: E501
        """put_thumbnail_aas_repository  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_thumbnail_aas_repository(file_name, file, aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_name: (required)
        :param str file: (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_thumbnail_aas_repository_with_http_info(file_name, file, aas_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.put_thumbnail_aas_repository_with_http_info(file_name, file, aas_identifier, **kwargs)  # noqa: E501
            return data

    def put_thumbnail_aas_repository_with_http_info(self, file_name, file, aas_identifier, **kwargs):  # noqa: E501
        """put_thumbnail_aas_repository  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_thumbnail_aas_repository_with_http_info(file_name, file, aas_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_name: (required)
        :param str file: (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_name', 'file', 'aas_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_thumbnail_aas_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params or
                params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `put_thumbnail_aas_repository`")  # noqa: E501
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `put_thumbnail_aas_repository`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `put_thumbnail_aas_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file_name' in params:
            form_params.append(('fileName', params['file_name']))  # noqa: E501
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = self.api_client.configuration.get_auth_settings_keys()   # noqa: E501

        return self.api_client.call_api(
            '/shells/{aasIdentifier}/asset-information/thumbnail', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
