from enum import Enum


class User(str, Enum):
    CREATE_SUB_UID = "/v5/user/create-sub-member"
    CREATE_SUB_API_KEY = "/v5/user/create-sub-api"
    GET_SUB_UID_LIST = "/v5/user/query-sub-members"
    GET_SUB_UID_LIST_UNLIMITED = "/v5/user/submembers"
    FREEZE_SUB_UID = "/v5/user/frozen-sub-member"
    GET_API_KEY_INFORMATION = "/v5/user/query-api"
    MODIFY_MASTER_API_KEY = "/v5/user/update-api"
    MODIFY_SUB_API_KEY = "/v5/user/update-sub-api"
    DELETE_MASTER_API_KEY = "/v5/user/delete-api"
    DELETE_SUB_API_KEY = "/v5/user/delete-sub-api"
    DELETE_SUB_UID = "/v5/user/del-submember"
    GET_ALL_SUB_API_KEYS = "/v5/user/sub-apikeys"
    GET_UID_WALLET_TYPE = "/v5/user/get-member-type"
    GET_ESCROW_SUB_MEMBERS = "/v5/user/escrow_sub_members"

    def __str__(self) -> str:
        return self.value
