# -*- coding: utf-8 -*-
#
# This file was automatically generated.
#
from datetime import datetime
from typing import Optional

from .amount_data import AmountData
from .dcc_data import DccData
from .payment_references import PaymentReferences

from worldline.acquiring.sdk.domain.data_object import DataObject


class ApiPaymentRefundRequest(DataObject):

    __amount: Optional[AmountData] = None
    __capture_immediately: Optional[bool] = None
    __dynamic_currency_conversion: Optional[DccData] = None
    __operation_id: Optional[str] = None
    __references: Optional[PaymentReferences] = None
    __transaction_timestamp: Optional[datetime] = None

    @property
    def amount(self) -> Optional[AmountData]:
        """
        | Amount to refund. If not provided, the full amount will be refunded.

        Type: :class:`worldline.acquiring.sdk.v1.domain.amount_data.AmountData`
        """
        return self.__amount

    @amount.setter
    def amount(self, value: Optional[AmountData]) -> None:
        self.__amount = value

    @property
    def capture_immediately(self) -> Optional[bool]:
        """
        | If true the transaction will be authorized and captured immediately

        Type: bool
        """
        return self.__capture_immediately

    @capture_immediately.setter
    def capture_immediately(self, value: Optional[bool]) -> None:
        self.__capture_immediately = value

    @property
    def dynamic_currency_conversion(self) -> Optional[DccData]:
        """
        | Dynamic Currency Conversion (DCC) rate data from DCC lookup response.
        | Mandatory for DCC transactions.

        Type: :class:`worldline.acquiring.sdk.v1.domain.dcc_data.DccData`
        """
        return self.__dynamic_currency_conversion

    @dynamic_currency_conversion.setter
    def dynamic_currency_conversion(self, value: Optional[DccData]) -> None:
        self.__dynamic_currency_conversion = value

    @property
    def operation_id(self) -> Optional[str]:
        """
        | A globally unique identifier of the operation, generated by you.
        | We advise you to submit a UUID or an identifier composed of an arbitrary string and a UUID/URL-safe Base64 UUID (RFC 4648 §5).
        | It's used to detect duplicate requests or to reference an operation in technical reversals.

        Type: str
        """
        return self.__operation_id

    @operation_id.setter
    def operation_id(self, value: Optional[str]) -> None:
        self.__operation_id = value

    @property
    def references(self) -> Optional[PaymentReferences]:
        """
        | Payment References

        Type: :class:`worldline.acquiring.sdk.v1.domain.payment_references.PaymentReferences`
        """
        return self.__references

    @references.setter
    def references(self, value: Optional[PaymentReferences]) -> None:
        self.__references = value

    @property
    def transaction_timestamp(self) -> Optional[datetime]:
        """
        | Timestamp of transaction in ISO 8601 format (YYYY-MM-DDThh:mm:ss+TZD)
        | It can be expressed in merchant time zone (ex: 2023-10-10T08:00+02:00) or in UTC (ex: 2023-10-10T08:00Z)

        Type: datetime
        """
        return self.__transaction_timestamp

    @transaction_timestamp.setter
    def transaction_timestamp(self, value: Optional[datetime]) -> None:
        self.__transaction_timestamp = value

    def to_dictionary(self) -> dict:
        dictionary = super(ApiPaymentRefundRequest, self).to_dictionary()
        if self.amount is not None:
            dictionary['amount'] = self.amount.to_dictionary()
        if self.capture_immediately is not None:
            dictionary['captureImmediately'] = self.capture_immediately
        if self.dynamic_currency_conversion is not None:
            dictionary['dynamicCurrencyConversion'] = self.dynamic_currency_conversion.to_dictionary()
        if self.operation_id is not None:
            dictionary['operationId'] = self.operation_id
        if self.references is not None:
            dictionary['references'] = self.references.to_dictionary()
        if self.transaction_timestamp is not None:
            dictionary['transactionTimestamp'] = DataObject.format_datetime(self.transaction_timestamp)
        return dictionary

    def from_dictionary(self, dictionary: dict) -> 'ApiPaymentRefundRequest':
        super(ApiPaymentRefundRequest, self).from_dictionary(dictionary)
        if 'amount' in dictionary:
            if not isinstance(dictionary['amount'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['amount']))
            value = AmountData()
            self.amount = value.from_dictionary(dictionary['amount'])
        if 'captureImmediately' in dictionary:
            self.capture_immediately = dictionary['captureImmediately']
        if 'dynamicCurrencyConversion' in dictionary:
            if not isinstance(dictionary['dynamicCurrencyConversion'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['dynamicCurrencyConversion']))
            value = DccData()
            self.dynamic_currency_conversion = value.from_dictionary(dictionary['dynamicCurrencyConversion'])
        if 'operationId' in dictionary:
            self.operation_id = dictionary['operationId']
        if 'references' in dictionary:
            if not isinstance(dictionary['references'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['references']))
            value = PaymentReferences()
            self.references = value.from_dictionary(dictionary['references'])
        if 'transactionTimestamp' in dictionary:
            self.transaction_timestamp = DataObject.parse_datetime(dictionary['transactionTimestamp'])
        return self
