# -*- coding: utf-8 -*-
#
# This file was automatically generated.
#
from datetime import datetime
from typing import Optional

from .terminal_data import TerminalData

from worldline.acquiring.sdk.domain.data_object import DataObject


class ApiRefundReversalRequest(DataObject):

    __operation_id: Optional[str] = None
    __terminal_data: Optional[TerminalData] = None
    __transaction_timestamp: Optional[datetime] = None

    @property
    def operation_id(self) -> Optional[str]:
        """
        | A globally unique identifier of the operation, generated by you.
        | We advise you to submit a UUID or an identifier composed of an arbitrary string and a UUID/URL-safe Base64 UUID (RFC 4648 §5).
        | It's used to detect duplicate requests or to reference an operation in technical reversals.

        Type: str
        """
        return self.__operation_id

    @operation_id.setter
    def operation_id(self, value: Optional[str]) -> None:
        self.__operation_id = value

    @property
    def terminal_data(self) -> Optional[TerminalData]:
        """
        Type: :class:`worldline.acquiring.sdk.v1.domain.terminal_data.TerminalData`
        """
        return self.__terminal_data

    @terminal_data.setter
    def terminal_data(self, value: Optional[TerminalData]) -> None:
        self.__terminal_data = value

    @property
    def transaction_timestamp(self) -> Optional[datetime]:
        """
        | Timestamp of transaction in ISO 8601 format (YYYY-MM-DDThh:mm:ss+TZD)
        | It can be expressed in merchant time zone (ex: 2023-10-10T08:00+02:00) or in UTC (ex: 2023-10-10T08:00Z)

        Type: datetime
        """
        return self.__transaction_timestamp

    @transaction_timestamp.setter
    def transaction_timestamp(self, value: Optional[datetime]) -> None:
        self.__transaction_timestamp = value

    def to_dictionary(self) -> dict:
        dictionary = super(ApiRefundReversalRequest, self).to_dictionary()
        if self.operation_id is not None:
            dictionary['operationId'] = self.operation_id
        if self.terminal_data is not None:
            dictionary['terminalData'] = self.terminal_data.to_dictionary()
        if self.transaction_timestamp is not None:
            dictionary['transactionTimestamp'] = DataObject.format_datetime(self.transaction_timestamp)
        return dictionary

    def from_dictionary(self, dictionary: dict) -> 'ApiRefundReversalRequest':
        super(ApiRefundReversalRequest, self).from_dictionary(dictionary)
        if 'operationId' in dictionary:
            self.operation_id = dictionary['operationId']
        if 'terminalData' in dictionary:
            if not isinstance(dictionary['terminalData'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['terminalData']))
            value = TerminalData()
            self.terminal_data = value.from_dictionary(dictionary['terminalData'])
        if 'transactionTimestamp' in dictionary:
            self.transaction_timestamp = DataObject.parse_datetime(dictionary['transactionTimestamp'])
        return self
