# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 0.3.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class AltAzConstraint(BaseModel):
    """
    For a given Alt/Az constraint, is a given coordinate inside this constraint? Constraint is both defined by a polygon exclusion region and a minimum and maximum altitude. By default the minimum and maximum altitude values are 0 and 90 degrees respectively. Polygon restriction regions can be combined with minimum and maximum altitude restrictions.  Parameters ---------- polygon     The polygon defining the exclusion region. min     The minimum altitude in degrees. max     The maximum altitude in degrees.
    """ # noqa: E501
    short_name: Optional[StrictStr] = 'AltAz'
    name: Optional[StrictStr] = 'Altitude/Azimuth Avoidance'
    polygon: List[List[Union[StrictFloat, StrictInt]]]
    altitude_min: Optional[Union[Annotated[float, Field(le=90.0, strict=True, ge=0.0)], Annotated[int, Field(le=90, strict=True, ge=0)]]] = None
    altitude_max: Optional[Union[Annotated[float, Field(le=90.0, strict=True, ge=0.0)], Annotated[int, Field(le=90, strict=True, ge=0)]]] = None
    azimuth_min: Optional[Union[Annotated[float, Field(strict=True, ge=0.0)], Annotated[int, Field(strict=True, ge=0)]]] = None
    azimuth_max: Optional[Union[Annotated[float, Field(strict=True, ge=0.0)], Annotated[int, Field(strict=True, ge=0)]]] = None
    __properties: ClassVar[List[str]] = ["short_name", "name", "polygon", "altitude_min", "altitude_max", "azimuth_min", "azimuth_max"]

    @field_validator('name')
    def name_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Altitude/Azimuth Avoidance']):
            raise ValueError("must be one of enum values ('Altitude/Azimuth Avoidance')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AltAzConstraint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if altitude_min (nullable) is None
        # and model_fields_set contains the field
        if self.altitude_min is None and "altitude_min" in self.model_fields_set:
            _dict['altitude_min'] = None

        # set to None if altitude_max (nullable) is None
        # and model_fields_set contains the field
        if self.altitude_max is None and "altitude_max" in self.model_fields_set:
            _dict['altitude_max'] = None

        # set to None if azimuth_min (nullable) is None
        # and model_fields_set contains the field
        if self.azimuth_min is None and "azimuth_min" in self.model_fields_set:
            _dict['azimuth_min'] = None

        # set to None if azimuth_max (nullable) is None
        # and model_fields_set contains the field
        if self.azimuth_max is None and "azimuth_max" in self.model_fields_set:
            _dict['azimuth_max'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AltAzConstraint from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "short_name": obj.get("short_name") if obj.get("short_name") is not None else 'AltAz',
            "name": obj.get("name") if obj.get("name") is not None else 'Altitude/Azimuth Avoidance',
            "polygon": obj.get("polygon"),
            "altitude_min": obj.get("altitude_min"),
            "altitude_max": obj.get("altitude_max"),
            "azimuth_min": obj.get("azimuth_min"),
            "azimuth_max": obj.get("azimuth_max")
        })
        return _obj


