# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 0.3.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from across.sdk.v1.models.date_range import DateRange
from across.sdk.v1.models.observation_create import ObservationCreate
from across.sdk.v1.models.schedule_fidelity import ScheduleFidelity
from across.sdk.v1.models.schedule_status import ScheduleStatus
from typing import Optional, Set
from typing_extensions import Self

class ScheduleCreate(BaseModel):
    """
    A Pydantic model class representing the a schedule to be created in the database  Parameters ---------- observations : list[schemas.Observation]     A list of observations for the schedule  Notes --------- Inherits from ScheduleBase  Methods to_orm(self, created_by_id: UUID) -> ScheduleModel     Method that creates the ORM record for a schedule to be serialized into the database.     This method does not instantiate the list of observations, the observation schema requires     a schedule ID so it is instantiated after the model id is flushed within the service.
    """ # noqa: E501
    telescope_id: StrictStr
    name: StrictStr
    date_range: DateRange
    status: ScheduleStatus
    external_id: Optional[StrictStr] = None
    fidelity: Optional[ScheduleFidelity] = None
    observations: List[ObservationCreate]
    __properties: ClassVar[List[str]] = ["telescope_id", "name", "date_range", "status", "external_id", "fidelity", "observations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ScheduleCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of date_range
        if self.date_range:
            _dict['date_range'] = self.date_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in observations (list)
        _items = []
        if self.observations:
            for _item_observations in self.observations:
                if _item_observations:
                    _items.append(_item_observations.to_dict())
            _dict['observations'] = _items
        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['external_id'] = None

        # set to None if fidelity (nullable) is None
        # and model_fields_set contains the field
        if self.fidelity is None and "fidelity" in self.model_fields_set:
            _dict['fidelity'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScheduleCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "telescope_id": obj.get("telescope_id"),
            "name": obj.get("name"),
            "date_range": DateRange.from_dict(obj["date_range"]) if obj.get("date_range") is not None else None,
            "status": obj.get("status"),
            "external_id": obj.get("external_id"),
            "fidelity": obj.get("fidelity"),
            "observations": [ObservationCreate.from_dict(_item) for _item in obj["observations"]] if obj.get("observations") is not None else None
        })
        return _obj


