# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 0.3.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt
from typing import Any, ClassVar, Dict, List
from across.sdk.v1.models.constraint_reason import ConstraintReason
from across.sdk.v1.models.window import Window
from typing import Optional, Set
from typing_extensions import Self

class VisibilityWindow(BaseModel):
    """
    Represents a Visibility Window with max visibility duration and information about the start and end constraints reason.
    """ # noqa: E501
    window: Window
    max_visibility_duration: StrictInt
    constraint_reason: ConstraintReason
    __properties: ClassVar[List[str]] = ["window", "max_visibility_duration", "constraint_reason"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VisibilityWindow from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of window
        if self.window:
            _dict['window'] = self.window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of constraint_reason
        if self.constraint_reason:
            _dict['constraint_reason'] = self.constraint_reason.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VisibilityWindow from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "window": Window.from_dict(obj["window"]) if obj.get("window") is not None else None,
            "max_visibility_duration": obj.get("max_visibility_duration"),
            "constraint_reason": ConstraintReason.from_dict(obj["constraint_reason"]) if obj.get("constraint_reason") is not None else None
        })
        return _obj


