# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 1.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictInt, StrictStr
from typing import List, Optional, Union
from typing_extensions import Annotated
from across.sdk.v1.models.joint_visibility_result import JointVisibilityResult
from across.sdk.v1.models.visibility_result import VisibilityResult

from across.sdk.v1.api_client import ApiClient, RequestSerialized
from across.sdk.v1.api_response import ApiResponse
from across.sdk.v1.rest import RESTResponseType


class ToolsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def calculate_joint_windows_tools_visibility_calculator_windows_get(
        self,
        ra: Union[Annotated[float, Field(le=360.0, strict=True, ge=0.0)], Annotated[int, Field(le=360, strict=True, ge=0)]],
        dec: Union[Annotated[float, Field(le=90.0, strict=True, ge=-90.0)], Annotated[int, Field(le=90, strict=True, ge=-90)]],
        date_range_begin: datetime,
        date_range_end: datetime,
        instrument_ids: List[Optional[StrictStr]],
        hi_res: Optional[StrictBool] = None,
        min_visibility_duration: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> JointVisibilityResult:
        """Calculated Joint Visibility Windows

        Calculate joint visibility windows between instruments for a given observation coordinate    Use GET /telescope/ to retrieve a list of telescopes and their associated instruments    WARNING: This is a long running process and is liable to timeout after a strict 60 second execution limit    If you experience issues retrieving results, please scope your date range to be a smaller window or set `hi_res` to `false`

        :param ra: (required)
        :type ra: float
        :param dec: (required)
        :type dec: float
        :param date_range_begin: (required)
        :type date_range_begin: datetime
        :param date_range_end: (required)
        :type date_range_end: datetime
        :param instrument_ids: (required)
        :type instrument_ids: List[Optional[str]]
        :param hi_res:
        :type hi_res: bool
        :param min_visibility_duration:
        :type min_visibility_duration: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._calculate_joint_windows_tools_visibility_calculator_windows_get_serialize(
            ra=ra,
            dec=dec,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            instrument_ids=instrument_ids,
            hi_res=hi_res,
            min_visibility_duration=min_visibility_duration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "JointVisibilityResult",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def calculate_joint_windows_tools_visibility_calculator_windows_get_with_http_info(
        self,
        ra: Union[Annotated[float, Field(le=360.0, strict=True, ge=0.0)], Annotated[int, Field(le=360, strict=True, ge=0)]],
        dec: Union[Annotated[float, Field(le=90.0, strict=True, ge=-90.0)], Annotated[int, Field(le=90, strict=True, ge=-90)]],
        date_range_begin: datetime,
        date_range_end: datetime,
        instrument_ids: List[Optional[StrictStr]],
        hi_res: Optional[StrictBool] = None,
        min_visibility_duration: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[JointVisibilityResult]:
        """Calculated Joint Visibility Windows

        Calculate joint visibility windows between instruments for a given observation coordinate    Use GET /telescope/ to retrieve a list of telescopes and their associated instruments    WARNING: This is a long running process and is liable to timeout after a strict 60 second execution limit    If you experience issues retrieving results, please scope your date range to be a smaller window or set `hi_res` to `false`

        :param ra: (required)
        :type ra: float
        :param dec: (required)
        :type dec: float
        :param date_range_begin: (required)
        :type date_range_begin: datetime
        :param date_range_end: (required)
        :type date_range_end: datetime
        :param instrument_ids: (required)
        :type instrument_ids: List[Optional[str]]
        :param hi_res:
        :type hi_res: bool
        :param min_visibility_duration:
        :type min_visibility_duration: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._calculate_joint_windows_tools_visibility_calculator_windows_get_serialize(
            ra=ra,
            dec=dec,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            instrument_ids=instrument_ids,
            hi_res=hi_res,
            min_visibility_duration=min_visibility_duration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "JointVisibilityResult",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def calculate_joint_windows_tools_visibility_calculator_windows_get_without_preload_content(
        self,
        ra: Union[Annotated[float, Field(le=360.0, strict=True, ge=0.0)], Annotated[int, Field(le=360, strict=True, ge=0)]],
        dec: Union[Annotated[float, Field(le=90.0, strict=True, ge=-90.0)], Annotated[int, Field(le=90, strict=True, ge=-90)]],
        date_range_begin: datetime,
        date_range_end: datetime,
        instrument_ids: List[Optional[StrictStr]],
        hi_res: Optional[StrictBool] = None,
        min_visibility_duration: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Calculated Joint Visibility Windows

        Calculate joint visibility windows between instruments for a given observation coordinate    Use GET /telescope/ to retrieve a list of telescopes and their associated instruments    WARNING: This is a long running process and is liable to timeout after a strict 60 second execution limit    If you experience issues retrieving results, please scope your date range to be a smaller window or set `hi_res` to `false`

        :param ra: (required)
        :type ra: float
        :param dec: (required)
        :type dec: float
        :param date_range_begin: (required)
        :type date_range_begin: datetime
        :param date_range_end: (required)
        :type date_range_end: datetime
        :param instrument_ids: (required)
        :type instrument_ids: List[Optional[str]]
        :param hi_res:
        :type hi_res: bool
        :param min_visibility_duration:
        :type min_visibility_duration: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._calculate_joint_windows_tools_visibility_calculator_windows_get_serialize(
            ra=ra,
            dec=dec,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            instrument_ids=instrument_ids,
            hi_res=hi_res,
            min_visibility_duration=min_visibility_duration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "JointVisibilityResult",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _calculate_joint_windows_tools_visibility_calculator_windows_get_serialize(
        self,
        ra,
        dec,
        date_range_begin,
        date_range_end,
        instrument_ids,
        hi_res,
        min_visibility_duration,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'instrument_ids': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if ra is not None:
            
            _query_params.append(('ra', ra))
            
        if dec is not None:
            
            _query_params.append(('dec', dec))
            
        if date_range_begin is not None:
            if isinstance(date_range_begin, datetime):
                _query_params.append(
                    (
                        'date_range_begin',
                        date_range_begin.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('date_range_begin', date_range_begin))
            
        if date_range_end is not None:
            if isinstance(date_range_end, datetime):
                _query_params.append(
                    (
                        'date_range_end',
                        date_range_end.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('date_range_end', date_range_end))
            
        if hi_res is not None:
            
            _query_params.append(('hi_res', hi_res))
            
        if min_visibility_duration is not None:
            
            _query_params.append(('min_visibility_duration', min_visibility_duration))
            
        if instrument_ids is not None:
            
            _query_params.append(('instrument_ids', instrument_ids))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/tools/visibility-calculator/windows/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def calculate_joint_windows_tools_visibility_calculator_windows_get_0(
        self,
        ra: Union[Annotated[float, Field(le=360.0, strict=True, ge=0.0)], Annotated[int, Field(le=360, strict=True, ge=0)]],
        dec: Union[Annotated[float, Field(le=90.0, strict=True, ge=-90.0)], Annotated[int, Field(le=90, strict=True, ge=-90)]],
        date_range_begin: datetime,
        date_range_end: datetime,
        instrument_ids: List[Optional[StrictStr]],
        hi_res: Optional[StrictBool] = None,
        min_visibility_duration: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> JointVisibilityResult:
        """Calculated Joint Visibility Windows

        Calculate joint visibility windows between instruments for a given observation coordinate    Use GET /telescope/ to retrieve a list of telescopes and their associated instruments    WARNING: This is a long running process and is liable to timeout after a strict 60 second execution limit    If you experience issues retrieving results, please scope your date range to be a smaller window or set `hi_res` to `false`

        :param ra: (required)
        :type ra: float
        :param dec: (required)
        :type dec: float
        :param date_range_begin: (required)
        :type date_range_begin: datetime
        :param date_range_end: (required)
        :type date_range_end: datetime
        :param instrument_ids: (required)
        :type instrument_ids: List[Optional[str]]
        :param hi_res:
        :type hi_res: bool
        :param min_visibility_duration:
        :type min_visibility_duration: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._calculate_joint_windows_tools_visibility_calculator_windows_get_0_serialize(
            ra=ra,
            dec=dec,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            instrument_ids=instrument_ids,
            hi_res=hi_res,
            min_visibility_duration=min_visibility_duration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "JointVisibilityResult",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def calculate_joint_windows_tools_visibility_calculator_windows_get_0_with_http_info(
        self,
        ra: Union[Annotated[float, Field(le=360.0, strict=True, ge=0.0)], Annotated[int, Field(le=360, strict=True, ge=0)]],
        dec: Union[Annotated[float, Field(le=90.0, strict=True, ge=-90.0)], Annotated[int, Field(le=90, strict=True, ge=-90)]],
        date_range_begin: datetime,
        date_range_end: datetime,
        instrument_ids: List[Optional[StrictStr]],
        hi_res: Optional[StrictBool] = None,
        min_visibility_duration: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[JointVisibilityResult]:
        """Calculated Joint Visibility Windows

        Calculate joint visibility windows between instruments for a given observation coordinate    Use GET /telescope/ to retrieve a list of telescopes and their associated instruments    WARNING: This is a long running process and is liable to timeout after a strict 60 second execution limit    If you experience issues retrieving results, please scope your date range to be a smaller window or set `hi_res` to `false`

        :param ra: (required)
        :type ra: float
        :param dec: (required)
        :type dec: float
        :param date_range_begin: (required)
        :type date_range_begin: datetime
        :param date_range_end: (required)
        :type date_range_end: datetime
        :param instrument_ids: (required)
        :type instrument_ids: List[Optional[str]]
        :param hi_res:
        :type hi_res: bool
        :param min_visibility_duration:
        :type min_visibility_duration: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._calculate_joint_windows_tools_visibility_calculator_windows_get_0_serialize(
            ra=ra,
            dec=dec,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            instrument_ids=instrument_ids,
            hi_res=hi_res,
            min_visibility_duration=min_visibility_duration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "JointVisibilityResult",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def calculate_joint_windows_tools_visibility_calculator_windows_get_0_without_preload_content(
        self,
        ra: Union[Annotated[float, Field(le=360.0, strict=True, ge=0.0)], Annotated[int, Field(le=360, strict=True, ge=0)]],
        dec: Union[Annotated[float, Field(le=90.0, strict=True, ge=-90.0)], Annotated[int, Field(le=90, strict=True, ge=-90)]],
        date_range_begin: datetime,
        date_range_end: datetime,
        instrument_ids: List[Optional[StrictStr]],
        hi_res: Optional[StrictBool] = None,
        min_visibility_duration: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Calculated Joint Visibility Windows

        Calculate joint visibility windows between instruments for a given observation coordinate    Use GET /telescope/ to retrieve a list of telescopes and their associated instruments    WARNING: This is a long running process and is liable to timeout after a strict 60 second execution limit    If you experience issues retrieving results, please scope your date range to be a smaller window or set `hi_res` to `false`

        :param ra: (required)
        :type ra: float
        :param dec: (required)
        :type dec: float
        :param date_range_begin: (required)
        :type date_range_begin: datetime
        :param date_range_end: (required)
        :type date_range_end: datetime
        :param instrument_ids: (required)
        :type instrument_ids: List[Optional[str]]
        :param hi_res:
        :type hi_res: bool
        :param min_visibility_duration:
        :type min_visibility_duration: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._calculate_joint_windows_tools_visibility_calculator_windows_get_0_serialize(
            ra=ra,
            dec=dec,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            instrument_ids=instrument_ids,
            hi_res=hi_res,
            min_visibility_duration=min_visibility_duration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "JointVisibilityResult",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _calculate_joint_windows_tools_visibility_calculator_windows_get_0_serialize(
        self,
        ra,
        dec,
        date_range_begin,
        date_range_end,
        instrument_ids,
        hi_res,
        min_visibility_duration,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'instrument_ids': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if ra is not None:
            
            _query_params.append(('ra', ra))
            
        if dec is not None:
            
            _query_params.append(('dec', dec))
            
        if date_range_begin is not None:
            if isinstance(date_range_begin, datetime):
                _query_params.append(
                    (
                        'date_range_begin',
                        date_range_begin.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('date_range_begin', date_range_begin))
            
        if date_range_end is not None:
            if isinstance(date_range_end, datetime):
                _query_params.append(
                    (
                        'date_range_end',
                        date_range_end.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('date_range_end', date_range_end))
            
        if hi_res is not None:
            
            _query_params.append(('hi_res', hi_res))
            
        if min_visibility_duration is not None:
            
            _query_params.append(('min_visibility_duration', min_visibility_duration))
            
        if instrument_ids is not None:
            
            _query_params.append(('instrument_ids', instrument_ids))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/tools/visibility-calculator/windows/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def calculate_windows_tools_visibility_calculator_windows_instrument_id_get(
        self,
        instrument_id: StrictStr,
        ra: Union[Annotated[float, Field(le=360.0, strict=True, ge=0.0)], Annotated[int, Field(le=360, strict=True, ge=0)]],
        dec: Union[Annotated[float, Field(le=90.0, strict=True, ge=-90.0)], Annotated[int, Field(le=90, strict=True, ge=-90)]],
        date_range_begin: datetime,
        date_range_end: datetime,
        hi_res: Optional[StrictBool] = None,
        min_visibility_duration: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> VisibilityResult:
        """Calculated Visibility Windows

        Calculate visibility windows of an instrument for a given observation coordinate    Use GET /telescope/ to retrieve a list of telescopes and their associated instruments    WARNING: This is a long running process and is liable to timeout after a strict 60 second execution limit    If you experience issues retrieving results, please scope your date range to be a smaller window or set `hi_res` to `false`

        :param instrument_id: (required)
        :type instrument_id: str
        :param ra: (required)
        :type ra: float
        :param dec: (required)
        :type dec: float
        :param date_range_begin: (required)
        :type date_range_begin: datetime
        :param date_range_end: (required)
        :type date_range_end: datetime
        :param hi_res:
        :type hi_res: bool
        :param min_visibility_duration:
        :type min_visibility_duration: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._calculate_windows_tools_visibility_calculator_windows_instrument_id_get_serialize(
            instrument_id=instrument_id,
            ra=ra,
            dec=dec,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            hi_res=hi_res,
            min_visibility_duration=min_visibility_duration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VisibilityResult",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def calculate_windows_tools_visibility_calculator_windows_instrument_id_get_with_http_info(
        self,
        instrument_id: StrictStr,
        ra: Union[Annotated[float, Field(le=360.0, strict=True, ge=0.0)], Annotated[int, Field(le=360, strict=True, ge=0)]],
        dec: Union[Annotated[float, Field(le=90.0, strict=True, ge=-90.0)], Annotated[int, Field(le=90, strict=True, ge=-90)]],
        date_range_begin: datetime,
        date_range_end: datetime,
        hi_res: Optional[StrictBool] = None,
        min_visibility_duration: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[VisibilityResult]:
        """Calculated Visibility Windows

        Calculate visibility windows of an instrument for a given observation coordinate    Use GET /telescope/ to retrieve a list of telescopes and their associated instruments    WARNING: This is a long running process and is liable to timeout after a strict 60 second execution limit    If you experience issues retrieving results, please scope your date range to be a smaller window or set `hi_res` to `false`

        :param instrument_id: (required)
        :type instrument_id: str
        :param ra: (required)
        :type ra: float
        :param dec: (required)
        :type dec: float
        :param date_range_begin: (required)
        :type date_range_begin: datetime
        :param date_range_end: (required)
        :type date_range_end: datetime
        :param hi_res:
        :type hi_res: bool
        :param min_visibility_duration:
        :type min_visibility_duration: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._calculate_windows_tools_visibility_calculator_windows_instrument_id_get_serialize(
            instrument_id=instrument_id,
            ra=ra,
            dec=dec,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            hi_res=hi_res,
            min_visibility_duration=min_visibility_duration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VisibilityResult",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def calculate_windows_tools_visibility_calculator_windows_instrument_id_get_without_preload_content(
        self,
        instrument_id: StrictStr,
        ra: Union[Annotated[float, Field(le=360.0, strict=True, ge=0.0)], Annotated[int, Field(le=360, strict=True, ge=0)]],
        dec: Union[Annotated[float, Field(le=90.0, strict=True, ge=-90.0)], Annotated[int, Field(le=90, strict=True, ge=-90)]],
        date_range_begin: datetime,
        date_range_end: datetime,
        hi_res: Optional[StrictBool] = None,
        min_visibility_duration: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Calculated Visibility Windows

        Calculate visibility windows of an instrument for a given observation coordinate    Use GET /telescope/ to retrieve a list of telescopes and their associated instruments    WARNING: This is a long running process and is liable to timeout after a strict 60 second execution limit    If you experience issues retrieving results, please scope your date range to be a smaller window or set `hi_res` to `false`

        :param instrument_id: (required)
        :type instrument_id: str
        :param ra: (required)
        :type ra: float
        :param dec: (required)
        :type dec: float
        :param date_range_begin: (required)
        :type date_range_begin: datetime
        :param date_range_end: (required)
        :type date_range_end: datetime
        :param hi_res:
        :type hi_res: bool
        :param min_visibility_duration:
        :type min_visibility_duration: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._calculate_windows_tools_visibility_calculator_windows_instrument_id_get_serialize(
            instrument_id=instrument_id,
            ra=ra,
            dec=dec,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            hi_res=hi_res,
            min_visibility_duration=min_visibility_duration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VisibilityResult",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _calculate_windows_tools_visibility_calculator_windows_instrument_id_get_serialize(
        self,
        instrument_id,
        ra,
        dec,
        date_range_begin,
        date_range_end,
        hi_res,
        min_visibility_duration,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if instrument_id is not None:
            _path_params['instrument_id'] = instrument_id
        # process the query parameters
        if ra is not None:
            
            _query_params.append(('ra', ra))
            
        if dec is not None:
            
            _query_params.append(('dec', dec))
            
        if date_range_begin is not None:
            if isinstance(date_range_begin, datetime):
                _query_params.append(
                    (
                        'date_range_begin',
                        date_range_begin.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('date_range_begin', date_range_begin))
            
        if date_range_end is not None:
            if isinstance(date_range_end, datetime):
                _query_params.append(
                    (
                        'date_range_end',
                        date_range_end.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('date_range_end', date_range_end))
            
        if hi_res is not None:
            
            _query_params.append(('hi_res', hi_res))
            
        if min_visibility_duration is not None:
            
            _query_params.append(('min_visibility_duration', min_visibility_duration))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/tools/visibility-calculator/windows/{instrument_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def calculate_windows_tools_visibility_calculator_windows_instrument_id_get_0(
        self,
        instrument_id: StrictStr,
        ra: Union[Annotated[float, Field(le=360.0, strict=True, ge=0.0)], Annotated[int, Field(le=360, strict=True, ge=0)]],
        dec: Union[Annotated[float, Field(le=90.0, strict=True, ge=-90.0)], Annotated[int, Field(le=90, strict=True, ge=-90)]],
        date_range_begin: datetime,
        date_range_end: datetime,
        hi_res: Optional[StrictBool] = None,
        min_visibility_duration: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> VisibilityResult:
        """Calculated Visibility Windows

        Calculate visibility windows of an instrument for a given observation coordinate    Use GET /telescope/ to retrieve a list of telescopes and their associated instruments    WARNING: This is a long running process and is liable to timeout after a strict 60 second execution limit    If you experience issues retrieving results, please scope your date range to be a smaller window or set `hi_res` to `false`

        :param instrument_id: (required)
        :type instrument_id: str
        :param ra: (required)
        :type ra: float
        :param dec: (required)
        :type dec: float
        :param date_range_begin: (required)
        :type date_range_begin: datetime
        :param date_range_end: (required)
        :type date_range_end: datetime
        :param hi_res:
        :type hi_res: bool
        :param min_visibility_duration:
        :type min_visibility_duration: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._calculate_windows_tools_visibility_calculator_windows_instrument_id_get_0_serialize(
            instrument_id=instrument_id,
            ra=ra,
            dec=dec,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            hi_res=hi_res,
            min_visibility_duration=min_visibility_duration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VisibilityResult",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def calculate_windows_tools_visibility_calculator_windows_instrument_id_get_0_with_http_info(
        self,
        instrument_id: StrictStr,
        ra: Union[Annotated[float, Field(le=360.0, strict=True, ge=0.0)], Annotated[int, Field(le=360, strict=True, ge=0)]],
        dec: Union[Annotated[float, Field(le=90.0, strict=True, ge=-90.0)], Annotated[int, Field(le=90, strict=True, ge=-90)]],
        date_range_begin: datetime,
        date_range_end: datetime,
        hi_res: Optional[StrictBool] = None,
        min_visibility_duration: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[VisibilityResult]:
        """Calculated Visibility Windows

        Calculate visibility windows of an instrument for a given observation coordinate    Use GET /telescope/ to retrieve a list of telescopes and their associated instruments    WARNING: This is a long running process and is liable to timeout after a strict 60 second execution limit    If you experience issues retrieving results, please scope your date range to be a smaller window or set `hi_res` to `false`

        :param instrument_id: (required)
        :type instrument_id: str
        :param ra: (required)
        :type ra: float
        :param dec: (required)
        :type dec: float
        :param date_range_begin: (required)
        :type date_range_begin: datetime
        :param date_range_end: (required)
        :type date_range_end: datetime
        :param hi_res:
        :type hi_res: bool
        :param min_visibility_duration:
        :type min_visibility_duration: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._calculate_windows_tools_visibility_calculator_windows_instrument_id_get_0_serialize(
            instrument_id=instrument_id,
            ra=ra,
            dec=dec,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            hi_res=hi_res,
            min_visibility_duration=min_visibility_duration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VisibilityResult",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def calculate_windows_tools_visibility_calculator_windows_instrument_id_get_0_without_preload_content(
        self,
        instrument_id: StrictStr,
        ra: Union[Annotated[float, Field(le=360.0, strict=True, ge=0.0)], Annotated[int, Field(le=360, strict=True, ge=0)]],
        dec: Union[Annotated[float, Field(le=90.0, strict=True, ge=-90.0)], Annotated[int, Field(le=90, strict=True, ge=-90)]],
        date_range_begin: datetime,
        date_range_end: datetime,
        hi_res: Optional[StrictBool] = None,
        min_visibility_duration: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Calculated Visibility Windows

        Calculate visibility windows of an instrument for a given observation coordinate    Use GET /telescope/ to retrieve a list of telescopes and their associated instruments    WARNING: This is a long running process and is liable to timeout after a strict 60 second execution limit    If you experience issues retrieving results, please scope your date range to be a smaller window or set `hi_res` to `false`

        :param instrument_id: (required)
        :type instrument_id: str
        :param ra: (required)
        :type ra: float
        :param dec: (required)
        :type dec: float
        :param date_range_begin: (required)
        :type date_range_begin: datetime
        :param date_range_end: (required)
        :type date_range_end: datetime
        :param hi_res:
        :type hi_res: bool
        :param min_visibility_duration:
        :type min_visibility_duration: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._calculate_windows_tools_visibility_calculator_windows_instrument_id_get_0_serialize(
            instrument_id=instrument_id,
            ra=ra,
            dec=dec,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            hi_res=hi_res,
            min_visibility_duration=min_visibility_duration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VisibilityResult",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _calculate_windows_tools_visibility_calculator_windows_instrument_id_get_0_serialize(
        self,
        instrument_id,
        ra,
        dec,
        date_range_begin,
        date_range_end,
        hi_res,
        min_visibility_duration,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if instrument_id is not None:
            _path_params['instrument_id'] = instrument_id
        # process the query parameters
        if ra is not None:
            
            _query_params.append(('ra', ra))
            
        if dec is not None:
            
            _query_params.append(('dec', dec))
            
        if date_range_begin is not None:
            if isinstance(date_range_begin, datetime):
                _query_params.append(
                    (
                        'date_range_begin',
                        date_range_begin.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('date_range_begin', date_range_begin))
            
        if date_range_end is not None:
            if isinstance(date_range_end, datetime):
                _query_params.append(
                    (
                        'date_range_end',
                        date_range_end.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('date_range_end', date_range_end))
            
        if hi_res is not None:
            
            _query_params.append(('hi_res', hi_res))
            
        if min_visibility_duration is not None:
            
            _query_params.append(('min_visibility_duration', min_visibility_duration))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/tools/visibility-calculator/windows/{instrument_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


