# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 1.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from across.sdk.v1.models.across_server_routes_v1_group_role_schemas_service_account import AcrossServerRoutesV1GroupRoleSchemasServiceAccount
from across.sdk.v1.models.across_server_routes_v1_group_role_schemas_user import AcrossServerRoutesV1GroupRoleSchemasUser
from across.sdk.v1.models.permission import Permission
from typing import Optional, Set
from typing_extensions import Self

class AcrossServerRoutesV1GroupRoleSchemasGroupRole(BaseModel):
    """
    AcrossServerRoutesV1GroupRoleSchemasGroupRole
    """ # noqa: E501
    name: StrictStr
    permissions: List[Permission]
    id: StrictStr
    users: List[AcrossServerRoutesV1GroupRoleSchemasUser]
    service_accounts: Optional[List[AcrossServerRoutesV1GroupRoleSchemasServiceAccount]]
    __properties: ClassVar[List[str]] = ["name", "permissions", "id", "users", "service_accounts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AcrossServerRoutesV1GroupRoleSchemasGroupRole from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in permissions (list)
        _items = []
        if self.permissions:
            for _item_permissions in self.permissions:
                if _item_permissions:
                    _items.append(_item_permissions.to_dict())
            _dict['permissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in users (list)
        _items = []
        if self.users:
            for _item_users in self.users:
                if _item_users:
                    _items.append(_item_users.to_dict())
            _dict['users'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in service_accounts (list)
        _items = []
        if self.service_accounts:
            for _item_service_accounts in self.service_accounts:
                if _item_service_accounts:
                    _items.append(_item_service_accounts.to_dict())
            _dict['service_accounts'] = _items
        # set to None if service_accounts (nullable) is None
        # and model_fields_set contains the field
        if self.service_accounts is None and "service_accounts" in self.model_fields_set:
            _dict['service_accounts'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AcrossServerRoutesV1GroupRoleSchemasGroupRole from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "permissions": [Permission.from_dict(_item) for _item in obj["permissions"]] if obj.get("permissions") is not None else None,
            "id": obj.get("id"),
            "users": [AcrossServerRoutesV1GroupRoleSchemasUser.from_dict(_item) for _item in obj["users"]] if obj.get("users") is not None else None,
            "service_accounts": [AcrossServerRoutesV1GroupRoleSchemasServiceAccount.from_dict(_item) for _item in obj["service_accounts"]] if obj.get("service_accounts") is not None else None
        })
        return _obj


