# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 1.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class SAAPolygonConstraint(BaseModel):
    """
    Polygon based SAA constraint. The SAA is defined by a Shapely Polygon, and this constraint will calculate for a given set of times and a given ephemeris whether the spacecraft is in that SAA polygon.  Attributes ---------- polygon     Shapely Polygon object defining the SAA polygon.
    """ # noqa: E501
    short_name: Optional[StrictStr] = 'SAA'
    name: Optional[StrictStr] = 'South Atlantic Anomaly'
    polygon: Optional[List[List[Union[StrictFloat, StrictInt]]]] = None
    __properties: ClassVar[List[str]] = ["short_name", "name", "polygon"]

    @field_validator('name')
    def name_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['South Atlantic Anomaly']):
            raise ValueError("must be one of enum values ('South Atlantic Anomaly')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SAAPolygonConstraint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if polygon (nullable) is None
        # and model_fields_set contains the field
        if self.polygon is None and "polygon" in self.model_fields_set:
            _dict['polygon'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SAAPolygonConstraint from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "short_name": obj.get("short_name") if obj.get("short_name") is not None else 'SAA',
            "name": obj.get("name") if obj.get("name") is not None else 'South Atlantic Anomaly',
            "polygon": obj.get("polygon")
        })
        return _obj


