# across.sdk.v1
Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.1.0
- Package version: 1.0.0
- Generator version: 7.14.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import across.sdk.v1
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import across.sdk.v1
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import across.sdk.v1
from across.sdk.v1.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to /api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = across.sdk.v1.Configuration(
    host = "/api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: Authorization
configuration = across.sdk.v1.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with across.sdk.v1.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = across.sdk.v1.AuthApi(api_client)
    email = 'email_example' # str | 

    try:
        # Login
        api_response = api_instance.login(email)
        print("The response of AuthApi->login:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AuthApi->login: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to */api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthApi* | [**login**](docs/AuthApi.md#login) | **POST** /auth/login | Login
*AuthApi* | [**refresh**](docs/AuthApi.md#refresh) | **POST** /auth/refresh | Refresh Token
*AuthApi* | [**token**](docs/AuthApi.md#token) | **POST** /auth/token | Token
*AuthApi* | [**verify**](docs/AuthApi.md#verify) | **GET** /auth/verify | Verify
*FilterApi* | [**get_filter_filter_id_get**](docs/FilterApi.md#get_filter_filter_id_get) | **GET** /filter/{filter_id} | Read a filter
*FilterApi* | [**get_many_filter_get**](docs/FilterApi.md#get_many_filter_get) | **GET** /filter/ | Read filters(s)
*GroupApi* | [**get_group**](docs/GroupApi.md#get_group) | **GET** /group/{group_id} | Read a group
*GroupApi* | [**remove_user**](docs/GroupApi.md#remove_user) | **DELETE** /group/{group_id}/user/{user_id} | Remove a user from a group
*GroupInviteApi* | [**delete_invite**](docs/GroupInviteApi.md#delete_invite) | **DELETE** /group/{group_id}/invite/{invite_id} | Delete a group invite
*GroupInviteApi* | [**get_invite**](docs/GroupInviteApi.md#get_invite) | **GET** /group/{group_id}/invite/{invite_id} | Read a group invite
*GroupInviteApi* | [**get_invites**](docs/GroupInviteApi.md#get_invites) | **GET** /group/{group_id}/invite | Read group invites
*GroupInviteApi* | [**send_invite**](docs/GroupInviteApi.md#send_invite) | **POST** /group/{group_id}/invite | Create and send a group invite
*GroupRoleApi* | [**assign_to_user**](docs/GroupRoleApi.md#assign_to_user) | **PUT** /group/{group_id}/user/{user_id}/role/{group_role_id} | Assign a group role to a user
*GroupRoleApi* | [**create_group_role**](docs/GroupRoleApi.md#create_group_role) | **POST** /group/{group_id}/role | Create a group role
*GroupRoleApi* | [**delete_group_role**](docs/GroupRoleApi.md#delete_group_role) | **DELETE** /group/{group_id}/role/{group_role_id} | Delete a group role
*GroupRoleApi* | [**get_group_role**](docs/GroupRoleApi.md#get_group_role) | **GET** /group/{group_id}/role/{group_role_id} | Read a group role
*GroupRoleApi* | [**get_group_roles**](docs/GroupRoleApi.md#get_group_roles) | **GET** /group/{group_id}/role | Read group roles
*GroupRoleApi* | [**remove_from_user**](docs/GroupRoleApi.md#remove_from_user) | **DELETE** /group/{group_id}/user/{user_id}/role/{group_role_id} | Remove a group role from a user
*GroupRoleApi* | [**update_group_role**](docs/GroupRoleApi.md#update_group_role) | **PUT** /group/{group_id}/role/{group_role_id} | Update a group role
*InstrumentApi* | [**get_instrument**](docs/InstrumentApi.md#get_instrument) | **GET** /instrument/{instrument_id} | Read an instrument
*InstrumentApi* | [**get_instruments**](docs/InstrumentApi.md#get_instruments) | **GET** /instrument/ | Read instruments(s)
*InternalApi* | [**get_service_account**](docs/InternalApi.md#get_service_account) | **GET** /service-account/{service_account_id} | Get a system service account
*InternalApi* | [**service_account_rotate_key**](docs/InternalApi.md#service_account_rotate_key) | **PATCH** /service-account/{service_account_id}/rotate_key | Rotate a service account key
*ObservationApi* | [**get_observation**](docs/ObservationApi.md#get_observation) | **GET** /observation/{observation_id} | Read an observation
*ObservationApi* | [**get_observations**](docs/ObservationApi.md#get_observations) | **GET** /observation/ | Read observations(s)
*ObservatoryApi* | [**get_observatories**](docs/ObservatoryApi.md#get_observatories) | **GET** /observatory/ | Read observatory(s)
*ObservatoryApi* | [**get_observatory**](docs/ObservatoryApi.md#get_observatory) | **GET** /observatory/{observatory_id} | Read an observatory
*PermissionApi* | [**get_permissions**](docs/PermissionApi.md#get_permissions) | **GET** /permission/ | Read permissions
*ScheduleApi* | [**create_many_schedules**](docs/ScheduleApi.md#create_many_schedules) | **POST** /schedule/bulk | Create many Schedules
*ScheduleApi* | [**create_schedule**](docs/ScheduleApi.md#create_schedule) | **POST** /schedule/ | Create a Schedule
*ScheduleApi* | [**get_schedule**](docs/ScheduleApi.md#get_schedule) | **GET** /schedule/{schedule_id} | Read a schedule
*ScheduleApi* | [**get_schedules**](docs/ScheduleApi.md#get_schedules) | **GET** /schedule/ | Read schedule(s)
*ScheduleApi* | [**get_schedules_history**](docs/ScheduleApi.md#get_schedules_history) | **GET** /schedule/history | Read schedule(s)
*ServiceAccountApi* | [**assign_to_service_account**](docs/ServiceAccountApi.md#assign_to_service_account) | **POST** /user/{user_id}/service-account/{service_account_id}/group-role/{group_role_id} | Assign group role
*ServiceAccountApi* | [**create_user_service_account**](docs/ServiceAccountApi.md#create_user_service_account) | **POST** /user/{user_id}/service_account/ | Create a service account
*ServiceAccountApi* | [**delete_user_service_account**](docs/ServiceAccountApi.md#delete_user_service_account) | **DELETE** /user/{user_id}/service_account/{service_account_id} | Delete a service_account
*ServiceAccountApi* | [**get_service_accounts**](docs/ServiceAccountApi.md#get_service_accounts) | **GET** /user/{user_id}/service_account/ | Read service accounts
*ServiceAccountApi* | [**get_user_service_account**](docs/ServiceAccountApi.md#get_user_service_account) | **GET** /user/{user_id}/service_account/{service_account_id} | Read a service account
*ServiceAccountApi* | [**remove_from_service_account**](docs/ServiceAccountApi.md#remove_from_service_account) | **DELETE** /user/{user_id}/service-account/{service_account_id}/group-role/{group_role_id} | Remove group role
*ServiceAccountApi* | [**update_user_service_account**](docs/ServiceAccountApi.md#update_user_service_account) | **PATCH** /user/{user_id}/service_account/{service_account_id} | Update a service account
*ServiceAccountApi* | [**user_service_account_rotate_key**](docs/ServiceAccountApi.md#user_service_account_rotate_key) | **PATCH** /user/{user_id}/service_account/{service_account_id}/rotate_key | Rotate a service account key
*TLEApi* | [**create_tle**](docs/TLEApi.md#create_tle) | **POST** /tle/ | Create a TLE
*TelescopeApi* | [**get_telescope**](docs/TelescopeApi.md#get_telescope) | **GET** /telescope/{telescope_id} | Read an telescope
*TelescopeApi* | [**get_telescopes**](docs/TelescopeApi.md#get_telescopes) | **GET** /telescope/ | Read telescopes(s)
*ToolsApi* | [**calculate_joint_windows_tools_visibility_calculator_windows_get**](docs/ToolsApi.md#calculate_joint_windows_tools_visibility_calculator_windows_get) | **GET** /tools/visibility-calculator/windows/ | Calculated Joint Visibility Windows
*ToolsApi* | [**calculate_joint_windows_tools_visibility_calculator_windows_get_0**](docs/ToolsApi.md#calculate_joint_windows_tools_visibility_calculator_windows_get_0) | **GET** /tools/visibility-calculator/windows/ | Calculated Joint Visibility Windows
*ToolsApi* | [**calculate_windows_tools_visibility_calculator_windows_instrument_id_get**](docs/ToolsApi.md#calculate_windows_tools_visibility_calculator_windows_instrument_id_get) | **GET** /tools/visibility-calculator/windows/{instrument_id} | Calculated Visibility Windows
*ToolsApi* | [**calculate_windows_tools_visibility_calculator_windows_instrument_id_get_0**](docs/ToolsApi.md#calculate_windows_tools_visibility_calculator_windows_instrument_id_get_0) | **GET** /tools/visibility-calculator/windows/{instrument_id} | Calculated Visibility Windows
*UserApi* | [**accept_invite**](docs/UserApi.md#accept_invite) | **PATCH** /user/{user_id}/invite/{invite_id} | Accept a group invitation
*UserApi* | [**create_user**](docs/UserApi.md#create_user) | **POST** /user/ | Create a user
*UserApi* | [**decline_invite**](docs/UserApi.md#decline_invite) | **DELETE** /user/{user_id}/invite/{invite_id} | Decline a group invitation
*UserApi* | [**delete_user**](docs/UserApi.md#delete_user) | **DELETE** /user/{user_id} | Delete a user
*UserApi* | [**get_group_invites**](docs/UserApi.md#get_group_invites) | **GET** /user/{user_id}/invite | Read a user&#39;s group invites
*UserApi* | [**get_user**](docs/UserApi.md#get_user) | **GET** /user/{user_id} | Read a user
*UserApi* | [**leave_group**](docs/UserApi.md#leave_group) | **DELETE** /user/{user_id}/group/{group_id} | Leave a group
*UserApi* | [**update_user**](docs/UserApi.md#update_user) | **PATCH** /user/{user_id} | Update a user


## Documentation For Models

 - [AccessTokenResponse](docs/AccessTokenResponse.md)
 - [AcrossServerRoutesV1GroupInviteSchemasGroupInvite](docs/AcrossServerRoutesV1GroupInviteSchemasGroupInvite.md)
 - [AcrossServerRoutesV1GroupRoleSchemasGroupRole](docs/AcrossServerRoutesV1GroupRoleSchemasGroupRole.md)
 - [AcrossServerRoutesV1GroupRoleSchemasServiceAccount](docs/AcrossServerRoutesV1GroupRoleSchemasServiceAccount.md)
 - [AcrossServerRoutesV1GroupRoleSchemasUser](docs/AcrossServerRoutesV1GroupRoleSchemasUser.md)
 - [AcrossServerRoutesV1GroupSchemasGroup](docs/AcrossServerRoutesV1GroupSchemasGroup.md)
 - [AcrossServerRoutesV1GroupSchemasUser](docs/AcrossServerRoutesV1GroupSchemasUser.md)
 - [AcrossServerRoutesV1UserSchemasGroup](docs/AcrossServerRoutesV1UserSchemasGroup.md)
 - [AcrossServerRoutesV1UserSchemasGroupInvite](docs/AcrossServerRoutesV1UserSchemasGroupInvite.md)
 - [AcrossServerRoutesV1UserSchemasGroupRole](docs/AcrossServerRoutesV1UserSchemasGroupRole.md)
 - [AcrossServerRoutesV1UserSchemasUser](docs/AcrossServerRoutesV1UserSchemasUser.md)
 - [AcrossServerRoutesV1UserServiceAccountSchemasServiceAccount](docs/AcrossServerRoutesV1UserServiceAccountSchemasServiceAccount.md)
 - [AltAzConstraint](docs/AltAzConstraint.md)
 - [Bandpass](docs/Bandpass.md)
 - [BandpassType](docs/BandpassType.md)
 - [ConstrainedDate](docs/ConstrainedDate.md)
 - [ConstraintReason](docs/ConstraintReason.md)
 - [ConstraintType](docs/ConstraintType.md)
 - [Coordinate](docs/Coordinate.md)
 - [DateRange](docs/DateRange.md)
 - [DepthUnit](docs/DepthUnit.md)
 - [EarthLimbConstraint](docs/EarthLimbConstraint.md)
 - [EnergyBandpass](docs/EnergyBandpass.md)
 - [EnergyUnit](docs/EnergyUnit.md)
 - [EphemerisType](docs/EphemerisType.md)
 - [Filter](docs/Filter.md)
 - [FrequencyBandpass](docs/FrequencyBandpass.md)
 - [FrequencyUnit](docs/FrequencyUnit.md)
 - [GrantType](docs/GrantType.md)
 - [GroundParameters](docs/GroundParameters.md)
 - [GroupInviteCreate](docs/GroupInviteCreate.md)
 - [GroupInviteGroupDetails](docs/GroupInviteGroupDetails.md)
 - [GroupRead](docs/GroupRead.md)
 - [GroupRoleCreate](docs/GroupRoleCreate.md)
 - [GroupRoleRead](docs/GroupRoleRead.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [IDNameSchema](docs/IDNameSchema.md)
 - [IVOAObsCategory](docs/IVOAObsCategory.md)
 - [IVOAObsTrackingType](docs/IVOAObsTrackingType.md)
 - [Instrument](docs/Instrument.md)
 - [InstrumentConstraintsInner](docs/InstrumentConstraintsInner.md)
 - [JPLParameters](docs/JPLParameters.md)
 - [JointVisibilityResult](docs/JointVisibilityResult.md)
 - [MoonAngleConstraint](docs/MoonAngleConstraint.md)
 - [NullableDateRange](docs/NullableDateRange.md)
 - [Observation](docs/Observation.md)
 - [ObservationCreate](docs/ObservationCreate.md)
 - [ObservationStatus](docs/ObservationStatus.md)
 - [ObservationType](docs/ObservationType.md)
 - [Observatory](docs/Observatory.md)
 - [ObservatoryEphemerisType](docs/ObservatoryEphemerisType.md)
 - [ObservatoryType](docs/ObservatoryType.md)
 - [PageObservation](docs/PageObservation.md)
 - [PageSchedule](docs/PageSchedule.md)
 - [Parameters](docs/Parameters.md)
 - [Permission](docs/Permission.md)
 - [Point](docs/Point.md)
 - [RoleBase](docs/RoleBase.md)
 - [SAAPolygonConstraint](docs/SAAPolygonConstraint.md)
 - [SPICEParameters](docs/SPICEParameters.md)
 - [Schedule](docs/Schedule.md)
 - [ScheduleCadence](docs/ScheduleCadence.md)
 - [ScheduleCreate](docs/ScheduleCreate.md)
 - [ScheduleCreateMany](docs/ScheduleCreateMany.md)
 - [ScheduleFidelity](docs/ScheduleFidelity.md)
 - [ScheduleStatus](docs/ScheduleStatus.md)
 - [ServiceAccountCreate](docs/ServiceAccountCreate.md)
 - [ServiceAccountSecret](docs/ServiceAccountSecret.md)
 - [ServiceAccountUpdate](docs/ServiceAccountUpdate.md)
 - [SunAngleConstraint](docs/SunAngleConstraint.md)
 - [SystemServiceAccount](docs/SystemServiceAccount.md)
 - [TLE](docs/TLE.md)
 - [TLECreate](docs/TLECreate.md)
 - [TLEParameters](docs/TLEParameters.md)
 - [Telescope](docs/Telescope.md)
 - [TelescopeInstrument](docs/TelescopeInstrument.md)
 - [UnitValue](docs/UnitValue.md)
 - [UserCreate](docs/UserCreate.md)
 - [UserInfo](docs/UserInfo.md)
 - [UserUpdate](docs/UserUpdate.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)
 - [VisibilityResult](docs/VisibilityResult.md)
 - [VisibilityType](docs/VisibilityType.md)
 - [VisibilityWindow](docs/VisibilityWindow.md)
 - [WavelengthBandpass](docs/WavelengthBandpass.md)
 - [WavelengthUnit](docs/WavelengthUnit.md)
 - [Window](docs/Window.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="Authorization"></a>
### Authorization

- **Type**: Bearer authentication

<a id="ServiceAccountAuthorization"></a>
### ServiceAccountAuthorization

- **Type**: HTTP basic authentication


## Author




