# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 1.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictFloat, StrictInt, StrictStr
from typing import Any, List, Optional, Union
from typing_extensions import Annotated
from across.sdk.v1.models.depth_unit import DepthUnit
from across.sdk.v1.models.observation import Observation
from across.sdk.v1.models.observation_status import ObservationStatus
from across.sdk.v1.models.observation_type import ObservationType
from across.sdk.v1.models.page_observation import PageObservation

from across.sdk.v1.api_client import ApiClient, RequestSerialized
from across.sdk.v1.api_response import ApiResponse
from across.sdk.v1.rest import RESTResponseType


class ObservationApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_observation(
        self,
        observation_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Observation:
        """Read an observation

        Read an observation by an observation ID.

        :param observation_id: (required)
        :type observation_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_observation_serialize(
            observation_id=observation_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Observation",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_observation_with_http_info(
        self,
        observation_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Observation]:
        """Read an observation

        Read an observation by an observation ID.

        :param observation_id: (required)
        :type observation_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_observation_serialize(
            observation_id=observation_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Observation",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_observation_without_preload_content(
        self,
        observation_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Read an observation

        Read an observation by an observation ID.

        :param observation_id: (required)
        :type observation_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_observation_serialize(
            observation_id=observation_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Observation",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_observation_serialize(
        self,
        observation_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if observation_id is not None:
            _path_params['observation_id'] = observation_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/observation/{observation_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_observations(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        page_limit: Annotated[Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]], Field(description="Records per page")] = None,
        external_id: Optional[StrictStr] = None,
        schedule_ids: Optional[List[Optional[StrictStr]]] = None,
        observatory_ids: Optional[List[StrictStr]] = None,
        telescope_ids: Optional[List[StrictStr]] = None,
        instrument_ids: Optional[List[StrictStr]] = None,
        status: Optional[ObservationStatus] = None,
        proposal: Optional[StrictStr] = None,
        object_name: Optional[StrictStr] = None,
        date_range_begin: Optional[datetime] = None,
        date_range_end: Optional[datetime] = None,
        bandpass_min: Optional[Union[StrictFloat, StrictInt]] = None,
        bandpass_max: Optional[Union[StrictFloat, StrictInt]] = None,
        bandpass_type: Optional[Any] = None,
        cone_search_ra: Optional[Union[StrictFloat, StrictInt]] = None,
        cone_search_dec: Optional[Union[StrictFloat, StrictInt]] = None,
        cone_search_radius: Optional[Union[StrictFloat, StrictInt]] = None,
        type: Optional[ObservationType] = None,
        depth_value: Optional[Union[StrictFloat, StrictInt]] = None,
        depth_unit: Optional[DepthUnit] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PageObservation:
        """Read observations(s)

        Read the observations based on query params

        :param page: Page number
        :type page: int
        :param page_limit: Records per page
        :type page_limit: int
        :param external_id:
        :type external_id: str
        :param schedule_ids:
        :type schedule_ids: List[Optional[str]]
        :param observatory_ids:
        :type observatory_ids: List[str]
        :param telescope_ids:
        :type telescope_ids: List[str]
        :param instrument_ids:
        :type instrument_ids: List[str]
        :param status:
        :type status: ObservationStatus
        :param proposal:
        :type proposal: str
        :param object_name:
        :type object_name: str
        :param date_range_begin:
        :type date_range_begin: datetime
        :param date_range_end:
        :type date_range_end: datetime
        :param bandpass_min:
        :type bandpass_min: float
        :param bandpass_max:
        :type bandpass_max: float
        :param bandpass_type:
        :type bandpass_type: BandpassType
        :param cone_search_ra:
        :type cone_search_ra: float
        :param cone_search_dec:
        :type cone_search_dec: float
        :param cone_search_radius:
        :type cone_search_radius: float
        :param type:
        :type type: ObservationType
        :param depth_value:
        :type depth_value: float
        :param depth_unit:
        :type depth_unit: DepthUnit
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_observations_serialize(
            page=page,
            page_limit=page_limit,
            external_id=external_id,
            schedule_ids=schedule_ids,
            observatory_ids=observatory_ids,
            telescope_ids=telescope_ids,
            instrument_ids=instrument_ids,
            status=status,
            proposal=proposal,
            object_name=object_name,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            bandpass_min=bandpass_min,
            bandpass_max=bandpass_max,
            bandpass_type=bandpass_type,
            cone_search_ra=cone_search_ra,
            cone_search_dec=cone_search_dec,
            cone_search_radius=cone_search_radius,
            type=type,
            depth_value=depth_value,
            depth_unit=depth_unit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageObservation",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_observations_with_http_info(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        page_limit: Annotated[Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]], Field(description="Records per page")] = None,
        external_id: Optional[StrictStr] = None,
        schedule_ids: Optional[List[Optional[StrictStr]]] = None,
        observatory_ids: Optional[List[StrictStr]] = None,
        telescope_ids: Optional[List[StrictStr]] = None,
        instrument_ids: Optional[List[StrictStr]] = None,
        status: Optional[ObservationStatus] = None,
        proposal: Optional[StrictStr] = None,
        object_name: Optional[StrictStr] = None,
        date_range_begin: Optional[datetime] = None,
        date_range_end: Optional[datetime] = None,
        bandpass_min: Optional[Union[StrictFloat, StrictInt]] = None,
        bandpass_max: Optional[Union[StrictFloat, StrictInt]] = None,
        bandpass_type: Optional[Any] = None,
        cone_search_ra: Optional[Union[StrictFloat, StrictInt]] = None,
        cone_search_dec: Optional[Union[StrictFloat, StrictInt]] = None,
        cone_search_radius: Optional[Union[StrictFloat, StrictInt]] = None,
        type: Optional[ObservationType] = None,
        depth_value: Optional[Union[StrictFloat, StrictInt]] = None,
        depth_unit: Optional[DepthUnit] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PageObservation]:
        """Read observations(s)

        Read the observations based on query params

        :param page: Page number
        :type page: int
        :param page_limit: Records per page
        :type page_limit: int
        :param external_id:
        :type external_id: str
        :param schedule_ids:
        :type schedule_ids: List[Optional[str]]
        :param observatory_ids:
        :type observatory_ids: List[str]
        :param telescope_ids:
        :type telescope_ids: List[str]
        :param instrument_ids:
        :type instrument_ids: List[str]
        :param status:
        :type status: ObservationStatus
        :param proposal:
        :type proposal: str
        :param object_name:
        :type object_name: str
        :param date_range_begin:
        :type date_range_begin: datetime
        :param date_range_end:
        :type date_range_end: datetime
        :param bandpass_min:
        :type bandpass_min: float
        :param bandpass_max:
        :type bandpass_max: float
        :param bandpass_type:
        :type bandpass_type: BandpassType
        :param cone_search_ra:
        :type cone_search_ra: float
        :param cone_search_dec:
        :type cone_search_dec: float
        :param cone_search_radius:
        :type cone_search_radius: float
        :param type:
        :type type: ObservationType
        :param depth_value:
        :type depth_value: float
        :param depth_unit:
        :type depth_unit: DepthUnit
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_observations_serialize(
            page=page,
            page_limit=page_limit,
            external_id=external_id,
            schedule_ids=schedule_ids,
            observatory_ids=observatory_ids,
            telescope_ids=telescope_ids,
            instrument_ids=instrument_ids,
            status=status,
            proposal=proposal,
            object_name=object_name,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            bandpass_min=bandpass_min,
            bandpass_max=bandpass_max,
            bandpass_type=bandpass_type,
            cone_search_ra=cone_search_ra,
            cone_search_dec=cone_search_dec,
            cone_search_radius=cone_search_radius,
            type=type,
            depth_value=depth_value,
            depth_unit=depth_unit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageObservation",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_observations_without_preload_content(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        page_limit: Annotated[Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]], Field(description="Records per page")] = None,
        external_id: Optional[StrictStr] = None,
        schedule_ids: Optional[List[Optional[StrictStr]]] = None,
        observatory_ids: Optional[List[StrictStr]] = None,
        telescope_ids: Optional[List[StrictStr]] = None,
        instrument_ids: Optional[List[StrictStr]] = None,
        status: Optional[ObservationStatus] = None,
        proposal: Optional[StrictStr] = None,
        object_name: Optional[StrictStr] = None,
        date_range_begin: Optional[datetime] = None,
        date_range_end: Optional[datetime] = None,
        bandpass_min: Optional[Union[StrictFloat, StrictInt]] = None,
        bandpass_max: Optional[Union[StrictFloat, StrictInt]] = None,
        bandpass_type: Optional[Any] = None,
        cone_search_ra: Optional[Union[StrictFloat, StrictInt]] = None,
        cone_search_dec: Optional[Union[StrictFloat, StrictInt]] = None,
        cone_search_radius: Optional[Union[StrictFloat, StrictInt]] = None,
        type: Optional[ObservationType] = None,
        depth_value: Optional[Union[StrictFloat, StrictInt]] = None,
        depth_unit: Optional[DepthUnit] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Read observations(s)

        Read the observations based on query params

        :param page: Page number
        :type page: int
        :param page_limit: Records per page
        :type page_limit: int
        :param external_id:
        :type external_id: str
        :param schedule_ids:
        :type schedule_ids: List[Optional[str]]
        :param observatory_ids:
        :type observatory_ids: List[str]
        :param telescope_ids:
        :type telescope_ids: List[str]
        :param instrument_ids:
        :type instrument_ids: List[str]
        :param status:
        :type status: ObservationStatus
        :param proposal:
        :type proposal: str
        :param object_name:
        :type object_name: str
        :param date_range_begin:
        :type date_range_begin: datetime
        :param date_range_end:
        :type date_range_end: datetime
        :param bandpass_min:
        :type bandpass_min: float
        :param bandpass_max:
        :type bandpass_max: float
        :param bandpass_type:
        :type bandpass_type: BandpassType
        :param cone_search_ra:
        :type cone_search_ra: float
        :param cone_search_dec:
        :type cone_search_dec: float
        :param cone_search_radius:
        :type cone_search_radius: float
        :param type:
        :type type: ObservationType
        :param depth_value:
        :type depth_value: float
        :param depth_unit:
        :type depth_unit: DepthUnit
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_observations_serialize(
            page=page,
            page_limit=page_limit,
            external_id=external_id,
            schedule_ids=schedule_ids,
            observatory_ids=observatory_ids,
            telescope_ids=telescope_ids,
            instrument_ids=instrument_ids,
            status=status,
            proposal=proposal,
            object_name=object_name,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            bandpass_min=bandpass_min,
            bandpass_max=bandpass_max,
            bandpass_type=bandpass_type,
            cone_search_ra=cone_search_ra,
            cone_search_dec=cone_search_dec,
            cone_search_radius=cone_search_radius,
            type=type,
            depth_value=depth_value,
            depth_unit=depth_unit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageObservation",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_observations_serialize(
        self,
        page,
        page_limit,
        external_id,
        schedule_ids,
        observatory_ids,
        telescope_ids,
        instrument_ids,
        status,
        proposal,
        object_name,
        date_range_begin,
        date_range_end,
        bandpass_min,
        bandpass_max,
        bandpass_type,
        cone_search_ra,
        cone_search_dec,
        cone_search_radius,
        type,
        depth_value,
        depth_unit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'schedule_ids': 'multi',
            'observatory_ids': 'multi',
            'telescope_ids': 'multi',
            'instrument_ids': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_limit is not None:
            
            _query_params.append(('page_limit', page_limit))
            
        if external_id is not None:
            
            _query_params.append(('external_id', external_id))
            
        if schedule_ids is not None:
            
            _query_params.append(('schedule_ids', schedule_ids))
            
        if observatory_ids is not None:
            
            _query_params.append(('observatory_ids', observatory_ids))
            
        if telescope_ids is not None:
            
            _query_params.append(('telescope_ids', telescope_ids))
            
        if instrument_ids is not None:
            
            _query_params.append(('instrument_ids', instrument_ids))
            
        if status is not None:
            
            _query_params.append(('status', status.value))
            
        if proposal is not None:
            
            _query_params.append(('proposal', proposal))
            
        if object_name is not None:
            
            _query_params.append(('object_name', object_name))
            
        if date_range_begin is not None:
            if isinstance(date_range_begin, datetime):
                _query_params.append(
                    (
                        'date_range_begin',
                        date_range_begin.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('date_range_begin', date_range_begin))
            
        if date_range_end is not None:
            if isinstance(date_range_end, datetime):
                _query_params.append(
                    (
                        'date_range_end',
                        date_range_end.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('date_range_end', date_range_end))
            
        if bandpass_min is not None:
            
            _query_params.append(('bandpass_min', bandpass_min))
            
        if bandpass_max is not None:
            
            _query_params.append(('bandpass_max', bandpass_max))
            
        if bandpass_type is not None:
            
            _query_params.append(('bandpass_type', bandpass_type))
            
        if cone_search_ra is not None:
            
            _query_params.append(('cone_search_ra', cone_search_ra))
            
        if cone_search_dec is not None:
            
            _query_params.append(('cone_search_dec', cone_search_dec))
            
        if cone_search_radius is not None:
            
            _query_params.append(('cone_search_radius', cone_search_radius))
            
        if type is not None:
            
            _query_params.append(('type', type.value))
            
        if depth_value is not None:
            
            _query_params.append(('depth_value', depth_value))
            
        if depth_unit is not None:
            
            _query_params.append(('depth_unit', depth_unit.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/observation/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


