# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 1.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from across.sdk.v1.models.energy_bandpass import EnergyBandpass
from across.sdk.v1.models.frequency_bandpass import FrequencyBandpass
from across.sdk.v1.models.wavelength_bandpass import WavelengthBandpass
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

BANDPASS_ANY_OF_SCHEMAS = ["EnergyBandpass", "FrequencyBandpass", "WavelengthBandpass"]

class Bandpass(BaseModel):
    """
    Bandpass
    """

    # data type: EnergyBandpass
    anyof_schema_1_validator: Optional[EnergyBandpass] = None
    # data type: FrequencyBandpass
    anyof_schema_2_validator: Optional[FrequencyBandpass] = None
    # data type: WavelengthBandpass
    anyof_schema_3_validator: Optional[WavelengthBandpass] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[EnergyBandpass, FrequencyBandpass, WavelengthBandpass]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "EnergyBandpass", "FrequencyBandpass", "WavelengthBandpass" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = Bandpass.model_construct()
        error_messages = []
        # validate data type: EnergyBandpass
        if not isinstance(v, EnergyBandpass):
            error_messages.append(f"Error! Input type `{type(v)}` is not `EnergyBandpass`")
        else:
            return v

        # validate data type: FrequencyBandpass
        if not isinstance(v, FrequencyBandpass):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FrequencyBandpass`")
        else:
            return v

        # validate data type: WavelengthBandpass
        if not isinstance(v, WavelengthBandpass):
            error_messages.append(f"Error! Input type `{type(v)}` is not `WavelengthBandpass`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in Bandpass with anyOf schemas: EnergyBandpass, FrequencyBandpass, WavelengthBandpass. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[EnergyBandpass] = None
        try:
            instance.actual_instance = EnergyBandpass.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[FrequencyBandpass] = None
        try:
            instance.actual_instance = FrequencyBandpass.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[WavelengthBandpass] = None
        try:
            instance.actual_instance = WavelengthBandpass.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Bandpass with anyOf schemas: EnergyBandpass, FrequencyBandpass, WavelengthBandpass. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], EnergyBandpass, FrequencyBandpass, WavelengthBandpass]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


