# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 1.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from across.sdk.v1.models.page_schedule import PageSchedule
from across.sdk.v1.models.schedule import Schedule
from across.sdk.v1.models.schedule_create import ScheduleCreate
from across.sdk.v1.models.schedule_create_many import ScheduleCreateMany
from across.sdk.v1.models.schedule_fidelity import ScheduleFidelity
from across.sdk.v1.models.schedule_status import ScheduleStatus

from across.sdk.v1.api_client import ApiClient, RequestSerialized
from across.sdk.v1.api_response import ApiResponse
from across.sdk.v1.rest import RESTResponseType


class ScheduleApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_many_schedules(
        self,
        schedule_create_many: ScheduleCreateMany,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[str]:
        """Create many Schedules

        Create many new observing schedules for ACROSS.

        :param schedule_create_many: (required)
        :type schedule_create_many: ScheduleCreateMany
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_many_schedules_serialize(
            schedule_create_many=schedule_create_many,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "List[str]",
            '404': None,
            '422': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_many_schedules_with_http_info(
        self,
        schedule_create_many: ScheduleCreateMany,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[str]]:
        """Create many Schedules

        Create many new observing schedules for ACROSS.

        :param schedule_create_many: (required)
        :type schedule_create_many: ScheduleCreateMany
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_many_schedules_serialize(
            schedule_create_many=schedule_create_many,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "List[str]",
            '404': None,
            '422': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_many_schedules_without_preload_content(
        self,
        schedule_create_many: ScheduleCreateMany,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create many Schedules

        Create many new observing schedules for ACROSS.

        :param schedule_create_many: (required)
        :type schedule_create_many: ScheduleCreateMany
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_many_schedules_serialize(
            schedule_create_many=schedule_create_many,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "List[str]",
            '404': None,
            '422': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_many_schedules_serialize(
        self,
        schedule_create_many,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if schedule_create_many is not None:
            _body_params = schedule_create_many


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/schedule/bulk',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_schedule(
        self,
        schedule_create: ScheduleCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> str:
        """Create a Schedule

        Create a new observing schedule for ACROSS.

        :param schedule_create: (required)
        :type schedule_create: ScheduleCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_schedule_serialize(
            schedule_create=schedule_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "str",
            '404': None,
            '409': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_schedule_with_http_info(
        self,
        schedule_create: ScheduleCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[str]:
        """Create a Schedule

        Create a new observing schedule for ACROSS.

        :param schedule_create: (required)
        :type schedule_create: ScheduleCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_schedule_serialize(
            schedule_create=schedule_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "str",
            '404': None,
            '409': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_schedule_without_preload_content(
        self,
        schedule_create: ScheduleCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a Schedule

        Create a new observing schedule for ACROSS.

        :param schedule_create: (required)
        :type schedule_create: ScheduleCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_schedule_serialize(
            schedule_create=schedule_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "str",
            '404': None,
            '409': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_schedule_serialize(
        self,
        schedule_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if schedule_create is not None:
            _body_params = schedule_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/schedule/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_schedule(
        self,
        schedule_id: StrictStr,
        include_observations: Optional[StrictBool] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Schedule:
        """Read a schedule

        Read a schedule by a schedule ID.

        :param schedule_id: (required)
        :type schedule_id: str
        :param include_observations:
        :type include_observations: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_schedule_serialize(
            schedule_id=schedule_id,
            include_observations=include_observations,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Schedule",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_schedule_with_http_info(
        self,
        schedule_id: StrictStr,
        include_observations: Optional[StrictBool] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Schedule]:
        """Read a schedule

        Read a schedule by a schedule ID.

        :param schedule_id: (required)
        :type schedule_id: str
        :param include_observations:
        :type include_observations: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_schedule_serialize(
            schedule_id=schedule_id,
            include_observations=include_observations,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Schedule",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_schedule_without_preload_content(
        self,
        schedule_id: StrictStr,
        include_observations: Optional[StrictBool] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Read a schedule

        Read a schedule by a schedule ID.

        :param schedule_id: (required)
        :type schedule_id: str
        :param include_observations:
        :type include_observations: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_schedule_serialize(
            schedule_id=schedule_id,
            include_observations=include_observations,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Schedule",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_schedule_serialize(
        self,
        schedule_id,
        include_observations,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if schedule_id is not None:
            _path_params['schedule_id'] = schedule_id
        # process the query parameters
        if include_observations is not None:
            
            _query_params.append(('include_observations', include_observations))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/schedule/{schedule_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_schedules(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        page_limit: Annotated[Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]], Field(description="Records per page")] = None,
        date_range_begin: Optional[datetime] = None,
        date_range_end: Optional[datetime] = None,
        status: Optional[ScheduleStatus] = None,
        external_id: Optional[StrictStr] = None,
        fidelity: Optional[ScheduleFidelity] = None,
        created_on: Optional[datetime] = None,
        observatory_ids: Optional[List[Optional[StrictStr]]] = None,
        observatory_names: Optional[List[Optional[StrictStr]]] = None,
        telescope_ids: Optional[List[Optional[StrictStr]]] = None,
        telescope_names: Optional[List[Optional[StrictStr]]] = None,
        name: Optional[StrictStr] = None,
        include_observations: Optional[StrictBool] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PageSchedule:
        """Read schedule(s)

        Read most recent schedules based on query params

        :param page: Page number
        :type page: int
        :param page_limit: Records per page
        :type page_limit: int
        :param date_range_begin:
        :type date_range_begin: datetime
        :param date_range_end:
        :type date_range_end: datetime
        :param status:
        :type status: ScheduleStatus
        :param external_id:
        :type external_id: str
        :param fidelity:
        :type fidelity: ScheduleFidelity
        :param created_on:
        :type created_on: datetime
        :param observatory_ids:
        :type observatory_ids: List[Optional[str]]
        :param observatory_names:
        :type observatory_names: List[Optional[str]]
        :param telescope_ids:
        :type telescope_ids: List[Optional[str]]
        :param telescope_names:
        :type telescope_names: List[Optional[str]]
        :param name:
        :type name: str
        :param include_observations:
        :type include_observations: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_schedules_serialize(
            page=page,
            page_limit=page_limit,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            status=status,
            external_id=external_id,
            fidelity=fidelity,
            created_on=created_on,
            observatory_ids=observatory_ids,
            observatory_names=observatory_names,
            telescope_ids=telescope_ids,
            telescope_names=telescope_names,
            name=name,
            include_observations=include_observations,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageSchedule",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_schedules_with_http_info(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        page_limit: Annotated[Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]], Field(description="Records per page")] = None,
        date_range_begin: Optional[datetime] = None,
        date_range_end: Optional[datetime] = None,
        status: Optional[ScheduleStatus] = None,
        external_id: Optional[StrictStr] = None,
        fidelity: Optional[ScheduleFidelity] = None,
        created_on: Optional[datetime] = None,
        observatory_ids: Optional[List[Optional[StrictStr]]] = None,
        observatory_names: Optional[List[Optional[StrictStr]]] = None,
        telescope_ids: Optional[List[Optional[StrictStr]]] = None,
        telescope_names: Optional[List[Optional[StrictStr]]] = None,
        name: Optional[StrictStr] = None,
        include_observations: Optional[StrictBool] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PageSchedule]:
        """Read schedule(s)

        Read most recent schedules based on query params

        :param page: Page number
        :type page: int
        :param page_limit: Records per page
        :type page_limit: int
        :param date_range_begin:
        :type date_range_begin: datetime
        :param date_range_end:
        :type date_range_end: datetime
        :param status:
        :type status: ScheduleStatus
        :param external_id:
        :type external_id: str
        :param fidelity:
        :type fidelity: ScheduleFidelity
        :param created_on:
        :type created_on: datetime
        :param observatory_ids:
        :type observatory_ids: List[Optional[str]]
        :param observatory_names:
        :type observatory_names: List[Optional[str]]
        :param telescope_ids:
        :type telescope_ids: List[Optional[str]]
        :param telescope_names:
        :type telescope_names: List[Optional[str]]
        :param name:
        :type name: str
        :param include_observations:
        :type include_observations: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_schedules_serialize(
            page=page,
            page_limit=page_limit,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            status=status,
            external_id=external_id,
            fidelity=fidelity,
            created_on=created_on,
            observatory_ids=observatory_ids,
            observatory_names=observatory_names,
            telescope_ids=telescope_ids,
            telescope_names=telescope_names,
            name=name,
            include_observations=include_observations,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageSchedule",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_schedules_without_preload_content(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        page_limit: Annotated[Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]], Field(description="Records per page")] = None,
        date_range_begin: Optional[datetime] = None,
        date_range_end: Optional[datetime] = None,
        status: Optional[ScheduleStatus] = None,
        external_id: Optional[StrictStr] = None,
        fidelity: Optional[ScheduleFidelity] = None,
        created_on: Optional[datetime] = None,
        observatory_ids: Optional[List[Optional[StrictStr]]] = None,
        observatory_names: Optional[List[Optional[StrictStr]]] = None,
        telescope_ids: Optional[List[Optional[StrictStr]]] = None,
        telescope_names: Optional[List[Optional[StrictStr]]] = None,
        name: Optional[StrictStr] = None,
        include_observations: Optional[StrictBool] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Read schedule(s)

        Read most recent schedules based on query params

        :param page: Page number
        :type page: int
        :param page_limit: Records per page
        :type page_limit: int
        :param date_range_begin:
        :type date_range_begin: datetime
        :param date_range_end:
        :type date_range_end: datetime
        :param status:
        :type status: ScheduleStatus
        :param external_id:
        :type external_id: str
        :param fidelity:
        :type fidelity: ScheduleFidelity
        :param created_on:
        :type created_on: datetime
        :param observatory_ids:
        :type observatory_ids: List[Optional[str]]
        :param observatory_names:
        :type observatory_names: List[Optional[str]]
        :param telescope_ids:
        :type telescope_ids: List[Optional[str]]
        :param telescope_names:
        :type telescope_names: List[Optional[str]]
        :param name:
        :type name: str
        :param include_observations:
        :type include_observations: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_schedules_serialize(
            page=page,
            page_limit=page_limit,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            status=status,
            external_id=external_id,
            fidelity=fidelity,
            created_on=created_on,
            observatory_ids=observatory_ids,
            observatory_names=observatory_names,
            telescope_ids=telescope_ids,
            telescope_names=telescope_names,
            name=name,
            include_observations=include_observations,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageSchedule",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_schedules_serialize(
        self,
        page,
        page_limit,
        date_range_begin,
        date_range_end,
        status,
        external_id,
        fidelity,
        created_on,
        observatory_ids,
        observatory_names,
        telescope_ids,
        telescope_names,
        name,
        include_observations,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'observatory_ids': 'multi',
            'observatory_names': 'multi',
            'telescope_ids': 'multi',
            'telescope_names': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_limit is not None:
            
            _query_params.append(('page_limit', page_limit))
            
        if date_range_begin is not None:
            if isinstance(date_range_begin, datetime):
                _query_params.append(
                    (
                        'date_range_begin',
                        date_range_begin.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('date_range_begin', date_range_begin))
            
        if date_range_end is not None:
            if isinstance(date_range_end, datetime):
                _query_params.append(
                    (
                        'date_range_end',
                        date_range_end.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('date_range_end', date_range_end))
            
        if status is not None:
            
            _query_params.append(('status', status.value))
            
        if external_id is not None:
            
            _query_params.append(('external_id', external_id))
            
        if fidelity is not None:
            
            _query_params.append(('fidelity', fidelity.value))
            
        if created_on is not None:
            if isinstance(created_on, datetime):
                _query_params.append(
                    (
                        'created_on',
                        created_on.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('created_on', created_on))
            
        if observatory_ids is not None:
            
            _query_params.append(('observatory_ids', observatory_ids))
            
        if observatory_names is not None:
            
            _query_params.append(('observatory_names', observatory_names))
            
        if telescope_ids is not None:
            
            _query_params.append(('telescope_ids', telescope_ids))
            
        if telescope_names is not None:
            
            _query_params.append(('telescope_names', telescope_names))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if include_observations is not None:
            
            _query_params.append(('include_observations', include_observations))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/schedule/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_schedules_history(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        page_limit: Annotated[Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]], Field(description="Records per page")] = None,
        date_range_begin: Optional[datetime] = None,
        date_range_end: Optional[datetime] = None,
        status: Optional[ScheduleStatus] = None,
        external_id: Optional[StrictStr] = None,
        fidelity: Optional[ScheduleFidelity] = None,
        created_on: Optional[datetime] = None,
        observatory_ids: Optional[List[Optional[StrictStr]]] = None,
        observatory_names: Optional[List[Optional[StrictStr]]] = None,
        telescope_ids: Optional[List[Optional[StrictStr]]] = None,
        telescope_names: Optional[List[Optional[StrictStr]]] = None,
        name: Optional[StrictStr] = None,
        include_observations: Optional[StrictBool] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PageSchedule:
        """Read schedule(s)

        Read many recent schedules based on query params

        :param page: Page number
        :type page: int
        :param page_limit: Records per page
        :type page_limit: int
        :param date_range_begin:
        :type date_range_begin: datetime
        :param date_range_end:
        :type date_range_end: datetime
        :param status:
        :type status: ScheduleStatus
        :param external_id:
        :type external_id: str
        :param fidelity:
        :type fidelity: ScheduleFidelity
        :param created_on:
        :type created_on: datetime
        :param observatory_ids:
        :type observatory_ids: List[Optional[str]]
        :param observatory_names:
        :type observatory_names: List[Optional[str]]
        :param telescope_ids:
        :type telescope_ids: List[Optional[str]]
        :param telescope_names:
        :type telescope_names: List[Optional[str]]
        :param name:
        :type name: str
        :param include_observations:
        :type include_observations: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_schedules_history_serialize(
            page=page,
            page_limit=page_limit,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            status=status,
            external_id=external_id,
            fidelity=fidelity,
            created_on=created_on,
            observatory_ids=observatory_ids,
            observatory_names=observatory_names,
            telescope_ids=telescope_ids,
            telescope_names=telescope_names,
            name=name,
            include_observations=include_observations,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageSchedule",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_schedules_history_with_http_info(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        page_limit: Annotated[Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]], Field(description="Records per page")] = None,
        date_range_begin: Optional[datetime] = None,
        date_range_end: Optional[datetime] = None,
        status: Optional[ScheduleStatus] = None,
        external_id: Optional[StrictStr] = None,
        fidelity: Optional[ScheduleFidelity] = None,
        created_on: Optional[datetime] = None,
        observatory_ids: Optional[List[Optional[StrictStr]]] = None,
        observatory_names: Optional[List[Optional[StrictStr]]] = None,
        telescope_ids: Optional[List[Optional[StrictStr]]] = None,
        telescope_names: Optional[List[Optional[StrictStr]]] = None,
        name: Optional[StrictStr] = None,
        include_observations: Optional[StrictBool] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PageSchedule]:
        """Read schedule(s)

        Read many recent schedules based on query params

        :param page: Page number
        :type page: int
        :param page_limit: Records per page
        :type page_limit: int
        :param date_range_begin:
        :type date_range_begin: datetime
        :param date_range_end:
        :type date_range_end: datetime
        :param status:
        :type status: ScheduleStatus
        :param external_id:
        :type external_id: str
        :param fidelity:
        :type fidelity: ScheduleFidelity
        :param created_on:
        :type created_on: datetime
        :param observatory_ids:
        :type observatory_ids: List[Optional[str]]
        :param observatory_names:
        :type observatory_names: List[Optional[str]]
        :param telescope_ids:
        :type telescope_ids: List[Optional[str]]
        :param telescope_names:
        :type telescope_names: List[Optional[str]]
        :param name:
        :type name: str
        :param include_observations:
        :type include_observations: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_schedules_history_serialize(
            page=page,
            page_limit=page_limit,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            status=status,
            external_id=external_id,
            fidelity=fidelity,
            created_on=created_on,
            observatory_ids=observatory_ids,
            observatory_names=observatory_names,
            telescope_ids=telescope_ids,
            telescope_names=telescope_names,
            name=name,
            include_observations=include_observations,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageSchedule",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_schedules_history_without_preload_content(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        page_limit: Annotated[Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]], Field(description="Records per page")] = None,
        date_range_begin: Optional[datetime] = None,
        date_range_end: Optional[datetime] = None,
        status: Optional[ScheduleStatus] = None,
        external_id: Optional[StrictStr] = None,
        fidelity: Optional[ScheduleFidelity] = None,
        created_on: Optional[datetime] = None,
        observatory_ids: Optional[List[Optional[StrictStr]]] = None,
        observatory_names: Optional[List[Optional[StrictStr]]] = None,
        telescope_ids: Optional[List[Optional[StrictStr]]] = None,
        telescope_names: Optional[List[Optional[StrictStr]]] = None,
        name: Optional[StrictStr] = None,
        include_observations: Optional[StrictBool] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Read schedule(s)

        Read many recent schedules based on query params

        :param page: Page number
        :type page: int
        :param page_limit: Records per page
        :type page_limit: int
        :param date_range_begin:
        :type date_range_begin: datetime
        :param date_range_end:
        :type date_range_end: datetime
        :param status:
        :type status: ScheduleStatus
        :param external_id:
        :type external_id: str
        :param fidelity:
        :type fidelity: ScheduleFidelity
        :param created_on:
        :type created_on: datetime
        :param observatory_ids:
        :type observatory_ids: List[Optional[str]]
        :param observatory_names:
        :type observatory_names: List[Optional[str]]
        :param telescope_ids:
        :type telescope_ids: List[Optional[str]]
        :param telescope_names:
        :type telescope_names: List[Optional[str]]
        :param name:
        :type name: str
        :param include_observations:
        :type include_observations: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_schedules_history_serialize(
            page=page,
            page_limit=page_limit,
            date_range_begin=date_range_begin,
            date_range_end=date_range_end,
            status=status,
            external_id=external_id,
            fidelity=fidelity,
            created_on=created_on,
            observatory_ids=observatory_ids,
            observatory_names=observatory_names,
            telescope_ids=telescope_ids,
            telescope_names=telescope_names,
            name=name,
            include_observations=include_observations,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageSchedule",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_schedules_history_serialize(
        self,
        page,
        page_limit,
        date_range_begin,
        date_range_end,
        status,
        external_id,
        fidelity,
        created_on,
        observatory_ids,
        observatory_names,
        telescope_ids,
        telescope_names,
        name,
        include_observations,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'observatory_ids': 'multi',
            'observatory_names': 'multi',
            'telescope_ids': 'multi',
            'telescope_names': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_limit is not None:
            
            _query_params.append(('page_limit', page_limit))
            
        if date_range_begin is not None:
            if isinstance(date_range_begin, datetime):
                _query_params.append(
                    (
                        'date_range_begin',
                        date_range_begin.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('date_range_begin', date_range_begin))
            
        if date_range_end is not None:
            if isinstance(date_range_end, datetime):
                _query_params.append(
                    (
                        'date_range_end',
                        date_range_end.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('date_range_end', date_range_end))
            
        if status is not None:
            
            _query_params.append(('status', status.value))
            
        if external_id is not None:
            
            _query_params.append(('external_id', external_id))
            
        if fidelity is not None:
            
            _query_params.append(('fidelity', fidelity.value))
            
        if created_on is not None:
            if isinstance(created_on, datetime):
                _query_params.append(
                    (
                        'created_on',
                        created_on.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('created_on', created_on))
            
        if observatory_ids is not None:
            
            _query_params.append(('observatory_ids', observatory_ids))
            
        if observatory_names is not None:
            
            _query_params.append(('observatory_names', observatory_names))
            
        if telescope_ids is not None:
            
            _query_params.append(('telescope_ids', telescope_ids))
            
        if telescope_names is not None:
            
            _query_params.append(('telescope_names', telescope_names))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if include_observations is not None:
            
            _query_params.append(('include_observations', include_observations))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/schedule/history',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


