# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 1.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from across.sdk.v1.models.id_name_schema import IDNameSchema
from across.sdk.v1.models.nullable_date_range import NullableDateRange
from across.sdk.v1.models.observatory_ephemeris_type import ObservatoryEphemerisType
from across.sdk.v1.models.observatory_type import ObservatoryType
from typing import Optional, Set
from typing_extensions import Self

class Observatory(BaseModel):
    """
    A Pydantic model class representing a created observatory  Notes ----- Inherits from ObservatoryBase
    """ # noqa: E501
    id: StrictStr
    created_on: datetime
    name: StrictStr
    short_name: StrictStr
    type: ObservatoryType
    telescopes: Optional[List[IDNameSchema]] = None
    ephemeris_types: Optional[List[ObservatoryEphemerisType]] = None
    reference_url: Optional[StrictStr]
    operational: Optional[NullableDateRange]
    __properties: ClassVar[List[str]] = ["id", "created_on", "name", "short_name", "type", "telescopes", "ephemeris_types", "reference_url", "operational"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Observatory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in telescopes (list)
        _items = []
        if self.telescopes:
            for _item_telescopes in self.telescopes:
                if _item_telescopes:
                    _items.append(_item_telescopes.to_dict())
            _dict['telescopes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in ephemeris_types (list)
        _items = []
        if self.ephemeris_types:
            for _item_ephemeris_types in self.ephemeris_types:
                if _item_ephemeris_types:
                    _items.append(_item_ephemeris_types.to_dict())
            _dict['ephemeris_types'] = _items
        # override the default output from pydantic by calling `to_dict()` of operational
        if self.operational:
            _dict['operational'] = self.operational.to_dict()
        # set to None if telescopes (nullable) is None
        # and model_fields_set contains the field
        if self.telescopes is None and "telescopes" in self.model_fields_set:
            _dict['telescopes'] = None

        # set to None if ephemeris_types (nullable) is None
        # and model_fields_set contains the field
        if self.ephemeris_types is None and "ephemeris_types" in self.model_fields_set:
            _dict['ephemeris_types'] = None

        # set to None if reference_url (nullable) is None
        # and model_fields_set contains the field
        if self.reference_url is None and "reference_url" in self.model_fields_set:
            _dict['reference_url'] = None

        # set to None if operational (nullable) is None
        # and model_fields_set contains the field
        if self.operational is None and "operational" in self.model_fields_set:
            _dict['operational'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Observatory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created_on": obj.get("created_on"),
            "name": obj.get("name"),
            "short_name": obj.get("short_name"),
            "type": obj.get("type"),
            "telescopes": [IDNameSchema.from_dict(_item) for _item in obj["telescopes"]] if obj.get("telescopes") is not None else None,
            "ephemeris_types": [ObservatoryEphemerisType.from_dict(_item) for _item in obj["ephemeris_types"]] if obj.get("ephemeris_types") is not None else None,
            "reference_url": obj.get("reference_url"),
            "operational": NullableDateRange.from_dict(obj["operational"]) if obj.get("operational") is not None else None
        })
        return _obj


