# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 1.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from across.sdk.v1.models.energy_unit import EnergyUnit
from across.sdk.v1.models.frequency_unit import FrequencyUnit
from across.sdk.v1.models.wavelength_unit import WavelengthUnit
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

BANDPASSTYPE_ANY_OF_SCHEMAS = ["EnergyUnit", "FrequencyUnit", "WavelengthUnit"]

class BandpassType(BaseModel):
    """
    BandpassType
    """

    # data type: WavelengthUnit
    anyof_schema_1_validator: Optional[WavelengthUnit] = None
    # data type: EnergyUnit
    anyof_schema_2_validator: Optional[EnergyUnit] = None
    # data type: FrequencyUnit
    anyof_schema_3_validator: Optional[FrequencyUnit] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[EnergyUnit, FrequencyUnit, WavelengthUnit]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "EnergyUnit", "FrequencyUnit", "WavelengthUnit" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        if v is None:
            return v

        instance = BandpassType.model_construct()
        error_messages = []
        # validate data type: WavelengthUnit
        if not isinstance(v, WavelengthUnit):
            error_messages.append(f"Error! Input type `{type(v)}` is not `WavelengthUnit`")
        else:
            return v

        # validate data type: EnergyUnit
        if not isinstance(v, EnergyUnit):
            error_messages.append(f"Error! Input type `{type(v)}` is not `EnergyUnit`")
        else:
            return v

        # validate data type: FrequencyUnit
        if not isinstance(v, FrequencyUnit):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FrequencyUnit`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in BandpassType with anyOf schemas: EnergyUnit, FrequencyUnit, WavelengthUnit. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        if json_str is None:
            return instance

        error_messages = []
        # anyof_schema_1_validator: Optional[WavelengthUnit] = None
        try:
            instance.actual_instance = WavelengthUnit.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[EnergyUnit] = None
        try:
            instance.actual_instance = EnergyUnit.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[FrequencyUnit] = None
        try:
            instance.actual_instance = FrequencyUnit.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into BandpassType with anyOf schemas: EnergyUnit, FrequencyUnit, WavelengthUnit. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], EnergyUnit, FrequencyUnit, WavelengthUnit]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


