# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 1.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from across.sdk.v1.models.id_name_schema import IDNameSchema
from across.sdk.v1.models.schedule_cadence import ScheduleCadence
from across.sdk.v1.models.telescope_instrument import TelescopeInstrument
from typing import Optional, Set
from typing_extensions import Self

class Telescope(BaseModel):
    """
    A Pydantic model class representing a created telescope  Notes ----- Inherits from TelescopeBase  Methods ------- from_orm(telescope: TelescopeModel) -> Telescope     Static method that instantiates this class from a telescope database record
    """ # noqa: E501
    id: StrictStr
    created_on: datetime
    name: StrictStr
    short_name: StrictStr
    schedule_cadences: Optional[List[ScheduleCadence]] = None
    observatory: Optional[IDNameSchema] = None
    instruments: Optional[List[TelescopeInstrument]] = None
    __properties: ClassVar[List[str]] = ["id", "created_on", "name", "short_name", "schedule_cadences", "observatory", "instruments"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Telescope from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in schedule_cadences (list)
        _items = []
        if self.schedule_cadences:
            for _item_schedule_cadences in self.schedule_cadences:
                if _item_schedule_cadences:
                    _items.append(_item_schedule_cadences.to_dict())
            _dict['schedule_cadences'] = _items
        # override the default output from pydantic by calling `to_dict()` of observatory
        if self.observatory:
            _dict['observatory'] = self.observatory.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in instruments (list)
        _items = []
        if self.instruments:
            for _item_instruments in self.instruments:
                if _item_instruments:
                    _items.append(_item_instruments.to_dict())
            _dict['instruments'] = _items
        # set to None if schedule_cadences (nullable) is None
        # and model_fields_set contains the field
        if self.schedule_cadences is None and "schedule_cadences" in self.model_fields_set:
            _dict['schedule_cadences'] = None

        # set to None if observatory (nullable) is None
        # and model_fields_set contains the field
        if self.observatory is None and "observatory" in self.model_fields_set:
            _dict['observatory'] = None

        # set to None if instruments (nullable) is None
        # and model_fields_set contains the field
        if self.instruments is None and "instruments" in self.model_fields_set:
            _dict['instruments'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Telescope from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created_on": obj.get("created_on"),
            "name": obj.get("name"),
            "short_name": obj.get("short_name"),
            "schedule_cadences": [ScheduleCadence.from_dict(_item) for _item in obj["schedule_cadences"]] if obj.get("schedule_cadences") is not None else None,
            "observatory": IDNameSchema.from_dict(obj["observatory"]) if obj.get("observatory") is not None else None,
            "instruments": [TelescopeInstrument.from_dict(_item) for _item in obj["instruments"]] if obj.get("instruments") is not None else None
        })
        return _obj


