# coding: utf-8

"""
    Actinia

     ================================ Actinia - The GRASS GIS REST API ================================  **Actinia** is an open source REST API for scalable, distributed, high performance processing of geographical data that uses GRASS GIS for computational tasks.  It provides a REST API to process satellite images, time series of satellite images, arbitrary raster data with geographical relations and vector data.  The REST interface allows to access, manage and manipulate the GRASS GIS database via HTTP GET,PUT,POST and DELETE requests and to process raster, vector and time series data located in a persistent GRASS GIS database. **Actinia** allows the processing of cloud based data, for example all Landsat 4-8 scenes as well as all Sentinel2A scenes in an ephemeral databases. The computational results of ephemeral processing are available via object storage as GeoTIFF files.  The full API documentation is available here: https://redocly.github.io/redoc/?url=https://actinia.mundialis.de/latest/ swagger.json   Examples: ---------  To execute the examples, first setup login information, IP address and port:      export ACTINIA_URL=https://actinia.mundialis.de/latest     export AUTH='-u demouser:gu3st!pa55w0rd'  **Data management**  - List all locations that are available in the actinia persistent database:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations\"  - List all mapsets in the location latlong_wgs84:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets\"  - List all raster layers in location latlong_wgs84 and mapset Sentinel2A      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets/Sentinel2A/raster_layers\"  - List all space-time raster datasets (STRDS) in location ECAD and mapset   PERMANENT:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/raster_layers\"  - List all raster map layers of the STRDS precipitation_1950_2013_yearly_mm:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/strds/precipitation_    1950_2013_yearly_mm/raster_layers\"  **Landsat and Sentinel2A NDVI computation**  This API call will compute the NDVI of the top of atmosphere (TOAR) corrected Landsat4 scene LC80440342016259LGN00:      curl ${AUTH} -X POST \"${ACTINIA_URL}/landsat_process/    LC80440342016259LGN00/TOAR/NDVI\"  NDVI computation of Sentinel2A scene S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138:      curl ${AUTH} -X POST \"${ACTINIA_URL}/sentinel2_process/ndvi/    S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138\"  The results of the asynchronous computations are available as GeoTIFF file in a cloud storage for download. 

    The version of the OpenAPI document: v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import io
import warnings

from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Dict, List, Optional, Tuple, Union, Any

try:
    from typing import Annotated
except ImportError:
    from typing_extensions import Annotated

from pydantic import Field
from typing_extensions import Annotated
from pydantic import StrictStr

from actinia_openapi_python_client.models.point_list_model import PointListModel
from actinia_openapi_python_client.models.strds_sample_geo_json_response_model import STRDSSampleGeoJSONResponseModel
from actinia_openapi_python_client.models.strds_sample_response_model import STRDSSampleResponseModel

from actinia_openapi_python_client.api_client import ApiClient
from actinia_openapi_python_client.api_response import ApiResponse
from actinia_openapi_python_client.rest import RESTResponseType


class STRDSSamplingApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_async_geojson_post(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        strds_name: Annotated[StrictStr, Field(description="The name of the space-time raster dataset that should be sampled")],
        points: Annotated[StrictStr, Field(description="GeoJSON vector input that contains the vector points for sampling")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> STRDSSampleGeoJSONResponseModel:
        """Sample a strds by point coordinates, asynchronous call

        Spatial sampling of a space-time raster dataset (STRDS) with vector points. The vector points must be provided as GeoJSON vector point format that includes correct coordinate system specification. The result of the sampling is located in the resource responseJSON document after the processing was finished, as a list of timestamped values for each vector point. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param strds_name: The name of the space-time raster dataset that should be sampled (required)
        :type strds_name: str
        :param points: GeoJSON vector input that contains the vector points for sampling (required)
        :type points: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_async_geojson_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            strds_name=strds_name,
            points=points,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "STRDSSampleGeoJSONResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_async_geojson_post_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        strds_name: Annotated[StrictStr, Field(description="The name of the space-time raster dataset that should be sampled")],
        points: Annotated[StrictStr, Field(description="GeoJSON vector input that contains the vector points for sampling")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[STRDSSampleGeoJSONResponseModel]:
        """Sample a strds by point coordinates, asynchronous call

        Spatial sampling of a space-time raster dataset (STRDS) with vector points. The vector points must be provided as GeoJSON vector point format that includes correct coordinate system specification. The result of the sampling is located in the resource responseJSON document after the processing was finished, as a list of timestamped values for each vector point. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param strds_name: The name of the space-time raster dataset that should be sampled (required)
        :type strds_name: str
        :param points: GeoJSON vector input that contains the vector points for sampling (required)
        :type points: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_async_geojson_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            strds_name=strds_name,
            points=points,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "STRDSSampleGeoJSONResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_async_geojson_post_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        strds_name: Annotated[StrictStr, Field(description="The name of the space-time raster dataset that should be sampled")],
        points: Annotated[StrictStr, Field(description="GeoJSON vector input that contains the vector points for sampling")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Sample a strds by point coordinates, asynchronous call

        Spatial sampling of a space-time raster dataset (STRDS) with vector points. The vector points must be provided as GeoJSON vector point format that includes correct coordinate system specification. The result of the sampling is located in the resource responseJSON document after the processing was finished, as a list of timestamped values for each vector point. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param strds_name: The name of the space-time raster dataset that should be sampled (required)
        :type strds_name: str
        :param points: GeoJSON vector input that contains the vector points for sampling (required)
        :type points: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_async_geojson_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            strds_name=strds_name,
            points=points,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "STRDSSampleGeoJSONResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_async_geojson_post_serialize(
        self,
        location_name,
        mapset_name,
        strds_name,
        points,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        if strds_name is not None:
            _path_params['strds_name'] = strds_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if points is not None:
            _body_params = points


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/strds/{strds_name}/sampling_async_geojson',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_async_post(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        strds_name: Annotated[StrictStr, Field(description="The name of the space-time raster dataset that should be sampled")],
        points: Annotated[PointListModel, Field(description="The sampling point array [[id, x, y],[id, x, y]] and an optional where statement. The coordinates of the sampling points must be the same as of the location that contains the space-time raster dataset.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> STRDSSampleResponseModel:
        """Sample a strds by point coordinates, asynchronous call

        Spatial sampling of a space-time raster dataset with vector points. The vector points must be in the same coordinate reference system as the location that contains the space-time raster dataset. The result of the sampling is located in the resource responseJSON docuement after the processing was finished, as a list of timestamped values for each vector point. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param strds_name: The name of the space-time raster dataset that should be sampled (required)
        :type strds_name: str
        :param points: The sampling point array [[id, x, y],[id, x, y]] and an optional where statement. The coordinates of the sampling points must be the same as of the location that contains the space-time raster dataset. (required)
        :type points: PointListModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_async_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            strds_name=strds_name,
            points=points,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "STRDSSampleResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_async_post_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        strds_name: Annotated[StrictStr, Field(description="The name of the space-time raster dataset that should be sampled")],
        points: Annotated[PointListModel, Field(description="The sampling point array [[id, x, y],[id, x, y]] and an optional where statement. The coordinates of the sampling points must be the same as of the location that contains the space-time raster dataset.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[STRDSSampleResponseModel]:
        """Sample a strds by point coordinates, asynchronous call

        Spatial sampling of a space-time raster dataset with vector points. The vector points must be in the same coordinate reference system as the location that contains the space-time raster dataset. The result of the sampling is located in the resource responseJSON docuement after the processing was finished, as a list of timestamped values for each vector point. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param strds_name: The name of the space-time raster dataset that should be sampled (required)
        :type strds_name: str
        :param points: The sampling point array [[id, x, y],[id, x, y]] and an optional where statement. The coordinates of the sampling points must be the same as of the location that contains the space-time raster dataset. (required)
        :type points: PointListModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_async_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            strds_name=strds_name,
            points=points,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "STRDSSampleResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_async_post_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        strds_name: Annotated[StrictStr, Field(description="The name of the space-time raster dataset that should be sampled")],
        points: Annotated[PointListModel, Field(description="The sampling point array [[id, x, y],[id, x, y]] and an optional where statement. The coordinates of the sampling points must be the same as of the location that contains the space-time raster dataset.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Sample a strds by point coordinates, asynchronous call

        Spatial sampling of a space-time raster dataset with vector points. The vector points must be in the same coordinate reference system as the location that contains the space-time raster dataset. The result of the sampling is located in the resource responseJSON docuement after the processing was finished, as a list of timestamped values for each vector point. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param strds_name: The name of the space-time raster dataset that should be sampled (required)
        :type strds_name: str
        :param points: The sampling point array [[id, x, y],[id, x, y]] and an optional where statement. The coordinates of the sampling points must be the same as of the location that contains the space-time raster dataset. (required)
        :type points: PointListModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_async_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            strds_name=strds_name,
            points=points,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "STRDSSampleResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_async_post_serialize(
        self,
        location_name,
        mapset_name,
        strds_name,
        points,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        if strds_name is not None:
            _path_params['strds_name'] = strds_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if points is not None:
            _body_params = points


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/strds/{strds_name}/sampling_async',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_sync_geojson_post(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        strds_name: Annotated[StrictStr, Field(description="The name of the space-time raster dataset that should be sampled")],
        points: Annotated[StrictStr, Field(description="GeoJSON vector input that contains the vector points for sampling")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> STRDSSampleGeoJSONResponseModel:
        """Sample a strds by point coordinates, synchronous call

        Spatial sampling of a space-time raster dataset (STRDS) with vector points. The vector points must be provided as GeoJSON vector point format that includes correct coordinate system specification. The result of the sampling is located in the resource responseJSON document after the processing was finished, as a list of timestamped values for each vector point. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param strds_name: The name of the space-time raster dataset that should be sampled (required)
        :type strds_name: str
        :param points: GeoJSON vector input that contains the vector points for sampling (required)
        :type points: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_sync_geojson_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            strds_name=strds_name,
            points=points,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "STRDSSampleGeoJSONResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_sync_geojson_post_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        strds_name: Annotated[StrictStr, Field(description="The name of the space-time raster dataset that should be sampled")],
        points: Annotated[StrictStr, Field(description="GeoJSON vector input that contains the vector points for sampling")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[STRDSSampleGeoJSONResponseModel]:
        """Sample a strds by point coordinates, synchronous call

        Spatial sampling of a space-time raster dataset (STRDS) with vector points. The vector points must be provided as GeoJSON vector point format that includes correct coordinate system specification. The result of the sampling is located in the resource responseJSON document after the processing was finished, as a list of timestamped values for each vector point. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param strds_name: The name of the space-time raster dataset that should be sampled (required)
        :type strds_name: str
        :param points: GeoJSON vector input that contains the vector points for sampling (required)
        :type points: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_sync_geojson_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            strds_name=strds_name,
            points=points,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "STRDSSampleGeoJSONResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_sync_geojson_post_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        strds_name: Annotated[StrictStr, Field(description="The name of the space-time raster dataset that should be sampled")],
        points: Annotated[StrictStr, Field(description="GeoJSON vector input that contains the vector points for sampling")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Sample a strds by point coordinates, synchronous call

        Spatial sampling of a space-time raster dataset (STRDS) with vector points. The vector points must be provided as GeoJSON vector point format that includes correct coordinate system specification. The result of the sampling is located in the resource responseJSON document after the processing was finished, as a list of timestamped values for each vector point. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param strds_name: The name of the space-time raster dataset that should be sampled (required)
        :type strds_name: str
        :param points: GeoJSON vector input that contains the vector points for sampling (required)
        :type points: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_sync_geojson_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            strds_name=strds_name,
            points=points,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "STRDSSampleGeoJSONResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_sync_geojson_post_serialize(
        self,
        location_name,
        mapset_name,
        strds_name,
        points,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        if strds_name is not None:
            _path_params['strds_name'] = strds_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if points is not None:
            _body_params = points


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/strds/{strds_name}/sampling_sync_geojson',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_sync_post(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        strds_name: Annotated[StrictStr, Field(description="The name of the space-time raster dataset that should be sampled")],
        points: Annotated[PointListModel, Field(description="The sampling point array [[id, x, y],[id, x, y]] and an optional where statement. The coordinates of the sampling points must be the same as of the location that contains the space-time raster dataset.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> STRDSSampleResponseModel:
        """Sample a strds by point coordinates, synchronous call

        Spatial sampling of a space-time raster dataset with vector points. The vector points must be in the same coordinate reference system as the location that contains the space-time raster dataset. The result of the sampling is located in the resource responseJSON docuement after the processing was finished, as a list of timestamped values for each vector point. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param strds_name: The name of the space-time raster dataset that should be sampled (required)
        :type strds_name: str
        :param points: The sampling point array [[id, x, y],[id, x, y]] and an optional where statement. The coordinates of the sampling points must be the same as of the location that contains the space-time raster dataset. (required)
        :type points: PointListModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_sync_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            strds_name=strds_name,
            points=points,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "STRDSSampleResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_sync_post_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        strds_name: Annotated[StrictStr, Field(description="The name of the space-time raster dataset that should be sampled")],
        points: Annotated[PointListModel, Field(description="The sampling point array [[id, x, y],[id, x, y]] and an optional where statement. The coordinates of the sampling points must be the same as of the location that contains the space-time raster dataset.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[STRDSSampleResponseModel]:
        """Sample a strds by point coordinates, synchronous call

        Spatial sampling of a space-time raster dataset with vector points. The vector points must be in the same coordinate reference system as the location that contains the space-time raster dataset. The result of the sampling is located in the resource responseJSON docuement after the processing was finished, as a list of timestamped values for each vector point. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param strds_name: The name of the space-time raster dataset that should be sampled (required)
        :type strds_name: str
        :param points: The sampling point array [[id, x, y],[id, x, y]] and an optional where statement. The coordinates of the sampling points must be the same as of the location that contains the space-time raster dataset. (required)
        :type points: PointListModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_sync_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            strds_name=strds_name,
            points=points,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "STRDSSampleResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_sync_post_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        strds_name: Annotated[StrictStr, Field(description="The name of the space-time raster dataset that should be sampled")],
        points: Annotated[PointListModel, Field(description="The sampling point array [[id, x, y],[id, x, y]] and an optional where statement. The coordinates of the sampling points must be the same as of the location that contains the space-time raster dataset.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Sample a strds by point coordinates, synchronous call

        Spatial sampling of a space-time raster dataset with vector points. The vector points must be in the same coordinate reference system as the location that contains the space-time raster dataset. The result of the sampling is located in the resource responseJSON docuement after the processing was finished, as a list of timestamped values for each vector point. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param strds_name: The name of the space-time raster dataset that should be sampled (required)
        :type strds_name: str
        :param points: The sampling point array [[id, x, y],[id, x, y]] and an optional where statement. The coordinates of the sampling points must be the same as of the location that contains the space-time raster dataset. (required)
        :type points: PointListModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_sync_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            strds_name=strds_name,
            points=points,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "STRDSSampleResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_sync_post_serialize(
        self,
        location_name,
        mapset_name,
        strds_name,
        points,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        if strds_name is not None:
            _path_params['strds_name'] = strds_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if points is not None:
            _body_params = points


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/strds/{strds_name}/sampling_sync',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


