# coding: utf-8

"""
    Actinia

     ================================ Actinia - The GRASS GIS REST API ================================  **Actinia** is an open source REST API for scalable, distributed, high performance processing of geographical data that uses GRASS GIS for computational tasks.  It provides a REST API to process satellite images, time series of satellite images, arbitrary raster data with geographical relations and vector data.  The REST interface allows to access, manage and manipulate the GRASS GIS database via HTTP GET,PUT,POST and DELETE requests and to process raster, vector and time series data located in a persistent GRASS GIS database. **Actinia** allows the processing of cloud based data, for example all Landsat 4-8 scenes as well as all Sentinel2A scenes in an ephemeral databases. The computational results of ephemeral processing are available via object storage as GeoTIFF files.  The full API documentation is available here: https://redocly.github.io/redoc/?url=https://actinia.mundialis.de/latest/ swagger.json   Examples: ---------  To execute the examples, first setup login information, IP address and port:      export ACTINIA_URL=https://actinia.mundialis.de/latest     export AUTH='-u demouser:gu3st!pa55w0rd'  **Data management**  - List all locations that are available in the actinia persistent database:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations\"  - List all mapsets in the location latlong_wgs84:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets\"  - List all raster layers in location latlong_wgs84 and mapset Sentinel2A      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets/Sentinel2A/raster_layers\"  - List all space-time raster datasets (STRDS) in location ECAD and mapset   PERMANENT:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/raster_layers\"  - List all raster map layers of the STRDS precipitation_1950_2013_yearly_mm:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/strds/precipitation_    1950_2013_yearly_mm/raster_layers\"  **Landsat and Sentinel2A NDVI computation**  This API call will compute the NDVI of the top of atmosphere (TOAR) corrected Landsat4 scene LC80440342016259LGN00:      curl ${AUTH} -X POST \"${ACTINIA_URL}/landsat_process/    LC80440342016259LGN00/TOAR/NDVI\"  NDVI computation of Sentinel2A scene S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138:      curl ${AUTH} -X POST \"${ACTINIA_URL}/sentinel2_process/ndvi/    S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138\"  The results of the asynchronous computations are available as GeoTIFF file in a cloud storage for download. 

    The version of the OpenAPI document: v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional, Union
from pydantic import BaseModel, StrictFloat, StrictInt, StrictStr
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class AreaUnivarResultModel(BaseModel):
    """
    Response schema for the result of univariate computations of raster layers
    """ # noqa: E501
    fid: Optional[StrictStr] = Field(default=None, description="Field id from the polygon of the vector map layer used for area stats computation")
    cat: Optional[StrictStr] = Field(default=None, description="The category id from the polygon of the vector map layer used for area stats computation")
    raster_number: Optional[Union[StrictFloat, StrictInt]] = None
    raster_minimum: Optional[Union[StrictFloat, StrictInt]] = None
    raster_maximum: Optional[Union[StrictFloat, StrictInt]] = None
    raster_range: Optional[Union[StrictFloat, StrictInt]] = None
    raster_average: Optional[Union[StrictFloat, StrictInt]] = None
    raster_median: Optional[Union[StrictFloat, StrictInt]] = None
    raster_stddev: Optional[Union[StrictFloat, StrictInt]] = None
    raster_sum: Optional[Union[StrictFloat, StrictInt]] = None
    raster_variance: Optional[Union[StrictFloat, StrictInt]] = None
    raster_coeff_var: Optional[Union[StrictFloat, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["fid", "cat", "raster_number", "raster_minimum", "raster_maximum", "raster_range", "raster_average", "raster_median", "raster_stddev", "raster_sum", "raster_variance", "raster_coeff_var"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of AreaUnivarResultModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of AreaUnivarResultModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fid": obj.get("fid"),
            "cat": obj.get("cat"),
            "raster_number": obj.get("raster_number"),
            "raster_minimum": obj.get("raster_minimum"),
            "raster_maximum": obj.get("raster_maximum"),
            "raster_range": obj.get("raster_range"),
            "raster_average": obj.get("raster_average"),
            "raster_median": obj.get("raster_median"),
            "raster_stddev": obj.get("raster_stddev"),
            "raster_sum": obj.get("raster_sum"),
            "raster_variance": obj.get("raster_variance"),
            "raster_coeff_var": obj.get("raster_coeff_var")
        })
        return _obj


