# coding: utf-8

"""
    Actinia

     ================================ Actinia - The GRASS GIS REST API ================================  **Actinia** is an open source REST API for scalable, distributed, high performance processing of geographical data that uses GRASS GIS for computational tasks.  It provides a REST API to process satellite images, time series of satellite images, arbitrary raster data with geographical relations and vector data.  The REST interface allows to access, manage and manipulate the GRASS GIS database via HTTP GET,PUT,POST and DELETE requests and to process raster, vector and time series data located in a persistent GRASS GIS database. **Actinia** allows the processing of cloud based data, for example all Landsat 4-8 scenes as well as all Sentinel2A scenes in an ephemeral databases. The computational results of ephemeral processing are available via object storage as GeoTIFF files.  The full API documentation is available here: https://redocly.github.io/redoc/?url=https://actinia.mundialis.de/latest/ swagger.json   Examples: ---------  To execute the examples, first setup login information, IP address and port:      export ACTINIA_URL=https://actinia.mundialis.de/latest     export AUTH='-u demouser:gu3st!pa55w0rd'  **Data management**  - List all locations that are available in the actinia persistent database:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations\"  - List all mapsets in the location latlong_wgs84:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets\"  - List all raster layers in location latlong_wgs84 and mapset Sentinel2A      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets/Sentinel2A/raster_layers\"  - List all space-time raster datasets (STRDS) in location ECAD and mapset   PERMANENT:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/raster_layers\"  - List all raster map layers of the STRDS precipitation_1950_2013_yearly_mm:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/strds/precipitation_    1950_2013_yearly_mm/raster_layers\"  **Landsat and Sentinel2A NDVI computation**  This API call will compute the NDVI of the top of atmosphere (TOAR) corrected Landsat4 scene LC80440342016259LGN00:      curl ${AUTH} -X POST \"${ACTINIA_URL}/landsat_process/    LC80440342016259LGN00/TOAR/NDVI\"  NDVI computation of Sentinel2A scene S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138:      curl ${AUTH} -X POST \"${ACTINIA_URL}/sentinel2_process/ndvi/    S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138\"  The results of the asynchronous computations are available as GeoTIFF file in a cloud storage for download. 

    The version of the OpenAPI document: v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest
import datetime

from actinia_openapi_python_client.models.module_list import ModuleList

class TestModuleList(unittest.TestCase):
    """ModuleList unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> ModuleList:
        """Test ModuleList
            include_option is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # uncomment below to create an instance of `ModuleList`
        """
        model = ModuleList()
        if include_optional:
            return ModuleList(
                status = '',
                processes = [
                    {categories=[grass-module, level1, pointpattern, random, sampling, statistics, stratifiedrandomsampling, vector], description=Generates random 2D/3D vector points., id=v.random, parameters={a={description=. Generate n points for each individual area (requires restrict parameter), schema={default=False, type=boolean}}, b={description=Do not build topology. Advantageous when handling a large number of points, schema={default=False, type=boolean}}, cats={description=Category values. Example: 1,3,7-9,13, required=false, schema={subtype=cats, type=string}}, column={description=Name of column for z values. Writes z values to column, required=false, schema={subtype=dbcolumn, type=string}}, column_type={description=. Type of column for z values, required=false, schema={default=double precision, enum=[integer, double precision], type=string}}, help={description=. Print usage summary, schema={default=False, type=boolean}}, layer={description=Layer number or name ('-1' for all layers). A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name., required=false, schema={default=-1, subtype=layer_all, type=string}}, npoints={description=. Number of points to be created, required=true, schema={type=integer}}, output={description=. Name for output vector map, required=true, schema={subtype=vector, type=string}}, overwrite={description=. Allow output files to overwrite existing files, schema={default=False, type=boolean}}, quiet={description=. Quiet module output, schema={default=False, type=boolean}}, restrict={description=Name of input vector map. Restrict points to areas in input vector, required=false, schema={subtype=vector, type=string}}, seed={description=. The seed to initialize the random generator. If not set the process ID is used, required=false, schema={type=integer}}, verbose={description=. Verbose module output, schema={default=False, type=boolean}}, where={description=WHERE conditions of SQL statement without 'where' keyword. Example: income < 1000 and population >= 10000, required=false, schema={subtype=sql_query, type=string}}, z={description=. Create 3D output, schema={default=False, type=boolean}}, zmax={description=. Maximum z height (needs -z flag or column name), required=false, schema={default=0.0, type=number}}, zmin={description=. Minimum z height (needs -z flag or column name), required=false, schema={default=0.0, type=number}}}}
                    ]
            )
        else:
            return ModuleList(
                status = '',
                processes = [
                    {categories=[grass-module, level1, pointpattern, random, sampling, statistics, stratifiedrandomsampling, vector], description=Generates random 2D/3D vector points., id=v.random, parameters={a={description=. Generate n points for each individual area (requires restrict parameter), schema={default=False, type=boolean}}, b={description=Do not build topology. Advantageous when handling a large number of points, schema={default=False, type=boolean}}, cats={description=Category values. Example: 1,3,7-9,13, required=false, schema={subtype=cats, type=string}}, column={description=Name of column for z values. Writes z values to column, required=false, schema={subtype=dbcolumn, type=string}}, column_type={description=. Type of column for z values, required=false, schema={default=double precision, enum=[integer, double precision], type=string}}, help={description=. Print usage summary, schema={default=False, type=boolean}}, layer={description=Layer number or name ('-1' for all layers). A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name., required=false, schema={default=-1, subtype=layer_all, type=string}}, npoints={description=. Number of points to be created, required=true, schema={type=integer}}, output={description=. Name for output vector map, required=true, schema={subtype=vector, type=string}}, overwrite={description=. Allow output files to overwrite existing files, schema={default=False, type=boolean}}, quiet={description=. Quiet module output, schema={default=False, type=boolean}}, restrict={description=Name of input vector map. Restrict points to areas in input vector, required=false, schema={subtype=vector, type=string}}, seed={description=. The seed to initialize the random generator. If not set the process ID is used, required=false, schema={type=integer}}, verbose={description=. Verbose module output, schema={default=False, type=boolean}}, where={description=WHERE conditions of SQL statement without 'where' keyword. Example: income < 1000 and population >= 10000, required=false, schema={subtype=sql_query, type=string}}, z={description=. Create 3D output, schema={default=False, type=boolean}}, zmax={description=. Maximum z height (needs -z flag or column name), required=false, schema={default=0.0, type=number}}, zmin={description=. Minimum z height (needs -z flag or column name), required=false, schema={default=0.0, type=number}}}}
                    ],
        )
        """

    def testModuleList(self):
        """Test ModuleList"""
        # inst_req_only = self.make_instance(include_optional=False)
        # inst_req_and_optional = self.make_instance(include_optional=True)

if __name__ == '__main__':
    unittest.main()
