# coding: utf-8

"""
    Actinia

     ================================ Actinia - The GRASS GIS REST API ================================  **Actinia** is an open source REST API for scalable, distributed, high performance processing of geographical data that uses GRASS GIS for computational tasks.  It provides a REST API to process satellite images, time series of satellite images, arbitrary raster data with geographical relations and vector data.  The REST interface allows to access, manage and manipulate the GRASS GIS database via HTTP GET,PUT,POST and DELETE requests and to process raster, vector and time series data located in a persistent GRASS GIS database. **Actinia** allows the processing of cloud based data, for example all Landsat 4-8 scenes as well as all Sentinel2A scenes in an ephemeral databases. The computational results of ephemeral processing are available via object storage as GeoTIFF files.  The full API documentation is available here: https://redocly.github.io/redoc/?url=https://actinia.mundialis.de/latest/ swagger.json   Examples: ---------  To execute the examples, first setup login information, IP address and port:      export ACTINIA_URL=https://actinia.mundialis.de/latest     export AUTH='-u demouser:gu3st!pa55w0rd'  **Data management**  - List all locations that are available in the actinia persistent database:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations\"  - List all mapsets in the location latlong_wgs84:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets\"  - List all raster layers in location latlong_wgs84 and mapset Sentinel2A      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets/Sentinel2A/raster_layers\"  - List all space-time raster datasets (STRDS) in location ECAD and mapset   PERMANENT:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/raster_layers\"  - List all raster map layers of the STRDS precipitation_1950_2013_yearly_mm:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/strds/precipitation_    1950_2013_yearly_mm/raster_layers\"  **Landsat and Sentinel2A NDVI computation**  This API call will compute the NDVI of the top of atmosphere (TOAR) corrected Landsat4 scene LC80440342016259LGN00:      curl ${AUTH} -X POST \"${ACTINIA_URL}/landsat_process/    LC80440342016259LGN00/TOAR/NDVI\"  NDVI computation of Sentinel2A scene S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138:      curl ${AUTH} -X POST \"${ACTINIA_URL}/sentinel2_process/ndvi/    S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138\"  The results of the asynchronous computations are available as GeoTIFF file in a cloud storage for download. 

    The version of the OpenAPI document: v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from actinia_openapi_python_client.api.resource_management_api import ResourceManagementApi


class TestResourceManagementApi(unittest.TestCase):
    """ResourceManagementApi unit test stubs"""

    def setUp(self) -> None:
        self.api = ResourceManagementApi()

    def tearDown(self) -> None:
        pass

    def test_resource_storage_delete(self) -> None:
        """Test case for resource_storage_delete

        Clean the resource storage and remove all cached data
        """
        pass

    def test_resource_storage_get(self) -> None:
        """Test case for resource_storage_get

        Get the current size of the resource storage
        """
        pass

    def test_resources_user_id_delete(self) -> None:
        """Test case for resources_user_id_delete

        Terminate all accepted and running resources of the specified user.
        """
        pass

    def test_resources_user_id_get(self) -> None:
        """Test case for resources_user_id_get

        Get a list of resources that have been generated by the specified user.
        """
        pass

    def test_resources_user_id_resource_id_delete(self) -> None:
        """Test case for resources_user_id_resource_id_delete

        Request the termination of a resource.
        """
        pass

    def test_resources_user_id_resource_id_get(self) -> None:
        """Test case for resources_user_id_resource_id_get

        Get the status of a resource.
        """
        pass

    def test_resources_user_id_resource_id_put(self) -> None:
        """Test case for resources_user_id_resource_id_put

        Updates/Resumes the status of a resource.
        """
        pass


if __name__ == '__main__':
    unittest.main()
