# coding: utf-8

"""
    Actinia

     ================================ Actinia - The GRASS GIS REST API ================================  **Actinia** is an open source REST API for scalable, distributed, high performance processing of geographical data that uses GRASS GIS for computational tasks.  It provides a REST API to process satellite images, time series of satellite images, arbitrary raster data with geographical relations and vector data.  The REST interface allows to access, manage and manipulate the GRASS GIS database via HTTP GET,PUT,POST and DELETE requests and to process raster, vector and time series data located in a persistent GRASS GIS database. **Actinia** allows the processing of cloud based data, for example all Landsat 4-8 scenes as well as all Sentinel2A scenes in an ephemeral databases. The computational results of ephemeral processing are available via object storage as GeoTIFF files.  The full API documentation is available here: https://redocly.github.io/redoc/?url=https://actinia.mundialis.de/latest/ swagger.json   Examples: ---------  To execute the examples, first setup login information, IP address and port:      export ACTINIA_URL=https://actinia.mundialis.de/latest     export AUTH='-u demouser:gu3st!pa55w0rd'  **Data management**  - List all locations that are available in the actinia persistent database:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations\"  - List all mapsets in the location latlong_wgs84:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets\"  - List all raster layers in location latlong_wgs84 and mapset Sentinel2A      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets/Sentinel2A/raster_layers\"  - List all space-time raster datasets (STRDS) in location ECAD and mapset   PERMANENT:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/raster_layers\"  - List all raster map layers of the STRDS precipitation_1950_2013_yearly_mm:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/strds/precipitation_    1950_2013_yearly_mm/raster_layers\"  **Landsat and Sentinel2A NDVI computation**  This API call will compute the NDVI of the top of atmosphere (TOAR) corrected Landsat4 scene LC80440342016259LGN00:      curl ${AUTH} -X POST \"${ACTINIA_URL}/landsat_process/    LC80440342016259LGN00/TOAR/NDVI\"  NDVI computation of Sentinel2A scene S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138:      curl ${AUTH} -X POST \"${ACTINIA_URL}/sentinel2_process/ndvi/    S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138\"  The results of the asynchronous computations are available as GeoTIFF file in a cloud storage for download. 

    The version of the OpenAPI document: v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from actinia_openapi_python_client.api.satellite_image_algorithms_api import SatelliteImageAlgorithmsApi


class TestSatelliteImageAlgorithmsApi(unittest.TestCase):
    """SatelliteImageAlgorithmsApi unit test stubs"""

    def setUp(self) -> None:
        self.api = SatelliteImageAlgorithmsApi()

    def tearDown(self) -> None:
        pass

    def test_landsat_process_landsat_id_atcor_method_processing_method_post(self) -> None:
        """Test case for landsat_process_landsat_id_atcor_method_processing_method_post

        Vegetation index computation from an atmospherically corrected Landsat scene.
        """
        pass

    def test_landsat_query_get(self) -> None:
        """Test case for landsat_query_get

        Query the Google Landsat archives using time interval, lat/lon coordinates, scene id, spacecraft id and cloud cover.
        """
        pass

    def test_locations_location_name_mapsets_mapset_name_landsat_import_post(self) -> None:
        """Test case for locations_location_name_mapsets_mapset_name_landsat_import_post

        Download and import Landsat scenes into a new mapset and create a space time dataset for each imported band.
        """
        pass

    def test_locations_location_name_mapsets_mapset_name_sentinel2_import_post(self) -> None:
        """Test case for locations_location_name_mapsets_mapset_name_sentinel2_import_post

        Download and import Sentinel2A scenes into a new mapset and create a space-time raster dataset for each imported band.
        """
        pass

    def test_sentinel2_process_gcs_ndvi_product_id_post(self) -> None:
        """Test case for sentinel2_process_gcs_ndvi_product_id_post

        NDVI computation of an arbitrary Sentinel-2 scene. The results are stored in the Google Cloud Storage.
        """
        pass

    def test_sentinel2_process_ndvi_product_id_post(self) -> None:
        """Test case for sentinel2_process_ndvi_product_id_post

        NDVI computation of an arbitrary Sentinel-2 scene.
        """
        pass

    def test_sentinel2_query_get(self) -> None:
        """Test case for sentinel2_query_get

        Query the Google Sentinel2 archives using time interval, lat/lon coordinates, scene id and cloud cover.
        """
        pass

    def test_sentinel2a_aws_query_post(self) -> None:
        """Test case for sentinel2a_aws_query_post

        Generate the download urls for a list of sentinel2A scenes and band numbers.
        """
        pass


if __name__ == '__main__':
    unittest.main()
