# coding: utf-8

"""
    Actinia

     ================================ Actinia - The GRASS GIS REST API ================================  **Actinia** is an open source REST API for scalable, distributed, high performance processing of geographical data that uses GRASS GIS for computational tasks.  It provides a REST API to process satellite images, time series of satellite images, arbitrary raster data with geographical relations and vector data.  The REST interface allows to access, manage and manipulate the GRASS GIS database via HTTP GET,PUT,POST and DELETE requests and to process raster, vector and time series data located in a persistent GRASS GIS database. **Actinia** allows the processing of cloud based data, for example all Landsat 4-8 scenes as well as all Sentinel2A scenes in an ephemeral databases. The computational results of ephemeral processing are available via object storage as GeoTIFF files.  The full API documentation is available here: https://redocly.github.io/redoc/?url=https://actinia.mundialis.de/latest/ swagger.json   Examples: ---------  To execute the examples, first setup login information, IP address and port:      export ACTINIA_URL=https://actinia.mundialis.de/latest     export AUTH='-u demouser:gu3st!pa55w0rd'  **Data management**  - List all locations that are available in the actinia persistent database:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations\"  - List all mapsets in the location latlong_wgs84:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets\"  - List all raster layers in location latlong_wgs84 and mapset Sentinel2A      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets/Sentinel2A/raster_layers\"  - List all space-time raster datasets (STRDS) in location ECAD and mapset   PERMANENT:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/raster_layers\"  - List all raster map layers of the STRDS precipitation_1950_2013_yearly_mm:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/strds/precipitation_    1950_2013_yearly_mm/raster_layers\"  **Landsat and Sentinel2A NDVI computation**  This API call will compute the NDVI of the top of atmosphere (TOAR) corrected Landsat4 scene LC80440342016259LGN00:      curl ${AUTH} -X POST \"${ACTINIA_URL}/landsat_process/    LC80440342016259LGN00/TOAR/NDVI\"  NDVI computation of Sentinel2A scene S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138:      curl ${AUTH} -X POST \"${ACTINIA_URL}/sentinel2_process/ndvi/    S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138\"  The results of the asynchronous computations are available as GeoTIFF file in a cloud storage for download. 

    The version of the OpenAPI document: v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest
import datetime

from actinia_openapi_python_client.models.sentinel2_a_tile_entry import Sentinel2ATileEntry

class TestSentinel2ATileEntry(unittest.TestCase):
    """Sentinel2ATileEntry unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> Sentinel2ATileEntry:
        """Test Sentinel2ATileEntry
            include_option is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # uncomment below to create an instance of `Sentinel2ATileEntry`
        """
        model = Sentinel2ATileEntry()
        if include_optional:
            return Sentinel2ATileEntry(
                b01 = {file_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04.jp2, map_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04, public_url=http://sentinel-s2-l1c.s3.amazonaws.com/tiles/36/T/VT/2017/2/2/0/B04.jp2},
                b02 = {file_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04.jp2, map_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04, public_url=http://sentinel-s2-l1c.s3.amazonaws.com/tiles/36/T/VT/2017/2/2/0/B04.jp2},
                b03 = {file_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04.jp2, map_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04, public_url=http://sentinel-s2-l1c.s3.amazonaws.com/tiles/36/T/VT/2017/2/2/0/B04.jp2},
                b04 = {file_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04.jp2, map_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04, public_url=http://sentinel-s2-l1c.s3.amazonaws.com/tiles/36/T/VT/2017/2/2/0/B04.jp2},
                b05 = {file_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04.jp2, map_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04, public_url=http://sentinel-s2-l1c.s3.amazonaws.com/tiles/36/T/VT/2017/2/2/0/B04.jp2},
                b06 = {file_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04.jp2, map_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04, public_url=http://sentinel-s2-l1c.s3.amazonaws.com/tiles/36/T/VT/2017/2/2/0/B04.jp2},
                b07 = {file_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04.jp2, map_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04, public_url=http://sentinel-s2-l1c.s3.amazonaws.com/tiles/36/T/VT/2017/2/2/0/B04.jp2},
                b08 = {file_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04.jp2, map_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04, public_url=http://sentinel-s2-l1c.s3.amazonaws.com/tiles/36/T/VT/2017/2/2/0/B04.jp2},
                b09 = {file_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04.jp2, map_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04, public_url=http://sentinel-s2-l1c.s3.amazonaws.com/tiles/36/T/VT/2017/2/2/0/B04.jp2},
                b10 = {file_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04.jp2, map_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04, public_url=http://sentinel-s2-l1c.s3.amazonaws.com/tiles/36/T/VT/2017/2/2/0/B04.jp2},
                b11 = {file_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04.jp2, map_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04, public_url=http://sentinel-s2-l1c.s3.amazonaws.com/tiles/36/T/VT/2017/2/2/0/B04.jp2},
                b12 = {file_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04.jp2, map_name=S2A_MSIL1C_20170202T090201_N0204_R007_T36TVT_20170202T090155_tile_1_band_B04, public_url=http://sentinel-s2-l1c.s3.amazonaws.com/tiles/36/T/VT/2017/2/2/0/B04.jp2},
                info = '',
                metadata = '',
                preview = '',
                url = '',
                timestamp = ''
            )
        else:
            return Sentinel2ATileEntry(
                info = '',
                metadata = '',
                preview = '',
                url = '',
                timestamp = '',
        )
        """

    def testSentinel2ATileEntry(self):
        """Test Sentinel2ATileEntry"""
        # inst_req_only = self.make_instance(include_optional=False)
        # inst_req_and_optional = self.make_instance(include_optional=True)

if __name__ == '__main__':
    unittest.main()
