# coding: utf-8

"""
    Actinia

     ================================ Actinia - The GRASS GIS REST API ================================  **Actinia** is an open source REST API for scalable, distributed, high performance processing of geographical data that uses GRASS GIS for computational tasks.  It provides a REST API to process satellite images, time series of satellite images, arbitrary raster data with geographical relations and vector data.  The REST interface allows to access, manage and manipulate the GRASS GIS database via HTTP GET,PUT,POST and DELETE requests and to process raster, vector and time series data located in a persistent GRASS GIS database. **Actinia** allows the processing of cloud based data, for example all Landsat 4-8 scenes as well as all Sentinel2A scenes in an ephemeral databases. The computational results of ephemeral processing are available via object storage as GeoTIFF files.  The full API documentation is available here: https://redocly.github.io/redoc/?url=https://actinia.mundialis.de/latest/ swagger.json   Examples: ---------  To execute the examples, first setup login information, IP address and port:      export ACTINIA_URL=https://actinia.mundialis.de/latest     export AUTH='-u demouser:gu3st!pa55w0rd'  **Data management**  - List all locations that are available in the actinia persistent database:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations\"  - List all mapsets in the location latlong_wgs84:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets\"  - List all raster layers in location latlong_wgs84 and mapset Sentinel2A      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets/Sentinel2A/raster_layers\"  - List all space-time raster datasets (STRDS) in location ECAD and mapset   PERMANENT:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/raster_layers\"  - List all raster map layers of the STRDS precipitation_1950_2013_yearly_mm:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/strds/precipitation_    1950_2013_yearly_mm/raster_layers\"  **Landsat and Sentinel2A NDVI computation**  This API call will compute the NDVI of the top of atmosphere (TOAR) corrected Landsat4 scene LC80440342016259LGN00:      curl ${AUTH} -X POST \"${ACTINIA_URL}/landsat_process/    LC80440342016259LGN00/TOAR/NDVI\"  NDVI computation of Sentinel2A scene S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138:      curl ${AUTH} -X POST \"${ACTINIA_URL}/sentinel2_process/ndvi/    S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138\"  The results of the asynchronous computations are available as GeoTIFF file in a cloud storage for download. 

    The version of the OpenAPI document: v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import io
import warnings

from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Dict, List, Optional, Tuple, Union, Any

try:
    from typing import Annotated
except ImportError:
    from typing_extensions import Annotated

from pydantic import Field
from typing_extensions import Annotated
from pydantic import StrictStr

from actinia_openapi_python_client.models.process_chain_model import ProcessChainModel
from actinia_openapi_python_client.models.processing_response_model import ProcessingResponseModel

from actinia_openapi_python_client.api_client import ApiClient
from actinia_openapi_python_client.api_response import ApiResponse
from actinia_openapi_python_client.rest import RESTResponseType


class ProcessingApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def locations_location_name_mapsets_mapset_name_processing_async_post(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of an existing mapset or a new mapset that should be created")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be executed")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ProcessingResponseModel:
        """Execute a user defined process chain that creates a new mapset or

        Execute a user defined process chain in an existing mapset of the persistent user database or in a new mapset that will be created by this request in the persistent user database.  The process chain is executed asynchronously. The provided status URL in the response must be polled to gain information about the processing progress and finishing status.  **Note**      Space-time dataset processing can only be performed in a new mapset     that is created by this resource call, since merging of temporal databases     of different mapsets is not supported yet.  The mapset that is used for processing will be locked until the process chain execution finished (successfully or not), even if the mapset is be created by the request. Other requests on the locked mapset will abort with a mapset lock error.  The persistent user database will not be modified if the process chain does not run successfully. The processing is performed in an ephemeral database and then merged or copied into the persistent user database.  **Note**      Make sure that the process chain definition identifies all raster, vector     or space time datasets correctly with name and mapset: name@mapset.      All required mapsets will be identified by analysing the input parameter     of all module descriptions in the provided process chain     and mounted into the ephemeral database that is used for processing.  

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of an existing mapset or a new mapset that should be created (required)
        :type mapset_name: str
        :param process_chain: The process chain that should be executed (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_processing_async_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_processing_async_post_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of an existing mapset or a new mapset that should be created")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be executed")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ProcessingResponseModel]:
        """Execute a user defined process chain that creates a new mapset or

        Execute a user defined process chain in an existing mapset of the persistent user database or in a new mapset that will be created by this request in the persistent user database.  The process chain is executed asynchronously. The provided status URL in the response must be polled to gain information about the processing progress and finishing status.  **Note**      Space-time dataset processing can only be performed in a new mapset     that is created by this resource call, since merging of temporal databases     of different mapsets is not supported yet.  The mapset that is used for processing will be locked until the process chain execution finished (successfully or not), even if the mapset is be created by the request. Other requests on the locked mapset will abort with a mapset lock error.  The persistent user database will not be modified if the process chain does not run successfully. The processing is performed in an ephemeral database and then merged or copied into the persistent user database.  **Note**      Make sure that the process chain definition identifies all raster, vector     or space time datasets correctly with name and mapset: name@mapset.      All required mapsets will be identified by analysing the input parameter     of all module descriptions in the provided process chain     and mounted into the ephemeral database that is used for processing.  

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of an existing mapset or a new mapset that should be created (required)
        :type mapset_name: str
        :param process_chain: The process chain that should be executed (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_processing_async_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_processing_async_post_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of an existing mapset or a new mapset that should be created")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be executed")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Execute a user defined process chain that creates a new mapset or

        Execute a user defined process chain in an existing mapset of the persistent user database or in a new mapset that will be created by this request in the persistent user database.  The process chain is executed asynchronously. The provided status URL in the response must be polled to gain information about the processing progress and finishing status.  **Note**      Space-time dataset processing can only be performed in a new mapset     that is created by this resource call, since merging of temporal databases     of different mapsets is not supported yet.  The mapset that is used for processing will be locked until the process chain execution finished (successfully or not), even if the mapset is be created by the request. Other requests on the locked mapset will abort with a mapset lock error.  The persistent user database will not be modified if the process chain does not run successfully. The processing is performed in an ephemeral database and then merged or copied into the persistent user database.  **Note**      Make sure that the process chain definition identifies all raster, vector     or space time datasets correctly with name and mapset: name@mapset.      All required mapsets will be identified by analysing the input parameter     of all module descriptions in the provided process chain     and mounted into the ephemeral database that is used for processing.  

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of an existing mapset or a new mapset that should be created (required)
        :type mapset_name: str
        :param process_chain: The process chain that should be executed (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_processing_async_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_processing_async_post_serialize(
        self,
        location_name,
        mapset_name,
        process_chain,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if process_chain is not None:
            _body_params = process_chain


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/processing_async',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_mapsets_mapset_name_processing_post(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of an existing mapset or a new mapset that should be created")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be executed")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ProcessingResponseModel:
        """Execute a user defined process chain that creates a new mapset or

        Execute a user defined process chain in an existing mapset of the persistent user database or in a new mapset that will be created by this request in the persistent user database.  The process chain is executed asynchronously. The provided status URL in the response must be polled to gain information about the processing progress and finishing status.  **Note**      Space-time dataset processing can only be performed in a new mapset     that is created by this resource call, since merging of temporal databases     of different mapsets is not supported yet.  The mapset that is used for processing will be locked until the process chain execution finished (successfully or not), even if the mapset is be created by the request. Other requests on the locked mapset will abort with a mapset lock error.  The persistent user database will not be modified if the process chain does not run successfully. The processing is performed in an ephemeral database and then merged or copied into the persistent user database.  **Note**      Make sure that the process chain definition identifies all raster, vector     or space time datasets correctly with name and mapset: name@mapset.      All required mapsets will be identified by analysing the input parameter     of all module descriptions in the provided process chain     and mounted into the ephemeral database that is used for processing.  

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of an existing mapset or a new mapset that should be created (required)
        :type mapset_name: str
        :param process_chain: The process chain that should be executed (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_processing_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_processing_post_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of an existing mapset or a new mapset that should be created")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be executed")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ProcessingResponseModel]:
        """Execute a user defined process chain that creates a new mapset or

        Execute a user defined process chain in an existing mapset of the persistent user database or in a new mapset that will be created by this request in the persistent user database.  The process chain is executed asynchronously. The provided status URL in the response must be polled to gain information about the processing progress and finishing status.  **Note**      Space-time dataset processing can only be performed in a new mapset     that is created by this resource call, since merging of temporal databases     of different mapsets is not supported yet.  The mapset that is used for processing will be locked until the process chain execution finished (successfully or not), even if the mapset is be created by the request. Other requests on the locked mapset will abort with a mapset lock error.  The persistent user database will not be modified if the process chain does not run successfully. The processing is performed in an ephemeral database and then merged or copied into the persistent user database.  **Note**      Make sure that the process chain definition identifies all raster, vector     or space time datasets correctly with name and mapset: name@mapset.      All required mapsets will be identified by analysing the input parameter     of all module descriptions in the provided process chain     and mounted into the ephemeral database that is used for processing.  

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of an existing mapset or a new mapset that should be created (required)
        :type mapset_name: str
        :param process_chain: The process chain that should be executed (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_processing_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_processing_post_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of an existing mapset or a new mapset that should be created")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be executed")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Execute a user defined process chain that creates a new mapset or

        Execute a user defined process chain in an existing mapset of the persistent user database or in a new mapset that will be created by this request in the persistent user database.  The process chain is executed asynchronously. The provided status URL in the response must be polled to gain information about the processing progress and finishing status.  **Note**      Space-time dataset processing can only be performed in a new mapset     that is created by this resource call, since merging of temporal databases     of different mapsets is not supported yet.  The mapset that is used for processing will be locked until the process chain execution finished (successfully or not), even if the mapset is be created by the request. Other requests on the locked mapset will abort with a mapset lock error.  The persistent user database will not be modified if the process chain does not run successfully. The processing is performed in an ephemeral database and then merged or copied into the persistent user database.  **Note**      Make sure that the process chain definition identifies all raster, vector     or space time datasets correctly with name and mapset: name@mapset.      All required mapsets will be identified by analysing the input parameter     of all module descriptions in the provided process chain     and mounted into the ephemeral database that is used for processing.  

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of an existing mapset or a new mapset that should be created (required)
        :type mapset_name: str
        :param process_chain: The process chain that should be executed (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_processing_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_processing_post_serialize(
        self,
        location_name,
        mapset_name,
        process_chain,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if process_chain is not None:
            _body_params = process_chain


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/processing',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_process_chain_validation_async_post(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name that contains the data that should be used in the process chain")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be validated")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ProcessingResponseModel:
        """Validate a process chain asynchronously, check the provided sources

        Validate a process chain, check the provided sources (links) and the mapsets. The list of processes that were checked by Actinia are returned in the JSON response. 

        :param location_name: The location name that contains the data that should be used in the process chain (required)
        :type location_name: str
        :param process_chain: The process chain that should be validated (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_process_chain_validation_async_post_serialize(
            location_name=location_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_process_chain_validation_async_post_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name that contains the data that should be used in the process chain")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be validated")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ProcessingResponseModel]:
        """Validate a process chain asynchronously, check the provided sources

        Validate a process chain, check the provided sources (links) and the mapsets. The list of processes that were checked by Actinia are returned in the JSON response. 

        :param location_name: The location name that contains the data that should be used in the process chain (required)
        :type location_name: str
        :param process_chain: The process chain that should be validated (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_process_chain_validation_async_post_serialize(
            location_name=location_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_process_chain_validation_async_post_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name that contains the data that should be used in the process chain")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be validated")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Validate a process chain asynchronously, check the provided sources

        Validate a process chain, check the provided sources (links) and the mapsets. The list of processes that were checked by Actinia are returned in the JSON response. 

        :param location_name: The location name that contains the data that should be used in the process chain (required)
        :type location_name: str
        :param process_chain: The process chain that should be validated (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_process_chain_validation_async_post_serialize(
            location_name=location_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_process_chain_validation_async_post_serialize(
        self,
        location_name,
        process_chain,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if process_chain is not None:
            _body_params = process_chain


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/locations/{location_name}/process_chain_validation_async',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_process_chain_validation_sync_post(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name that contains the data that should be used in the process chain")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be validated")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ProcessingResponseModel:
        """Validate a process chain synchronously, check the provided sources

        Validate a process chain, check the provided sources (links) and the mapsets. The list of processes that were checked by Actinia are returned in the JSON response. 

        :param location_name: The location name that contains the data that should be used in the process chain (required)
        :type location_name: str
        :param process_chain: The process chain that should be validated (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_process_chain_validation_sync_post_serialize(
            location_name=location_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_process_chain_validation_sync_post_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name that contains the data that should be used in the process chain")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be validated")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ProcessingResponseModel]:
        """Validate a process chain synchronously, check the provided sources

        Validate a process chain, check the provided sources (links) and the mapsets. The list of processes that were checked by Actinia are returned in the JSON response. 

        :param location_name: The location name that contains the data that should be used in the process chain (required)
        :type location_name: str
        :param process_chain: The process chain that should be validated (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_process_chain_validation_sync_post_serialize(
            location_name=location_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_process_chain_validation_sync_post_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name that contains the data that should be used in the process chain")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be validated")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Validate a process chain synchronously, check the provided sources

        Validate a process chain, check the provided sources (links) and the mapsets. The list of processes that were checked by Actinia are returned in the JSON response. 

        :param location_name: The location name that contains the data that should be used in the process chain (required)
        :type location_name: str
        :param process_chain: The process chain that should be validated (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_process_chain_validation_sync_post_serialize(
            location_name=location_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_process_chain_validation_sync_post_serialize(
        self,
        location_name,
        process_chain,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if process_chain is not None:
            _body_params = process_chain


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/locations/{location_name}/process_chain_validation_sync',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_processing_async_export_gcs_post(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name that contains the data that should be processed")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be executed")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ProcessingResponseModel:
        """Execute a user defined process chain in an ephemeral location/mapset

        Execute a user defined process chain in an ephemeral database and provide the generated resources as downloadable files via URL's. Minimum required user role: user.  The process chain is executed asynchronously. The provided status URL in the response must be polled to gain information about the processing progress and finishing status.  **Note**      Make sure that the process chain definition identifies all raster, vector     or space-time datasets correctly with name and mapset: name@mapset if you     use data from other mapsets in the specified location.      All required mapsets will be identified by analysing the input parameter     of all module descriptions in the provided process chain and     mounted read-only into the ephemeral database that is used for processing.  The persistent database will not be modified. The ephemeral database will be removed after processing. Use the URL's provided in the finished response to download the resource that were specified in the process chain for export.  This endpoint also allows the creation of STAC ITEMS through the ACTINIA STAC PLUGIN. The STAC item is stored in a dedicated CATALOG following the standard from STAC specification (https://stacspec.org/). 

        :param location_name: The location name that contains the data that should be processed (required)
        :type location_name: str
        :param process_chain: The process chain that should be executed (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_processing_async_export_gcs_post_serialize(
            location_name=location_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_processing_async_export_gcs_post_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name that contains the data that should be processed")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be executed")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ProcessingResponseModel]:
        """Execute a user defined process chain in an ephemeral location/mapset

        Execute a user defined process chain in an ephemeral database and provide the generated resources as downloadable files via URL's. Minimum required user role: user.  The process chain is executed asynchronously. The provided status URL in the response must be polled to gain information about the processing progress and finishing status.  **Note**      Make sure that the process chain definition identifies all raster, vector     or space-time datasets correctly with name and mapset: name@mapset if you     use data from other mapsets in the specified location.      All required mapsets will be identified by analysing the input parameter     of all module descriptions in the provided process chain and     mounted read-only into the ephemeral database that is used for processing.  The persistent database will not be modified. The ephemeral database will be removed after processing. Use the URL's provided in the finished response to download the resource that were specified in the process chain for export.  This endpoint also allows the creation of STAC ITEMS through the ACTINIA STAC PLUGIN. The STAC item is stored in a dedicated CATALOG following the standard from STAC specification (https://stacspec.org/). 

        :param location_name: The location name that contains the data that should be processed (required)
        :type location_name: str
        :param process_chain: The process chain that should be executed (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_processing_async_export_gcs_post_serialize(
            location_name=location_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_processing_async_export_gcs_post_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name that contains the data that should be processed")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be executed")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Execute a user defined process chain in an ephemeral location/mapset

        Execute a user defined process chain in an ephemeral database and provide the generated resources as downloadable files via URL's. Minimum required user role: user.  The process chain is executed asynchronously. The provided status URL in the response must be polled to gain information about the processing progress and finishing status.  **Note**      Make sure that the process chain definition identifies all raster, vector     or space-time datasets correctly with name and mapset: name@mapset if you     use data from other mapsets in the specified location.      All required mapsets will be identified by analysing the input parameter     of all module descriptions in the provided process chain and     mounted read-only into the ephemeral database that is used for processing.  The persistent database will not be modified. The ephemeral database will be removed after processing. Use the URL's provided in the finished response to download the resource that were specified in the process chain for export.  This endpoint also allows the creation of STAC ITEMS through the ACTINIA STAC PLUGIN. The STAC item is stored in a dedicated CATALOG following the standard from STAC specification (https://stacspec.org/). 

        :param location_name: The location name that contains the data that should be processed (required)
        :type location_name: str
        :param process_chain: The process chain that should be executed (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_processing_async_export_gcs_post_serialize(
            location_name=location_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_processing_async_export_gcs_post_serialize(
        self,
        location_name,
        process_chain,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if process_chain is not None:
            _body_params = process_chain


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/locations/{location_name}/processing_async_export_gcs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_processing_async_export_post(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name that contains the data that should be processed")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be executed")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ProcessingResponseModel:
        """Execute a user defined process chain in an ephemeral location/mapset

        Execute a user defined process chain in an ephemeral database and provide the generated resources as downloadable files via URL's. Minimum required user role: user.  The process chain is executed asynchronously. The provided status URL in the response must be polled to gain information about the processing progress and finishing status.  **Note**      Make sure that the process chain definition identifies all raster, vector     or space-time datasets correctly with name and mapset: name@mapset if you     use data from other mapsets in the specified location.      All required mapsets will be identified by analysing the input parameter     of all module descriptions in the provided process chain and     mounted read-only into the ephemeral database that is used for processing.  The persistent database will not be modified. The ephemeral database will be removed after processing. Use the URL's provided in the finished response to download the resource that were specified in the process chain for export.  This endpoint also allows the creation of STAC ITEMS through the ACTINIA STAC PLUGIN. The STAC item is stored in a dedicated CATALOG following the standard from STAC specification (https://stacspec.org/). 

        :param location_name: The location name that contains the data that should be processed (required)
        :type location_name: str
        :param process_chain: The process chain that should be executed (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_processing_async_export_post_serialize(
            location_name=location_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_processing_async_export_post_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name that contains the data that should be processed")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be executed")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ProcessingResponseModel]:
        """Execute a user defined process chain in an ephemeral location/mapset

        Execute a user defined process chain in an ephemeral database and provide the generated resources as downloadable files via URL's. Minimum required user role: user.  The process chain is executed asynchronously. The provided status URL in the response must be polled to gain information about the processing progress and finishing status.  **Note**      Make sure that the process chain definition identifies all raster, vector     or space-time datasets correctly with name and mapset: name@mapset if you     use data from other mapsets in the specified location.      All required mapsets will be identified by analysing the input parameter     of all module descriptions in the provided process chain and     mounted read-only into the ephemeral database that is used for processing.  The persistent database will not be modified. The ephemeral database will be removed after processing. Use the URL's provided in the finished response to download the resource that were specified in the process chain for export.  This endpoint also allows the creation of STAC ITEMS through the ACTINIA STAC PLUGIN. The STAC item is stored in a dedicated CATALOG following the standard from STAC specification (https://stacspec.org/). 

        :param location_name: The location name that contains the data that should be processed (required)
        :type location_name: str
        :param process_chain: The process chain that should be executed (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_processing_async_export_post_serialize(
            location_name=location_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_processing_async_export_post_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name that contains the data that should be processed")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be executed")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Execute a user defined process chain in an ephemeral location/mapset

        Execute a user defined process chain in an ephemeral database and provide the generated resources as downloadable files via URL's. Minimum required user role: user.  The process chain is executed asynchronously. The provided status URL in the response must be polled to gain information about the processing progress and finishing status.  **Note**      Make sure that the process chain definition identifies all raster, vector     or space-time datasets correctly with name and mapset: name@mapset if you     use data from other mapsets in the specified location.      All required mapsets will be identified by analysing the input parameter     of all module descriptions in the provided process chain and     mounted read-only into the ephemeral database that is used for processing.  The persistent database will not be modified. The ephemeral database will be removed after processing. Use the URL's provided in the finished response to download the resource that were specified in the process chain for export.  This endpoint also allows the creation of STAC ITEMS through the ACTINIA STAC PLUGIN. The STAC item is stored in a dedicated CATALOG following the standard from STAC specification (https://stacspec.org/). 

        :param location_name: The location name that contains the data that should be processed (required)
        :type location_name: str
        :param process_chain: The process chain that should be executed (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_processing_async_export_post_serialize(
            location_name=location_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_processing_async_export_post_serialize(
        self,
        location_name,
        process_chain,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if process_chain is not None:
            _body_params = process_chain


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/locations/{location_name}/processing_async_export',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_processing_async_export_s3_post(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name that contains the data that should be processed")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be executed")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ProcessingResponseModel:
        """Execute a user defined process chain in an ephemeral location/mapset

        Execute a user defined process chain in an ephemeral database and provide the generated resources as downloadable files via URL's. Minimum required user role: user.  The process chain is executed asynchronously. The provided status URL in the response must be polled to gain information about the processing progress and finishing status.  **Note**      Make sure that the process chain definition identifies all raster, vector     or space-time datasets correctly with name and mapset: name@mapset if you     use data from other mapsets in the specified location.      All required mapsets will be identified by analysing the input parameter     of all module descriptions in the provided process chain and     mounted read-only into the ephemeral database that is used for processing.  The persistent database will not be modified. The ephemeral database will be removed after processing. Use the URL's provided in the finished response to download the resource that were specified in the process chain for export.  This endpoint also allows the creation of STAC ITEMS through the ACTINIA STAC PLUGIN. The STAC item is stored in a dedicated CATALOG following the standard from STAC specification (https://stacspec.org/). 

        :param location_name: The location name that contains the data that should be processed (required)
        :type location_name: str
        :param process_chain: The process chain that should be executed (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_processing_async_export_s3_post_serialize(
            location_name=location_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_processing_async_export_s3_post_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name that contains the data that should be processed")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be executed")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ProcessingResponseModel]:
        """Execute a user defined process chain in an ephemeral location/mapset

        Execute a user defined process chain in an ephemeral database and provide the generated resources as downloadable files via URL's. Minimum required user role: user.  The process chain is executed asynchronously. The provided status URL in the response must be polled to gain information about the processing progress and finishing status.  **Note**      Make sure that the process chain definition identifies all raster, vector     or space-time datasets correctly with name and mapset: name@mapset if you     use data from other mapsets in the specified location.      All required mapsets will be identified by analysing the input parameter     of all module descriptions in the provided process chain and     mounted read-only into the ephemeral database that is used for processing.  The persistent database will not be modified. The ephemeral database will be removed after processing. Use the URL's provided in the finished response to download the resource that were specified in the process chain for export.  This endpoint also allows the creation of STAC ITEMS through the ACTINIA STAC PLUGIN. The STAC item is stored in a dedicated CATALOG following the standard from STAC specification (https://stacspec.org/). 

        :param location_name: The location name that contains the data that should be processed (required)
        :type location_name: str
        :param process_chain: The process chain that should be executed (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_processing_async_export_s3_post_serialize(
            location_name=location_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_processing_async_export_s3_post_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name that contains the data that should be processed")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be executed")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Execute a user defined process chain in an ephemeral location/mapset

        Execute a user defined process chain in an ephemeral database and provide the generated resources as downloadable files via URL's. Minimum required user role: user.  The process chain is executed asynchronously. The provided status URL in the response must be polled to gain information about the processing progress and finishing status.  **Note**      Make sure that the process chain definition identifies all raster, vector     or space-time datasets correctly with name and mapset: name@mapset if you     use data from other mapsets in the specified location.      All required mapsets will be identified by analysing the input parameter     of all module descriptions in the provided process chain and     mounted read-only into the ephemeral database that is used for processing.  The persistent database will not be modified. The ephemeral database will be removed after processing. Use the URL's provided in the finished response to download the resource that were specified in the process chain for export.  This endpoint also allows the creation of STAC ITEMS through the ACTINIA STAC PLUGIN. The STAC item is stored in a dedicated CATALOG following the standard from STAC specification (https://stacspec.org/). 

        :param location_name: The location name that contains the data that should be processed (required)
        :type location_name: str
        :param process_chain: The process chain that should be executed (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_processing_async_export_s3_post_serialize(
            location_name=location_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_processing_async_export_s3_post_serialize(
        self,
        location_name,
        process_chain,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if process_chain is not None:
            _body_params = process_chain


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/locations/{location_name}/processing_async_export_s3',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_processing_export_post(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name that contains the data that should be processed")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be executed")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ProcessingResponseModel:
        """Execute a user defined process chain in an ephemeral location/mapset

        Execute a user defined process chain in an ephemeral database and provide the generated resources as downloadable files via URL's. Minimum required user role: user.  The process chain is executed asynchronously. The provided status URL in the response must be polled to gain information about the processing progress and finishing status.  **Note**      Make sure that the process chain definition identifies all raster, vector     or space-time datasets correctly with name and mapset: name@mapset if you     use data from other mapsets in the specified location.      All required mapsets will be identified by analysing the input parameter     of all module descriptions in the provided process chain and     mounted read-only into the ephemeral database that is used for processing.  The persistent database will not be modified. The ephemeral database will be removed after processing. Use the URL's provided in the finished response to download the resource that were specified in the process chain for export.  This endpoint also allows the creation of STAC ITEMS through the ACTINIA STAC PLUGIN. The STAC item is stored in a dedicated CATALOG following the standard from STAC specification (https://stacspec.org/). 

        :param location_name: The location name that contains the data that should be processed (required)
        :type location_name: str
        :param process_chain: The process chain that should be executed (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_processing_export_post_serialize(
            location_name=location_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_processing_export_post_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name that contains the data that should be processed")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be executed")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ProcessingResponseModel]:
        """Execute a user defined process chain in an ephemeral location/mapset

        Execute a user defined process chain in an ephemeral database and provide the generated resources as downloadable files via URL's. Minimum required user role: user.  The process chain is executed asynchronously. The provided status URL in the response must be polled to gain information about the processing progress and finishing status.  **Note**      Make sure that the process chain definition identifies all raster, vector     or space-time datasets correctly with name and mapset: name@mapset if you     use data from other mapsets in the specified location.      All required mapsets will be identified by analysing the input parameter     of all module descriptions in the provided process chain and     mounted read-only into the ephemeral database that is used for processing.  The persistent database will not be modified. The ephemeral database will be removed after processing. Use the URL's provided in the finished response to download the resource that were specified in the process chain for export.  This endpoint also allows the creation of STAC ITEMS through the ACTINIA STAC PLUGIN. The STAC item is stored in a dedicated CATALOG following the standard from STAC specification (https://stacspec.org/). 

        :param location_name: The location name that contains the data that should be processed (required)
        :type location_name: str
        :param process_chain: The process chain that should be executed (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_processing_export_post_serialize(
            location_name=location_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_processing_export_post_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name that contains the data that should be processed")],
        process_chain: Annotated[ProcessChainModel, Field(description="The process chain that should be executed")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Execute a user defined process chain in an ephemeral location/mapset

        Execute a user defined process chain in an ephemeral database and provide the generated resources as downloadable files via URL's. Minimum required user role: user.  The process chain is executed asynchronously. The provided status URL in the response must be polled to gain information about the processing progress and finishing status.  **Note**      Make sure that the process chain definition identifies all raster, vector     or space-time datasets correctly with name and mapset: name@mapset if you     use data from other mapsets in the specified location.      All required mapsets will be identified by analysing the input parameter     of all module descriptions in the provided process chain and     mounted read-only into the ephemeral database that is used for processing.  The persistent database will not be modified. The ephemeral database will be removed after processing. Use the URL's provided in the finished response to download the resource that were specified in the process chain for export.  This endpoint also allows the creation of STAC ITEMS through the ACTINIA STAC PLUGIN. The STAC item is stored in a dedicated CATALOG following the standard from STAC specification (https://stacspec.org/). 

        :param location_name: The location name that contains the data that should be processed (required)
        :type location_name: str
        :param process_chain: The process chain that should be executed (required)
        :type process_chain: ProcessChainModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_processing_export_post_serialize(
            location_name=location_name,
            process_chain=process_chain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_processing_export_post_serialize(
        self,
        location_name,
        process_chain,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if process_chain is not None:
            _body_params = process_chain


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/locations/{location_name}/processing_export',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


