# coding: utf-8

"""
    Actinia

     ================================ Actinia - The GRASS GIS REST API ================================  **Actinia** is an open source REST API for scalable, distributed, high performance processing of geographical data that uses GRASS GIS for computational tasks.  It provides a REST API to process satellite images, time series of satellite images, arbitrary raster data with geographical relations and vector data.  The REST interface allows to access, manage and manipulate the GRASS GIS database via HTTP GET,PUT,POST and DELETE requests and to process raster, vector and time series data located in a persistent GRASS GIS database. **Actinia** allows the processing of cloud based data, for example all Landsat 4-8 scenes as well as all Sentinel2A scenes in an ephemeral databases. The computational results of ephemeral processing are available via object storage as GeoTIFF files.  The full API documentation is available here: https://redocly.github.io/redoc/?url=https://actinia.mundialis.de/latest/ swagger.json   Examples: ---------  To execute the examples, first setup login information, IP address and port:      export ACTINIA_URL=https://actinia.mundialis.de/latest     export AUTH='-u demouser:gu3st!pa55w0rd'  **Data management**  - List all locations that are available in the actinia persistent database:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations\"  - List all mapsets in the location latlong_wgs84:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets\"  - List all raster layers in location latlong_wgs84 and mapset Sentinel2A      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets/Sentinel2A/raster_layers\"  - List all space-time raster datasets (STRDS) in location ECAD and mapset   PERMANENT:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/raster_layers\"  - List all raster map layers of the STRDS precipitation_1950_2013_yearly_mm:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/strds/precipitation_    1950_2013_yearly_mm/raster_layers\"  **Landsat and Sentinel2A NDVI computation**  This API call will compute the NDVI of the top of atmosphere (TOAR) corrected Landsat4 scene LC80440342016259LGN00:      curl ${AUTH} -X POST \"${ACTINIA_URL}/landsat_process/    LC80440342016259LGN00/TOAR/NDVI\"  NDVI computation of Sentinel2A scene S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138:      curl ${AUTH} -X POST \"${ACTINIA_URL}/sentinel2_process/ndvi/    S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138\"  The results of the asynchronous computations are available as GeoTIFF file in a cloud storage for download. 

    The version of the OpenAPI document: v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr, field_validator
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class InputParameterImportDescr(BaseModel):
    """
    Definition of sources to be imported as raster or vector map layer.
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="The type of the input that should be downloaded and imported. In case of raster or vector types a download URL must be provided as source using http, https or ftp protocols. In case of sentinel2  scenes the scene name and the band must be provided. The Landsat approach is different. <br><br>In case a Landsat scene is requested, all bands will be download, in the target location imported and an atmospheric correction is applied. The atmospheric correction must be specified. The resulting raster map layers have a specific name scheme, that is independent from the provided map name in the process description. The name scheme is always: <p>\\<landsat scene id\\>_\\<atcor\\>.\\<band\\></p>For example, if the scene <p>LT52170762005240COA00</p> was requested, the resulting name for the DOS1 atmospheric corrected band 1 would be: <p>LT52170762005240COA00_dos1.1</p>.For the DOS1 atmospheric corrected band 2 it would be: <p>LT52170762005240COA00_dos1.2</p> and so on. All other process steps must use these raster map layer names to refer to the imported Landsat bands. Use the file option to download any kind of files that should be processed by a grass gis module. ")
    sentinel_band: Optional[StrictStr] = Field(default=None, description="The band of the sentinel2 scene that should be imported")
    landsat_atcor: Optional[StrictStr] = Field(default=None, description="The atmospheric correction that should be applied to the landsat scene")
    vector_layer: Optional[StrictStr] = Field(default=None, description="The name of the layer that should be imported from the vector file or postGIS database")
    source: Optional[StrictStr] = Field(default=None, description="The input source that may be a landsat scene name, a sentinel2 scene name, a postGIS database string,a stac collection ID or an URL that points to an accessible raster or vector file. A HTTP, HTTPS or FTP connection must be specified in case of raster or vector types. In this case the source string must contain the protocol that will used for connection: http:// or https:// or ftp://. PostGIS vector layer can be imported by defining a database string as source and a layer name.")
    semantic_label: Optional[StrictStr] = Field(default=None, description="Refers to the common names used tocall the bands of an image,for example: red, blue, nir, swirHowever, this property also accepts the band namesuch as B1, B8 etc. The semantic labeling should matchthe labels register in the stac collection.")
    extent: Optional[StrictStr] = Field(default=None, description="Spatio-temporal constraint defined by the userthroughout bbox and interval concept.")
    filter: Optional[StrictStr] = Field(default=None, description="Constrain in any other propertyor metadata.")
    resample: Optional[StrictStr] = Field(default=None, description="Resampling method to use for reprojection of raster map (default: nearest).")
    resolution: Optional[StrictStr] = Field(default=None, description="Resolution of output raster map. Estimated, user-specified or current region resolution (default: estimated).")
    resolution_value: Optional[StrictStr] = Field(default=None, description="Resolution of output raster map (use with option \"resolution\": \"value\") in units of the target coordinate reference system, not in map units. Must be convertible to float.")
    basic_auth: Optional[StrictStr] = Field(default=None, description="User name and password for basic HTTP, HTTPS and FTP authentication of the source connection. The user name and password must be separated by a colon: username:password")
    __properties: ClassVar[List[str]] = ["type", "sentinel_band", "landsat_atcor", "vector_layer", "source", "semantic_label", "extent", "filter", "resample", "resolution", "resolution_value", "basic_auth"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('raster', 'vector', 'landsat', 'sentinel2', 'postgis', 'file', 'stac'):
            raise ValueError("must be one of enum values ('raster', 'vector', 'landsat', 'sentinel2', 'postgis', 'file', 'stac')")
        return value

    @field_validator('sentinel_band')
    def sentinel_band_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('B01', 'B02', 'B03', 'B04', 'B05', 'B06', 'B07', 'B08', 'B8A', 'B09', 'B10', 'B11', 'B12'):
            raise ValueError("must be one of enum values ('B01', 'B02', 'B03', 'B04', 'B05', 'B06', 'B07', 'B08', 'B8A', 'B09', 'B10', 'B11', 'B12')")
        return value

    @field_validator('landsat_atcor')
    def landsat_atcor_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('uncorrected', 'dos1', 'dos2', 'dos2b', 'dos3', 'dos4'):
            raise ValueError("must be one of enum values ('uncorrected', 'dos1', 'dos2', 'dos2b', 'dos3', 'dos4')")
        return value

    @field_validator('extent')
    def extent_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('spatial', 'temporal'):
            raise ValueError("must be one of enum values ('spatial', 'temporal')")
        return value

    @field_validator('resample')
    def resample_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('nearest', 'bilinear', 'bicubic', 'lanczos', 'bilinear_f', 'bicubic_f', 'lanczos_f'):
            raise ValueError("must be one of enum values ('nearest', 'bilinear', 'bicubic', 'lanczos', 'bilinear_f', 'bicubic_f', 'lanczos_f')")
        return value

    @field_validator('resolution')
    def resolution_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('estimated', 'value', 'region'):
            raise ValueError("must be one of enum values ('estimated', 'value', 'region')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of InputParameterImportDescr from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of InputParameterImportDescr from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "sentinel_band": obj.get("sentinel_band"),
            "landsat_atcor": obj.get("landsat_atcor"),
            "vector_layer": obj.get("vector_layer"),
            "source": obj.get("source"),
            "semantic_label": obj.get("semantic_label"),
            "extent": obj.get("extent"),
            "filter": obj.get("filter"),
            "resample": obj.get("resample"),
            "resolution": obj.get("resolution"),
            "resolution_value": obj.get("resolution_value"),
            "basic_auth": obj.get("basic_auth")
        })
        return _obj


