# actinia-openapi-python-client

## Actinia - The GRASS GIS REST API

**Actinia** is an open source REST API for scalable, distributed, high
performance processing of geographical data that uses GRASS GIS for
computational tasks.

It provides a REST API to process satellite images, time series of satellite
images, arbitrary raster data with geographical relations and vector data.

The REST interface allows to access, manage and manipulate the GRASS GIS
database via HTTP GET,PUT,POST and DELETE requests and to process raster,
vector and time series data located in a persistent GRASS GIS database.
**Actinia** allows the processing of cloud based data, for example all Landsat
4-8 scenes as well as all Sentinel2A scenes in an ephemeral databases. The
computational results of ephemeral processing are available via object storage
as GeoTIFF files.

### Examples

---------

To execute the examples, first setup login information, IP address and port:

    export ACTINIA_URL=https://actinia.mundialis.de/latest
    export AUTH='-u demouser:gu3st!pa55w0rd'

#### Data management*

- List all locations that are available in the actinia persistent database:

    curl ${AUTH} -X GET \"${ACTINIA_URL}/locations\"

- List all mapsets in the location latlong_wgs84:

    curl ${AUTH} -X GET \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets\"

- List all raster layers in location latlong_wgs84 and mapset Sentinel2A

    curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets/Sentinel2A/raster_layers\"

- List all space-time raster datasets (STRDS) in location ECAD and mapset
  PERMANENT:

    curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/raster_layers\"

- List all raster map layers of the STRDS precipitation_1950_2013_yearly_mm:

    curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/strds/precipitation_    1950_2013_yearly_mm/raster_layers\"

#### Landsat and Sentinel2A NDVI computation

This API call will compute the NDVI of the top of atmosphere (TOAR)
corrected Landsat4 scene LC80440342016259LGN00:

    curl ${AUTH} -X POST \"${ACTINIA_URL}/landsat_process/    LC80440342016259LGN00/TOAR/NDVI\"

NDVI computation of Sentinel2A scene
S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138:

    curl ${AUTH} -X POST \"${ACTINIA_URL}/sentinel2_process/ndvi/    S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138\"

The results of the asynchronous computations are available as GeoTIFF file in
a cloud storage for download.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 0.0.5
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements

Python 3.7+

## Installation & Usage

### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/OpenPlainsInc/actinia_openapi_python_client.git
```

(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/OpenPlainsInc/actinia_openapi_python_client.git`)

Then import the package:

```python
import actinia_openapi_python_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import actinia_openapi_python_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import actinia_openapi_python_client
from actinia_openapi_python_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = actinia_openapi_python_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = actinia_openapi_python_client.Configuration(
    username = os.environ["USERNAME"],
    password = os.environ["PASSWORD"]
)


# Enter a context with an instance of the API client
with actinia_openapi_python_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = actinia_openapi_python_client.APILogApi(api_client)
    user_id = 'user_id_example' # str | The unique user name/id

    try:
        # Get a list of all API calls that have been called by the provided user.
        api_response = api_instance.api_log_user_id_get(user_id)
        print("The response of APILogApi->api_log_user_id_get:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling APILogApi->api_log_user_id_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APILogApi* | [**api_log_user_id_get**](docs/APILogApi.md#api_log_user_id_get) | **GET** /api_log/{user_id} | Get a list of all API calls that have been called by the provided user.
*AuthenticationManagementApi* | [**api_key_get**](docs/AuthenticationManagementApi.md#api_key_get) | **GET** /api_key | Create an API key for permanent authentication.
*AuthenticationManagementApi* | [**token_get**](docs/AuthenticationManagementApi.md#token_get) | **GET** /token | Create an authentication token.
*CacheManagementApi* | [**download_cache_delete**](docs/CacheManagementApi.md#download_cache_delete) | **DELETE** /download_cache | Clean the download cache and remove all cached data
*CacheManagementApi* | [**download_cache_get**](docs/CacheManagementApi.md#download_cache_get) | **GET** /download_cache | Get the current size of the download cache
*FileManagementApi* | [**files_post**](docs/FileManagementApi.md#files_post) | **POST** /files | Upload file.
*GeoNetworkApi* | [**metadata_geodata_tags_tags_get**](docs/GeoNetworkApi.md#metadata_geodata_tags_tags_get) | **GET** /metadata/geodata/tags/{tags} | Get geodata object from requests to Geonetwork opensource by one or many tags.
*GeoNetworkApi* | [**metadata_geodata_uuids_uuid_get**](docs/GeoNetworkApi.md#metadata_geodata_uuids_uuid_get) | **GET** /metadata/geodata/uuids/{uuid} | Get geodata object from requests to Geonetwork opensource by uuid.
*GeoNetworkApi* | [**metadata_raw_categories_category_get**](docs/GeoNetworkApi.md#metadata_raw_categories_category_get) | **GET** /metadata/raw/categories/{category} | Requests a category from Geonetwork opensource.
*GeoNetworkApi* | [**metadata_raw_tags_tags_get**](docs/GeoNetworkApi.md#metadata_raw_tags_tags_get) | **GET** /metadata/raw/tags/{tags} | Requests one or many tags from Geonetwork opensource.
*GeoNetworkApi* | [**metadata_raw_uuids_uuid_get**](docs/GeoNetworkApi.md#metadata_raw_uuids_uuid_get) | **GET** /metadata/raw/uuids/{uuid} | Requests an uuid from Geonetwork opensource.
*GeoNetworkApi* | [**metadata_test_connection_get**](docs/GeoNetworkApi.md#metadata_test_connection_get) | **GET** /metadata/test/connection | Tests for active connection to Geonetwork opensource.
*GeoNetworkApi* | [**metadata_test_connection_post**](docs/GeoNetworkApi.md#metadata_test_connection_post) | **POST** /metadata/test/connection | Tests for active connection to Geonetwork opensource.
*LocationManagementApi* | [**locations_get**](docs/LocationManagementApi.md#locations_get) | **GET** /locations | Get a list of all available locations
*LocationManagementApi* | [**locations_location_name_delete**](docs/LocationManagementApi.md#locations_location_name_delete) | **DELETE** /locations/{location_name} | Delete an existing location and everything inside from the user
*LocationManagementApi* | [**locations_location_name_info_get**](docs/LocationManagementApi.md#locations_location_name_info_get) | **GET** /locations/{location_name}/info | Get the location projection and current computational region of the
*LocationManagementApi* | [**locations_location_name_post**](docs/LocationManagementApi.md#locations_location_name_post) | **POST** /locations/{location_name} | Create a new location based on EPSG code in the user database.
*MapsetManagementApi* | [**locations_location_name_mapsets_get**](docs/MapsetManagementApi.md#locations_location_name_mapsets_get) | **GET** /locations/{location_name}/mapsets | Get a list of all mapsets that are located in a specific location.
*MapsetManagementApi* | [**locations_location_name_mapsets_mapset_name_delete**](docs/MapsetManagementApi.md#locations_location_name_mapsets_mapset_name_delete) | **DELETE** /locations/{location_name}/mapsets/{mapset_name} | Delete an existing mapset
*MapsetManagementApi* | [**locations_location_name_mapsets_mapset_name_info_get**](docs/MapsetManagementApi.md#locations_location_name_mapsets_mapset_name_info_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/info | Get the current computational region of the mapset and the projection
*MapsetManagementApi* | [**locations_location_name_mapsets_mapset_name_lock_delete**](docs/MapsetManagementApi.md#locations_location_name_mapsets_mapset_name_lock_delete) | **DELETE** /locations/{location_name}/mapsets/{mapset_name}/lock | Delete a location/mapset lock.
*MapsetManagementApi* | [**locations_location_name_mapsets_mapset_name_lock_get**](docs/MapsetManagementApi.md#locations_location_name_mapsets_mapset_name_lock_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/lock | Get the location/mapset lock status.
*MapsetManagementApi* | [**locations_location_name_mapsets_mapset_name_lock_post**](docs/MapsetManagementApi.md#locations_location_name_mapsets_mapset_name_lock_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/lock | Create a location/mapset lock.
*MapsetManagementApi* | [**locations_location_name_mapsets_mapset_name_post**](docs/MapsetManagementApi.md#locations_location_name_mapsets_mapset_name_post) | **POST** /locations/{location_name}/mapsets/{mapset_name} | Create a new mapset in an existing location.
*MapsetsApi* | [**mapsets_get**](docs/MapsetsApi.md#mapsets_get) | **GET** /mapsets | 
*MergeApi* | [**locations_location_name_mapsets_mapset_name_merge_processes_get**](docs/MergeApi.md#locations_location_name_mapsets_mapset_name_merge_processes_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/merge_processes | Returns a list of all merge processes
*MergeApi* | [**locations_location_name_mapsets_mapset_name_merge_processes_patch_get**](docs/MergeApi.md#locations_location_name_mapsets_mapset_name_merge_processes_patch_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/merge_processes/patch | Get description of the patch merge process.
*MergeApi* | [**locations_location_name_mapsets_mapset_name_merge_processes_patch_post**](docs/MergeApi.md#locations_location_name_mapsets_mapset_name_merge_processes_patch_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/merge_processes/patch | Merging mapsets with same raster, vector, ... maps in one mapset by
*ModuleViewerApi* | [**actinia_modules_actiniamodule_get**](docs/ModuleViewerApi.md#actinia_modules_actiniamodule_get) | **GET** /actinia_modules/{actiniamodule} | Describe an actinia module (process chain template).
*ModuleViewerApi* | [**actinia_modules_get**](docs/ModuleViewerApi.md#actinia_modules_get) | **GET** /actinia_modules | Get a list of all actinia modules (process chain templates).
*ModuleViewerApi* | [**grass_modules_get**](docs/ModuleViewerApi.md#grass_modules_get) | **GET** /grass_modules | Get a list of all GRASS GIS modules.
*ModuleViewerApi* | [**grass_modules_grassmodule_get**](docs/ModuleViewerApi.md#grass_modules_grassmodule_get) | **GET** /grass_modules/{grassmodule} | Describe a GRASS GIS module.
*ModuleViewerApi* | [**modules_get**](docs/ModuleViewerApi.md#modules_get) | **GET** /modules | Get a list of all modules.
*ModuleViewerApi* | [**modules_module_get**](docs/ModuleViewerApi.md#modules_module_get) | **GET** /modules/{module} | Describe a module.
*ProcessChainMonitoringApi* | [**resources_user_id_resource_id_mapsetsizes_diffs_get**](docs/ProcessChainMonitoringApi.md#resources_user_id_resource_id_mapsetsizes_diffs_get) | **GET** /resources/{user_id}/{resource_id}/mapsetsizes/diffs | Get the step-by-step mapset size differences of a resource.
*ProcessChainMonitoringApi* | [**resources_user_id_resource_id_mapsetsizes_diffs_render_get**](docs/ProcessChainMonitoringApi.md#resources_user_id_resource_id_mapsetsizes_diffs_render_get) | **GET** /resources/{user_id}/{resource_id}/mapsetsizes/diffs/render | Render the step-by-step mapset size differences of a resource.
*ProcessChainMonitoringApi* | [**resources_user_id_resource_id_mapsetsizes_get**](docs/ProcessChainMonitoringApi.md#resources_user_id_resource_id_mapsetsizes_get) | **GET** /resources/{user_id}/{resource_id}/mapsetsizes | Get the sizes of mapset of a resource.
*ProcessChainMonitoringApi* | [**resources_user_id_resource_id_mapsetsizes_max_get**](docs/ProcessChainMonitoringApi.md#resources_user_id_resource_id_mapsetsizes_max_get) | **GET** /resources/{user_id}/{resource_id}/mapsetsizes/max | Get the maximum size of mapset of a resource.
*ProcessChainMonitoringApi* | [**resources_user_id_resource_id_mapsetsizes_render_get**](docs/ProcessChainMonitoringApi.md#resources_user_id_resource_id_mapsetsizes_render_get) | **GET** /resources/{user_id}/{resource_id}/mapsetsizes/render | Render the mapset sizes of a resource.
*ProcessChainTemplateManagementApi* | [**actinia_templates_get**](docs/ProcessChainTemplateManagementApi.md#actinia_templates_get) | **GET** /actinia_templates | Get a list of all actinia templates (process chain templates).
*ProcessChainTemplateManagementApi* | [**actinia_templates_post**](docs/ProcessChainTemplateManagementApi.md#actinia_templates_post) | **POST** /actinia_templates | Create an actinia template (process chain template).
*ProcessChainTemplateManagementApi* | [**actinia_templates_template_id_delete**](docs/ProcessChainTemplateManagementApi.md#actinia_templates_template_id_delete) | **DELETE** /actinia_templates/{template_id} | Delete an actinia template (process chain template).
*ProcessChainTemplateManagementApi* | [**actinia_templates_template_id_get**](docs/ProcessChainTemplateManagementApi.md#actinia_templates_template_id_get) | **GET** /actinia_templates/{template_id} | Read an actinia template (process chain template).
*ProcessChainTemplateManagementApi* | [**actinia_templates_template_id_put**](docs/ProcessChainTemplateManagementApi.md#actinia_templates_template_id_put) | **PUT** /actinia_templates/{template_id} | Update an actinia template (process chain template).
*ProcessingApi* | [**locations_location_name_mapsets_mapset_name_processing_async_post**](docs/ProcessingApi.md#locations_location_name_mapsets_mapset_name_processing_async_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/processing_async | Execute a user defined process chain that creates a new mapset or
*ProcessingApi* | [**locations_location_name_mapsets_mapset_name_processing_post**](docs/ProcessingApi.md#locations_location_name_mapsets_mapset_name_processing_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/processing | Execute a user defined process chain that creates a new mapset or
*ProcessingApi* | [**locations_location_name_process_chain_validation_async_post**](docs/ProcessingApi.md#locations_location_name_process_chain_validation_async_post) | **POST** /locations/{location_name}/process_chain_validation_async | Validate a process chain asynchronously, check the provided sources
*ProcessingApi* | [**locations_location_name_process_chain_validation_sync_post**](docs/ProcessingApi.md#locations_location_name_process_chain_validation_sync_post) | **POST** /locations/{location_name}/process_chain_validation_sync | Validate a process chain synchronously, check the provided sources
*ProcessingApi* | [**locations_location_name_processing_async_export_gcs_post**](docs/ProcessingApi.md#locations_location_name_processing_async_export_gcs_post) | **POST** /locations/{location_name}/processing_async_export_gcs | Execute a user defined process chain in an ephemeral location/mapset
*ProcessingApi* | [**locations_location_name_processing_async_export_post**](docs/ProcessingApi.md#locations_location_name_processing_async_export_post) | **POST** /locations/{location_name}/processing_async_export | Execute a user defined process chain in an ephemeral location/mapset
*ProcessingApi* | [**locations_location_name_processing_async_export_s3_post**](docs/ProcessingApi.md#locations_location_name_processing_async_export_s3_post) | **POST** /locations/{location_name}/processing_async_export_s3 | Execute a user defined process chain in an ephemeral location/mapset
*ProcessingApi* | [**locations_location_name_processing_export_post**](docs/ProcessingApi.md#locations_location_name_processing_export_post) | **POST** /locations/{location_name}/processing_export | Execute a user defined process chain in an ephemeral location/mapset
*RasterManagementApi* | [**locations_location_name_mapsets_mapset_name_raster_layers_delete**](docs/RasterManagementApi.md#locations_location_name_mapsets_mapset_name_raster_layers_delete) | **DELETE** /locations/{location_name}/mapsets/{mapset_name}/raster_layers | Delete a single raster map layer or a list of raster map layer names
*RasterManagementApi* | [**locations_location_name_mapsets_mapset_name_raster_layers_get**](docs/RasterManagementApi.md#locations_location_name_mapsets_mapset_name_raster_layers_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/raster_layers | Get a list of raster map layer names that are located in a specific
*RasterManagementApi* | [**locations_location_name_mapsets_mapset_name_raster_layers_put**](docs/RasterManagementApi.md#locations_location_name_mapsets_mapset_name_raster_layers_put) | **PUT** /locations/{location_name}/mapsets/{mapset_name}/raster_layers | Rename a single raster map layer or a list of raster map layers that
*RasterManagementApi* | [**locations_location_name_mapsets_mapset_name_raster_layers_raster_name_colors_get**](docs/RasterManagementApi.md#locations_location_name_mapsets_mapset_name_raster_layers_raster_name_colors_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}/colors | Get the color definition of an existing raster map layer.
*RasterManagementApi* | [**locations_location_name_mapsets_mapset_name_raster_layers_raster_name_colors_post**](docs/RasterManagementApi.md#locations_location_name_mapsets_mapset_name_raster_layers_raster_name_colors_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}/colors | Set the color definition for an existing raster map layer.
*RasterManagementApi* | [**locations_location_name_mapsets_mapset_name_raster_layers_raster_name_delete**](docs/RasterManagementApi.md#locations_location_name_mapsets_mapset_name_raster_layers_raster_name_delete) | **DELETE** /locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name} | Delete an existing raster map layer.
*RasterManagementApi* | [**locations_location_name_mapsets_mapset_name_raster_layers_raster_name_geotiff_async_orig_post**](docs/RasterManagementApi.md#locations_location_name_mapsets_mapset_name_raster_layers_raster_name_geotiff_async_orig_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}/geotiff_async_orig | Export an existing raster map layer as GeoTiff using the raster
*RasterManagementApi* | [**locations_location_name_mapsets_mapset_name_raster_layers_raster_name_geotiff_async_post**](docs/RasterManagementApi.md#locations_location_name_mapsets_mapset_name_raster_layers_raster_name_geotiff_async_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}/geotiff_async | Export an existing raster map layer as GeoTiff.
*RasterManagementApi* | [**locations_location_name_mapsets_mapset_name_raster_layers_raster_name_get**](docs/RasterManagementApi.md#locations_location_name_mapsets_mapset_name_raster_layers_raster_name_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name} | Get information about an existing raster map layer.
*RasterManagementApi* | [**locations_location_name_mapsets_mapset_name_raster_layers_raster_name_legend_get**](docs/RasterManagementApi.md#locations_location_name_mapsets_mapset_name_raster_layers_raster_name_legend_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}/legend | Render the legend of a raster map layer as a PNG image.
*RasterManagementApi* | [**locations_location_name_mapsets_mapset_name_raster_layers_raster_name_post**](docs/RasterManagementApi.md#locations_location_name_mapsets_mapset_name_raster_layers_raster_name_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name} | Create a new raster layer by uploading a GeoTIFF
*RasterManagementApi* | [**locations_location_name_mapsets_mapset_name_raster_layers_raster_name_render_get**](docs/RasterManagementApi.md#locations_location_name_mapsets_mapset_name_raster_layers_raster_name_render_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}/render | Render a raster map layer as a PNG image.
*RasterManagementApi* | [**locations_location_name_mapsets_mapset_name_render_rgb_get**](docs/RasterManagementApi.md#locations_location_name_mapsets_mapset_name_render_rgb_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/render_rgb | Render three raster map layer as composed RGB PNG image.
*RasterManagementApi* | [**locations_location_name_mapsets_mapset_name_render_shade_get**](docs/RasterManagementApi.md#locations_location_name_mapsets_mapset_name_render_shade_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/render_shade | Render two raster layers as a composed shade PNG image
*RasterSamplingApi* | [**locations_location_name_mapsets_mapset_name_raster_layers_raster_name_sampling_async_post**](docs/RasterSamplingApi.md#locations_location_name_mapsets_mapset_name_raster_layers_raster_name_sampling_async_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}/sampling_async | Perform raster map sampling on a raster map layer based on input
*RasterSamplingApi* | [**locations_location_name_mapsets_mapset_name_raster_layers_raster_name_sampling_sync_post**](docs/RasterSamplingApi.md#locations_location_name_mapsets_mapset_name_raster_layers_raster_name_sampling_sync_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}/sampling_sync | Perform raster map sampling on a raster map layer based on input
*RasterStatisticsApi* | [**locations_location_name_mapsets_mapset_name_raster_layers_raster_name_area_stats_async_post**](docs/RasterStatisticsApi.md#locations_location_name_mapsets_mapset_name_raster_layers_raster_name_area_stats_async_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}/area_stats_async | Compute areal categorical statistics on a raster map layer based on
*RasterStatisticsApi* | [**locations_location_name_mapsets_mapset_name_raster_layers_raster_name_area_stats_sync_post**](docs/RasterStatisticsApi.md#locations_location_name_mapsets_mapset_name_raster_layers_raster_name_area_stats_sync_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}/area_stats_sync | Compute areal categorical statistics on a raster map layer based on an
*RasterStatisticsApi* | [**locations_location_name_mapsets_mapset_name_raster_layers_raster_name_area_stats_univar_async_post**](docs/RasterStatisticsApi.md#locations_location_name_mapsets_mapset_name_raster_layers_raster_name_area_stats_univar_async_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}/area_stats_univar_async | Compute areal univariate statistics on a raster map layer based on an
*RasterStatisticsApi* | [**locations_location_name_mapsets_mapset_name_raster_layers_raster_name_area_stats_univar_sync_post**](docs/RasterStatisticsApi.md#locations_location_name_mapsets_mapset_name_raster_layers_raster_name_area_stats_univar_sync_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}/area_stats_univar_sync | Compute areal univariate statistics on a raster map layer based on an
*ResourceIterationManagementApi* | [**resources_user_id_resource_id_iteration_get**](docs/ResourceIterationManagementApi.md#resources_user_id_resource_id_iteration_get) | **GET** /resources/{user_id}/{resource_id}/{iteration} | Get the status of a resource of a given iteration.
*ResourceManagementApi* | [**resource_storage_delete**](docs/ResourceManagementApi.md#resource_storage_delete) | **DELETE** /resource_storage | Clean the resource storage and remove all cached data
*ResourceManagementApi* | [**resource_storage_get**](docs/ResourceManagementApi.md#resource_storage_get) | **GET** /resource_storage | Get the current size of the resource storage
*ResourceManagementApi* | [**resources_user_id_delete**](docs/ResourceManagementApi.md#resources_user_id_delete) | **DELETE** /resources/{user_id} | Terminate all accepted and running resources of the specified user.
*ResourceManagementApi* | [**resources_user_id_get**](docs/ResourceManagementApi.md#resources_user_id_get) | **GET** /resources/{user_id} | Get a list of resources that have been generated by the specified user.
*ResourceManagementApi* | [**resources_user_id_resource_id_delete**](docs/ResourceManagementApi.md#resources_user_id_resource_id_delete) | **DELETE** /resources/{user_id}/{resource_id} | Request the termination of a resource.
*ResourceManagementApi* | [**resources_user_id_resource_id_get**](docs/ResourceManagementApi.md#resources_user_id_resource_id_get) | **GET** /resources/{user_id}/{resource_id} | Get the status of a resource.
*ResourceManagementApi* | [**resources_user_id_resource_id_put**](docs/ResourceManagementApi.md#resources_user_id_resource_id_put) | **PUT** /resources/{user_id}/{resource_id} | Updates/Resumes the status of a resource.
*STACApi* | [**stac_catalogs_catalog_json_get**](docs/STACApi.md#stac_catalogs_catalog_json_get) | **GET** /stac/catalogs/catalog.json | Get a list of all instances.
*STACApi* | [**stac_collections_get**](docs/STACApi.md#stac_collections_get) | **GET** /stac/collections | Get a list of all Collection.
*STACApi* | [**stac_collections_post**](docs/STACApi.md#stac_collections_post) | **POST** /stac/collections | Add a new stac to the user collection
*STACApi* | [**stac_collections_stac_collection_id_delete**](docs/STACApi.md#stac_collections_stac_collection_id_delete) | **DELETE** /stac/collections/{stac_collection_id} | This function deletes the STAC collection with the given id.
*STACApi* | [**stac_collections_stac_collection_id_get**](docs/STACApi.md#stac_collections_stac_collection_id_get) | **GET** /stac/collections/{stac_collection_id} | Get a list of specified Collection.
*STACApi* | [**stac_get**](docs/STACApi.md#stac_get) | **GET** /stac | Get a list of instances and its notation.
*STACApi* | [**stac_instances_get**](docs/STACApi.md#stac_instances_get) | **GET** /stac/instances | Get a list of all instances.
*STACApi* | [**stac_instances_post**](docs/STACApi.md#stac_instances_post) | **POST** /stac/instances | Add a new stac to the user collection
*STACApi* | [**stac_instances_stac_instance_id_delete**](docs/STACApi.md#stac_instances_stac_instance_id_delete) | **DELETE** /stac/instances/{stac_instance_id} | This function delete the STAC Collection stored before on ID basis.
*STACApi* | [**stac_instances_stac_instance_id_get**](docs/STACApi.md#stac_instances_stac_instance_id_get) | **GET** /stac/instances/{stac_instance_id} | Get a list of collection that are inside a instance and its notation.
*STRDSManagementApi* | [**locations_location_name_mapsets_mapset_name_strds_get**](docs/STRDSManagementApi.md#locations_location_name_mapsets_mapset_name_strds_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/strds | Get a list of all STRDS that are located in a specific location/mapset.
*STRDSManagementApi* | [**locations_location_name_mapsets_mapset_name_strds_strds_name_delete**](docs/STRDSManagementApi.md#locations_location_name_mapsets_mapset_name_strds_strds_name_delete) | **DELETE** /locations/{location_name}/mapsets/{mapset_name}/strds/{strds_name} | Delete a STRDS that is located in a specific location/mapset.
*STRDSManagementApi* | [**locations_location_name_mapsets_mapset_name_strds_strds_name_get**](docs/STRDSManagementApi.md#locations_location_name_mapsets_mapset_name_strds_strds_name_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/strds/{strds_name} | Get information about a STRDS that is located in a specific
*STRDSManagementApi* | [**locations_location_name_mapsets_mapset_name_strds_strds_name_post**](docs/STRDSManagementApi.md#locations_location_name_mapsets_mapset_name_strds_strds_name_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/strds/{strds_name} | Create a new STRDS in a specific location/mapset.
*STRDSManagementApi* | [**locations_location_name_mapsets_mapset_name_strds_strds_name_raster_layers_delete**](docs/STRDSManagementApi.md#locations_location_name_mapsets_mapset_name_strds_strds_name_raster_layers_delete) | **DELETE** /locations/{location_name}/mapsets/{mapset_name}/strds/{strds_name}/raster_layers | Unregister raster map layers from a STRDS located in a specific
*STRDSManagementApi* | [**locations_location_name_mapsets_mapset_name_strds_strds_name_raster_layers_get**](docs/STRDSManagementApi.md#locations_location_name_mapsets_mapset_name_strds_strds_name_raster_layers_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/strds/{strds_name}/raster_layers | Get a list of all raster map layers that are registered in a STRDS
*STRDSManagementApi* | [**locations_location_name_mapsets_mapset_name_strds_strds_name_raster_layers_put**](docs/STRDSManagementApi.md#locations_location_name_mapsets_mapset_name_strds_strds_name_raster_layers_put) | **PUT** /locations/{location_name}/mapsets/{mapset_name}/strds/{strds_name}/raster_layers | Register raster map layers in a STRDS located in a specific
*STRDSManagementApi* | [**locations_location_name_mapsets_mapset_name_strds_strds_name_render_get**](docs/STRDSManagementApi.md#locations_location_name_mapsets_mapset_name_strds_strds_name_render_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/strds/{strds_name}/render | Render the raster map layers of a specific STRDS as a single image.
*STRDSSamplingApi* | [**locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_async_geojson_post**](docs/STRDSSamplingApi.md#locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_async_geojson_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/strds/{strds_name}/sampling_async_geojson | Sample a strds by point coordinates, asynchronous call
*STRDSSamplingApi* | [**locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_async_post**](docs/STRDSSamplingApi.md#locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_async_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/strds/{strds_name}/sampling_async | Sample a strds by point coordinates, asynchronous call
*STRDSSamplingApi* | [**locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_sync_geojson_post**](docs/STRDSSamplingApi.md#locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_sync_geojson_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/strds/{strds_name}/sampling_sync_geojson | Sample a strds by point coordinates, synchronous call
*STRDSSamplingApi* | [**locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_sync_post**](docs/STRDSSamplingApi.md#locations_location_name_mapsets_mapset_name_strds_strds_name_sampling_sync_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/strds/{strds_name}/sampling_sync | Sample a strds by point coordinates, synchronous call
*STRDSStatisticsApi* | [**locations_location_name_mapsets_mapset_name_strds_strds_name_timestamp_timestamp_area_stats_async_post**](docs/STRDSStatisticsApi.md#locations_location_name_mapsets_mapset_name_strds_strds_name_timestamp_timestamp_area_stats_async_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/strds/{strds_name}/timestamp/{timestamp}/area_stats_async | Compute area statistics based on a vector map for a single raster
*STRDSStatisticsApi* | [**locations_location_name_mapsets_mapset_name_strds_strds_name_timestamp_timestamp_area_stats_sync_post**](docs/STRDSStatisticsApi.md#locations_location_name_mapsets_mapset_name_strds_strds_name_timestamp_timestamp_area_stats_sync_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/strds/{strds_name}/timestamp/{timestamp}/area_stats_sync | Compute area statistics based on a vector map for a single raster
*STRDSStatisticsApi* | [**locations_location_name_mapsets_mapset_name_strds_strds_name_timestamp_timestamp_area_stats_univar_async_post**](docs/STRDSStatisticsApi.md#locations_location_name_mapsets_mapset_name_strds_strds_name_timestamp_timestamp_area_stats_univar_async_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/strds/{strds_name}/timestamp/{timestamp}/area_stats_univar_async | Compute areal univariate statistics on a raster map layer contained in
*STRDSStatisticsApi* | [**locations_location_name_mapsets_mapset_name_strds_strds_name_timestamp_timestamp_area_stats_univar_sync_post**](docs/STRDSStatisticsApi.md#locations_location_name_mapsets_mapset_name_strds_strds_name_timestamp_timestamp_area_stats_univar_sync_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/strds/{strds_name}/timestamp/{timestamp}/area_stats_univar_sync | Compute areal univariate statistics on a raster map layer contained in
*SatelliteImageAlgorithmsApi* | [**landsat_process_landsat_id_atcor_method_processing_method_post**](docs/SatelliteImageAlgorithmsApi.md#landsat_process_landsat_id_atcor_method_processing_method_post) | **POST** /landsat_process/{landsat_id}/{atcor_method}/{processing_method} | Vegetation index computation from an atmospherically corrected Landsat scene.
*SatelliteImageAlgorithmsApi* | [**landsat_query_get**](docs/SatelliteImageAlgorithmsApi.md#landsat_query_get) | **GET** /landsat_query | Query the Google Landsat archives using time interval, lat/lon coordinates, scene id, spacecraft id and cloud cover.
*SatelliteImageAlgorithmsApi* | [**locations_location_name_mapsets_mapset_name_landsat_import_post**](docs/SatelliteImageAlgorithmsApi.md#locations_location_name_mapsets_mapset_name_landsat_import_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/landsat_import | Download and import Landsat scenes into a new mapset and create a space time dataset for each imported band.
*SatelliteImageAlgorithmsApi* | [**locations_location_name_mapsets_mapset_name_sentinel2_import_post**](docs/SatelliteImageAlgorithmsApi.md#locations_location_name_mapsets_mapset_name_sentinel2_import_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/sentinel2_import | Download and import Sentinel2A scenes into a new mapset and create a space-time raster dataset for each imported band.
*SatelliteImageAlgorithmsApi* | [**sentinel2_process_gcs_ndvi_product_id_post**](docs/SatelliteImageAlgorithmsApi.md#sentinel2_process_gcs_ndvi_product_id_post) | **POST** /sentinel2_process_gcs/ndvi/{product_id} | NDVI computation of an arbitrary Sentinel-2 scene. The results are stored in the Google Cloud Storage.
*SatelliteImageAlgorithmsApi* | [**sentinel2_process_ndvi_product_id_post**](docs/SatelliteImageAlgorithmsApi.md#sentinel2_process_ndvi_product_id_post) | **POST** /sentinel2_process/ndvi/{product_id} | NDVI computation of an arbitrary Sentinel-2 scene.
*SatelliteImageAlgorithmsApi* | [**sentinel2_query_get**](docs/SatelliteImageAlgorithmsApi.md#sentinel2_query_get) | **GET** /sentinel2_query | Query the Google Sentinel2 archives using time interval, lat/lon coordinates, scene id and cloud cover.
*SatelliteImageAlgorithmsApi* | [**sentinel2a_aws_query_post**](docs/SatelliteImageAlgorithmsApi.md#sentinel2a_aws_query_post) | **POST** /sentinel2a_aws_query | Generate the download urls for a list of sentinel2A scenes and band numbers.
*TilingApi* | [**locations_location_name_mapsets_mapset_name_tiling_processes_get**](docs/TilingApi.md#locations_location_name_mapsets_mapset_name_tiling_processes_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/tiling_processes | Returns a list of all tiling prcesses
*TilingApi* | [**locations_location_name_mapsets_mapset_name_tiling_processes_grid_get**](docs/TilingApi.md#locations_location_name_mapsets_mapset_name_tiling_processes_grid_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/tiling_processes/grid | Get description of the grid tiling process.
*TilingApi* | [**locations_location_name_mapsets_mapset_name_tiling_processes_grid_post**](docs/TilingApi.md#locations_location_name_mapsets_mapset_name_tiling_processes_grid_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/tiling_processes/grid | Create grid tiles.
*UserManagementApi* | [**users_get**](docs/UserManagementApi.md#users_get) | **GET** /users | List all users in the database
*UserManagementApi* | [**users_user_id_delete**](docs/UserManagementApi.md#users_user_id_delete) | **DELETE** /users/{user_id} | Delete a specific user
*UserManagementApi* | [**users_user_id_get**](docs/UserManagementApi.md#users_user_id_get) | **GET** /users/{user_id} | Return the credentials of a single user
*UserManagementApi* | [**users_user_id_post**](docs/UserManagementApi.md#users_user_id_post) | **POST** /users/{user_id} | Create a user in the database
*VectorManagementApi* | [**locations_location_name_mapsets_mapset_name_vector_layers_delete**](docs/VectorManagementApi.md#locations_location_name_mapsets_mapset_name_vector_layers_delete) | **DELETE** /locations/{location_name}/mapsets/{mapset_name}/vector_layers | Delete a single vector map layer or a list of vector map layer names
*VectorManagementApi* | [**locations_location_name_mapsets_mapset_name_vector_layers_get**](docs/VectorManagementApi.md#locations_location_name_mapsets_mapset_name_vector_layers_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/vector_layers | Get a list of vector map layer names that are located in a specific
*VectorManagementApi* | [**locations_location_name_mapsets_mapset_name_vector_layers_put**](docs/VectorManagementApi.md#locations_location_name_mapsets_mapset_name_vector_layers_put) | **PUT** /locations/{location_name}/mapsets/{mapset_name}/vector_layers | Rename a single vector map layer or a list of vector map layers that
*VectorManagementApi* | [**locations_location_name_mapsets_mapset_name_vector_layers_vector_name_delete**](docs/VectorManagementApi.md#locations_location_name_mapsets_mapset_name_vector_layers_vector_name_delete) | **DELETE** /locations/{location_name}/mapsets/{mapset_name}/vector_layers/{vector_name} | Delete an existing vector map layer.
*VectorManagementApi* | [**locations_location_name_mapsets_mapset_name_vector_layers_vector_name_get**](docs/VectorManagementApi.md#locations_location_name_mapsets_mapset_name_vector_layers_vector_name_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/vector_layers/{vector_name} | Get information about an existing vector map layer.
*VectorManagementApi* | [**locations_location_name_mapsets_mapset_name_vector_layers_vector_name_post**](docs/VectorManagementApi.md#locations_location_name_mapsets_mapset_name_vector_layers_vector_name_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/vector_layers/{vector_name} | Create a new vector layer by uploading a GPKG, zipped Shapefile,
*VectorManagementApi* | [**locations_location_name_mapsets_mapset_name_vector_layers_vector_name_render_get**](docs/VectorManagementApi.md#locations_location_name_mapsets_mapset_name_vector_layers_vector_name_render_get) | **GET** /locations/{location_name}/mapsets/{mapset_name}/vector_layers/{vector_name}/render | Render a single vector map layer
*VectorSamplingApi* | [**locations_location_name_mapsets_mapset_name_vector_layers_vector_name_sampling_async_post**](docs/VectorSamplingApi.md#locations_location_name_mapsets_mapset_name_vector_layers_vector_name_sampling_async_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/vector_layers/{vector_name}/sampling_async | Perform vector map sampling on a vector map layer based on input
*VectorSamplingApi* | [**locations_location_name_mapsets_mapset_name_vector_layers_vector_name_sampling_sync_post**](docs/VectorSamplingApi.md#locations_location_name_mapsets_mapset_name_vector_layers_vector_name_sampling_sync_post) | **POST** /locations/{location_name}/mapsets/{mapset_name}/vector_layers/{vector_name}/sampling_sync | Perform vector map sampling on a vector map layer based on input


## Documentation For Models

 - [ApiInfoModel](docs/ApiInfoModel.md)
 - [ApiLogEntryModel](docs/ApiLogEntryModel.md)
 - [ApiLogListModel](docs/ApiLogListModel.md)
 - [AreaUnivarResultModel](docs/AreaUnivarResultModel.md)
 - [BandInformationEntry](docs/BandInformationEntry.md)
 - [CategoricalStatisticsResultModel](docs/CategoricalStatisticsResultModel.md)
 - [ExceptionTracebackModel](docs/ExceptionTracebackModel.md)
 - [GeodataResponseModel](docs/GeodataResponseModel.md)
 - [GrassModule](docs/GrassModule.md)
 - [GridTilingResponseModel](docs/GridTilingResponseModel.md)
 - [IOParameterBase](docs/IOParameterBase.md)
 - [InputParameter](docs/InputParameter.md)
 - [InputParameterImportDescr](docs/InputParameterImportDescr.md)
 - [LandsatNDVIResponseModel](docs/LandsatNDVIResponseModel.md)
 - [LandsatSceneListModel](docs/LandsatSceneListModel.md)
 - [LocationListResponseModel](docs/LocationListResponseModel.md)
 - [LockedMapsetListResponseModel](docs/LockedMapsetListResponseModel.md)
 - [MapsetInfoModel](docs/MapsetInfoModel.md)
 - [MapsetInfoResponseModel](docs/MapsetInfoResponseModel.md)
 - [MapsetLockManagementResponseModel](docs/MapsetLockManagementResponseModel.md)
 - [MapsetSizeResponseModel](docs/MapsetSizeResponseModel.md)
 - [MaxMapsetSizeResponseModel](docs/MaxMapsetSizeResponseModel.md)
 - [MergeListResponseModel](docs/MergeListResponseModel.md)
 - [MergeShortDescResponseModel](docs/MergeShortDescResponseModel.md)
 - [Module](docs/Module.md)
 - [ModuleExportDescription](docs/ModuleExportDescription.md)
 - [ModuleImportDescription](docs/ModuleImportDescription.md)
 - [ModuleList](docs/ModuleList.md)
 - [ModuleParameter](docs/ModuleParameter.md)
 - [ModuleParameterSchema](docs/ModuleParameterSchema.md)
 - [ModuleReturns](docs/ModuleReturns.md)
 - [OutputParameter](docs/OutputParameter.md)
 - [OutputParameterExport](docs/OutputParameterExport.md)
 - [OutputParameterMetadata](docs/OutputParameterMetadata.md)
 - [PointListModel](docs/PointListModel.md)
 - [ProcessChainModel](docs/ProcessChainModel.md)
 - [ProcessChainTemplate](docs/ProcessChainTemplate.md)
 - [ProcessChainTemplateTemplate](docs/ProcessChainTemplateTemplate.md)
 - [ProcessLogModel](docs/ProcessLogModel.md)
 - [ProcessingErrorResponseModel](docs/ProcessingErrorResponseModel.md)
 - [ProcessingResponseListModel](docs/ProcessingResponseListModel.md)
 - [ProcessingResponseModel](docs/ProcessingResponseModel.md)
 - [ProgressInfoModel](docs/ProgressInfoModel.md)
 - [ProjectionInfoModel](docs/ProjectionInfoModel.md)
 - [RasterAreaStatsResponseModel](docs/RasterAreaStatsResponseModel.md)
 - [RasterAreaUnivarStatsResponseModel](docs/RasterAreaUnivarStatsResponseModel.md)
 - [RasterColorModel](docs/RasterColorModel.md)
 - [RasterInfoModel](docs/RasterInfoModel.md)
 - [RasterInfoResponseModel](docs/RasterInfoResponseModel.md)
 - [RasterListEntryModel](docs/RasterListEntryModel.md)
 - [RasterSamplingResponseModel](docs/RasterSamplingResponseModel.md)
 - [RegionModel](docs/RegionModel.md)
 - [STRDSCreationModel](docs/STRDSCreationModel.md)
 - [STRDSInfoModel](docs/STRDSInfoModel.md)
 - [STRDSInfoResponseModel](docs/STRDSInfoResponseModel.md)
 - [STRDSRasterListEntryModel](docs/STRDSRasterListEntryModel.md)
 - [STRDSRasterListResponseModel](docs/STRDSRasterListResponseModel.md)
 - [STRDSSampleGeoJSONResponseModel](docs/STRDSSampleGeoJSONResponseModel.md)
 - [STRDSSampleResponseModel](docs/STRDSSampleResponseModel.md)
 - [SatelliteSceneEntry](docs/SatelliteSceneEntry.md)
 - [SatelliteSceneList](docs/SatelliteSceneList.md)
 - [Sentinel2ASceneEntry](docs/Sentinel2ASceneEntry.md)
 - [Sentinel2ASceneList](docs/Sentinel2ASceneList.md)
 - [Sentinel2ASceneListModel](docs/Sentinel2ASceneListModel.md)
 - [Sentinel2ATileEntry](docs/Sentinel2ATileEntry.md)
 - [SentinelNDVIResponseModel](docs/SentinelNDVIResponseModel.md)
 - [SetRegionModel](docs/SetRegionModel.md)
 - [SimpleResponseModel](docs/SimpleResponseModel.md)
 - [SimpleStatusCodeResponseModel](docs/SimpleStatusCodeResponseModel.md)
 - [StacCollectionsPost400Response](docs/StacCollectionsPost400Response.md)
 - [StacCollectionsPostRequest](docs/StacCollectionsPostRequest.md)
 - [StacCollectionsStacCollectionIdDelete400Response](docs/StacCollectionsStacCollectionIdDelete400Response.md)
 - [StacCollectionsStacCollectionIdGet400Response](docs/StacCollectionsStacCollectionIdGet400Response.md)
 - [StacInstancesPost400Response](docs/StacInstancesPost400Response.md)
 - [StacInstancesPostRequest](docs/StacInstancesPostRequest.md)
 - [StacInstancesStacInstanceIdDelete400Response](docs/StacInstancesStacInstanceIdDelete400Response.md)
 - [StacInstancesStacInstanceIdGet400Response](docs/StacInstancesStacInstanceIdGet400Response.md)
 - [StdoutParser](docs/StdoutParser.md)
 - [StorageModel](docs/StorageModel.md)
 - [StorageResponseModel](docs/StorageResponseModel.md)
 - [StringListProcessingResultResponseModel](docs/StringListProcessingResultResponseModel.md)
 - [TilingListResponseModel](docs/TilingListResponseModel.md)
 - [TilingShortDescResponseModel](docs/TilingShortDescResponseModel.md)
 - [TokenResponseModel](docs/TokenResponseModel.md)
 - [UnivarResultModel](docs/UnivarResultModel.md)
 - [UrlModel](docs/UrlModel.md)
 - [UserInfoResponseModel](docs/UserInfoResponseModel.md)
 - [UserInfoResponseModelPermissions](docs/UserInfoResponseModelPermissions.md)
 - [UserListResponseModel](docs/UserListResponseModel.md)
 - [VectorAttributeModel](docs/VectorAttributeModel.md)
 - [VectorCreationModel](docs/VectorCreationModel.md)
 - [VectorInfoModel](docs/VectorInfoModel.md)
 - [VectorInfoResponseModel](docs/VectorInfoResponseModel.md)
 - [VectorRegionCreationModel](docs/VectorRegionCreationModel.md)
 - [VectorSamplingResponseModel](docs/VectorSamplingResponseModel.md)
 - [Webhooks](docs/Webhooks.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="basicAuth"></a>
### basicAuth

- **Type**: HTTP basic authentication


## Author




