# coding: utf-8

"""
    Actinia

     ================================ Actinia - The GRASS GIS REST API ================================  **Actinia** is an open source REST API for scalable, distributed, high performance processing of geographical data that uses GRASS GIS for computational tasks.  It provides a REST API to process satellite images, time series of satellite images, arbitrary raster data with geographical relations and vector data.  The REST interface allows to access, manage and manipulate the GRASS GIS database via HTTP GET,PUT,POST and DELETE requests and to process raster, vector and time series data located in a persistent GRASS GIS database. **Actinia** allows the processing of cloud based data, for example all Landsat 4-8 scenes as well as all Sentinel2A scenes in an ephemeral databases. The computational results of ephemeral processing are available via object storage as GeoTIFF files.  The full API documentation is available here: https://redocly.github.io/redoc/?url=https://actinia.mundialis.de/latest/ swagger.json   Examples: ---------  To execute the examples, first setup login information, IP address and port:      export ACTINIA_URL=https://actinia.mundialis.de/latest     export AUTH='-u demouser:gu3st!pa55w0rd'  **Data management**  - List all locations that are available in the actinia persistent database:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations\"  - List all mapsets in the location latlong_wgs84:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets\"  - List all raster layers in location latlong_wgs84 and mapset Sentinel2A      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets/Sentinel2A/raster_layers\"  - List all space-time raster datasets (STRDS) in location ECAD and mapset   PERMANENT:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/raster_layers\"  - List all raster map layers of the STRDS precipitation_1950_2013_yearly_mm:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/strds/precipitation_    1950_2013_yearly_mm/raster_layers\"  **Landsat and Sentinel2A NDVI computation**  This API call will compute the NDVI of the top of atmosphere (TOAR) corrected Landsat4 scene LC80440342016259LGN00:      curl ${AUTH} -X POST \"${ACTINIA_URL}/landsat_process/    LC80440342016259LGN00/TOAR/NDVI\"  NDVI computation of Sentinel2A scene S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138:      curl ${AUTH} -X POST \"${ACTINIA_URL}/sentinel2_process/ndvi/    S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138\"  The results of the asynchronous computations are available as GeoTIFF file in a cloud storage for download. 

    The version of the OpenAPI document: v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import io
import warnings

from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Dict, List, Optional, Tuple, Union, Any

try:
    from typing import Annotated
except ImportError:
    from typing_extensions import Annotated

from pydantic import Field
from typing_extensions import Annotated
from pydantic import StrictFloat, StrictInt, StrictStr

from typing import Optional, Union

from actinia_openapi_python_client.models.processing_response_model import ProcessingResponseModel
from actinia_openapi_python_client.models.raster_color_model import RasterColorModel
from actinia_openapi_python_client.models.raster_info_response_model import RasterInfoResponseModel
from actinia_openapi_python_client.models.string_list_processing_result_response_model import StringListProcessingResultResponseModel

from actinia_openapi_python_client.api_client import ApiClient
from actinia_openapi_python_client.api_response import ApiResponse
from actinia_openapi_python_client.rest import RESTResponseType


class RasterManagementApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_delete(
        self,
        location_name: Annotated[StrictStr, Field(description="The name of the location that should be accessed")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset from which the raster map layers should be deleted")],
        pattern: Annotated[Optional[StrictStr], Field(description="A parameter passed for g.remove to remove a list of raster map layers, to remove all eg.: http://<url>?pattern=\"*\"")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ProcessingResponseModel:
        """Delete a single raster map layer or a list of raster map layer names

        Delete a single raster map layer or a list of raster map layer names that are located in a specific location/mapset. Minimum required user role: user.

        :param location_name: The name of the location that should be accessed (required)
        :type location_name: str
        :param mapset_name: The name of the mapset from which the raster map layers should be deleted (required)
        :type mapset_name: str
        :param pattern: A parameter passed for g.remove to remove a list of raster map layers, to remove all eg.: http://<url>?pattern=\"*\"
        :type pattern: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_delete_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            pattern=pattern,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_delete_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The name of the location that should be accessed")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset from which the raster map layers should be deleted")],
        pattern: Annotated[Optional[StrictStr], Field(description="A parameter passed for g.remove to remove a list of raster map layers, to remove all eg.: http://<url>?pattern=\"*\"")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ProcessingResponseModel]:
        """Delete a single raster map layer or a list of raster map layer names

        Delete a single raster map layer or a list of raster map layer names that are located in a specific location/mapset. Minimum required user role: user.

        :param location_name: The name of the location that should be accessed (required)
        :type location_name: str
        :param mapset_name: The name of the mapset from which the raster map layers should be deleted (required)
        :type mapset_name: str
        :param pattern: A parameter passed for g.remove to remove a list of raster map layers, to remove all eg.: http://<url>?pattern=\"*\"
        :type pattern: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_delete_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            pattern=pattern,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_delete_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The name of the location that should be accessed")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset from which the raster map layers should be deleted")],
        pattern: Annotated[Optional[StrictStr], Field(description="A parameter passed for g.remove to remove a list of raster map layers, to remove all eg.: http://<url>?pattern=\"*\"")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a single raster map layer or a list of raster map layer names

        Delete a single raster map layer or a list of raster map layer names that are located in a specific location/mapset. Minimum required user role: user.

        :param location_name: The name of the location that should be accessed (required)
        :type location_name: str
        :param mapset_name: The name of the mapset from which the raster map layers should be deleted (required)
        :type mapset_name: str
        :param pattern: A parameter passed for g.remove to remove a list of raster map layers, to remove all eg.: http://<url>?pattern=\"*\"
        :type pattern: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_delete_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            pattern=pattern,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_raster_layers_delete_serialize(
        self,
        location_name,
        mapset_name,
        pattern,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        # process the query parameters
        if pattern is not None:
            
            _query_params.append(('pattern', pattern))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/raster_layers',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_get(
        self,
        location_name: Annotated[StrictStr, Field(description="The name of the location that should be accessed")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset from which the raster map layers should be listed")],
        pattern: Annotated[Optional[StrictStr], Field(description="A parameter passed to g.list for raster map layer selection, eg.: http://<url>?pattern=\"*\"")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> StringListProcessingResultResponseModel:
        """Get a list of raster map layer names that are located in a specific

        Get a list of raster map layer names that are located in a specific location/mapset. Minimum required user role: user.

        :param location_name: The name of the location that should be accessed (required)
        :type location_name: str
        :param mapset_name: The name of the mapset from which the raster map layers should be listed (required)
        :type mapset_name: str
        :param pattern: A parameter passed to g.list for raster map layer selection, eg.: http://<url>?pattern=\"*\"
        :type pattern: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            pattern=pattern,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StringListProcessingResultResponseModel",
            '400': "ProcessingResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_get_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The name of the location that should be accessed")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset from which the raster map layers should be listed")],
        pattern: Annotated[Optional[StrictStr], Field(description="A parameter passed to g.list for raster map layer selection, eg.: http://<url>?pattern=\"*\"")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[StringListProcessingResultResponseModel]:
        """Get a list of raster map layer names that are located in a specific

        Get a list of raster map layer names that are located in a specific location/mapset. Minimum required user role: user.

        :param location_name: The name of the location that should be accessed (required)
        :type location_name: str
        :param mapset_name: The name of the mapset from which the raster map layers should be listed (required)
        :type mapset_name: str
        :param pattern: A parameter passed to g.list for raster map layer selection, eg.: http://<url>?pattern=\"*\"
        :type pattern: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            pattern=pattern,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StringListProcessingResultResponseModel",
            '400': "ProcessingResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_get_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The name of the location that should be accessed")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset from which the raster map layers should be listed")],
        pattern: Annotated[Optional[StrictStr], Field(description="A parameter passed to g.list for raster map layer selection, eg.: http://<url>?pattern=\"*\"")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a list of raster map layer names that are located in a specific

        Get a list of raster map layer names that are located in a specific location/mapset. Minimum required user role: user.

        :param location_name: The name of the location that should be accessed (required)
        :type location_name: str
        :param mapset_name: The name of the mapset from which the raster map layers should be listed (required)
        :type mapset_name: str
        :param pattern: A parameter passed to g.list for raster map layer selection, eg.: http://<url>?pattern=\"*\"
        :type pattern: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            pattern=pattern,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StringListProcessingResultResponseModel",
            '400': "ProcessingResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_raster_layers_get_serialize(
        self,
        location_name,
        mapset_name,
        pattern,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        # process the query parameters
        if pattern is not None:
            
            _query_params.append(('pattern', pattern))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/raster_layers',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_put(
        self,
        location_name: Annotated[StrictStr, Field(description="The name of the location that should be accessed")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset from which the raster map layers should be renamed")],
        rename_list: Annotated[StrictStr, Field(description="A list of raster name tuples [(a, a_new),(b, b_new),(c, c_new), ...]")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ProcessingResponseModel:
        """Rename a single raster map layer or a list of raster map layers that

        Rename a single raster map layer or a list of raster map layers that are located in a specific location/mapset. Minimum required user role: user.

        :param location_name: The name of the location that should be accessed (required)
        :type location_name: str
        :param mapset_name: The name of the mapset from which the raster map layers should be renamed (required)
        :type mapset_name: str
        :param rename_list: A list of raster name tuples [(a, a_new),(b, b_new),(c, c_new), ...] (required)
        :type rename_list: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_put_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            rename_list=rename_list,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_put_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The name of the location that should be accessed")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset from which the raster map layers should be renamed")],
        rename_list: Annotated[StrictStr, Field(description="A list of raster name tuples [(a, a_new),(b, b_new),(c, c_new), ...]")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ProcessingResponseModel]:
        """Rename a single raster map layer or a list of raster map layers that

        Rename a single raster map layer or a list of raster map layers that are located in a specific location/mapset. Minimum required user role: user.

        :param location_name: The name of the location that should be accessed (required)
        :type location_name: str
        :param mapset_name: The name of the mapset from which the raster map layers should be renamed (required)
        :type mapset_name: str
        :param rename_list: A list of raster name tuples [(a, a_new),(b, b_new),(c, c_new), ...] (required)
        :type rename_list: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_put_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            rename_list=rename_list,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_put_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The name of the location that should be accessed")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset from which the raster map layers should be renamed")],
        rename_list: Annotated[StrictStr, Field(description="A list of raster name tuples [(a, a_new),(b, b_new),(c, c_new), ...]")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Rename a single raster map layer or a list of raster map layers that

        Rename a single raster map layer or a list of raster map layers that are located in a specific location/mapset. Minimum required user role: user.

        :param location_name: The name of the location that should be accessed (required)
        :type location_name: str
        :param mapset_name: The name of the mapset from which the raster map layers should be renamed (required)
        :type mapset_name: str
        :param rename_list: A list of raster name tuples [(a, a_new),(b, b_new),(c, c_new), ...] (required)
        :type rename_list: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_put_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            rename_list=rename_list,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_raster_layers_put_serialize(
        self,
        location_name,
        mapset_name,
        rename_list,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if rename_list is not None:
            _body_params = rename_list


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/gml+xml', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/raster_layers',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_colors_get(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to get the color table from")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> StringListProcessingResultResponseModel:
        """Get the color definition of an existing raster map layer.

        Get the color definition of an existing raster map layer. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to get the color table from (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_colors_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StringListProcessingResultResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_colors_get_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to get the color table from")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[StringListProcessingResultResponseModel]:
        """Get the color definition of an existing raster map layer.

        Get the color definition of an existing raster map layer. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to get the color table from (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_colors_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StringListProcessingResultResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_colors_get_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to get the color table from")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get the color definition of an existing raster map layer.

        Get the color definition of an existing raster map layer. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to get the color table from (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_colors_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StringListProcessingResultResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_raster_layers_raster_name_colors_get_serialize(
        self,
        location_name,
        mapset_name,
        raster_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        if raster_name is not None:
            _path_params['raster_name'] = raster_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}/colors',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_colors_post(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to set the color table")],
        color: Annotated[RasterColorModel, Field(description="The color definition.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ProcessingResponseModel:
        """Set the color definition for an existing raster map layer.

        Set the color definition for an existing raster map layer. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to set the color table (required)
        :type raster_name: str
        :param color: The color definition. (required)
        :type color: RasterColorModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_colors_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            color=color,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_colors_post_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to set the color table")],
        color: Annotated[RasterColorModel, Field(description="The color definition.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ProcessingResponseModel]:
        """Set the color definition for an existing raster map layer.

        Set the color definition for an existing raster map layer. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to set the color table (required)
        :type raster_name: str
        :param color: The color definition. (required)
        :type color: RasterColorModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_colors_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            color=color,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_colors_post_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to set the color table")],
        color: Annotated[RasterColorModel, Field(description="The color definition.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Set the color definition for an existing raster map layer.

        Set the color definition for an existing raster map layer. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to set the color table (required)
        :type raster_name: str
        :param color: The color definition. (required)
        :type color: RasterColorModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_colors_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            color=color,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_raster_layers_raster_name_colors_post_serialize(
        self,
        location_name,
        mapset_name,
        raster_name,
        color,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        if raster_name is not None:
            _path_params['raster_name'] = raster_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if color is not None:
            _body_params = color


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}/colors',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_delete(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to be deleted")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ProcessingResponseModel:
        """Delete an existing raster map layer.

        Delete an existing raster map layer. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to be deleted (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_delete_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_delete_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to be deleted")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ProcessingResponseModel]:
        """Delete an existing raster map layer.

        Delete an existing raster map layer. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to be deleted (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_delete_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_delete_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to be deleted")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete an existing raster map layer.

        Delete an existing raster map layer. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to be deleted (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_delete_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_raster_layers_raster_name_delete_serialize(
        self,
        location_name,
        mapset_name,
        raster_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        if raster_name is not None:
            _path_params['raster_name'] = raster_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_geotiff_async_orig_post(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to export")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ProcessingResponseModel:
        """Export an existing raster map layer as GeoTiff using the raster

        Export an existing raster map layer as GTiff or COG (if COG driver available). The link to the exported raster map layer is located in the JSON response. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to export (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_geotiff_async_orig_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_geotiff_async_orig_post_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to export")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ProcessingResponseModel]:
        """Export an existing raster map layer as GeoTiff using the raster

        Export an existing raster map layer as GTiff or COG (if COG driver available). The link to the exported raster map layer is located in the JSON response. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to export (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_geotiff_async_orig_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_geotiff_async_orig_post_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to export")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Export an existing raster map layer as GeoTiff using the raster

        Export an existing raster map layer as GTiff or COG (if COG driver available). The link to the exported raster map layer is located in the JSON response. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to export (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_geotiff_async_orig_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_raster_layers_raster_name_geotiff_async_orig_post_serialize(
        self,
        location_name,
        mapset_name,
        raster_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        if raster_name is not None:
            _path_params['raster_name'] = raster_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}/geotiff_async_orig',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_geotiff_async_post(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to export")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ProcessingResponseModel:
        """Export an existing raster map layer as GeoTiff.

        Export an existing raster map layer as GTiff or COG (if COG driver available). The link to the exported raster map layer is located in the JSON response.The current region settings of the mapset are used to export the raster layer. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to export (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_geotiff_async_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_geotiff_async_post_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to export")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ProcessingResponseModel]:
        """Export an existing raster map layer as GeoTiff.

        Export an existing raster map layer as GTiff or COG (if COG driver available). The link to the exported raster map layer is located in the JSON response.The current region settings of the mapset are used to export the raster layer. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to export (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_geotiff_async_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_geotiff_async_post_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to export")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Export an existing raster map layer as GeoTiff.

        Export an existing raster map layer as GTiff or COG (if COG driver available). The link to the exported raster map layer is located in the JSON response.The current region settings of the mapset are used to export the raster layer. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to export (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_geotiff_async_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_raster_layers_raster_name_geotiff_async_post_serialize(
        self,
        location_name,
        mapset_name,
        raster_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        if raster_name is not None:
            _path_params['raster_name'] = raster_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}/geotiff_async',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_get(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to get information about")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RasterInfoResponseModel:
        """Get information about an existing raster map layer.

        Get information about an existing raster map layer. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to get information about (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RasterInfoResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_get_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to get information about")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RasterInfoResponseModel]:
        """Get information about an existing raster map layer.

        Get information about an existing raster map layer. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to get information about (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RasterInfoResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_get_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to get information about")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get information about an existing raster map layer.

        Get information about an existing raster map layer. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to get information about (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RasterInfoResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_raster_layers_raster_name_get_serialize(
        self,
        location_name,
        mapset_name,
        raster_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        if raster_name is not None:
            _path_params['raster_name'] = raster_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_legend_get(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer of which the legend should be rendered")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Render the legend of a raster map layer as a PNG image.

        Render the legend of a raster map layer as a PNG image. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer of which the legend should be rendered (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_legend_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_legend_get_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer of which the legend should be rendered")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Render the legend of a raster map layer as a PNG image.

        Render the legend of a raster map layer as a PNG image. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer of which the legend should be rendered (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_legend_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_legend_get_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer of which the legend should be rendered")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Render the legend of a raster map layer as a PNG image.

        Render the legend of a raster map layer as a PNG image. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer of which the legend should be rendered (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_legend_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_raster_layers_raster_name_legend_get_serialize(
        self,
        location_name,
        mapset_name,
        raster_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        if raster_name is not None:
            _path_params['raster_name'] = raster_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'image/png'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}/legend',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_post(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset in which the raster map layer should be created")],
        raster_name: Annotated[StrictStr, Field(description="The name of the new raster map layer to be created")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ProcessingResponseModel:
        """Create a new raster layer by uploading a GeoTIFF

        Create a new raster map layer by uploading a GeoTIFF. This method will fail if the map already exists. An example request is 'curl -L -u \"XXX:XXX\" -X POST -H \"Content-Type: multipart/form-data\" -F \"file=@/home/....tif\" http://localhost:8088/api/v3/locations/nc_spm_08/mapsets/test_mapset/raster_layers/testraster'. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset in which the raster map layer should be created (required)
        :type mapset_name: str
        :param raster_name: The name of the new raster map layer to be created (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_post_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset in which the raster map layer should be created")],
        raster_name: Annotated[StrictStr, Field(description="The name of the new raster map layer to be created")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ProcessingResponseModel]:
        """Create a new raster layer by uploading a GeoTIFF

        Create a new raster map layer by uploading a GeoTIFF. This method will fail if the map already exists. An example request is 'curl -L -u \"XXX:XXX\" -X POST -H \"Content-Type: multipart/form-data\" -F \"file=@/home/....tif\" http://localhost:8088/api/v3/locations/nc_spm_08/mapsets/test_mapset/raster_layers/testraster'. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset in which the raster map layer should be created (required)
        :type mapset_name: str
        :param raster_name: The name of the new raster map layer to be created (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_post_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset in which the raster map layer should be created")],
        raster_name: Annotated[StrictStr, Field(description="The name of the new raster map layer to be created")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a new raster layer by uploading a GeoTIFF

        Create a new raster map layer by uploading a GeoTIFF. This method will fail if the map already exists. An example request is 'curl -L -u \"XXX:XXX\" -X POST -H \"Content-Type: multipart/form-data\" -F \"file=@/home/....tif\" http://localhost:8088/api/v3/locations/nc_spm_08/mapsets/test_mapset/raster_layers/testraster'. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset in which the raster map layer should be created (required)
        :type mapset_name: str
        :param raster_name: The name of the new raster map layer to be created (required)
        :type raster_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_raster_layers_raster_name_post_serialize(
        self,
        location_name,
        mapset_name,
        raster_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        if raster_name is not None:
            _path_params['raster_name'] = raster_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_render_get(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to render")],
        n: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Northern border")] = None,
        s: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Southern border")] = None,
        e: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Eastern border")] = None,
        w: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Western border")] = None,
        width: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Image width in pixel, default is 800")] = None,
        height: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Image height in pixel, default is 600")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Render a raster map layer as a PNG image.

        Render a raster map layer as a PNG image. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to render (required)
        :type raster_name: str
        :param n: Northern border
        :type n: float
        :param s: Southern border
        :type s: float
        :param e: Eastern border
        :type e: float
        :param w: Western border
        :type w: float
        :param width: Image width in pixel, default is 800
        :type width: float
        :param height: Image height in pixel, default is 600
        :type height: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_render_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            n=n,
            s=s,
            e=e,
            w=w,
            width=width,
            height=height,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_render_get_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to render")],
        n: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Northern border")] = None,
        s: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Southern border")] = None,
        e: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Eastern border")] = None,
        w: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Western border")] = None,
        width: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Image width in pixel, default is 800")] = None,
        height: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Image height in pixel, default is 600")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Render a raster map layer as a PNG image.

        Render a raster map layer as a PNG image. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to render (required)
        :type raster_name: str
        :param n: Northern border
        :type n: float
        :param s: Southern border
        :type s: float
        :param e: Eastern border
        :type e: float
        :param w: Western border
        :type w: float
        :param width: Image width in pixel, default is 800
        :type width: float
        :param height: Image height in pixel, default is 600
        :type height: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_render_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            n=n,
            s=s,
            e=e,
            w=w,
            width=width,
            height=height,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_raster_layers_raster_name_render_get_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        raster_name: Annotated[StrictStr, Field(description="The name of the raster map layer to render")],
        n: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Northern border")] = None,
        s: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Southern border")] = None,
        e: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Eastern border")] = None,
        w: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Western border")] = None,
        width: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Image width in pixel, default is 800")] = None,
        height: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Image height in pixel, default is 600")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Render a raster map layer as a PNG image.

        Render a raster map layer as a PNG image. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param raster_name: The name of the raster map layer to render (required)
        :type raster_name: str
        :param n: Northern border
        :type n: float
        :param s: Southern border
        :type s: float
        :param e: Eastern border
        :type e: float
        :param w: Western border
        :type w: float
        :param width: Image width in pixel, default is 800
        :type width: float
        :param height: Image height in pixel, default is 600
        :type height: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_raster_layers_raster_name_render_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            raster_name=raster_name,
            n=n,
            s=s,
            e=e,
            w=w,
            width=width,
            height=height,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_raster_layers_raster_name_render_get_serialize(
        self,
        location_name,
        mapset_name,
        raster_name,
        n,
        s,
        e,
        w,
        width,
        height,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        if raster_name is not None:
            _path_params['raster_name'] = raster_name
        # process the query parameters
        if n is not None:
            
            _query_params.append(('n', n))
            
        if s is not None:
            
            _query_params.append(('s', s))
            
        if e is not None:
            
            _query_params.append(('e', e))
            
        if w is not None:
            
            _query_params.append(('w', w))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'image/png'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/raster_layers/{raster_name}/render',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_mapsets_mapset_name_render_rgb_get(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        red: Annotated[StrictStr, Field(description="The name of the raster map layer to render as color red")],
        green: Annotated[StrictStr, Field(description="The name of the raster map layer to render as color green")],
        blue: Annotated[StrictStr, Field(description="The name of the raster map layer to render as color blue")],
        n: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Northern border")] = None,
        s: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Southern border")] = None,
        e: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Eastern border")] = None,
        w: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Western border")] = None,
        width: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Image width in pixel, default is 800")] = None,
        height: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Image height in pixel, default is 600")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Render three raster map layer as composed RGB PNG image.

        Render three raster map layer as composed RGB PNG image. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param red: The name of the raster map layer to render as color red (required)
        :type red: str
        :param green: The name of the raster map layer to render as color green (required)
        :type green: str
        :param blue: The name of the raster map layer to render as color blue (required)
        :type blue: str
        :param n: Northern border
        :type n: float
        :param s: Southern border
        :type s: float
        :param e: Eastern border
        :type e: float
        :param w: Western border
        :type w: float
        :param width: Image width in pixel, default is 800
        :type width: float
        :param height: Image height in pixel, default is 600
        :type height: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_render_rgb_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            red=red,
            green=green,
            blue=blue,
            n=n,
            s=s,
            e=e,
            w=w,
            width=width,
            height=height,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_render_rgb_get_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        red: Annotated[StrictStr, Field(description="The name of the raster map layer to render as color red")],
        green: Annotated[StrictStr, Field(description="The name of the raster map layer to render as color green")],
        blue: Annotated[StrictStr, Field(description="The name of the raster map layer to render as color blue")],
        n: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Northern border")] = None,
        s: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Southern border")] = None,
        e: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Eastern border")] = None,
        w: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Western border")] = None,
        width: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Image width in pixel, default is 800")] = None,
        height: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Image height in pixel, default is 600")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Render three raster map layer as composed RGB PNG image.

        Render three raster map layer as composed RGB PNG image. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param red: The name of the raster map layer to render as color red (required)
        :type red: str
        :param green: The name of the raster map layer to render as color green (required)
        :type green: str
        :param blue: The name of the raster map layer to render as color blue (required)
        :type blue: str
        :param n: Northern border
        :type n: float
        :param s: Southern border
        :type s: float
        :param e: Eastern border
        :type e: float
        :param w: Western border
        :type w: float
        :param width: Image width in pixel, default is 800
        :type width: float
        :param height: Image height in pixel, default is 600
        :type height: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_render_rgb_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            red=red,
            green=green,
            blue=blue,
            n=n,
            s=s,
            e=e,
            w=w,
            width=width,
            height=height,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_render_rgb_get_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        red: Annotated[StrictStr, Field(description="The name of the raster map layer to render as color red")],
        green: Annotated[StrictStr, Field(description="The name of the raster map layer to render as color green")],
        blue: Annotated[StrictStr, Field(description="The name of the raster map layer to render as color blue")],
        n: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Northern border")] = None,
        s: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Southern border")] = None,
        e: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Eastern border")] = None,
        w: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Western border")] = None,
        width: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Image width in pixel, default is 800")] = None,
        height: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Image height in pixel, default is 600")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Render three raster map layer as composed RGB PNG image.

        Render three raster map layer as composed RGB PNG image. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param red: The name of the raster map layer to render as color red (required)
        :type red: str
        :param green: The name of the raster map layer to render as color green (required)
        :type green: str
        :param blue: The name of the raster map layer to render as color blue (required)
        :type blue: str
        :param n: Northern border
        :type n: float
        :param s: Southern border
        :type s: float
        :param e: Eastern border
        :type e: float
        :param w: Western border
        :type w: float
        :param width: Image width in pixel, default is 800
        :type width: float
        :param height: Image height in pixel, default is 600
        :type height: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_render_rgb_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            red=red,
            green=green,
            blue=blue,
            n=n,
            s=s,
            e=e,
            w=w,
            width=width,
            height=height,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_render_rgb_get_serialize(
        self,
        location_name,
        mapset_name,
        red,
        green,
        blue,
        n,
        s,
        e,
        w,
        width,
        height,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        # process the query parameters
        if red is not None:
            
            _query_params.append(('red', red))
            
        if green is not None:
            
            _query_params.append(('green', green))
            
        if blue is not None:
            
            _query_params.append(('blue', blue))
            
        if n is not None:
            
            _query_params.append(('n', n))
            
        if s is not None:
            
            _query_params.append(('s', s))
            
        if e is not None:
            
            _query_params.append(('e', e))
            
        if w is not None:
            
            _query_params.append(('w', w))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'image/png'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/render_rgb',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_mapsets_mapset_name_render_shade_get(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        shade: Annotated[StrictStr, Field(description="The name of the raster map layer to be used for shading")],
        color: Annotated[StrictStr, Field(description="The name of the raster map layer to be used for coloring")],
        n: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Northern border")] = None,
        s: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Southern border")] = None,
        e: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Eastern border")] = None,
        w: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Western border")] = None,
        width: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Image width in pixel, default is 800")] = None,
        height: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Image height in pixel, default is 600")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Render two raster layers as a composed shade PNG image

        Render two raster layers as a composed shade PNG image. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param shade: The name of the raster map layer to be used for shading (required)
        :type shade: str
        :param color: The name of the raster map layer to be used for coloring (required)
        :type color: str
        :param n: Northern border
        :type n: float
        :param s: Southern border
        :type s: float
        :param e: Eastern border
        :type e: float
        :param w: Western border
        :type w: float
        :param width: Image width in pixel, default is 800
        :type width: float
        :param height: Image height in pixel, default is 600
        :type height: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_render_shade_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            shade=shade,
            color=color,
            n=n,
            s=s,
            e=e,
            w=w,
            width=width,
            height=height,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_render_shade_get_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        shade: Annotated[StrictStr, Field(description="The name of the raster map layer to be used for shading")],
        color: Annotated[StrictStr, Field(description="The name of the raster map layer to be used for coloring")],
        n: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Northern border")] = None,
        s: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Southern border")] = None,
        e: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Eastern border")] = None,
        w: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Western border")] = None,
        width: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Image width in pixel, default is 800")] = None,
        height: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Image height in pixel, default is 600")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Render two raster layers as a composed shade PNG image

        Render two raster layers as a composed shade PNG image. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param shade: The name of the raster map layer to be used for shading (required)
        :type shade: str
        :param color: The name of the raster map layer to be used for coloring (required)
        :type color: str
        :param n: Northern border
        :type n: float
        :param s: Southern border
        :type s: float
        :param e: Eastern border
        :type e: float
        :param w: Western border
        :type w: float
        :param width: Image width in pixel, default is 800
        :type width: float
        :param height: Image height in pixel, default is 600
        :type height: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_render_shade_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            shade=shade,
            color=color,
            n=n,
            s=s,
            e=e,
            w=w,
            width=width,
            height=height,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_render_shade_get_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset that contains the required raster map layer")],
        shade: Annotated[StrictStr, Field(description="The name of the raster map layer to be used for shading")],
        color: Annotated[StrictStr, Field(description="The name of the raster map layer to be used for coloring")],
        n: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Northern border")] = None,
        s: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Southern border")] = None,
        e: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Eastern border")] = None,
        w: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Western border")] = None,
        width: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Image width in pixel, default is 800")] = None,
        height: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Image height in pixel, default is 600")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Render two raster layers as a composed shade PNG image

        Render two raster layers as a composed shade PNG image. Minimum required user role: user.

        :param location_name: The location name (required)
        :type location_name: str
        :param mapset_name: The name of the mapset that contains the required raster map layer (required)
        :type mapset_name: str
        :param shade: The name of the raster map layer to be used for shading (required)
        :type shade: str
        :param color: The name of the raster map layer to be used for coloring (required)
        :type color: str
        :param n: Northern border
        :type n: float
        :param s: Southern border
        :type s: float
        :param e: Eastern border
        :type e: float
        :param w: Western border
        :type w: float
        :param width: Image width in pixel, default is 800
        :type width: float
        :param height: Image height in pixel, default is 600
        :type height: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_render_shade_get_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            shade=shade,
            color=color,
            n=n,
            s=s,
            e=e,
            w=w,
            width=width,
            height=height,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_render_shade_get_serialize(
        self,
        location_name,
        mapset_name,
        shade,
        color,
        n,
        s,
        e,
        w,
        width,
        height,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        # process the query parameters
        if shade is not None:
            
            _query_params.append(('shade', shade))
            
        if color is not None:
            
            _query_params.append(('color', color))
            
        if n is not None:
            
            _query_params.append(('n', n))
            
        if s is not None:
            
            _query_params.append(('s', s))
            
        if e is not None:
            
            _query_params.append(('e', e))
            
        if w is not None:
            
            _query_params.append(('w', w))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'image/png'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/render_shade',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


