# coding: utf-8

"""
    Actinia

     ================================ Actinia - The GRASS GIS REST API ================================  **Actinia** is an open source REST API for scalable, distributed, high performance processing of geographical data that uses GRASS GIS for computational tasks.  It provides a REST API to process satellite images, time series of satellite images, arbitrary raster data with geographical relations and vector data.  The REST interface allows to access, manage and manipulate the GRASS GIS database via HTTP GET,PUT,POST and DELETE requests and to process raster, vector and time series data located in a persistent GRASS GIS database. **Actinia** allows the processing of cloud based data, for example all Landsat 4-8 scenes as well as all Sentinel2A scenes in an ephemeral databases. The computational results of ephemeral processing are available via object storage as GeoTIFF files.  The full API documentation is available here: https://redocly.github.io/redoc/?url=https://actinia.mundialis.de/latest/ swagger.json   Examples: ---------  To execute the examples, first setup login information, IP address and port:      export ACTINIA_URL=https://actinia.mundialis.de/latest     export AUTH='-u demouser:gu3st!pa55w0rd'  **Data management**  - List all locations that are available in the actinia persistent database:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations\"  - List all mapsets in the location latlong_wgs84:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets\"  - List all raster layers in location latlong_wgs84 and mapset Sentinel2A      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets/Sentinel2A/raster_layers\"  - List all space-time raster datasets (STRDS) in location ECAD and mapset   PERMANENT:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/raster_layers\"  - List all raster map layers of the STRDS precipitation_1950_2013_yearly_mm:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/strds/precipitation_    1950_2013_yearly_mm/raster_layers\"  **Landsat and Sentinel2A NDVI computation**  This API call will compute the NDVI of the top of atmosphere (TOAR) corrected Landsat4 scene LC80440342016259LGN00:      curl ${AUTH} -X POST \"${ACTINIA_URL}/landsat_process/    LC80440342016259LGN00/TOAR/NDVI\"  NDVI computation of Sentinel2A scene S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138:      curl ${AUTH} -X POST \"${ACTINIA_URL}/sentinel2_process/ndvi/    S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138\"  The results of the asynchronous computations are available as GeoTIFF file in a cloud storage for download. 

    The version of the OpenAPI document: v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import io
import warnings

from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Dict, List, Optional, Tuple, Union, Any

try:
    from typing import Annotated
except ImportError:
    from typing_extensions import Annotated

from pydantic import Field
from typing_extensions import Annotated
from pydantic import StrictFloat, StrictInt, StrictStr, field_validator

from typing import Optional, Union

from actinia_openapi_python_client.models.landsat_ndvi_response_model import LandsatNDVIResponseModel
from actinia_openapi_python_client.models.landsat_scene_list_model import LandsatSceneListModel
from actinia_openapi_python_client.models.processing_response_model import ProcessingResponseModel
from actinia_openapi_python_client.models.satellite_scene_list import SatelliteSceneList
from actinia_openapi_python_client.models.sentinel2_a_scene_list import Sentinel2ASceneList
from actinia_openapi_python_client.models.sentinel2_a_scene_list_model import Sentinel2ASceneListModel
from actinia_openapi_python_client.models.sentinel_ndvi_response_model import SentinelNDVIResponseModel

from actinia_openapi_python_client.api_client import ApiClient
from actinia_openapi_python_client.api_response import ApiResponse
from actinia_openapi_python_client.rest import RESTResponseType


class SatelliteImageAlgorithmsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def landsat_process_landsat_id_atcor_method_processing_method_post(
        self,
        landsat_id: Annotated[StrictStr, Field(description="The id of a Landsat scene only with sensors: LT04, LT05, LE07, LC08")],
        atcor_method: Annotated[StrictStr, Field(description="The method for atmospheric correction")],
        processing_method: Annotated[StrictStr, Field(description="The method that should be used to compute the vegetation index")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> LandsatNDVIResponseModel:
        """Vegetation index computation from an atmospherically corrected Landsat scene.

        Vegetation index computation from an atmospherically corrected Landsat scene. The Landsat scene is located in the google cloud storage. The processing is as follows: A user specific Landsat scene (LT4, LT5, LE7 and LC8) will be download and imported into an ephemeral database. Then atmospheric correction will be performed, with either TOAR or DOS4, depending on the users choice. The user specific vegetation index will be computed based on the TOAR or DOS4 data. The result of the computation is available as gzipped Geotiff file. In addition, the univariate statistic will be computed as well as a preview image including a legend. Minimum required user role: user.

        :param landsat_id: The id of a Landsat scene only with sensors: LT04, LT05, LE07, LC08 (required)
        :type landsat_id: str
        :param atcor_method: The method for atmospheric correction (required)
        :type atcor_method: str
        :param processing_method: The method that should be used to compute the vegetation index (required)
        :type processing_method: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._landsat_process_landsat_id_atcor_method_processing_method_post_serialize(
            landsat_id=landsat_id,
            atcor_method=atcor_method,
            processing_method=processing_method,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LandsatNDVIResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def landsat_process_landsat_id_atcor_method_processing_method_post_with_http_info(
        self,
        landsat_id: Annotated[StrictStr, Field(description="The id of a Landsat scene only with sensors: LT04, LT05, LE07, LC08")],
        atcor_method: Annotated[StrictStr, Field(description="The method for atmospheric correction")],
        processing_method: Annotated[StrictStr, Field(description="The method that should be used to compute the vegetation index")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[LandsatNDVIResponseModel]:
        """Vegetation index computation from an atmospherically corrected Landsat scene.

        Vegetation index computation from an atmospherically corrected Landsat scene. The Landsat scene is located in the google cloud storage. The processing is as follows: A user specific Landsat scene (LT4, LT5, LE7 and LC8) will be download and imported into an ephemeral database. Then atmospheric correction will be performed, with either TOAR or DOS4, depending on the users choice. The user specific vegetation index will be computed based on the TOAR or DOS4 data. The result of the computation is available as gzipped Geotiff file. In addition, the univariate statistic will be computed as well as a preview image including a legend. Minimum required user role: user.

        :param landsat_id: The id of a Landsat scene only with sensors: LT04, LT05, LE07, LC08 (required)
        :type landsat_id: str
        :param atcor_method: The method for atmospheric correction (required)
        :type atcor_method: str
        :param processing_method: The method that should be used to compute the vegetation index (required)
        :type processing_method: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._landsat_process_landsat_id_atcor_method_processing_method_post_serialize(
            landsat_id=landsat_id,
            atcor_method=atcor_method,
            processing_method=processing_method,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LandsatNDVIResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def landsat_process_landsat_id_atcor_method_processing_method_post_without_preload_content(
        self,
        landsat_id: Annotated[StrictStr, Field(description="The id of a Landsat scene only with sensors: LT04, LT05, LE07, LC08")],
        atcor_method: Annotated[StrictStr, Field(description="The method for atmospheric correction")],
        processing_method: Annotated[StrictStr, Field(description="The method that should be used to compute the vegetation index")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Vegetation index computation from an atmospherically corrected Landsat scene.

        Vegetation index computation from an atmospherically corrected Landsat scene. The Landsat scene is located in the google cloud storage. The processing is as follows: A user specific Landsat scene (LT4, LT5, LE7 and LC8) will be download and imported into an ephemeral database. Then atmospheric correction will be performed, with either TOAR or DOS4, depending on the users choice. The user specific vegetation index will be computed based on the TOAR or DOS4 data. The result of the computation is available as gzipped Geotiff file. In addition, the univariate statistic will be computed as well as a preview image including a legend. Minimum required user role: user.

        :param landsat_id: The id of a Landsat scene only with sensors: LT04, LT05, LE07, LC08 (required)
        :type landsat_id: str
        :param atcor_method: The method for atmospheric correction (required)
        :type atcor_method: str
        :param processing_method: The method that should be used to compute the vegetation index (required)
        :type processing_method: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._landsat_process_landsat_id_atcor_method_processing_method_post_serialize(
            landsat_id=landsat_id,
            atcor_method=atcor_method,
            processing_method=processing_method,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LandsatNDVIResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _landsat_process_landsat_id_atcor_method_processing_method_post_serialize(
        self,
        landsat_id,
        atcor_method,
        processing_method,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if landsat_id is not None:
            _path_params['landsat_id'] = landsat_id
        if atcor_method is not None:
            _path_params['atcor_method'] = atcor_method
        if processing_method is not None:
            _path_params['processing_method'] = processing_method
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/landsat_process/{landsat_id}/{atcor_method}/{processing_method}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def landsat_query_get(
        self,
        scene_id: Annotated[Optional[StrictStr], Field(description="The scene id of the landsat scenes that should be searched")] = None,
        spacecraft_id: Annotated[Optional[StrictStr], Field(description="The spacecraft id of the landsat scenes that should be searched")] = None,
        start_time: Annotated[Optional[StrictStr], Field(description="The start time of the search interval")] = None,
        end_time: Annotated[Optional[StrictStr], Field(description="The end time of the search interval")] = None,
        lon: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The longitude coordinate with which the scenes should intersect")] = None,
        lat: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The latitude coordinate with which the scenes should intersect")] = None,
        cloud_covert: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Cloud cover between 0 - 100")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SatelliteSceneList:
        """Query the Google Landsat archives using time interval, lat/lon coordinates, scene id, spacecraft id and cloud cover.

        Query the Google Landsat archives using time interval, lat/lon coordinates, scene id, spacecraft id and cloud cover. All scenes that are located within the time interval and that intersect the given latitude/longitude coordinates are returned as a list of scene names with associated time stamps. Minimum required user role: user.

        :param scene_id: The scene id of the landsat scenes that should be searched
        :type scene_id: str
        :param spacecraft_id: The spacecraft id of the landsat scenes that should be searched
        :type spacecraft_id: str
        :param start_time: The start time of the search interval
        :type start_time: str
        :param end_time: The end time of the search interval
        :type end_time: str
        :param lon: The longitude coordinate with which the scenes should intersect
        :type lon: float
        :param lat: The latitude coordinate with which the scenes should intersect
        :type lat: float
        :param cloud_covert: Cloud cover between 0 - 100
        :type cloud_covert: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._landsat_query_get_serialize(
            scene_id=scene_id,
            spacecraft_id=spacecraft_id,
            start_time=start_time,
            end_time=end_time,
            lon=lon,
            lat=lat,
            cloud_covert=cloud_covert,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SatelliteSceneList",
            '400': "SimpleResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def landsat_query_get_with_http_info(
        self,
        scene_id: Annotated[Optional[StrictStr], Field(description="The scene id of the landsat scenes that should be searched")] = None,
        spacecraft_id: Annotated[Optional[StrictStr], Field(description="The spacecraft id of the landsat scenes that should be searched")] = None,
        start_time: Annotated[Optional[StrictStr], Field(description="The start time of the search interval")] = None,
        end_time: Annotated[Optional[StrictStr], Field(description="The end time of the search interval")] = None,
        lon: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The longitude coordinate with which the scenes should intersect")] = None,
        lat: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The latitude coordinate with which the scenes should intersect")] = None,
        cloud_covert: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Cloud cover between 0 - 100")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SatelliteSceneList]:
        """Query the Google Landsat archives using time interval, lat/lon coordinates, scene id, spacecraft id and cloud cover.

        Query the Google Landsat archives using time interval, lat/lon coordinates, scene id, spacecraft id and cloud cover. All scenes that are located within the time interval and that intersect the given latitude/longitude coordinates are returned as a list of scene names with associated time stamps. Minimum required user role: user.

        :param scene_id: The scene id of the landsat scenes that should be searched
        :type scene_id: str
        :param spacecraft_id: The spacecraft id of the landsat scenes that should be searched
        :type spacecraft_id: str
        :param start_time: The start time of the search interval
        :type start_time: str
        :param end_time: The end time of the search interval
        :type end_time: str
        :param lon: The longitude coordinate with which the scenes should intersect
        :type lon: float
        :param lat: The latitude coordinate with which the scenes should intersect
        :type lat: float
        :param cloud_covert: Cloud cover between 0 - 100
        :type cloud_covert: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._landsat_query_get_serialize(
            scene_id=scene_id,
            spacecraft_id=spacecraft_id,
            start_time=start_time,
            end_time=end_time,
            lon=lon,
            lat=lat,
            cloud_covert=cloud_covert,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SatelliteSceneList",
            '400': "SimpleResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def landsat_query_get_without_preload_content(
        self,
        scene_id: Annotated[Optional[StrictStr], Field(description="The scene id of the landsat scenes that should be searched")] = None,
        spacecraft_id: Annotated[Optional[StrictStr], Field(description="The spacecraft id of the landsat scenes that should be searched")] = None,
        start_time: Annotated[Optional[StrictStr], Field(description="The start time of the search interval")] = None,
        end_time: Annotated[Optional[StrictStr], Field(description="The end time of the search interval")] = None,
        lon: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The longitude coordinate with which the scenes should intersect")] = None,
        lat: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The latitude coordinate with which the scenes should intersect")] = None,
        cloud_covert: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Cloud cover between 0 - 100")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Query the Google Landsat archives using time interval, lat/lon coordinates, scene id, spacecraft id and cloud cover.

        Query the Google Landsat archives using time interval, lat/lon coordinates, scene id, spacecraft id and cloud cover. All scenes that are located within the time interval and that intersect the given latitude/longitude coordinates are returned as a list of scene names with associated time stamps. Minimum required user role: user.

        :param scene_id: The scene id of the landsat scenes that should be searched
        :type scene_id: str
        :param spacecraft_id: The spacecraft id of the landsat scenes that should be searched
        :type spacecraft_id: str
        :param start_time: The start time of the search interval
        :type start_time: str
        :param end_time: The end time of the search interval
        :type end_time: str
        :param lon: The longitude coordinate with which the scenes should intersect
        :type lon: float
        :param lat: The latitude coordinate with which the scenes should intersect
        :type lat: float
        :param cloud_covert: Cloud cover between 0 - 100
        :type cloud_covert: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._landsat_query_get_serialize(
            scene_id=scene_id,
            spacecraft_id=spacecraft_id,
            start_time=start_time,
            end_time=end_time,
            lon=lon,
            lat=lat,
            cloud_covert=cloud_covert,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SatelliteSceneList",
            '400': "SimpleResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _landsat_query_get_serialize(
        self,
        scene_id,
        spacecraft_id,
        start_time,
        end_time,
        lon,
        lat,
        cloud_covert,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if scene_id is not None:
            
            _query_params.append(('scene_id', scene_id))
            
        if spacecraft_id is not None:
            
            _query_params.append(('spacecraft_id', spacecraft_id))
            
        if start_time is not None:
            
            _query_params.append(('start_time', start_time))
            
        if end_time is not None:
            
            _query_params.append(('end_time', end_time))
            
        if lon is not None:
            
            _query_params.append(('lon', lon))
            
        if lat is not None:
            
            _query_params.append(('lat', lat))
            
        if cloud_covert is not None:
            
            _query_params.append(('cloud_covert', cloud_covert))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/landsat_query',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_mapsets_mapset_name_landsat_import_post(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name to import the Landsat scenes in")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset to import the Landsat scenes in")],
        tiles: Annotated[LandsatSceneListModel, Field(description="The list of Landsat scenes, the band names and the target STRDS names")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ProcessingResponseModel:
        """Download and import Landsat scenes into a new mapset and create a space time dataset for each imported band.

        Download and import Landsat scenes into a new mapset and create a space-time raster dataset for each imported band. The resulting data will be located in a persistent user database. The location name is part of the path and must exist. The mapset will be created while importing and should not already exist in the location. The names of theLandsat scenes that should be downloaded must be specified in the HTTP body as application/json content. In addition, the basename of the STRDS that should manage the Landsat scenes must be provided in the application/json content. For each band a separate strds will be cerated and the STRDS base name will be extended with the band number.This call is performed asynchronously. The provided resource URL must be pulled to receive the status of the import. The data is available in the provided location/mapset, after the download and import finished. Minimum required user role: user.

        :param location_name: The location name to import the Landsat scenes in (required)
        :type location_name: str
        :param mapset_name: The name of the mapset to import the Landsat scenes in (required)
        :type mapset_name: str
        :param tiles: The list of Landsat scenes, the band names and the target STRDS names (required)
        :type tiles: LandsatSceneListModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_landsat_import_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            tiles=tiles,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_landsat_import_post_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name to import the Landsat scenes in")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset to import the Landsat scenes in")],
        tiles: Annotated[LandsatSceneListModel, Field(description="The list of Landsat scenes, the band names and the target STRDS names")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ProcessingResponseModel]:
        """Download and import Landsat scenes into a new mapset and create a space time dataset for each imported band.

        Download and import Landsat scenes into a new mapset and create a space-time raster dataset for each imported band. The resulting data will be located in a persistent user database. The location name is part of the path and must exist. The mapset will be created while importing and should not already exist in the location. The names of theLandsat scenes that should be downloaded must be specified in the HTTP body as application/json content. In addition, the basename of the STRDS that should manage the Landsat scenes must be provided in the application/json content. For each band a separate strds will be cerated and the STRDS base name will be extended with the band number.This call is performed asynchronously. The provided resource URL must be pulled to receive the status of the import. The data is available in the provided location/mapset, after the download and import finished. Minimum required user role: user.

        :param location_name: The location name to import the Landsat scenes in (required)
        :type location_name: str
        :param mapset_name: The name of the mapset to import the Landsat scenes in (required)
        :type mapset_name: str
        :param tiles: The list of Landsat scenes, the band names and the target STRDS names (required)
        :type tiles: LandsatSceneListModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_landsat_import_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            tiles=tiles,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_landsat_import_post_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name to import the Landsat scenes in")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset to import the Landsat scenes in")],
        tiles: Annotated[LandsatSceneListModel, Field(description="The list of Landsat scenes, the band names and the target STRDS names")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Download and import Landsat scenes into a new mapset and create a space time dataset for each imported band.

        Download and import Landsat scenes into a new mapset and create a space-time raster dataset for each imported band. The resulting data will be located in a persistent user database. The location name is part of the path and must exist. The mapset will be created while importing and should not already exist in the location. The names of theLandsat scenes that should be downloaded must be specified in the HTTP body as application/json content. In addition, the basename of the STRDS that should manage the Landsat scenes must be provided in the application/json content. For each band a separate strds will be cerated and the STRDS base name will be extended with the band number.This call is performed asynchronously. The provided resource URL must be pulled to receive the status of the import. The data is available in the provided location/mapset, after the download and import finished. Minimum required user role: user.

        :param location_name: The location name to import the Landsat scenes in (required)
        :type location_name: str
        :param mapset_name: The name of the mapset to import the Landsat scenes in (required)
        :type mapset_name: str
        :param tiles: The list of Landsat scenes, the band names and the target STRDS names (required)
        :type tiles: LandsatSceneListModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_landsat_import_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            tiles=tiles,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_landsat_import_post_serialize(
        self,
        location_name,
        mapset_name,
        tiles,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if tiles is not None:
            _body_params = tiles


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/landsat_import',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def locations_location_name_mapsets_mapset_name_sentinel2_import_post(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name to import the Sentinel2A scenes in")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset to import the Sentinel2A scenes in")],
        tiles: Annotated[Sentinel2ASceneListModel, Field(description="The list of Sentinel-2 scenes, the band names and the target STRDS names")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ProcessingResponseModel:
        """Download and import Sentinel2A scenes into a new mapset and create a space-time raster dataset for each imported band.

        Download and import Sentinel2A scenes into a new mapset and create a space-time raster dataset for each imported band. The resulting data will be located in a persistent user database. The location name is part of the path and must exist. The mapset will be created while importing and should not already exist in the location. The names of theSentinel-2 scenes and the band names that should be downloaded must be specified in the HTTP body as application/json content. In addition, the names of the STRDS that should manage the sentinel scenes must be provided in the application/json content. For each band a separate STRDS name must be provided.This call is performed asynchronously. The provided resource URL must be pulled to receive the status of the import. The data is available in the provided location/mapset, after the download and import finished. Minimum required user role: user.

        :param location_name: The location name to import the Sentinel2A scenes in (required)
        :type location_name: str
        :param mapset_name: The name of the mapset to import the Sentinel2A scenes in (required)
        :type mapset_name: str
        :param tiles: The list of Sentinel-2 scenes, the band names and the target STRDS names (required)
        :type tiles: Sentinel2ASceneListModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_sentinel2_import_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            tiles=tiles,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def locations_location_name_mapsets_mapset_name_sentinel2_import_post_with_http_info(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name to import the Sentinel2A scenes in")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset to import the Sentinel2A scenes in")],
        tiles: Annotated[Sentinel2ASceneListModel, Field(description="The list of Sentinel-2 scenes, the band names and the target STRDS names")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ProcessingResponseModel]:
        """Download and import Sentinel2A scenes into a new mapset and create a space-time raster dataset for each imported band.

        Download and import Sentinel2A scenes into a new mapset and create a space-time raster dataset for each imported band. The resulting data will be located in a persistent user database. The location name is part of the path and must exist. The mapset will be created while importing and should not already exist in the location. The names of theSentinel-2 scenes and the band names that should be downloaded must be specified in the HTTP body as application/json content. In addition, the names of the STRDS that should manage the sentinel scenes must be provided in the application/json content. For each band a separate STRDS name must be provided.This call is performed asynchronously. The provided resource URL must be pulled to receive the status of the import. The data is available in the provided location/mapset, after the download and import finished. Minimum required user role: user.

        :param location_name: The location name to import the Sentinel2A scenes in (required)
        :type location_name: str
        :param mapset_name: The name of the mapset to import the Sentinel2A scenes in (required)
        :type mapset_name: str
        :param tiles: The list of Sentinel-2 scenes, the band names and the target STRDS names (required)
        :type tiles: Sentinel2ASceneListModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_sentinel2_import_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            tiles=tiles,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def locations_location_name_mapsets_mapset_name_sentinel2_import_post_without_preload_content(
        self,
        location_name: Annotated[StrictStr, Field(description="The location name to import the Sentinel2A scenes in")],
        mapset_name: Annotated[StrictStr, Field(description="The name of the mapset to import the Sentinel2A scenes in")],
        tiles: Annotated[Sentinel2ASceneListModel, Field(description="The list of Sentinel-2 scenes, the band names and the target STRDS names")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Download and import Sentinel2A scenes into a new mapset and create a space-time raster dataset for each imported band.

        Download and import Sentinel2A scenes into a new mapset and create a space-time raster dataset for each imported band. The resulting data will be located in a persistent user database. The location name is part of the path and must exist. The mapset will be created while importing and should not already exist in the location. The names of theSentinel-2 scenes and the band names that should be downloaded must be specified in the HTTP body as application/json content. In addition, the names of the STRDS that should manage the sentinel scenes must be provided in the application/json content. For each band a separate STRDS name must be provided.This call is performed asynchronously. The provided resource URL must be pulled to receive the status of the import. The data is available in the provided location/mapset, after the download and import finished. Minimum required user role: user.

        :param location_name: The location name to import the Sentinel2A scenes in (required)
        :type location_name: str
        :param mapset_name: The name of the mapset to import the Sentinel2A scenes in (required)
        :type mapset_name: str
        :param tiles: The list of Sentinel-2 scenes, the band names and the target STRDS names (required)
        :type tiles: Sentinel2ASceneListModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._locations_location_name_mapsets_mapset_name_sentinel2_import_post_serialize(
            location_name=location_name,
            mapset_name=mapset_name,
            tiles=tiles,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProcessingResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _locations_location_name_mapsets_mapset_name_sentinel2_import_post_serialize(
        self,
        location_name,
        mapset_name,
        tiles,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if location_name is not None:
            _path_params['location_name'] = location_name
        if mapset_name is not None:
            _path_params['mapset_name'] = mapset_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if tiles is not None:
            _body_params = tiles


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/locations/{location_name}/mapsets/{mapset_name}/sentinel2_import',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def sentinel2_process_gcs_ndvi_product_id_post(
        self,
        product_id: Annotated[StrictStr, Field(description="The product id of a sentinel scene")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SentinelNDVIResponseModel:
        """NDVI computation of an arbitrary Sentinel-2 scene. The results are stored in the Google Cloud Storage.

        NDVI computation of an arbitrary Sentinel-2 scene.The processing is as follows: A user specific Sentinel-2 scene (Bands 04 and 08)will be download and imported into an ephemeral database.. The NDVI will be computed via r.mapcalc. The result of the computation is available as gzipped geotiff file. In addition, the univariate statistic will be computed as well as a preview image including a legend and scale. Minimum required user role: user.

        :param product_id: The product id of a sentinel scene (required)
        :type product_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sentinel2_process_gcs_ndvi_product_id_post_serialize(
            product_id=product_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SentinelNDVIResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def sentinel2_process_gcs_ndvi_product_id_post_with_http_info(
        self,
        product_id: Annotated[StrictStr, Field(description="The product id of a sentinel scene")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SentinelNDVIResponseModel]:
        """NDVI computation of an arbitrary Sentinel-2 scene. The results are stored in the Google Cloud Storage.

        NDVI computation of an arbitrary Sentinel-2 scene.The processing is as follows: A user specific Sentinel-2 scene (Bands 04 and 08)will be download and imported into an ephemeral database.. The NDVI will be computed via r.mapcalc. The result of the computation is available as gzipped geotiff file. In addition, the univariate statistic will be computed as well as a preview image including a legend and scale. Minimum required user role: user.

        :param product_id: The product id of a sentinel scene (required)
        :type product_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sentinel2_process_gcs_ndvi_product_id_post_serialize(
            product_id=product_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SentinelNDVIResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def sentinel2_process_gcs_ndvi_product_id_post_without_preload_content(
        self,
        product_id: Annotated[StrictStr, Field(description="The product id of a sentinel scene")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """NDVI computation of an arbitrary Sentinel-2 scene. The results are stored in the Google Cloud Storage.

        NDVI computation of an arbitrary Sentinel-2 scene.The processing is as follows: A user specific Sentinel-2 scene (Bands 04 and 08)will be download and imported into an ephemeral database.. The NDVI will be computed via r.mapcalc. The result of the computation is available as gzipped geotiff file. In addition, the univariate statistic will be computed as well as a preview image including a legend and scale. Minimum required user role: user.

        :param product_id: The product id of a sentinel scene (required)
        :type product_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sentinel2_process_gcs_ndvi_product_id_post_serialize(
            product_id=product_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SentinelNDVIResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _sentinel2_process_gcs_ndvi_product_id_post_serialize(
        self,
        product_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if product_id is not None:
            _path_params['product_id'] = product_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/sentinel2_process_gcs/ndvi/{product_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def sentinel2_process_ndvi_product_id_post(
        self,
        product_id: Annotated[StrictStr, Field(description="The product id of a sentinel scene")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SentinelNDVIResponseModel:
        """NDVI computation of an arbitrary Sentinel-2 scene.

        NDVI computation of an arbitrary Sentinel-2 scene.The processing is as follows: A user specific Sentinel-2 scene (Bands 04 and 08)will be download and imported into an ephemeral database.. The NDVI will be computed via r.mapcalc. The result of the computation is available as gzipped geotiff file. In addition, the univariate statistic will be computed as well as a preview image including a legend and scale. Minimum required user role: user.

        :param product_id: The product id of a sentinel scene (required)
        :type product_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sentinel2_process_ndvi_product_id_post_serialize(
            product_id=product_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SentinelNDVIResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def sentinel2_process_ndvi_product_id_post_with_http_info(
        self,
        product_id: Annotated[StrictStr, Field(description="The product id of a sentinel scene")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SentinelNDVIResponseModel]:
        """NDVI computation of an arbitrary Sentinel-2 scene.

        NDVI computation of an arbitrary Sentinel-2 scene.The processing is as follows: A user specific Sentinel-2 scene (Bands 04 and 08)will be download and imported into an ephemeral database.. The NDVI will be computed via r.mapcalc. The result of the computation is available as gzipped geotiff file. In addition, the univariate statistic will be computed as well as a preview image including a legend and scale. Minimum required user role: user.

        :param product_id: The product id of a sentinel scene (required)
        :type product_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sentinel2_process_ndvi_product_id_post_serialize(
            product_id=product_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SentinelNDVIResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def sentinel2_process_ndvi_product_id_post_without_preload_content(
        self,
        product_id: Annotated[StrictStr, Field(description="The product id of a sentinel scene")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """NDVI computation of an arbitrary Sentinel-2 scene.

        NDVI computation of an arbitrary Sentinel-2 scene.The processing is as follows: A user specific Sentinel-2 scene (Bands 04 and 08)will be download and imported into an ephemeral database.. The NDVI will be computed via r.mapcalc. The result of the computation is available as gzipped geotiff file. In addition, the univariate statistic will be computed as well as a preview image including a legend and scale. Minimum required user role: user.

        :param product_id: The product id of a sentinel scene (required)
        :type product_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sentinel2_process_ndvi_product_id_post_serialize(
            product_id=product_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SentinelNDVIResponseModel",
            '400': "ProcessingErrorResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _sentinel2_process_ndvi_product_id_post_serialize(
        self,
        product_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if product_id is not None:
            _path_params['product_id'] = product_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/sentinel2_process/ndvi/{product_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def sentinel2_query_get(
        self,
        scene_id: Annotated[Optional[StrictStr], Field(description="The scene id also named product id of the Sentinel2A scenes that should be searched")] = None,
        start_time: Annotated[Optional[StrictStr], Field(description="The start time of the search interval")] = None,
        end_time: Annotated[Optional[StrictStr], Field(description="The end time of the search interval")] = None,
        lon: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The longitude coordinate with which the scenes should intersect")] = None,
        lat: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The latitude coordinate with which the scenes should intersect")] = None,
        cloud_covert: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Cloud cover between 0 - 100")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SatelliteSceneList:
        """Query the Google Sentinel2 archives using time interval, lat/lon coordinates, scene id and cloud cover.

        Query the Google Sentinel2 archives using time interval, lat/lon coordinates, scene id and cloud cover. All scenes that are located within the time interval and that intersect the given latitude/longitude coordinates are returned as a list of scene names with associated time stamps. Minimum required user role: user.

        :param scene_id: The scene id also named product id of the Sentinel2A scenes that should be searched
        :type scene_id: str
        :param start_time: The start time of the search interval
        :type start_time: str
        :param end_time: The end time of the search interval
        :type end_time: str
        :param lon: The longitude coordinate with which the scenes should intersect
        :type lon: float
        :param lat: The latitude coordinate with which the scenes should intersect
        :type lat: float
        :param cloud_covert: Cloud cover between 0 - 100
        :type cloud_covert: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sentinel2_query_get_serialize(
            scene_id=scene_id,
            start_time=start_time,
            end_time=end_time,
            lon=lon,
            lat=lat,
            cloud_covert=cloud_covert,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SatelliteSceneList",
            '400': "SimpleResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def sentinel2_query_get_with_http_info(
        self,
        scene_id: Annotated[Optional[StrictStr], Field(description="The scene id also named product id of the Sentinel2A scenes that should be searched")] = None,
        start_time: Annotated[Optional[StrictStr], Field(description="The start time of the search interval")] = None,
        end_time: Annotated[Optional[StrictStr], Field(description="The end time of the search interval")] = None,
        lon: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The longitude coordinate with which the scenes should intersect")] = None,
        lat: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The latitude coordinate with which the scenes should intersect")] = None,
        cloud_covert: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Cloud cover between 0 - 100")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SatelliteSceneList]:
        """Query the Google Sentinel2 archives using time interval, lat/lon coordinates, scene id and cloud cover.

        Query the Google Sentinel2 archives using time interval, lat/lon coordinates, scene id and cloud cover. All scenes that are located within the time interval and that intersect the given latitude/longitude coordinates are returned as a list of scene names with associated time stamps. Minimum required user role: user.

        :param scene_id: The scene id also named product id of the Sentinel2A scenes that should be searched
        :type scene_id: str
        :param start_time: The start time of the search interval
        :type start_time: str
        :param end_time: The end time of the search interval
        :type end_time: str
        :param lon: The longitude coordinate with which the scenes should intersect
        :type lon: float
        :param lat: The latitude coordinate with which the scenes should intersect
        :type lat: float
        :param cloud_covert: Cloud cover between 0 - 100
        :type cloud_covert: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sentinel2_query_get_serialize(
            scene_id=scene_id,
            start_time=start_time,
            end_time=end_time,
            lon=lon,
            lat=lat,
            cloud_covert=cloud_covert,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SatelliteSceneList",
            '400': "SimpleResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def sentinel2_query_get_without_preload_content(
        self,
        scene_id: Annotated[Optional[StrictStr], Field(description="The scene id also named product id of the Sentinel2A scenes that should be searched")] = None,
        start_time: Annotated[Optional[StrictStr], Field(description="The start time of the search interval")] = None,
        end_time: Annotated[Optional[StrictStr], Field(description="The end time of the search interval")] = None,
        lon: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The longitude coordinate with which the scenes should intersect")] = None,
        lat: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The latitude coordinate with which the scenes should intersect")] = None,
        cloud_covert: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Cloud cover between 0 - 100")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Query the Google Sentinel2 archives using time interval, lat/lon coordinates, scene id and cloud cover.

        Query the Google Sentinel2 archives using time interval, lat/lon coordinates, scene id and cloud cover. All scenes that are located within the time interval and that intersect the given latitude/longitude coordinates are returned as a list of scene names with associated time stamps. Minimum required user role: user.

        :param scene_id: The scene id also named product id of the Sentinel2A scenes that should be searched
        :type scene_id: str
        :param start_time: The start time of the search interval
        :type start_time: str
        :param end_time: The end time of the search interval
        :type end_time: str
        :param lon: The longitude coordinate with which the scenes should intersect
        :type lon: float
        :param lat: The latitude coordinate with which the scenes should intersect
        :type lat: float
        :param cloud_covert: Cloud cover between 0 - 100
        :type cloud_covert: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sentinel2_query_get_serialize(
            scene_id=scene_id,
            start_time=start_time,
            end_time=end_time,
            lon=lon,
            lat=lat,
            cloud_covert=cloud_covert,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SatelliteSceneList",
            '400': "SimpleResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _sentinel2_query_get_serialize(
        self,
        scene_id,
        start_time,
        end_time,
        lon,
        lat,
        cloud_covert,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if scene_id is not None:
            
            _query_params.append(('scene_id', scene_id))
            
        if start_time is not None:
            
            _query_params.append(('start_time', start_time))
            
        if end_time is not None:
            
            _query_params.append(('end_time', end_time))
            
        if lon is not None:
            
            _query_params.append(('lon', lon))
            
        if lat is not None:
            
            _query_params.append(('lat', lat))
            
        if cloud_covert is not None:
            
            _query_params.append(('cloud_covert', cloud_covert))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/sentinel2_query',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def sentinel2a_aws_query_post(
        self,
        scenes: Annotated[Sentinel2ASceneListModel, Field(description="The list of Sentinel-2 scenes and the band names")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Sentinel2ASceneList:
        """Generate the download urls for a list of sentinel2A scenes and band numbers.

        Generate the download urls for a list of sentinel2A scenes and band numbers. Minimum required user role: user.

        :param scenes: The list of Sentinel-2 scenes and the band names (required)
        :type scenes: Sentinel2ASceneListModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sentinel2a_aws_query_post_serialize(
            scenes=scenes,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Sentinel2ASceneList",
            '400': "SimpleResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def sentinel2a_aws_query_post_with_http_info(
        self,
        scenes: Annotated[Sentinel2ASceneListModel, Field(description="The list of Sentinel-2 scenes and the band names")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Sentinel2ASceneList]:
        """Generate the download urls for a list of sentinel2A scenes and band numbers.

        Generate the download urls for a list of sentinel2A scenes and band numbers. Minimum required user role: user.

        :param scenes: The list of Sentinel-2 scenes and the band names (required)
        :type scenes: Sentinel2ASceneListModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sentinel2a_aws_query_post_serialize(
            scenes=scenes,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Sentinel2ASceneList",
            '400': "SimpleResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def sentinel2a_aws_query_post_without_preload_content(
        self,
        scenes: Annotated[Sentinel2ASceneListModel, Field(description="The list of Sentinel-2 scenes and the band names")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Generate the download urls for a list of sentinel2A scenes and band numbers.

        Generate the download urls for a list of sentinel2A scenes and band numbers. Minimum required user role: user.

        :param scenes: The list of Sentinel-2 scenes and the band names (required)
        :type scenes: Sentinel2ASceneListModel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sentinel2a_aws_query_post_serialize(
            scenes=scenes,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Sentinel2ASceneList",
            '400': "SimpleResponseModel"
            
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _sentinel2a_aws_query_post_serialize(
        self,
        scenes,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if scenes is not None:
            _body_params = scenes


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                '*/*'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/sentinel2a_aws_query',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


