# coding: utf-8

"""
    Actinia

     ================================ Actinia - The GRASS GIS REST API ================================  **Actinia** is an open source REST API for scalable, distributed, high performance processing of geographical data that uses GRASS GIS for computational tasks.  It provides a REST API to process satellite images, time series of satellite images, arbitrary raster data with geographical relations and vector data.  The REST interface allows to access, manage and manipulate the GRASS GIS database via HTTP GET,PUT,POST and DELETE requests and to process raster, vector and time series data located in a persistent GRASS GIS database. **Actinia** allows the processing of cloud based data, for example all Landsat 4-8 scenes as well as all Sentinel2A scenes in an ephemeral databases. The computational results of ephemeral processing are available via object storage as GeoTIFF files.  The full API documentation is available here: https://redocly.github.io/redoc/?url=https://actinia.mundialis.de/latest/ swagger.json   Examples: ---------  To execute the examples, first setup login information, IP address and port:      export ACTINIA_URL=https://actinia.mundialis.de/latest     export AUTH='-u demouser:gu3st!pa55w0rd'  **Data management**  - List all locations that are available in the actinia persistent database:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations\"  - List all mapsets in the location latlong_wgs84:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets\"  - List all raster layers in location latlong_wgs84 and mapset Sentinel2A      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets/Sentinel2A/raster_layers\"  - List all space-time raster datasets (STRDS) in location ECAD and mapset   PERMANENT:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/raster_layers\"  - List all raster map layers of the STRDS precipitation_1950_2013_yearly_mm:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/strds/precipitation_    1950_2013_yearly_mm/raster_layers\"  **Landsat and Sentinel2A NDVI computation**  This API call will compute the NDVI of the top of atmosphere (TOAR) corrected Landsat4 scene LC80440342016259LGN00:      curl ${AUTH} -X POST \"${ACTINIA_URL}/landsat_process/    LC80440342016259LGN00/TOAR/NDVI\"  NDVI computation of Sentinel2A scene S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138:      curl ${AUTH} -X POST \"${ACTINIA_URL}/sentinel2_process/ndvi/    S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138\"  The results of the asynchronous computations are available as GeoTIFF file in a cloud storage for download. 

    The version of the OpenAPI document: v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictStr
from pydantic import Field
from actinia_openapi_python_client.models.input_parameter import InputParameter
from actinia_openapi_python_client.models.output_parameter import OutputParameter
from actinia_openapi_python_client.models.stdout_parser import StdoutParser
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self


class GrassModule(BaseModel):
    """
    The definition of a single GRASS GIS module and its inputs, outputs and flags. This module will be run in a location/mapset environment and is part of a process chain. The stdout and stderr output of modules that were run before this module in the process chain can be used as stdin for this module. The stdout of a module can be automatically transformed in list, table or key/value JSON representations in the HTTP response.
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="A unique id to identify the module call in the process chain to reference its stdout and stderr output as stdin in other modules.")
    module: Optional[StrictStr] = Field(default=None, description="The name of the GRASS GIS module (r.univar, r.slope.aspect, v.select, ...) that should be executed. Use as module names \"importer\" or \"exporter\" to import or export raster layer, vector layer or other file based data without calling a GRASS GIS module.")
    inputs: Optional[List[InputParameter]] = Field(default=None, description="A list of input parameters of a GRASS GIS module.")
    outputs: Optional[List[OutputParameter]] = Field(default=None, description="A list of output parameters of a GRASS GIS module.")
    flags: Optional[StrictStr] = Field(default=None, description="The flags that should be set for the GRASS GIS module.")
    stdin: Optional[StrictStr] = Field(default=None, description="Use the stdout output of a GRASS GIS module or executable of the process chain as input for this module. Refer to the module/executable output as *id::stderr* or *id::stdout*, the \"id\" is the unique identifier of a GRASS GIS module definition.")
    stdout: Optional[StdoutParser] = None
    overwrite: Optional[StrictBool] = Field(default=None, description="Set True to overwrite existing data.")
    verbose: Optional[StrictBool] = Field(default=None, description="Set True to activate verbosity output of the module.")
    superquiet: Optional[StrictBool] = Field(default=None, description="Set True to silence the output of the module.")
    interface_description: Optional[StrictBool] = Field(default=None, description="Set True to print interface description and exit.", alias="interface-description")
    __properties: ClassVar[List[str]] = ["id", "module", "inputs", "outputs", "flags", "stdin", "stdout", "overwrite", "verbose", "superquiet", "interface-description"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of GrassModule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in inputs (list)
        _items = []
        if self.inputs:
            for _item in self.inputs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['inputs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in outputs (list)
        _items = []
        if self.outputs:
            for _item in self.outputs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['outputs'] = _items
        # override the default output from pydantic by calling `to_dict()` of stdout
        if self.stdout:
            _dict['stdout'] = self.stdout.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of GrassModule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "module": obj.get("module"),
            "inputs": [InputParameter.from_dict(_item) for _item in obj.get("inputs")] if obj.get("inputs") is not None else None,
            "outputs": [OutputParameter.from_dict(_item) for _item in obj.get("outputs")] if obj.get("outputs") is not None else None,
            "flags": obj.get("flags"),
            "stdin": obj.get("stdin"),
            "stdout": StdoutParser.from_dict(obj.get("stdout")) if obj.get("stdout") is not None else None,
            "overwrite": obj.get("overwrite"),
            "verbose": obj.get("verbose"),
            "superquiet": obj.get("superquiet"),
            "interface-description": obj.get("interface-description")
        })
        return _obj


