# coding: utf-8

"""
    Actinia

     ================================ Actinia - The GRASS GIS REST API ================================  **Actinia** is an open source REST API for scalable, distributed, high performance processing of geographical data that uses GRASS GIS for computational tasks.  It provides a REST API to process satellite images, time series of satellite images, arbitrary raster data with geographical relations and vector data.  The REST interface allows to access, manage and manipulate the GRASS GIS database via HTTP GET,PUT,POST and DELETE requests and to process raster, vector and time series data located in a persistent GRASS GIS database. **Actinia** allows the processing of cloud based data, for example all Landsat 4-8 scenes as well as all Sentinel2A scenes in an ephemeral databases. The computational results of ephemeral processing are available via object storage as GeoTIFF files.  The full API documentation is available here: https://redocly.github.io/redoc/?url=https://actinia.mundialis.de/latest/ swagger.json   Examples: ---------  To execute the examples, first setup login information, IP address and port:      export ACTINIA_URL=https://actinia.mundialis.de/latest     export AUTH='-u demouser:gu3st!pa55w0rd'  **Data management**  - List all locations that are available in the actinia persistent database:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations\"  - List all mapsets in the location latlong_wgs84:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets\"  - List all raster layers in location latlong_wgs84 and mapset Sentinel2A      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets/Sentinel2A/raster_layers\"  - List all space-time raster datasets (STRDS) in location ECAD and mapset   PERMANENT:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/raster_layers\"  - List all raster map layers of the STRDS precipitation_1950_2013_yearly_mm:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/strds/precipitation_    1950_2013_yearly_mm/raster_layers\"  **Landsat and Sentinel2A NDVI computation**  This API call will compute the NDVI of the top of atmosphere (TOAR) corrected Landsat4 scene LC80440342016259LGN00:      curl ${AUTH} -X POST \"${ACTINIA_URL}/landsat_process/    LC80440342016259LGN00/TOAR/NDVI\"  NDVI computation of Sentinel2A scene S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138:      curl ${AUTH} -X POST \"${ACTINIA_URL}/sentinel2_process/ndvi/    S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138\"  The results of the asynchronous computations are available as GeoTIFF file in a cloud storage for download. 

    The version of the OpenAPI document: v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr
from pydantic import Field
from actinia_openapi_python_client.models.band_information_entry import BandInformationEntry
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class Sentinel2ATileEntry(BaseModel):
    """
    Sentinel2ATileEntry
    """ # noqa: E501
    b01: Optional[BandInformationEntry] = Field(default=None, alias="B01")
    b02: Optional[BandInformationEntry] = Field(default=None, alias="B02")
    b03: Optional[BandInformationEntry] = Field(default=None, alias="B03")
    b04: Optional[BandInformationEntry] = Field(default=None, alias="B04")
    b05: Optional[BandInformationEntry] = Field(default=None, alias="B05")
    b06: Optional[BandInformationEntry] = Field(default=None, alias="B06")
    b07: Optional[BandInformationEntry] = Field(default=None, alias="B07")
    b08: Optional[BandInformationEntry] = Field(default=None, alias="B08")
    b09: Optional[BandInformationEntry] = Field(default=None, alias="B09")
    b10: Optional[BandInformationEntry] = Field(default=None, alias="B10")
    b11: Optional[BandInformationEntry] = Field(default=None, alias="B11")
    b12: Optional[BandInformationEntry] = Field(default=None, alias="B12")
    info: StrictStr = Field(description="The url to Sentinel2A scene information")
    metadata: StrictStr = Field(description="The url to Sentinel2A scene XML metadata")
    preview: StrictStr = Field(description="The url to Sentinel2A scene preview image")
    url: StrictStr = Field(description="The url to Sentinel2A scene root directory that contains all informations about the scene")
    timestamp: StrictStr = Field(description="The sensing time of the scene")
    __properties: ClassVar[List[str]] = ["B01", "B02", "B03", "B04", "B05", "B06", "B07", "B08", "B09", "B10", "B11", "B12", "info", "metadata", "preview", "url", "timestamp"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Sentinel2ATileEntry from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of b01
        if self.b01:
            _dict['B01'] = self.b01.to_dict()
        # override the default output from pydantic by calling `to_dict()` of b02
        if self.b02:
            _dict['B02'] = self.b02.to_dict()
        # override the default output from pydantic by calling `to_dict()` of b03
        if self.b03:
            _dict['B03'] = self.b03.to_dict()
        # override the default output from pydantic by calling `to_dict()` of b04
        if self.b04:
            _dict['B04'] = self.b04.to_dict()
        # override the default output from pydantic by calling `to_dict()` of b05
        if self.b05:
            _dict['B05'] = self.b05.to_dict()
        # override the default output from pydantic by calling `to_dict()` of b06
        if self.b06:
            _dict['B06'] = self.b06.to_dict()
        # override the default output from pydantic by calling `to_dict()` of b07
        if self.b07:
            _dict['B07'] = self.b07.to_dict()
        # override the default output from pydantic by calling `to_dict()` of b08
        if self.b08:
            _dict['B08'] = self.b08.to_dict()
        # override the default output from pydantic by calling `to_dict()` of b09
        if self.b09:
            _dict['B09'] = self.b09.to_dict()
        # override the default output from pydantic by calling `to_dict()` of b10
        if self.b10:
            _dict['B10'] = self.b10.to_dict()
        # override the default output from pydantic by calling `to_dict()` of b11
        if self.b11:
            _dict['B11'] = self.b11.to_dict()
        # override the default output from pydantic by calling `to_dict()` of b12
        if self.b12:
            _dict['B12'] = self.b12.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of Sentinel2ATileEntry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "B01": BandInformationEntry.from_dict(obj.get("B01")) if obj.get("B01") is not None else None,
            "B02": BandInformationEntry.from_dict(obj.get("B02")) if obj.get("B02") is not None else None,
            "B03": BandInformationEntry.from_dict(obj.get("B03")) if obj.get("B03") is not None else None,
            "B04": BandInformationEntry.from_dict(obj.get("B04")) if obj.get("B04") is not None else None,
            "B05": BandInformationEntry.from_dict(obj.get("B05")) if obj.get("B05") is not None else None,
            "B06": BandInformationEntry.from_dict(obj.get("B06")) if obj.get("B06") is not None else None,
            "B07": BandInformationEntry.from_dict(obj.get("B07")) if obj.get("B07") is not None else None,
            "B08": BandInformationEntry.from_dict(obj.get("B08")) if obj.get("B08") is not None else None,
            "B09": BandInformationEntry.from_dict(obj.get("B09")) if obj.get("B09") is not None else None,
            "B10": BandInformationEntry.from_dict(obj.get("B10")) if obj.get("B10") is not None else None,
            "B11": BandInformationEntry.from_dict(obj.get("B11")) if obj.get("B11") is not None else None,
            "B12": BandInformationEntry.from_dict(obj.get("B12")) if obj.get("B12") is not None else None,
            "info": obj.get("info"),
            "metadata": obj.get("metadata"),
            "preview": obj.get("preview"),
            "url": obj.get("url"),
            "timestamp": obj.get("timestamp")
        })
        return _obj


