# coding: utf-8

"""
    Actinia

     ================================ Actinia - The GRASS GIS REST API ================================  **Actinia** is an open source REST API for scalable, distributed, high performance processing of geographical data that uses GRASS GIS for computational tasks.  It provides a REST API to process satellite images, time series of satellite images, arbitrary raster data with geographical relations and vector data.  The REST interface allows to access, manage and manipulate the GRASS GIS database via HTTP GET,PUT,POST and DELETE requests and to process raster, vector and time series data located in a persistent GRASS GIS database. **Actinia** allows the processing of cloud based data, for example all Landsat 4-8 scenes as well as all Sentinel2A scenes in an ephemeral databases. The computational results of ephemeral processing are available via object storage as GeoTIFF files.  The full API documentation is available here: https://redocly.github.io/redoc/?url=https://actinia.mundialis.de/latest/ swagger.json   Examples: ---------  To execute the examples, first setup login information, IP address and port:      export ACTINIA_URL=https://actinia.mundialis.de/latest     export AUTH='-u demouser:gu3st!pa55w0rd'  **Data management**  - List all locations that are available in the actinia persistent database:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations\"  - List all mapsets in the location latlong_wgs84:      curl ${AUTH} -X GET \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets\"  - List all raster layers in location latlong_wgs84 and mapset Sentinel2A      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/latlong_wgs84/mapsets/Sentinel2A/raster_layers\"  - List all space-time raster datasets (STRDS) in location ECAD and mapset   PERMANENT:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/raster_layers\"  - List all raster map layers of the STRDS precipitation_1950_2013_yearly_mm:      curl ${AUTH} -X GET     \"${ACTINIA_URL}/locations/ECAD/mapsets/PERMANENT/strds/precipitation_    1950_2013_yearly_mm/raster_layers\"  **Landsat and Sentinel2A NDVI computation**  This API call will compute the NDVI of the top of atmosphere (TOAR) corrected Landsat4 scene LC80440342016259LGN00:      curl ${AUTH} -X POST \"${ACTINIA_URL}/landsat_process/    LC80440342016259LGN00/TOAR/NDVI\"  NDVI computation of Sentinel2A scene S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138:      curl ${AUTH} -X POST \"${ACTINIA_URL}/sentinel2_process/ndvi/    S2A_MSIL1C_20170212T104141_N0204_R008_T31TGJ_20170212T104138\"  The results of the asynchronous computations are available as GeoTIFF file in a cloud storage for download. 

    The version of the OpenAPI document: v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class STRDSInfoModel(BaseModel):
    """
    Information about a specific space-time raster dataset (STRDS)
    """ # noqa: E501
    aggregation_type: Optional[StrictStr] = None
    bottom: Optional[StrictStr] = None
    creation_time: Optional[StrictStr] = None
    creator: Optional[StrictStr] = None
    east: Optional[StrictStr] = None
    end_time: Optional[StrictStr] = None
    ewres_max: Optional[StrictStr] = None
    ewres_min: Optional[StrictStr] = None
    granularity: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    map_time: Optional[StrictStr] = None
    mapset: Optional[StrictStr] = None
    max_max: Optional[StrictStr] = None
    max_min: Optional[StrictStr] = None
    min_max: Optional[StrictStr] = None
    min_min: Optional[StrictStr] = None
    modification_time: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    north: Optional[StrictStr] = None
    number_of_semantic_labels: Optional[StrictStr] = None
    nsres_max: Optional[StrictStr] = None
    nsres_min: Optional[StrictStr] = None
    number_of_maps: Optional[StrictStr] = None
    raster_register: Optional[StrictStr] = None
    semantic_labels: Optional[StrictStr] = None
    semantic_type: Optional[StrictStr] = None
    south: Optional[StrictStr] = None
    start_time: Optional[StrictStr] = None
    temporal_type: Optional[StrictStr] = None
    top: Optional[StrictStr] = None
    west: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["aggregation_type", "bottom", "creation_time", "creator", "east", "end_time", "ewres_max", "ewres_min", "granularity", "id", "map_time", "mapset", "max_max", "max_min", "min_max", "min_min", "modification_time", "name", "north", "number_of_semantic_labels", "nsres_max", "nsres_min", "number_of_maps", "raster_register", "semantic_labels", "semantic_type", "south", "start_time", "temporal_type", "top", "west"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of STRDSInfoModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of STRDSInfoModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "aggregation_type": obj.get("aggregation_type"),
            "bottom": obj.get("bottom"),
            "creation_time": obj.get("creation_time"),
            "creator": obj.get("creator"),
            "east": obj.get("east"),
            "end_time": obj.get("end_time"),
            "ewres_max": obj.get("ewres_max"),
            "ewres_min": obj.get("ewres_min"),
            "granularity": obj.get("granularity"),
            "id": obj.get("id"),
            "map_time": obj.get("map_time"),
            "mapset": obj.get("mapset"),
            "max_max": obj.get("max_max"),
            "max_min": obj.get("max_min"),
            "min_max": obj.get("min_max"),
            "min_min": obj.get("min_min"),
            "modification_time": obj.get("modification_time"),
            "name": obj.get("name"),
            "north": obj.get("north"),
            "number_of_semantic_labels": obj.get("number_of_semantic_labels"),
            "nsres_max": obj.get("nsres_max"),
            "nsres_min": obj.get("nsres_min"),
            "number_of_maps": obj.get("number_of_maps"),
            "raster_register": obj.get("raster_register"),
            "semantic_labels": obj.get("semantic_labels"),
            "semantic_type": obj.get("semantic_type"),
            "south": obj.get("south"),
            "start_time": obj.get("start_time"),
            "temporal_type": obj.get("temporal_type"),
            "top": obj.get("top"),
            "west": obj.get("west")
        })
        return _obj


