#-*- coding: utf-8 -*-
"""
@brief      test log(time=60s)
"""

import sys
import os
import unittest


try:
    import src
except ImportError:
    path = os.path.normpath(
        os.path.abspath(
            os.path.join(
                os.path.split(__file__)[0],
                "..",
                "..")))
    if path not in sys.path:
        sys.path.append(path)
    import src

try:
    import pyquickhelper as skip_
except ImportError:
    path = os.path.normpath(
        os.path.abspath(
            os.path.join(
                os.path.split(__file__)[0],
                "..",
                "..",
                "..",
                "pyquickhelper",
                "src")))
    if path not in sys.path:
        sys.path.append(path)
    import pyquickhelper as skip_

from pyquickhelper.loghelper import fLOG


class TestShapely(unittest.TestCase):

    def test_cascade_union(self):
        fLOG(
            __file__,
            self._testMethodName,
            OutputPrint=__name__ == "__main__")

        from shapely.geometry import Polygon
        from shapely.ops import unary_union

        p1 = [(3.8876905895685203, 45.04151669413147), (3.887627532189014, 45.04153865143242), (3.8876011122794605, 45.041690066670036),
              (3.887381519004584, 45.04165503703554), (3.887353965173554,
                                                       45.04182587265956), (3.887338229049791, 45.04183314960833),
              (3.887310771940028, 45.04191918723689), (3.887242112408525,
                                                       45.04195140548229), (3.8872438123226587, 45.04196773839195),
              (3.887204374749257, 45.04202526514552), (3.8871171132633293,
                                                       45.042065804722895), (3.8871012475368705, 45.04206490944411),
              (3.8870572765066194, 45.04220011790408), (3.8870587497518514,
                                                        45.04220214947662), (3.8870545404506114, 45.0422093345757),
              (3.8870202992078413, 45.04232198915604), (3.887094933116707,
                                                        45.042393932102385), (3.8871011336990033, 45.042421467354565),
              (3.8869717947329887, 45.04244395220097), (3.8869230634575063,
                                                        45.042551613886076), (3.886926317471929, 45.042575086000106),
              (3.886895103639052, 45.04260598416935), (3.886886879144402,
                                                       45.04263261265057), (3.8868338254523085, 45.042649381567756),
              (3.886794289881556, 45.04270077903939), (3.886797268744776,
                                                       45.04270688524097), (3.8867806092536608, 45.04274686237081),
              (3.88673968122416, 45.04280133587073), (3.8867411544736874,
                                                      45.04280336744776), (3.8867276032286915, 45.042857622970615),
              (3.8867023468543094, 45.042900733495436), (3.886666437899186,
                                                         45.042908170952025), (3.8866428003243114, 45.04296250676361),
              (3.8866486933259656, 45.04297063307715), (3.8866480614378323,
                                                        45.04302172077985), (3.8866554115187126, 45.04303085714689),
              (3.8866494852855977, 45.0431116149495), (3.8866495014657123,
                                                       45.04311263647416), (3.8866596200854433, 45.04311459922658),
              (3.8867401483427297, 45.04310374157178), (3.886817891880622,
                                                        45.043099035952864), (3.8868580421740018, 45.04317738356993),
              (3.8869827688429424, 45.04313654583372), (3.887067166310092,
                                                        45.04318797799437), (3.8871346455874347, 45.04317211571721),
              (3.887150576385327, 45.04317709708995), (3.8872069008404164,
                                                       45.043184821653774), (3.887245902175824, 45.04319064088496),
              (3.8872487677768497, 45.043189596403046), (3.8872891776324767,
                                                         45.04319336109119), (3.887347040176567, 45.043207203252585),
              (3.887393229831397, 45.04321194350764), (3.887401826629178,
                                                       45.04320881005028), (3.8875174870496596, 45.04323240812782),
              (3.8875904227549194, 45.043288017848305), (3.8876334553317693,
                                                         45.043275415052165), (3.8877849602459436, 45.04328748898497),
              (3.8878322668676484, 45.04327178708148), (3.8879971949577947,
                                                        45.0434032872083), (3.8880175620388595, 45.04341538466404),
              (3.8880121387385693, 45.04343688263403), (3.888008221156936,
                                                        45.04346245521364), (3.8879086866151, 45.04354702437961),
              (3.8880513052171137, 45.04363477118274), (3.88805562793906,
                                                        45.04363473671548), (3.888144317453734, 45.04368409055008),
              (3.8882955336080265, 45.0437687035279), (3.8882970249619313,
                                                       45.043862683792874), (3.8882999229986432, 45.043863682333004),
              (3.888457985682361, 45.04383483690544), (3.8885464164295427,
                                                       45.043867846028704), (3.8886407244539387, 45.0439079597676),
              (3.8886722461769727, 45.04389647006554), (3.8887232782367693,
                                                        45.04393386406545), (3.8887483252237445, 45.04396840043702),
              (3.888764402362445, 45.043982575301364), (3.8887833126843288,
                                                        45.04399366259261), (3.8888383594728513, 45.044011613077636),
              (3.88887716690155, 45.044005173443765), (3.8889237953350024,
                                                       45.04403749422907), (3.8889324732840924, 45.044039468275805),
              (3.888970196703939, 45.04405551365088), (3.8889817889393674,
                                                       45.044059507741046), (3.8889861603626215, 45.044062537811406),
              (3.88900212402531, 45.044069561969685), (3.8890180876920053,
                                                       45.04407658612566), (3.88902386758968, 45.04407756164384),
              (3.889034051362706, 45.04408361027939), (3.889050015037413,
                                                       45.04409063443081), (3.889051455956257, 45.04409062292882),
              (3.889065881369161, 45.04409152943247), (3.889110744557409,
                                                       45.04410343115066), (3.8891864512344116, 45.044151866161144),
              (3.8892212767338505, 45.044166912934536), (3.8892745549455103,
                                                         45.044073517026675), (3.8892860498353468, 45.044071381937876),
              (3.889422206676772, 45.04402432027214), (3.8894591223437933,
                                                       45.0440802164447), (3.8894620366442143, 45.04408223647918),
              (3.8894989523892, 45.0441381326394), (3.8895578391659162,
                                                    45.04421632970203), (3.889550476070388, 45.04429709919299),
              (3.889549051379701, 45.04429813222598), (3.889650565472931,
                                                       45.044338187572016), (3.8897064734000355, 45.044410278432196),
              (3.889720915142458, 45.044412206375654), (3.8897826031870775,
                                                        45.04448527268083), (3.889778653865622, 45.044508802280674),
              (3.889794861323779, 45.04453114919509), (3.889809465482321,
                                                       45.0445432923731), (3.889815489016512, 45.0445595907193),
              (3.8898538138833647, 45.04461343220789), (3.889867042100782,
                                                        45.04462967298946), (3.8898803190444204, 45.044648978343375),
              (3.8899270947567355, 45.04469049243582), (3.8899163955333784,
                                                        45.04474268229789), (3.890103819345595, 45.0448382417801),
              (3.890092438033577, 45.044847527626146), (3.890073130480882,
                                                        45.04499275685796), (3.89009503699226, 45.0450109715718),
              (3.890127923545318, 45.0450852895284), (3.8902105659013078,
                                                      45.04520722757142), (3.8902192115853858, 45.0452071584691),
              (3.890320895383467, 45.045348355680446), (3.890409269865682,
                                                        45.045468204461145), (3.8905245516161586, 45.04555821006024),
              (3.890512428077643, 45.04561143303746), (3.8906757926851583,
                                                       45.04564384137342), (3.8907036154980115, 45.04576213083073),
              (3.890781394907228, 45.04575946549153), (3.890908368151999,
                                                       45.045859593752745), (3.8908962449131392, 45.04591281677601),
              (3.891059610622416, 45.045945224551616), (3.891090300072543,
                                                        45.046062469340974), (3.89116662264816, 45.04605879373611),
              (3.891281923098172, 45.04614982009028), (3.8914198077283877,
                                                       45.0462110375875), (3.8915664035901147, 45.046276271807386),
              (3.891566419860872, 45.04627729333219), (3.8916941531906395,
                                                       45.04633450513391), (3.891698573757933, 45.04634059967409),
              (3.891923064474209, 45.04641031806606), (3.891960961643275, 45.046346671965594), (3.8919004166951385, 45.04625520784626), ]
        p2 = [(3.9033250381529108, 45.05093325543448), (3.9033250546396214, 45.05093427695883), (3.9033642444113967, 45.050951327325535),
              (3.9033250381529108, 45.05093325543448), (3.891923064474209,
                                                        45.04641031806606), (3.8919237643988627, 45.04645424363251),
              (3.8920377073103842, 45.046550388377206), (3.892129832441455,
                                                         45.04654352058926), (3.892321988194928, 45.04675448560807),
              (3.892424102813548, 45.04674140761672), (3.892445360111011,
                                                       45.04689959387055), (3.8925370872501452, 45.046958114881974),
              (3.8925758724799224, 45.04704055816467), (3.8926527501788764,
                                                        45.04707161338626), (3.8926489810796707, 45.047106379877654),
              (3.892723775230843, 45.04718751286762), (3.892833854245315,
                                                       45.0473122941628), (3.8927844782737586, 45.047379097554376),
              (3.8927910080756667, 45.04742706302508), (3.893017653129355,
                                                        45.04745078750724), (3.8930311627051406, 45.0476652268719),
              (3.8930283132807366, 45.0476672930288), (3.8932979714241482,
                                                       45.04776729625783), (3.8932216010767653, 45.0479487417864),
              (3.8933944905393134, 45.04794531188697), (3.8935060298662343,
                                                        45.04807110250977), (3.8935103529274078, 45.048071067830776),
              (3.8936852709284016, 45.04810440082078), (3.8937723683503305,
                                                        45.04814354654425), (3.8938401127059405, 45.04814402458359),
              (3.894047810532827, 45.04824452324314), (3.894324090834022,
                                                       45.04830769126977), (3.894679105789929, 45.048337533227674),
              (3.894877951179586, 45.04833491420052), (3.8950298307103934,
                                                       45.04836945184219), (3.8953418443442476, 45.04841394040901),
              (3.895517911353912, 45.04842887149359), (3.895473530744397,
                                                       45.0485375238582), (3.895459430931195, 45.04855704868051),
              (3.8954552058880343, 45.048563212584305), (3.89513349884777,
                                                         45.048903966627016), (3.8949419924749553, 45.049185439297915),
              (3.8948878782825087, 45.04940655184275), (3.8949651324994217,
                                                        45.04955100636216), (3.8949371368611247, 45.04978314731374),
              (3.894994024405238, 45.04982559981246), (3.8950972875378556, 45.04988402612915), (3.895554378034938, 45.05007753180062), ]
        shapes = [Polygon([(x, y) for x, y in p1]),
                  Polygon([(x, y) for x, y in p2])]

        points = unary_union(shapes)
        assert points


if __name__ == "__main__":
    unittest.main()
