"""
AdMesh Weave Python SDK Types

Type definitions for the AdMesh Weave Python SDK.
"""

from typing import List, Optional, TypedDict, Literal


class ProductLogo(TypedDict):
    """Product logo information."""

    url: str


class AdMeshRecommendation(TypedDict):
    """
    Individual recommendation object returned by the API.

    Core required fields (13 total) - Finalized minimal schema.
    """

    ad_id: str
    product_id: str
    recommendation_id: str
    product_title: str
    citation_summary: str
    weave_summary: str
    exposure_url: str
    click_url: str
    product_logo: ProductLogo
    categories: List[str]
    contextual_relevance_score: float
    trust_score: float
    model_used: str


class AdMeshPublishedRecommendations(TypedDict):
    """Published recommendations with metadata."""

    request_id: str
    session_id: str
    message_id: str
    query: str
    recommendations: List[AdMeshRecommendation]
    published_at: str
    ttl_ms: int


class AdMeshWaitOptions(TypedDict, total=False):
    """Options for waiting for recommendations."""

    timeout_ms: Optional[int]
    poll_interval_ms: Optional[int]


class AdMeshWaitResult(TypedDict, total=False):
    """Result from get_recommendations_for_weave method."""

    found: bool
    recommendations: Optional[List[AdMeshRecommendation]]
    query: Optional[str]
    request_id: Optional[str]
    error: Optional[str]


class AdMeshClientConfig(TypedDict, total=False):
    """Configuration for initializing the AdMeshClient."""

    api_key: str
    api_base_url: Optional[str]


class AdMeshSubscriptionOptions(TypedDict, total=False):
    """Options for subscribing to recommendations."""

    session_id: str
    message_id: str
    query: str  # Required: User query for contextual recommendations
    timeout_ms: Optional[int]


class AdMeshIntegrationResult(TypedDict, total=False):
    """Result from integrate_recommendations method."""

    success: bool
    recommendations: List[AdMeshRecommendation]
    query: str
    weave_text: str
    error: Optional[str]


class AdMeshPromptContext(TypedDict, total=False):
    """Context for formatting recommendations in prompts."""

    query: str
    recommendations: List[AdMeshRecommendation]
    format: Optional[Literal["markdown", "json", "text"]]

