#!/usr/bin/python
# -*- coding: utf-8 -*-

# Hive Administration Scripts
# Copyright (c) 2008-2015 Hive Solutions Lda.
#
# This file is part of Hive Administration Scripts.
#
# Hive Administration Scripts is free software: you can redistribute it and/or modify
# it under the terms of the Apache License as published by the Apache
# Foundation, either version 2.0 of the License, or (at your option) any
# later version.
#
# Hive Administration Scripts is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# Apache License for more details.
#
# You should have received a copy of the Apache License along with
# Hive Administration Scripts. If not, see <http://www.apache.org/licenses/>.

__author__ = "João Magalhães <joamag@hive.pt> & Luís Martinho <lmartinho@hive.pt>"
""" The author(s) of the module """

__version__ = "1.0.0"
""" The version of the module """

__revision__ = "$LastChangedRevision$"
""" The revision number of the module """

__date__ = "$LastChangedDate$"
""" The last change date of the module """

__copyright__ = "Copyright (c) 2008-2015 Hive Solutions Lda."
""" The copyright for the module """

__license__ = "Apache License, Version 2.0"
""" The license for the module """

configurations = (
    {
        "recursive" : True,
        "windows_newline" : True,
        "fix_extra_newlines" : False,
        "property_order" : (
            "animation",
            "-o-animation",
            "-ms-animation",
            "-moz-animation",
            "-khtml-animation",
            "-webkit-animation",
            "animation-duration",
            "-o-animation-duration",
            "-ms-animation-duration",
            "-moz-animation-duration",
            "-khtml-animation-duration",
            "-webkit-animation-duration",
            "-webkit-animation-name",
            "appearance",
            "-o-appearance",
            "-moz-appearance",
            "-khtml-appearance",
            "-webkit-appearance",
            "azimuth",
            "backface-visibility",
            "-o-backface-visibility",
            "-ms-backface-visibility",
            "-moz-backface-visibility",
            "-webkit-backface-visibility",
            "background",
            "background-attachment",
            "-webkit-background-clip",
            "background-color",
            "background-image",
            "background-position",
            "background-position-x",
            "background-position-y",
            "background-size",
            "background-repeat",
            "border",
            "border-bottom",
            "border-bottom-color",
            "border-bottom-left-radius",
            "-webkit-border-bottom-left-radius",
            "border-bottom-right-radius",
            "-webkit-border-bottom-right-radius",
            "border-bottom-style",
            "border-bottom-width",
            "border-collapse",
            "border-color",
            "border-left",
            "border-left-color",
            "border-left-style",
            "border-left-width",
            "border-radius",
            "-o-border-radius",
            "-ms-border-radius",
            "-moz-border-radius",
            "-khtml-border-radius",
            "-webkit-border-radius",
            "-moz-border-radius-bottomleft",
            "-moz-border-radius-bottomright",
            "-moz-border-radius-topleft",
            "-moz-border-radius-topright",
            "border-right",
            "border-right-color",
            "border-right-style",
            "border-right-width",
            "border-spacing",
            "border-style",
            "border-top",
            "border-top-color",
            "border-top-left-radius",
            "-webkit-border-top-left-radius",
            "border-top-right-radius",
            "-webkit-border-top-right-radius",
            "border-top-style",
            "border-top-width",
            "border-width",
            "bottom",
            "box-shadow",
            "-moz-box-shadow",
            "-webkit-box-shadow",
            "box-sizing",
            "-moz-box-sizing",
            "-webkit-box-sizing",
            "caption-side",
            "clear",
            "clip",
            "color",
            "column-count",
            "-o-column-count",
            "-ms-column-count",
            "-moz-column-count",
            "-khtml-column-count",
            "-webkit-column-count",
            "-webkit-column-count",
            "column-gap",
            "-o-column-gap",
            "-ms-column-gap",
            "-moz-column-gap",
            "-khtml-column-gap",
            "-webkit-column-gap",
            "-webkit-column-gap",
            "content",
            "counter-increment",
            "counter-reset",
            "cue-after",
            "cue-before",
            "cue",
            "cursor",
            "direction",
            "display",
            "elevation",
            "empty-cells",
            "float",
            "font-family",
            "font-size",
            "font-size-adjust",
            "font-smoothing",
            "-o-font-smoothing",
            "-moz-font-smoothing",
            "-khtml-font-smoothing",
            "-webkit-font-smoothing",
            "font-style",
            "font-variant",
            "font-weight",
            "font",
            "height",
            "hyphens",
            "-ms-hyphens",
            "-moz-hyphens",
            "-webkit-hyphens",
            "left",
            "letter-spacing",
            "line-height",
            "list-style",
            "list-style-image",
            "list-style-position",
            "list-style-type",
            "margin",
            "margin-bottom",
            "margin-left",
            "margin-right",
            "margin-top",
            "max-height",
            "max-width",
            "min-height",
            "min-width",
            "opacity",
            "orphans",
            "outline-color",
            "outline-offset",
            "outline-style",
            "outline-width",
            "outline",
            "overflow",
            "overflow-x",
            "overflow-y",
            "padding-bottom",
            "padding-left",
            "padding-right",
            "padding-top",
            "padding",
            "page-break-after",
            "page-break-before",
            "page-break-inside",
            "pause-after",
            "pause-before",
            "pause",
            "-webkit-perspective",
            "pitch-range",
            "pitch",
            "play-during",
            "pointer-events",
            "position",
            "quotes",
            "resize",
            "richness",
            "right",
            "size",
            "speak",
            "speak-header",
            "speak-numeral",
            "speak-punctuation",
            "speech-rate",
            "src",
            "stress",
            "tab-size",
            "-o-tab-size",
            "-moz-tab-size",
            "table-layout",
            "tap-highlight-color",
            "-o-tap-highlight-color",
            "-ms-tap-highlight-color",
            "-moz-tap-highlight-color",
            "-webkit-tap-highlight-color",
            "text-align",
            "text-decoration",
            "text-fill-color",
            "-webkit-text-fill-color",
            "text-indent",
            "text-overflow",
            "text-shadow",
            "text-transform",
            "top",
            "touch-callout",
            "-o-touch-callout",
            "-ms-touch-callout",
            "-moz-touch-callout",
            "-webkit-touch-callout",
            "transform",
            "-o-transform",
            "-ms-transform",
            "-moz-transform",
            "-webkit-transform",
            "-webkit-transform-style",
            "transition",
            "-o-transition",
            "-ms-transition",
            "-moz-transition",
            "-webkit-transition",
            "transition-delay",
            "-o-transition-delay",
            "-ms-transition-delay",
            "-moz-transition-delay",
            "-webkit-transition-delay",
            "transition-duration",
            "-o-transition-duration",
            "-ms-transition-duration",
            "-moz-transition-duration",
            "-webkit-transition-duration",
            "transition-timing-function",
            "-o-transition-timing-function",
            "-ms-transition-timing-function",
            "-moz-transition-timing-function",
            "-webkit-transition-timing-function",
            "unicode-bidi",
            "user-select",
            "-o-user-select",
            "-moz-user-select",
            "-khtml-user-select",
            "-webkit-user-select",
            "vertical-align",
            "visibility",
            "voice-family",
            "volume",
            "white-space",
            "widows",
            "width",
            "word-break",
            "word-spacing",
            "word-wrap",
            "z-index"
        ),
        "rules_skip" : (
            "@-",
        ),
        "file_extensions" : (
            "css",
        ),
        "file_exclusion" : ("android-sdk",)
    },
)
