from collections.abc import Mapping
from typing import Any, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

T = TypeVar("T", bound="ModelInformationRequest")


@_attrs_define
class ModelInformationRequest:
    """
    Attributes:
        brand (str): Brand name
        manufacturer (str): Manufacturer name
        model (str): Model name
    """

    brand: str
    manufacturer: str
    model: str
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        brand = self.brand

        manufacturer = self.manufacturer

        model = self.model

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "brand": brand,
                "manufacturer": manufacturer,
                "model": model,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        brand = d.pop("brand")

        manufacturer = d.pop("manufacturer")

        model = d.pop("model")

        model_information_request = cls(
            brand=brand,
            manufacturer=manufacturer,
            model=model,
        )

        model_information_request.additional_properties = d
        return model_information_request

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
