# Copyright (c) 2025 Beijing Volcano Engine Technology Co., Ltd. and/or its affiliates.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated from API JSON definition
# Do not edit manually

from __future__ import annotations

from typing import Optional, List, Dict, Any
from pydantic import BaseModel, Field


# Data Types
class ApiKeysForListMCPToolsets(BaseModel):
    key: Optional[str] = Field(default=None, alias="Key")
    name: Optional[str] = Field(default=None, alias="Name")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class KeyAuthForListMCPToolsets(BaseModel):
    api_key_location: Optional[str] = Field(default=None, alias="ApiKeyLocation")
    api_keys: Optional[list[ApiKeysForListMCPToolsets]] = Field(default=None, alias="ApiKeys")
    parameter: Optional[str] = Field(default=None, alias="Parameter")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class AuthorizerForListMCPToolsets(BaseModel):
    key_auth: Optional[KeyAuthForListMCPToolsets] = Field(default=None, alias="KeyAuth")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class AuthorizerConfigurationForListMCPToolsets(BaseModel):
    authorizer: Optional[AuthorizerForListMCPToolsets] = Field(default=None, alias="Authorizer")
    authorizer_type: Optional[str] = Field(default=None, alias="AuthorizerType")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class NetworkConfigurationsForListMCPToolsets(BaseModel):
    endpoint: Optional[str] = Field(default=None, alias="Endpoint")
    network_type: Optional[str] = Field(default=None, alias="NetworkType")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class ProtocolConfigurationForListMCPToolsets(BaseModel):
    protocol_convert_configuration: Optional[str] = Field(default=None, alias="ProtocolConvertConfiguration")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class MCPServicesForListMCPToolsets(BaseModel):
    created_at: Optional[str] = Field(default=None, alias="CreatedAt")
    m_c_p_service_id: Optional[str] = Field(default=None, alias="MCPServiceId")
    name: Optional[str] = Field(default=None, alias="Name")
    network_configurations: Optional[list[NetworkConfigurationsForListMCPToolsets]] = Field(default=None, alias="NetworkConfigurations")
    path: Optional[str] = Field(default=None, alias="Path")
    protocol_configuration: Optional[ProtocolConfigurationForListMCPToolsets] = Field(default=None, alias="ProtocolConfiguration")
    protocol_type: Optional[str] = Field(default=None, alias="ProtocolType")
    status: Optional[str] = Field(default=None, alias="Status")
    updated_at: Optional[str] = Field(default=None, alias="UpdatedAt")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class NetworkConfigurationsForListMCPToolsets(BaseModel):
    endpoint: Optional[str] = Field(default=None, alias="Endpoint")
    network_type: Optional[str] = Field(default=None, alias="NetworkType")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class MCPToolsetsForListMCPToolsets(BaseModel):
    authorizer_configuration: Optional[AuthorizerConfigurationForListMCPToolsets] = Field(default=None, alias="AuthorizerConfiguration")
    created_at: Optional[str] = Field(default=None, alias="CreatedAt")
    m_c_p_services: Optional[list[MCPServicesForListMCPToolsets]] = Field(default=None, alias="MCPServices")
    m_c_p_toolset_id: Optional[str] = Field(default=None, alias="MCPToolsetId")
    name: Optional[str] = Field(default=None, alias="Name")
    network_configurations: Optional[list[NetworkConfigurationsForListMCPToolsets]] = Field(default=None, alias="NetworkConfigurations")
    path: Optional[str] = Field(default=None, alias="Path")
    status: Optional[str] = Field(default=None, alias="Status")
    updated_at: Optional[str] = Field(default=None, alias="UpdatedAt")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class MCPServiceToolsForListMCPTools(BaseModel):
    m_c_p_service_id: Optional[str] = Field(default=None, alias="MCPServiceId")
    tools: Optional[str] = Field(default=None, alias="Tools")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class NetworkConfigurationsForListMCPServices(BaseModel):
    endpoint: Optional[str] = Field(default=None, alias="Endpoint")
    network_type: Optional[str] = Field(default=None, alias="NetworkType")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class ProtocolConfigurationForListMCPServices(BaseModel):
    protocol_convert_configuration: Optional[str] = Field(default=None, alias="ProtocolConvertConfiguration")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class MCPServicesForListMCPServices(BaseModel):
    created_at: Optional[str] = Field(default=None, alias="CreatedAt")
    m_c_p_service_id: Optional[str] = Field(default=None, alias="MCPServiceId")
    name: Optional[str] = Field(default=None, alias="Name")
    network_configurations: Optional[list[NetworkConfigurationsForListMCPServices]] = Field(default=None, alias="NetworkConfigurations")
    path: Optional[str] = Field(default=None, alias="Path")
    protocol_configuration: Optional[ProtocolConfigurationForListMCPServices] = Field(default=None, alias="ProtocolConfiguration")
    protocol_type: Optional[str] = Field(default=None, alias="ProtocolType")
    status: Optional[str] = Field(default=None, alias="Status")
    updated_at: Optional[str] = Field(default=None, alias="UpdatedAt")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class CustomConfigurationForGetMCPService(BaseModel):
    domain: Optional[str] = Field(default=None, alias="Domain")
    port: Optional[int] = Field(default=None, alias="Port")
    protocol_type: Optional[str] = Field(default=None, alias="ProtocolType")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class FunctionConfigurationForGetMCPService(BaseModel):
    function_id: Optional[str] = Field(default=None, alias="FunctionId")
    function_name: Optional[str] = Field(default=None, alias="FunctionName")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class BackendConfigurationForGetMCPService(BaseModel):
    custom_configuration: Optional[CustomConfigurationForGetMCPService] = Field(default=None, alias="CustomConfiguration")
    function_configuration: Optional[FunctionConfigurationForGetMCPService] = Field(default=None, alias="FunctionConfiguration")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class ApiKeysForGetMCPService(BaseModel):
    key: Optional[str] = Field(default=None, alias="Key")
    name: Optional[str] = Field(default=None, alias="Name")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class KeyAuthForGetMCPService(BaseModel):
    api_key_location: Optional[str] = Field(default=None, alias="ApiKeyLocation")
    api_keys: Optional[list[ApiKeysForGetMCPService]] = Field(default=None, alias="ApiKeys")
    parameter: Optional[str] = Field(default=None, alias="Parameter")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class AuthorizerForGetMCPService(BaseModel):
    key_auth: Optional[KeyAuthForGetMCPService] = Field(default=None, alias="KeyAuth")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class InboundAuthorizerConfigurationForGetMCPService(BaseModel):
    authorizer: Optional[AuthorizerForGetMCPService] = Field(default=None, alias="Authorizer")
    authorizer_type: Optional[str] = Field(default=None, alias="AuthorizerType")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class NetworkConfigurationsForGetMCPService(BaseModel):
    endpoint: Optional[str] = Field(default=None, alias="Endpoint")
    network_type: Optional[str] = Field(default=None, alias="NetworkType")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class ApiKeysForGetMCPService(BaseModel):
    key: Optional[str] = Field(default=None, alias="Key")
    name: Optional[str] = Field(default=None, alias="Name")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class KeyAuthForGetMCPService(BaseModel):
    api_key_location: Optional[str] = Field(default=None, alias="ApiKeyLocation")
    api_keys: Optional[list[ApiKeysForGetMCPService]] = Field(default=None, alias="ApiKeys")
    parameter: Optional[str] = Field(default=None, alias="Parameter")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class AuthorizerForGetMCPService(BaseModel):
    key_auth: Optional[KeyAuthForGetMCPService] = Field(default=None, alias="KeyAuth")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class OutboundAuthorizerConfigurationForGetMCPService(BaseModel):
    authorizer: Optional[AuthorizerForGetMCPService] = Field(default=None, alias="Authorizer")
    authorizer_type: Optional[str] = Field(default=None, alias="AuthorizerType")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class ProtocolConfigurationForGetMCPService(BaseModel):
    protocol_convert_configuration: Optional[str] = Field(default=None, alias="ProtocolConvertConfiguration")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class MCPServiceForGetMCPService(BaseModel):
    backend_configuration: Optional[BackendConfigurationForGetMCPService] = Field(default=None, alias="BackendConfiguration")
    backend_type: Optional[str] = Field(default=None, alias="BackendType")
    created_at: Optional[str] = Field(default=None, alias="CreatedAt")
    inbound_authorizer_configuration: Optional[InboundAuthorizerConfigurationForGetMCPService] = Field(default=None, alias="InboundAuthorizerConfiguration")
    m_c_p_service_id: Optional[str] = Field(default=None, alias="MCPServiceId")
    name: Optional[str] = Field(default=None, alias="Name")
    network_configurations: Optional[list[NetworkConfigurationsForGetMCPService]] = Field(default=None, alias="NetworkConfigurations")
    outbound_authorizer_configuration: Optional[OutboundAuthorizerConfigurationForGetMCPService] = Field(default=None, alias="OutboundAuthorizerConfiguration")
    path: Optional[str] = Field(default=None, alias="Path")
    protocol_configuration: Optional[ProtocolConfigurationForGetMCPService] = Field(default=None, alias="ProtocolConfiguration")
    protocol_type: Optional[str] = Field(default=None, alias="ProtocolType")
    status: Optional[str] = Field(default=None, alias="Status")
    updated_at: Optional[str] = Field(default=None, alias="UpdatedAt")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class ApiKeysForGetMCPToolset(BaseModel):
    key: Optional[str] = Field(default=None, alias="Key")
    name: Optional[str] = Field(default=None, alias="Name")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class KeyAuthForGetMCPToolset(BaseModel):
    api_key_location: Optional[str] = Field(default=None, alias="ApiKeyLocation")
    api_keys: Optional[list[ApiKeysForGetMCPToolset]] = Field(default=None, alias="ApiKeys")
    parameter: Optional[str] = Field(default=None, alias="Parameter")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class AuthorizerForGetMCPToolset(BaseModel):
    key_auth: Optional[KeyAuthForGetMCPToolset] = Field(default=None, alias="KeyAuth")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class AuthorizerConfigurationForGetMCPToolset(BaseModel):
    authorizer: Optional[AuthorizerForGetMCPToolset] = Field(default=None, alias="Authorizer")
    authorizer_type: Optional[str] = Field(default=None, alias="AuthorizerType")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class NetworkConfigurationsForGetMCPToolset(BaseModel):
    endpoint: Optional[str] = Field(default=None, alias="Endpoint")
    network_type: Optional[str] = Field(default=None, alias="NetworkType")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class ProtocolConfigurationForGetMCPToolset(BaseModel):
    protocol_convert_configuration: Optional[str] = Field(default=None, alias="ProtocolConvertConfiguration")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class MCPServicesForGetMCPToolset(BaseModel):
    created_at: Optional[str] = Field(default=None, alias="CreatedAt")
    m_c_p_service_id: Optional[str] = Field(default=None, alias="MCPServiceId")
    name: Optional[str] = Field(default=None, alias="Name")
    network_configurations: Optional[list[NetworkConfigurationsForGetMCPToolset]] = Field(default=None, alias="NetworkConfigurations")
    path: Optional[str] = Field(default=None, alias="Path")
    protocol_configuration: Optional[ProtocolConfigurationForGetMCPToolset] = Field(default=None, alias="ProtocolConfiguration")
    protocol_type: Optional[str] = Field(default=None, alias="ProtocolType")
    status: Optional[str] = Field(default=None, alias="Status")
    updated_at: Optional[str] = Field(default=None, alias="UpdatedAt")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class NetworkConfigurationsForGetMCPToolset(BaseModel):
    endpoint: Optional[str] = Field(default=None, alias="Endpoint")
    network_type: Optional[str] = Field(default=None, alias="NetworkType")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class MCPToolsetForGetMCPToolset(BaseModel):
    authorizer_configuration: Optional[AuthorizerConfigurationForGetMCPToolset] = Field(default=None, alias="AuthorizerConfiguration")
    created_at: Optional[str] = Field(default=None, alias="CreatedAt")
    m_c_p_services: Optional[list[MCPServicesForGetMCPToolset]] = Field(default=None, alias="MCPServices")
    m_c_p_toolset_id: Optional[str] = Field(default=None, alias="MCPToolsetId")
    name: Optional[str] = Field(default=None, alias="Name")
    network_configurations: Optional[list[NetworkConfigurationsForGetMCPToolset]] = Field(default=None, alias="NetworkConfigurations")
    path: Optional[str] = Field(default=None, alias="Path")
    status: Optional[str] = Field(default=None, alias="Status")
    updated_at: Optional[str] = Field(default=None, alias="UpdatedAt")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetMCPTools - Request
class GetMCPToolsRequest(BaseModel):
    m_c_p_toolset_id: str = Field(..., alias="MCPToolsetId")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetMCPTools - Response
class GetMCPToolsResponse(BaseModel):
    tools: Optional[str] = Field(default=None, alias="Tools")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListMCPToolsets - Request
class FiltersItem(BaseModel):
    name: Optional[str] = Field(default=None, alias="Name", description="精确过滤的字段名。 - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔，为“或”的关系。 - 取值： - name：MCP工具集名称。 - status：MCP工具集状态。 ::: tip 当`Filters.N.Name`和`Filters.N.NameContains`同时传入时，仅`Filters.N.Name`生效。 :::")
    name_contains: Optional[str] = Field(default=None, alias="NameContains", description="精确过滤的字段名。 - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔，为“或”的关系。 - 取值： - name：MCP工具集名称。 - status：MCP工具集状态。 ::: tip 当`Filters.N.Name`和`Filters.N.NameContains`同时传入时，仅`Filters.N.Name`生效。 :::")
    values: Optional[list[str]] = Field(default=None, alias="Values", description="过滤字段的值。 - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔。 当过滤字段为status时，取值： - Ready：运行中。 - Creating：创建中。 - Updating：更新中。 - Deleting：删除中。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class ListMCPToolsetsRequest(BaseModel):
    max_results: Optional[int] = Field(default=None, alias="MaxResults", description="分页查询时设置的每页行数。 - 最小值：1。 - 最大值：100。 - 默认值：10")
    next_token: Optional[str] = Field(default=None, alias="NextToken", description="分页查询凭证，用于标记分页的位置，初次调用该接口时无需设置。下次查询时，取值为上一次API调用返回的`NextToken`参数值。")
    filters: Optional[list[FiltersItem]] = Field(default=None, alias="Filters")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListMCPToolsets - Response
class ListMCPToolsetsResponse(BaseModel):
    m_c_p_toolsets: Optional[list[MCPToolsetsForListMCPToolsets]] = Field(default=None, alias="MCPToolsets", description="MCP服务详情。")
    next_token: Optional[str] = Field(default=None, alias="NextToken", description="本次调用返回的查询凭证值，返回为空表示该页为末页。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# CreateMCPToolset - Request
class AuthorizerConfiguration(BaseModel):
    authorizer_type: str = Field(..., alias="AuthorizerType", description="MCP服务访问后端服务时的认证类型，取值： - ApiKey：当前仅支持APIKey。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class Authorizer(BaseModel):
    key_auth: Optional[KeyAuth] = Field(default=None, alias="KeyAuth")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class KeyAuth(BaseModel):
    api_key_location: Optional[str] = Field(default=None, alias="ApiKeyLocation", description="访问MCP工具集网关，APIKey传递的位置。取值： - HEADER：当前仅支持Header。")
    parameter: Optional[str] = Field(default=None, alias="Parameter", description="访问MCP工具集时，需要携带的Header的APIKey对应的名称。 ::: tip 当`AuthorizerType`取值为ApiKey时必填。 :::")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class ApiKeysItem(BaseModel):
    name: str = Field(..., alias="Name", description="MCP工具集身份认证鉴权的APIKey名称。 - 参数 - N：表示APIKey名称的序号，取值范围：1～5。 - 多个字段名之间用&分隔。 - 长度为4 ～ 64的字符串。 - 由字母、数字、“-”和“_”组成。 ::: tip 当`AuthorizerType`取值为ApiKey时必填。 :::")
    key: Optional[str] = Field(default=None, alias="Key", description="MCP工具集身份认证鉴权的APIKey。 - 参数 - N：表示APIKey值的序号，取值范围：1～5。 - 多个字段名之间用&分隔。 - 不填则默认随机生成一个字符串。 ::: tip 当`AuthorizerType`取值为ApiKey时必填。 :::")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class NetworkConfigurationsItem(BaseModel):
    network_type: str = Field(..., alias="NetworkType", description="需要开启的访问类型。 - 参数 - N：表示网络访问类型的序号，取值范围：1。 取值： - Public：当前仅支持公网访问。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class CreateMCPToolsetRequest(BaseModel):
    client_token: Optional[str] = Field(default=None, alias="ClientToken", description="保证请求幂等性。由客户端自动生成一个参数值，确保不同请求间该参数值唯一，避免当调用API超时或服务器内部错误时，客户端多次重试导致重复性操作。 取值：仅支持ASCII字符，且不能超过64个字符。")
    m_c_p_service_ids: str = Field(..., alias="MCPServiceIds", description="MCP服务。 - 参数 - N：表示MCP服务的序号，取值范围：1～100。 - 多个字段名之间用&分隔。")
    name: str = Field(..., alias="Name", description="MCP工具集名称。 - 长度为4-64的字符串。 - 由字母、数字、“-”和“_”组成。")
    path: str = Field(..., alias="Path", description="MCP工具集的访问路径。")
    authorizer_configuration: Optional[AuthorizerConfiguration] = Field(default=None, alias="AuthorizerConfiguration")
    network_configurations: Optional[list[NetworkConfigurationsItem]] = Field(default=None, alias="NetworkConfigurations")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# CreateMCPToolset - Response
class CreateMCPToolsetResponse(BaseModel):
    m_c_p_toolset_id: Optional[str] = Field(default=None, alias="MCPToolsetId", description="MCP工具集ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListMCPTools - Request
class ListMCPToolsRequest(BaseModel):
    m_c_p_toolset_ids: str = Field(..., alias="MCPToolsetIds")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListMCPTools - Response
class ListMCPToolsResponse(BaseModel):
    m_c_p_service_tools: Optional[list[MCPServiceToolsForListMCPTools]] = Field(default=None, alias="MCPServiceTools")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListMCPServices - Request
class FiltersItem(BaseModel):
    name: Optional[str] = Field(default=None, alias="Name", description="精确过滤的字段名。 - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔，为“或”的关系。 - 取值： - name：MCP服务名称。 - status：MCP服务状态。 ::: tip 当`Filters.N.Name`和`Filters.N.NameContains`同时传入时，仅`Filters.N.Name`生效。 :::")
    name_contains: Optional[str] = Field(default=None, alias="NameContains", description="模糊过滤的字段名。 - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔，为“或”的关系。 - 取值： - name：MCP服务名称。 - status：MCP服务状态。 ::: tip 当`Filters.N.Name`和`Filters.N.NameContains`同时传入时，仅`Filters.N.Name`生效。 :::")
    values: Optional[list[str]] = Field(default=None, alias="Values", description="过滤字段的值。 - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔。 当过滤字段为status时，取值： - Ready：运行中。 - Creating：创建中。 - Updating：更新中。 - Deleting：删除中。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class ListMCPServicesRequest(BaseModel):
    max_results: Optional[int] = Field(default=None, alias="MaxResults", description="分页查询时设置的每页行数。 - 最小值：1。 - 最大值：100。 - 默认值：10")
    next_token: Optional[str] = Field(default=None, alias="NextToken", description="分页查询凭证，用于标记分页的位置，初次调用该接口时无需设置。下次查询时，取值为上一次API调用返回的`NextToken`参数值。")
    filters: Optional[list[FiltersItem]] = Field(default=None, alias="Filters")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListMCPServices - Response
class ListMCPServicesResponse(BaseModel):
    m_c_p_services: Optional[list[MCPServicesForListMCPServices]] = Field(default=None, alias="MCPServices", description="MCP服务详情。")
    next_token: Optional[str] = Field(default=None, alias="NextToken", description="本次调用返回的查询凭证值，返回为空表示该页为末页。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# CreateMCPService - Request
class BackendConfiguration(BaseModel):
    custom_configuration: Optional[CustomConfiguration] = Field(default=None, alias="CustomConfiguration")
    function_configuration: Optional[FunctionConfiguration] = Field(default=None, alias="FunctionConfiguration")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class CustomConfiguration(BaseModel):
    domain: Optional[str] = Field(default=None, alias="Domain", description="MCP服务的后端服务的域名。 ::: tip 当`BackendType`取值为Domain时必填。 :::")
    port: Optional[int] = Field(default=None, alias="Port", description="MCP服务对接的后端服务的端口。 ::: tip 当`BackendType`取值为Domain时必填。 :::")
    protocol_type: Optional[str] = Field(default=None, alias="ProtocolType", description="MCP服务对接的后端服务的协议，取值： - HTTP：后端为HTTP服务。 - HTTPS：后端为HTTPS服务。 ::: tip 当`BackendType`取值为Domain时必填。 :::")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class FunctionConfiguration(BaseModel):
    function_id: Optional[str] = Field(default=None, alias="FunctionId", description="函数服务（veFaaS）ID。 ::: tip 当`BackendType`取值为Function时必填。 :::")
    function_name: Optional[str] = Field(default=None, alias="FunctionName", description="函数服务（veFaaS）名称。 ::: tip 当`BackendType`取值为Function时必填。 :::")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class InboundAuthorizerConfiguration(BaseModel):
    authorizer_type: str = Field(..., alias="AuthorizerType", description="MCP服务身份认证加安全的类型，取值： - ApiKey：当前仅支持APIKey。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class Authorizer(BaseModel):
    key_auth: Optional[KeyAuth] = Field(default=None, alias="KeyAuth")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class KeyAuth(BaseModel):
    api_key_location: Optional[str] = Field(default=None, alias="ApiKeyLocation", description="使用APIKey进行身份认证鉴权时，APIKey的传递的位置。取值： - HEADER：当前仅支持HEADER。 ::: tip 当`Inbound****.AuthorizerType`取值为ApiKey时必填。 :::")
    parameter: Optional[str] = Field(default=None, alias="Parameter", description="MCP访问后端服务时，需要携带的Header的APIKey对应的名称。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class OutboundAuthorizerConfiguration(BaseModel):
    authorizer_type: str = Field(..., alias="AuthorizerType", description="MCP服务访问后端服务时的认证类型，取值： - ApiKey：当前仅支持APIKey。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class Authorizer(BaseModel):
    key_auth: Optional[KeyAuth] = Field(default=None, alias="KeyAuth")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class KeyAuth(BaseModel):
    api_key_location: Optional[str] = Field(default=None, alias="ApiKeyLocation", description="MCP服务网关对应的后端服务使用APIKey进行身份认证鉴权时，APIKey的传递的位置。取值： - HEADER：当前仅支持HEADER。 ::: tip 当`Outbound****.AuthorizerType`取值为ApiKey时必填。 :::")
    parameter: Optional[str] = Field(default=None, alias="Parameter", description="MCP服务访问后端时，携带的Header的APIKey对应的名称。 ::: tip 当`Outbound****AuthorizerType`取值为ApiKey时必填。 :::")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class ProtocolConfiguration(BaseModel):
    http_api_configuration: Optional[HttpApiConfiguration] = Field(default=None, alias="HttpApiConfiguration")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class HttpApiConfiguration(BaseModel):
    configuration: Optional[str] = Field(default=None, alias="Configuration", description="MCP后端服务的接口描述，如：Swagger 的json，需进行Base64编码。")
    type: Optional[str] = Field(default=None, alias="Type", description="当后端接口为HTTP时，后端接口的展示形式，取值：Swagger。 ::: tip 当ProtocolType为HTTP时，为必填。 :::")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class ApiKeysItem(BaseModel):
    name: str = Field(..., alias="Name", description="MCP服务身份认证鉴权的APIKey名称。 - 参数 - N：表示APIKey名称的序号，取值范围：1～5。 - 多个字段名之间用&分隔。 - 长度为4-64的字符串。 - 由字母、数字、“-”和“_”组成 ::: tip 当`Inbound****.AuthorizerType`取值为ApiKey时必填。 :::")
    key: Optional[str] = Field(default=None, alias="Key", description="MCP服务身份认证鉴权的APIKey值，用户需要携带该APIKey访问MCP服务。取值： - 参数 - N：表示APIKey值的序号，取值范围：1～5。 - 多个字段名之间用&分隔。 - 不填则默认随机生成一个字符串。 ::: tip 当`Inbound****.AuthorizerType`取值为ApiKey时必填。 :::")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class NetworkConfigurationsItem(BaseModel):
    network_type: str = Field(..., alias="NetworkType", description="MCP服务的网络访问类型。 - 参数 - N：表示网络访问类型的序号，取值范围：1。 取值： - Public：当前仅支持公网访问。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class ApiKeysItem(BaseModel):
    key: Optional[str] = Field(default=None, alias="Key", description="MCP服务网关对应的后端服务身份认证鉴权的APIKey值，用户需要携带该APIKey访问MCP服务。取值： - 参数 - N：表示APIKey值的序号，取值范围：1～5。 - 多个字段名之间用&分隔。 - 不填则默认随机生成一个字符串。 ::: tip 当`Outbound****AuthorizerType`取值为ApiKey时必填。 :::")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class CreateMCPServiceRequest(BaseModel):
    backend_type: str = Field(..., alias="BackendType", description="MCP服务的后端服务的类型，取值： - Function：veFaaS函数。 - Domain：固定域名。")
    client_token: Optional[str] = Field(default=None, alias="ClientToken", description="保证请求幂等性。由客户端自动生成一个参数值，确保不同请求间该参数值唯一，避免当调用API超时或服务器内部错误时，客户端多次重试导致重复性操作。 取值：仅支持ASCII字符，且不能超过64个字符。")
    name: str = Field(..., alias="Name", description="MCP服务名称，取值： - 长度为4 ～ 64的字符串。 - 由字母、数字、“-”和“_”组成")
    path: str = Field(..., alias="Path", description="MCP服务的访问路径。")
    protocol_type: str = Field(..., alias="ProtocolType", description="MCP服务后端协议类型，取值： - HTTP：HTTP 转 MCP。 - MCP：直接访问 MCP。")
    backend_configuration: Optional[BackendConfiguration] = Field(default=None, alias="BackendConfiguration")
    inbound_authorizer_configuration: Optional[InboundAuthorizerConfiguration] = Field(default=None, alias="InboundAuthorizerConfiguration")
    network_configurations: Optional[list[NetworkConfigurationsItem]] = Field(default=None, alias="NetworkConfigurations")
    outbound_authorizer_configuration: Optional[OutboundAuthorizerConfiguration] = Field(default=None, alias="OutboundAuthorizerConfiguration")
    protocol_configuration: Optional[ProtocolConfiguration] = Field(default=None, alias="ProtocolConfiguration")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# CreateMCPService - Response
class CreateMCPServiceResponse(BaseModel):
    m_c_p_service_id: Optional[str] = Field(default=None, alias="MCPServiceId", description="MCP服务ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# DeleteMCPToolset - Request
class DeleteMCPToolsetRequest(BaseModel):
    m_c_p_toolset_id: str = Field(..., alias="MCPToolsetId", description="MCP工具集ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# DeleteMCPToolset - Response
class DeleteMCPToolsetResponse(BaseModel):
    m_c_p_toolset_id: Optional[str] = Field(default=None, alias="MCPToolsetId", description="MCP工具集ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# UpdateMCPService - Request
class BackendConfiguration(BaseModel):
    custom_configuration: Optional[CustomConfiguration] = Field(default=None, alias="CustomConfiguration")
    function_configuration: Optional[FunctionConfiguration] = Field(default=None, alias="FunctionConfiguration")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class CustomConfiguration(BaseModel):
    domain: Optional[str] = Field(default=None, alias="Domain", description="MCP服务的后端服务的域名。 ::: tip 当`BackendType`取值为Domain时必填。 :::")
    port: Optional[int] = Field(default=None, alias="Port", description="MCP服务对接的后端服务的端口。 ::: tip 当`BackendType`取值为Domain时必填。 :::")
    protocol_type: Optional[str] = Field(default=None, alias="ProtocolType", description="MCP服务对接的后端服务的协议，取值： - HTTP：后端为HTTP服务。 - HTTPS：后端为HTTPS服务。 ::: tip 当`BackendType`取值为Domain时必填。 :::")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class FunctionConfiguration(BaseModel):
    function_id: Optional[str] = Field(default=None, alias="FunctionId", description="函数服务（veFaaS）ID。 ::: tip 当`BackendType`取值为Function时必填。 :::")
    function_name: Optional[str] = Field(default=None, alias="FunctionName", description="函数服务（veFaaS）名称。 ::: tip 当`BackendType`取值为Function时必填。 :::")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class InboundAuthorizerConfiguration(BaseModel):
    authorizer_type: str = Field(..., alias="AuthorizerType", description="MCP服务身份认证加安全的类型，取值： - ApiKey：当前仅支持APIKey。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class Authorizer(BaseModel):
    key_auth: Optional[KeyAuth] = Field(default=None, alias="KeyAuth")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class KeyAuth(BaseModel):
    api_key_location: Optional[str] = Field(default=None, alias="ApiKeyLocation", description="使用APIKey进行身份认证鉴权时，APIKey的传递的位置。取值： - HEADER：当前仅支持HEADER。 ::: tip 当`Inbound****.AuthorizerType`取值为ApiKey时必填。 :::")
    parameter: Optional[str] = Field(default=None, alias="Parameter", description="MCP访问后端服务时，需要携带的Header的APIKey对应的名称。 ::: tip 当`Inbound****.AuthorizerType`取值为ApiKey时必填。 :::")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class OutboundAuthorizerConfiguration(BaseModel):
    authorizer_type: str = Field(..., alias="AuthorizerType", description="MCP服务访问后端服务时的认证类型，取值： - ApiKey：当前仅支持APIKey。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class Authorizer(BaseModel):
    key_auth: Optional[KeyAuth] = Field(default=None, alias="KeyAuth")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class KeyAuth(BaseModel):
    api_key_location: Optional[str] = Field(default=None, alias="ApiKeyLocation", description="MCP服务网关对应的后端服务使用APIKey进行身份认证鉴权时，APIKey的传递的位置。取值： - HEADER：当前仅支持HEADER。 ::: tip 当`Outbound****.AuthorizerType`取值为ApiKey时必填。 :::")
    parameter: Optional[str] = Field(default=None, alias="Parameter", description="MCP服务访问后端时，携带的Header的APIKey对应的名称。 ::: tip 当`Outbound****AuthorizerType`取值为ApiKey时必填。 :::")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class ApiKeysItem(BaseModel):
    name: str = Field(..., alias="Name", description="MCP服务身份认证鉴权的APIKey名称。 - 参数 - N：表示APIKey名称的序号，取值范围：1～5。 - 多个字段名之间用&分隔。 - 长度为4-64的字符串。 - 由字母、数字、“-”和“_”组成 ::: tip 当`Inbound****.AuthorizerType`取值为ApiKey时必填。 :::")
    key: Optional[str] = Field(default=None, alias="Key", description="MCP服务身份认证鉴权的APIKey值，用户需要携带该APIKey访问MCP服务。取值： - 参数 - N：表示APIKey值的序号，取值范围：1～5。 - 多个字段名之间用&分隔。 - 不填则默认随机生成一个字符串。 ::: tip 当`Inbound****.AuthorizerType`取值为ApiKey时必填。 :::")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class NetworkConfigurationsItem(BaseModel):
    network_type: str = Field(..., alias="NetworkType", description="MCP服务的网络访问类型。 - 参数 - N：表示网络访问类型的序号，取值范围：1。 取值： - Public：当前仅支持公网访问")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class ApiKeysItem(BaseModel):
    name: str = Field(..., alias="Name", description="MCP服务网关对应的后端服务身份认证鉴权的APIKey名称，取值： - 长度为4 ～ 64的字符串。 - 由字母、数字、“-”和“_”组成。 - 多个字段名之间用&分隔。 ::: tip 当`Outbound****AuthorizerType`取值为ApiKey时必填。 :::")
    key: Optional[str] = Field(default=None, alias="Key", description="MCP服务网关对应的后端服务身份认证鉴权的APIKey值，用户需要携带该APIKey访问MCP服务。取值： - 参数 - N：表示APIKey值的序号，取值范围：1～5。 - 多个字段名之间用&分隔。 - 不填则默认随机生成一个字符串。 ::: tip 当`Outbound****AuthorizerType`取值为ApiKey时必填。 :::")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class UpdateMCPServiceRequest(BaseModel):
    backend_type: Optional[str] = Field(default=None, alias="BackendType", description="MCP服务的后端服务的类型，取值： - Function：veFaaS函数。 - Domain：固定域名。")
    m_c_p_service_id: str = Field(..., alias="MCPServiceId", description="MCP服务ID。")
    backend_configuration: Optional[BackendConfiguration] = Field(default=None, alias="BackendConfiguration")
    inbound_authorizer_configuration: Optional[InboundAuthorizerConfiguration] = Field(default=None, alias="InboundAuthorizerConfiguration")
    network_configurations: Optional[list[NetworkConfigurationsItem]] = Field(default=None, alias="NetworkConfigurations")
    outbound_authorizer_configuration: Optional[OutboundAuthorizerConfiguration] = Field(default=None, alias="OutboundAuthorizerConfiguration")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# UpdateMCPService - Response
class UpdateMCPServiceResponse(BaseModel):
    m_c_p_service_id: Optional[str] = Field(default=None, alias="MCPServiceId", description="MCP服务ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetMCPService - Request
class GetMCPServiceRequest(BaseModel):
    m_c_p_service_id: str = Field(..., alias="MCPServiceId", description="MCP服务ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetMCPService - Response
class GetMCPServiceResponse(BaseModel):
    m_c_p_service: Optional[MCPServiceForGetMCPService] = Field(default=None, alias="MCPService", description="MCP服务详情。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetMCPToolset - Request
class GetMCPToolsetRequest(BaseModel):
    m_c_p_toolset_id: str = Field(..., alias="MCPToolsetId", description="MCP工具集ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetMCPToolset - Response
class GetMCPToolsetResponse(BaseModel):
    m_c_p_toolset: Optional[MCPToolsetForGetMCPToolset] = Field(default=None, alias="MCPToolset", description="MCP工具集信息。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# UpdateMCPTools - Request
class UpdateMCPToolsRequest(BaseModel):
    m_c_p_service_id: str = Field(..., alias="MCPServiceId", description="MCP工具集ID。")
    tools: str = Field(..., alias="Tools", description="MCP工具集关联的MCP服务。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# UpdateMCPTools - Response
class UpdateMCPToolsResponse(BaseModel):
    m_c_p_service_id: Optional[str] = Field(default=None, alias="MCPServiceId", description="MCP服务ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# UpdateMCPToolset - Request
class AuthorizerConfiguration(BaseModel):
    authorizer_type: str = Field(..., alias="AuthorizerType", description="MCP服务访问后端服务时的认证类型，取值： - ApiKey：当前仅支持APIKey。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class Authorizer(BaseModel):
    key_auth: Optional[KeyAuth] = Field(default=None, alias="KeyAuth")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class KeyAuth(BaseModel):
    api_key_location: Optional[str] = Field(default=None, alias="ApiKeyLocation", description="访问MCP工具集网关，APIKey传递的位置。取值： - HEADER：当前仅支持Header。")
    parameter: Optional[str] = Field(default=None, alias="Parameter", description="访问MCP工具集时，需要携带的Header的APIKey对应的名称。 ::: tip 当`AuthorizerType`取值为ApiKey时必填。 :::")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class ApiKeysItem(BaseModel):
    name: str = Field(..., alias="Name", description="MCP工具集身份认证鉴权的APIKey名称。 - 参数 - N：表示APIKey名称的序号，取值范围：1～5。 - 多个字段名之间用&分隔。 - 长度为4 ～ 64的字符串。 - 由字母、数字、“-”和“_”组成。 ::: tip 当`AuthorizerType`取值为ApiKey时必填。 :::")
    key: Optional[str] = Field(default=None, alias="Key", description="MCP工具集身份认证鉴权的APIKey。 - 参数 - N：表示APIKey值的序号，取值范围：1～5。 - 多个字段名之间用&分隔。 - 不填则默认随机生成一个字符串。 ::: tip 当`AuthorizerType`取值为ApiKey时必填。 :::")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class UpdateMCPToolsetRequest(BaseModel):
    client_token: Optional[str] = Field(default=None, alias="ClientToken", description="保证请求幂等性。由客户端自动生成一个参数值，确保不同请求间该参数值唯一，避免当调用API超时或服务器内部错误时，客户端多次重试导致重复性操作。 取值：仅支持ASCII字符，且不能超过64个字符。")
    m_c_p_service_ids: Optional[str] = Field(default=None, alias="MCPServiceIds", description="MCP服务。 - 参数 - N：表示MCP服务的序号，取值范围：1～100。 - 多个字段名之间用&分隔。")
    m_c_p_toolset_id: str = Field(..., alias="MCPToolsetId", description="MCP工具集ID。")
    authorizer_configuration: Optional[AuthorizerConfiguration] = Field(default=None, alias="AuthorizerConfiguration")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# UpdateMCPToolset - Response
class UpdateMCPToolsetResponse(BaseModel):
    m_c_p_toolset_id: Optional[str] = Field(default=None, alias="MCPToolsetId", description="MCP工具集ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# DeleteMCPService - Request
class DeleteMCPServiceRequest(BaseModel):
    m_c_p_service_id: str = Field(..., alias="MCPServiceId", description="MCP服务ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# DeleteMCPService - Response
class DeleteMCPServiceResponse(BaseModel):
    m_c_p_service_id: Optional[str] = Field(default=None, alias="MCPServiceId", description="MCP服务ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }

