# Copyright (c) 2025 Beijing Volcano Engine Technology Co., Ltd. and/or its affiliates.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated from API JSON definition
# Do not edit manually

from __future__ import annotations

from typing import Optional, List, Dict, Any
from pydantic import BaseModel, Field


# Data Types
class StrategiesForUpdateMemoryCollection(BaseModel):
    custom_extraction_instructions: Optional[str] = Field(default=None, alias="CustomExtractionInstructions")
    name: Optional[str] = Field(default=None, alias="Name")
    type: Optional[str] = Field(default=None, alias="Type")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class LongTermConfigurationForUpdateMemoryCollection(BaseModel):
    strategies: Optional[list[StrategiesForUpdateMemoryCollection]] = Field(default=None, alias="Strategies")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class CollectionsForAddMemoryCollection(BaseModel):
    memory_id: Optional[str] = Field(default=None, alias="MemoryId")
    message: Optional[str] = Field(default=None, alias="Message")
    provider_collection_id: Optional[str] = Field(default=None, alias="ProviderCollectionId")
    provider_type: Optional[str] = Field(default=None, alias="ProviderType")
    status: Optional[str] = Field(default=None, alias="Status")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class ConnectionInfosForGetMemoryConnectionInfo(BaseModel):
    auth_key: Optional[str] = Field(default=None, alias="AuthKey")
    auth_type: Optional[str] = Field(default=None, alias="AuthType")
    base_url: Optional[str] = Field(default=None, alias="BaseUrl")
    expire_at: Optional[str] = Field(default=None, alias="ExpireAt")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class StrategiesForGetMemoryCollection(BaseModel):
    custom_extraction_instructions: Optional[str] = Field(default=None, alias="CustomExtractionInstructions")
    name: Optional[str] = Field(default=None, alias="Name")
    type: Optional[str] = Field(default=None, alias="Type")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class LongTermConfigurationForGetMemoryCollection(BaseModel):
    strategies: Optional[list[StrategiesForGetMemoryCollection]] = Field(default=None, alias="Strategies")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class MemoriesForListMemoryCollections(BaseModel):
    create_time: Optional[str] = Field(default=None, alias="CreateTime")
    description: Optional[str] = Field(default=None, alias="Description")
    last_update_time: Optional[str] = Field(default=None, alias="LastUpdateTime")
    managed: Optional[bool] = Field(default=None, alias="Managed")
    memory_id: Optional[str] = Field(default=None, alias="MemoryId")
    name: Optional[str] = Field(default=None, alias="Name")
    project_name: Optional[str] = Field(default=None, alias="ProjectName")
    provider_collection_id: Optional[str] = Field(default=None, alias="ProviderCollectionId")
    provider_type: Optional[str] = Field(default=None, alias="ProviderType")
    status: Optional[str] = Field(default=None, alias="Status")
    strategies_count: Optional[int] = Field(default=None, alias="StrategiesCount")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# UpdateMemoryCollection - Request
class LongTermConfiguration(BaseModel):
    pass
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class StrategiesItem(BaseModel):
    name: str = Field(..., alias="Name", description="长期记忆提取策略的名称。 - 参数 - N：表示策略的序号，取值范围：1～5。 - 多个字段名之间用&分隔。 命名规则如下： - 只能包含英文字符[A-Za-z]、数字和下划线“_”。 - 长度限制在1～48个字符之间。 ::: tip 同一个记忆库中，策略名称不可以重复。 :::")
    type: str = Field(..., alias="Type", description="长期记忆提取策略的类型。 - 参数 - N：表示策略的序号，取值范围：1～5。 - 多个字段名之间用&分隔。 - 取值： - Summary：会话摘要（会话级别）。 - Semantic：语义记忆（用户级别）。 - UserPreference：用户偏好（用户级别）。")
    custom_extraction_instructions: Optional[str] = Field(default=None, alias="CustomExtractionInstructions", description="自定义策略的系统提示词（Prompt）。 - 参数 - N：表示策略的序号，取值范围：1～5。 - 最大长度不超过8000个字符。 ::: tip 不含Prompt的策略即为内置策略，每种策略类型的内置策略最多只能有一个。 :::")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class UpdateMemoryCollectionRequest(BaseModel):
    description: Optional[str] = Field(default=None, alias="Description", description="记忆库描述。最多允许输入200个字符。")
    memory_id: str = Field(..., alias="MemoryId", description="记忆库ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# UpdateMemoryCollection - Response
class UpdateMemoryCollectionResponse(BaseModel):
    long_term_configuration: Optional[LongTermConfigurationForUpdateMemoryCollection] = Field(default=None, alias="LongTermConfiguration")
    memory_id: Optional[str] = Field(default=None, alias="MemoryId", description="记忆库ID。")
    provider_collection_id: Optional[str] = Field(default=None, alias="ProviderCollectionId", description="已导入的记忆库ID。")
    provider_type: Optional[str] = Field(default=None, alias="ProviderType", description="记忆库类型，取值： - MEM0：Mem0记忆库。 - VIKINGDB_MEMORY：Viking长期记忆。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# AddMemoryCollection - Request
class CollectionsItem(BaseModel):
    provider_collection_id: str = Field(..., alias="ProviderCollectionId", description="待导入记忆库的ID。 - 参数 - N：表示记忆库的序号。 - 多个字段名之间用&分隔。 取值： - Mem0：填入Mem0项目的ID，即project_id。 - Viking：填入CollectionName。")
    description: Optional[str] = Field(default=None, alias="Description", description="待导入记忆库的描述。 - 参数 - N：表示记忆库的序号。 - 最多允许输入200个字符，不填默认为空。 - 多个字段名之间用&分隔。")
    name: Optional[str] = Field(default=None, alias="Name", description="待导入记忆库名称。 - 参数 - N：表示记忆库的序号。 - 多个字段名之间用&分隔。 取值： - Mem0：填入Mem0项目的名称，即ProjectName。 - Viking：填入CollectionName。")
    project_name: Optional[str] = Field(default=None, alias="ProjectName")
    provider_type: Optional[str] = Field(default=None, alias="ProviderType", description="待导入记忆库的类型。 - 参数 - N：表示记忆库的序号。 - 多个字段名之间用&分隔。 - 取值： - MEM0：Mem0记忆库。 - VIKINGDB_MEMORY：Viking长期记忆。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class AddMemoryCollectionRequest(BaseModel):
    client_token: Optional[str] = Field(default=None, alias="ClientToken", description="保证请求幂等性。由客户端自动生成一个参数值，确保不同请求间该参数值唯一，避免当调用API超时或服务器内部错误时，客户端多次重试导致重复性操作。 取值：仅支持ASCII字符，且不能超过64个字符。")
    collections: Optional[list[CollectionsItem]] = Field(default=None, alias="Collections")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# AddMemoryCollection - Response
class AddMemoryCollectionResponse(BaseModel):
    collections: Optional[list[CollectionsForAddMemoryCollection]] = Field(default=None, alias="Collections", description="已导入记忆库信息。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetMemoryConnectionInfo - Request
class GetMemoryConnectionInfoRequest(BaseModel):
    memory_id: str = Field(..., alias="MemoryId", description="记忆库ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetMemoryConnectionInfo - Response
class GetMemoryConnectionInfoResponse(BaseModel):
    connection_infos: Optional[list[ConnectionInfosForGetMemoryConnectionInfo]] = Field(default=None, alias="ConnectionInfos", description="长期记忆提取策略信息。")
    managed: Optional[bool] = Field(default=None, alias="Managed", description="记忆库是否由Agentkit平台管理，取值： - true：表示由Agentkit平台创建，删除时会同时删除对应平台的资源。 - false：表示由提供商平台导入，删除时保留对应平台的资源。")
    memory_id: Optional[str] = Field(default=None, alias="MemoryId", description="记忆库ID。")
    message: Optional[str] = Field(default=None, alias="Message", description="状态消息，包含额外的状态信息或错误描述。")
    provider_collection_id: Optional[str] = Field(default=None, alias="ProviderCollectionId", description="已导入的记忆库ID。")
    provider_type: Optional[str] = Field(default=None, alias="ProviderType", description="记忆库类型，取值： - MEM0：Mem0记忆库。 - VIKINGDB_MEMORY：Viking长期记忆。")
    status: Optional[str] = Field(default=None, alias="Status", description="记忆库状态，取值： - Creating：创建中。 - CreateFailed：创建失败。 - Ready：可用。 - Deleting：删除中。 - DeleteFailed：删除失败。 - Deleted：已删除。 - Error：错误。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# DeleteMemoryCollection - Request
class DeleteMemoryCollectionRequest(BaseModel):
    memory_id: str = Field(..., alias="MemoryId", description="记忆库ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# DeleteMemoryCollection - Response
class DeleteMemoryCollectionResponse(BaseModel):
    memory_id: Optional[str] = Field(default=None, alias="MemoryId", description="记忆库ID。")
    provider_collection_id: Optional[str] = Field(default=None, alias="ProviderCollectionId", description="已导入的记忆库ID。")
    provider_type: Optional[str] = Field(default=None, alias="ProviderType", description="导入记忆库的类型，取值： - MEM0：Mem0记忆库。 - VIKINGDB_MEMORY：Viking长期记忆。")
    status: Optional[str] = Field(default=None, alias="Status", description="记忆库状态，取值： - Creating：创建中。 - CreateFailed：创建失败。 - Ready：可用。 - Deleting：删除中。 - DeleteFailed：删除失败。 - Deleted：已删除。 - Error：错误。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetMemoryCollection - Request
class GetMemoryCollectionRequest(BaseModel):
    memory_id: str = Field(..., alias="MemoryId", description="记忆库ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetMemoryCollection - Response
class GetMemoryCollectionResponse(BaseModel):
    create_time: Optional[str] = Field(default=None, alias="CreateTime", description="记忆库创建时间。")
    description: Optional[str] = Field(default=None, alias="Description", description="记忆库描述。")
    last_update_time: Optional[str] = Field(default=None, alias="LastUpdateTime", description="记忆库更新时间。")
    long_term_configuration: Optional[LongTermConfigurationForGetMemoryCollection] = Field(default=None, alias="LongTermConfiguration", description="长期记忆提取策略信息。")
    managed: Optional[bool] = Field(default=None, alias="Managed", description="记忆库是否由Agentkit平台管理，取值： - true：表示由Agentkit平台创建，删除时会同时删除对应平台的资源。 - false：表示由提供商平台导入，删除时保留对应平台的资源。")
    memory_id: Optional[str] = Field(default=None, alias="MemoryId", description="记忆库ID。")
    name: Optional[str] = Field(default=None, alias="Name", description="记忆库名称。")
    project_name: Optional[str] = Field(default=None, alias="ProjectName")
    provider_collection_id: Optional[str] = Field(default=None, alias="ProviderCollectionId", description="已导入的记忆库ID。")
    provider_type: Optional[str] = Field(default=None, alias="ProviderType", description="记忆库类型，取值： - MEM0：Mem0记忆库。 - VIKINGDB_MEMORY：Viking长期记忆。")
    status: Optional[str] = Field(default=None, alias="Status", description="记忆库状态，取值： - Creating：创建中。 - CreateFailed：创建失败。 - Ready：可用。 - Deleting：删除中。 - DeleteFailed：删除失败。 - Deleted：已删除。 - Error：错误。")
    trn: Optional[str] = Field(default=None, alias="Trn", description="记忆库的TRN。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListMemoryCollections - Request
class FiltersItem(BaseModel):
    name: Optional[str] = Field(default=None, alias="Name", description="精确过滤的字段名。 - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔，为“或”的关系。 - 取值： - collection_id：记忆库ID。 - name：记忆库名称。 - description：记忆库描述。 - status：记忆库状态。 - provider_type：导入的知识库平台类型。 ::: tip 当`Filters.N.Name`和`Filters.N.NameContains`同时传入时，仅`Filters.N.Name`生效。 :::")
    name_contains: Optional[str] = Field(default=None, alias="NameContains", description="模糊过滤的字段名。 - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔，为“或”的关系。 - 取值： - collection_id：记忆库ID。 - name：记忆库名称。 - description：记忆库描述。 - status：记忆库状态。 - provider_type：导入的知识库平台类型。 ::: tip 当`Filters.N.Name`和`Filters.N.NameContains`同时传入时，仅`Filters.N.Name`生效。 :::")
    values: Optional[list[str]] = Field(default=None, alias="Values", description="过滤字段的值。 - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔。 当过滤条件为status时，取值： - Creating：创建中。 - CreateFailed：创建失败。 - Ready：可用。 - Deleting：删除中。 - DeleteFailed：删除失败。 - Deleted：已删除。 - Error：错误。 当过滤条件为provider_type时，取值： - MEM0：Mem0记忆库。 - VIKINGDB_MEMORY：Viking长期记忆。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class ListMemoryCollectionsRequest(BaseModel):
    create_time_after: Optional[str] = Field(default=None, alias="CreateTimeAfter", description="筛选该时间点后创建的记忆库。（RFC3339格式）")
    create_time_before: Optional[str] = Field(default=None, alias="CreateTimeBefore", description="筛选该时间点前创建的记忆库。（RFC3339格式）")
    max_results: Optional[int] = Field(default=None, alias="MaxResults", description="分页查询时设置的每页行数。 - 最小值：1。 - 最大值：100。 - 默认值：10。")
    next_token: Optional[str] = Field(default=None, alias="NextToken", description="分页查询凭证，用于标记分页的位置，初次调用该接口时无需设置。下次查询时，取值为上一次API调用返回的`NextToken`参数值。")
    project_name: Optional[str] = Field(default=None, alias="ProjectName")
    update_time_after: Optional[str] = Field(default=None, alias="UpdateTimeAfter", description="筛选该时间点后更新的记忆库。（RFC3339格式）")
    update_time_before: Optional[str] = Field(default=None, alias="UpdateTimeBefore", description="筛选该时间点前更新的记忆库。（RFC3339格式）")
    filters: Optional[list[FiltersItem]] = Field(default=None, alias="Filters")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListMemoryCollections - Response
class ListMemoryCollectionsResponse(BaseModel):
    memories: Optional[list[MemoriesForListMemoryCollections]] = Field(default=None, alias="Memories", description="符合条件的记忆库信息。")
    page_number: Optional[int] = Field(default=None, alias="PageNumber")
    page_size: Optional[int] = Field(default=None, alias="PageSize")
    total_count: Optional[int] = Field(default=None, alias="TotalCount", description="符合条件的记忆库合集。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# CreateMemoryCollection - Request
class LongTermConfiguration(BaseModel):
    pass
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class StrategiesItem(BaseModel):
    name: str = Field(..., alias="Name", description="长期记忆提取策略的名称。 - 参数 - N：表示策略的序号，取值范围：1～5。 - 多个字段名之间用&分隔。 命名规则如下： - 只能包含英文字符[A-Za-z]、数字和下划线“_”。 - 长度限制在1～48个字符之间。 ::: tip 同一个记忆库中，策略名称不可以重复。 :::")
    type: str = Field(..., alias="Type", description="长期记忆提取策略的类型。 - 参数 - N：表示策略的序号，取值范围：1～5。 - 多个字段名之间用&分隔。 - 取值： - Summary：会话摘要（会话级别）。 - Semantic：语义记忆（用户级别）。 - UserPreference：用户偏好（用户级别）。")
    custom_extraction_instructions: Optional[str] = Field(default=None, alias="CustomExtractionInstructions", description="自定义策略的系统提示词（Prompt）。 - 参数 - N：表示策略的序号，取值范围：1～5。 - 最大长度不超过8000个字符。 ::: tip 不含Prompt的策略即为内置策略，每种策略类型的内置策略最多只能有一个。 :::")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class CreateMemoryCollectionRequest(BaseModel):
    client_token: Optional[str] = Field(default=None, alias="ClientToken", description="保证请求幂等性。由客户端自动生成一个参数值，确保不同请求间该参数值唯一，避免当调用API超时或服务器内部错误时，客户端多次重试导致重复性操作。 取值：仅支持ASCII字符，且不能超过64个字符。")
    description: Optional[str] = Field(default=None, alias="Description", description="记忆库的描述。 - 最多允许输入200个字符。 - 不填默认为空。")
    name: str = Field(..., alias="Name", description="记忆库名称，取值： - 只能包含英文字符[A-Za-z]、数字和下划线“_”。 - 长度限制在1～48个字符之间。")
    project_name: Optional[str] = Field(default=None, alias="ProjectName")
    provider_type: Optional[str] = Field(default=None, alias="ProviderType", description="记忆库类型，取值： - MEM0（默认）：Mem0记忆库。 - VIKINGDB_MEMORY：Viking长期记忆。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# CreateMemoryCollection - Response
class CreateMemoryCollectionResponse(BaseModel):
    memory_id: Optional[str] = Field(default=None, alias="MemoryId", description="记忆库ID。")
    provider_collection_id: Optional[str] = Field(default=None, alias="ProviderCollectionId", description="已导入的记忆库ID。")
    provider_type: Optional[str] = Field(default=None, alias="ProviderType", description="记忆库类型。")
    status: Optional[str] = Field(default=None, alias="Status", description="记忆库状态，取值： - Creating：创建中。 - CreateFailed：创建失败。 - Ready：可用。 - Deleting：删除中。 - DeleteFailed：删除失败。 - Deleted：已删除。 - Error：错误。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }

