# Copyright (c) 2025 Beijing Volcano Engine Technology Co., Ltd. and/or its affiliates.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated from API JSON definition
# Do not edit manually

from __future__ import annotations

from typing import Optional, List, Dict, Any
from pydantic import BaseModel, Field


# Data Types
class KeyAuthForGetRuntimeVersion(BaseModel):
    api_key: Optional[str] = Field(default=None, alias="ApiKey")
    api_key_location: Optional[str] = Field(default=None, alias="ApiKeyLocation")
    api_key_name: Optional[str] = Field(default=None, alias="ApiKeyName")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class AuthorizerConfigurationForGetRuntimeVersion(BaseModel):
    key_auth: Optional[KeyAuthForGetRuntimeVersion] = Field(default=None, alias="KeyAuth")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class EnvsForGetRuntimeVersion(BaseModel):
    key: Optional[str] = Field(default=None, alias="Key")
    value: Optional[str] = Field(default=None, alias="Value")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class CrRegistriesForListRuntimeCrRegistries(BaseModel):
    artifact_url: Optional[str] = Field(default=None, alias="ArtifactUrl")
    description: Optional[str] = Field(default=None, alias="Description")
    framework_type: Optional[str] = Field(default=None, alias="FrameworkType")
    language: Optional[str] = Field(default=None, alias="Language")
    tag: Optional[str] = Field(default=None, alias="Tag")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class KeyAuthForGetRuntime(BaseModel):
    api_key: Optional[str] = Field(default=None, alias="ApiKey")
    api_key_location: Optional[str] = Field(default=None, alias="ApiKeyLocation")
    api_key_name: Optional[str] = Field(default=None, alias="ApiKeyName")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class AuthorizerConfigurationForGetRuntime(BaseModel):
    key_auth: Optional[KeyAuthForGetRuntime] = Field(default=None, alias="KeyAuth")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class EnvsForGetRuntime(BaseModel):
    key: Optional[str] = Field(default=None, alias="Key")
    value: Optional[str] = Field(default=None, alias="Value")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class KeyAuthForListRuntimeVersions(BaseModel):
    api_key: Optional[str] = Field(default=None, alias="ApiKey")
    api_key_location: Optional[str] = Field(default=None, alias="ApiKeyLocation")
    api_key_name: Optional[str] = Field(default=None, alias="ApiKeyName")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class AuthorizerConfigurationForListRuntimeVersions(BaseModel):
    key_auth: Optional[KeyAuthForListRuntimeVersions] = Field(default=None, alias="KeyAuth")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class EnvsForListRuntimeVersions(BaseModel):
    key: Optional[str] = Field(default=None, alias="Key")
    value: Optional[str] = Field(default=None, alias="Value")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class AgentKitRuntimeVersionsForListRuntimeVersions(BaseModel):
    apmplus_enable: Optional[bool] = Field(default=None, alias="ApmplusEnable")
    artifact_type: Optional[str] = Field(default=None, alias="ArtifactType")
    artifact_url: Optional[str] = Field(default=None, alias="ArtifactUrl")
    authorizer_configuration: Optional[AuthorizerConfigurationForListRuntimeVersions] = Field(default=None, alias="AuthorizerConfiguration")
    command: Optional[str] = Field(default=None, alias="Command")
    cpu_milli: Optional[int] = Field(default=None, alias="CpuMilli")
    created_at: Optional[str] = Field(default=None, alias="CreatedAt")
    description: Optional[str] = Field(default=None, alias="Description")
    envs: Optional[list[EnvsForListRuntimeVersions]] = Field(default=None, alias="Envs")
    memory_mb: Optional[int] = Field(default=None, alias="MemoryMb")
    role_name: Optional[str] = Field(default=None, alias="RoleName")
    runtime_id: Optional[str] = Field(default=None, alias="RuntimeId")
    status: Optional[str] = Field(default=None, alias="Status")
    updated_at: Optional[str] = Field(default=None, alias="UpdatedAt")
    version_number: Optional[int] = Field(default=None, alias="VersionNumber")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class KeyAuthForListRuntimes(BaseModel):
    api_key: Optional[str] = Field(default=None, alias="ApiKey")
    api_key_location: Optional[str] = Field(default=None, alias="ApiKeyLocation")
    api_key_name: Optional[str] = Field(default=None, alias="ApiKeyName")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class AuthorizerConfigurationForListRuntimes(BaseModel):
    key_auth: Optional[KeyAuthForListRuntimes] = Field(default=None, alias="KeyAuth")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class EnvsForListRuntimes(BaseModel):
    key: Optional[str] = Field(default=None, alias="Key")
    value: Optional[str] = Field(default=None, alias="Value")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class AgentKitRuntimesForListRuntimes(BaseModel):
    apmplus_enable: Optional[bool] = Field(default=None, alias="ApmplusEnable")
    artifact_type: Optional[str] = Field(default=None, alias="ArtifactType")
    artifact_url: Optional[str] = Field(default=None, alias="ArtifactUrl")
    authorizer_configuration: Optional[AuthorizerConfigurationForListRuntimes] = Field(default=None, alias="AuthorizerConfiguration")
    command: Optional[str] = Field(default=None, alias="Command")
    cpu_milli: Optional[int] = Field(default=None, alias="CpuMilli")
    created_at: Optional[str] = Field(default=None, alias="CreatedAt")
    current_version_number: Optional[int] = Field(default=None, alias="CurrentVersionNumber")
    description: Optional[str] = Field(default=None, alias="Description")
    endpoint: Optional[str] = Field(default=None, alias="Endpoint")
    envs: Optional[list[EnvsForListRuntimes]] = Field(default=None, alias="Envs")
    memory_mb: Optional[int] = Field(default=None, alias="MemoryMb")
    name: Optional[str] = Field(default=None, alias="Name")
    role_name: Optional[str] = Field(default=None, alias="RoleName")
    runtime_id: Optional[str] = Field(default=None, alias="RuntimeId")
    status: Optional[str] = Field(default=None, alias="Status")
    updated_at: Optional[str] = Field(default=None, alias="UpdatedAt")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetRuntimeVersion - Request
class GetRuntimeVersionRequest(BaseModel):
    runtime_id: str = Field(..., alias="RuntimeId", description="运行时ID。")
    version_number: Optional[int] = Field(default=None, alias="VersionNumber", description="运行时版本号。不填默认为0，表示最新版本。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetRuntimeVersion - Response
class GetRuntimeVersionResponse(BaseModel):
    apmplus_enable: Optional[bool] = Field(default=None, alias="ApmplusEnable", description="是否开启APMPlus 服务。包括： - true：开启。 - false：不开启。")
    artifact_type: Optional[str] = Field(default=None, alias="ArtifactType", description="运行时镜像类型。取值： - image: 自定义镜像，当前只支持image。")
    artifact_url: Optional[str] = Field(default=None, alias="ArtifactUrl", description="运行时镜像的URL。")
    authorizer_configuration: Optional[AuthorizerConfigurationForGetRuntimeVersion] = Field(default=None, alias="AuthorizerConfiguration", description="运行时认证配置信息。目前只支持KeyAuth认证配置。")
    command: Optional[str] = Field(default=None, alias="Command", description="运行时启动命令。")
    cpu_milli: Optional[int] = Field(default=None, alias="CpuMilli", description="单实例最大CPU。单位：milli cpu。")
    created_at: Optional[str] = Field(default=None, alias="CreatedAt", description="版本创建时间。")
    description: Optional[str] = Field(default=None, alias="Description", description="运行时描述。")
    endpoint: Optional[str] = Field(default=None, alias="Endpoint", description="运行时访问域名。")
    envs: Optional[list[EnvsForGetRuntimeVersion]] = Field(default=None, alias="Envs", description="运行时环境变量。")
    name: Optional[str] = Field(default=None, alias="Name", description="运行时名称。")
    project_name: Optional[str] = Field(default=None, alias="ProjectName", description="运行时所属项目名称。")
    role_name: Optional[str] = Field(default=None, alias="RoleName", description="运行时绑定的IAM角色名称。")
    runtime_id: Optional[str] = Field(default=None, alias="RuntimeId", description="运行时ID。")
    status: Optional[str] = Field(default=None, alias="Status", description="运行时状态。取值： - Creating：创建中。 - Error： 错误。 - Releasing： 发布中。 - Ready： 运行中。 - Deleting： 删除中。 - Deleted： 已删除。 - Updating： 更新中。 - UnReleased： 未发布。")
    updated_at: Optional[str] = Field(default=None, alias="UpdatedAt", description="版本更新时间。")
    version_number: Optional[int] = Field(default=None, alias="VersionNumber", description="运行时版本号。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListRuntimeCrRegistries - Request
class ListRuntimeCrRegistriesRequest(BaseModel):
    page_number: Optional[int] = Field(default=None, alias="PageNumber")
    page_size: Optional[int] = Field(default=None, alias="PageSize")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListRuntimeCrRegistries - Response
class ListRuntimeCrRegistriesResponse(BaseModel):
    cr_registries: Optional[list[CrRegistriesForListRuntimeCrRegistries]] = Field(default=None, alias="CrRegistries")
    page_number: Optional[int] = Field(default=None, alias="PageNumber")
    page_size: Optional[int] = Field(default=None, alias="PageSize")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# CreateRuntime - Request
class AuthorizerConfiguration(BaseModel):
    key_auth: Optional[KeyAuth] = Field(default=None, alias="KeyAuth")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class KeyAuth(BaseModel):
    api_key: Optional[str] = Field(default=None, alias="ApiKey", description="运行时的入口鉴权ApiKey，允许为空，留空默认随机生成一个字符串。 用户访问运行时需要携带这个Key。")
    api_key_location: Optional[str] = Field(default=None, alias="ApiKeyLocation", description="用户访问运行时实例时，APIKey传递的位置。 - Header：当前仅支持Header。")
    api_key_name: Optional[str] = Field(default=None, alias="ApiKeyName", description="运行时服务的入口鉴权APIKey名字。 - 不能为空，长度为4 ～ 64的字符串。 - 由字母、数字、“-”和“_”组成")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }
class EnvsItem(BaseModel):
    key: str = Field(..., alias="Key", description="运行时环境变量的键。 - 1 ~ 63 个字符，字符中可包含英文、数字以及下划线（_），并且不能以数字开头。 - 同一运行时下 Key 唯一。")
    value: str = Field(..., alias="Value", description="运行时环境变量的值。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class CreateRuntimeRequest(BaseModel):
    apmplus_enable: Optional[bool] = Field(default=None, alias="ApmplusEnable", description="是否开启APMPlus服务以提供对Runtime的监控。取值： - true（默认）：开启。 - false：不开启。")
    artifact_type: str = Field(..., alias="ArtifactType", description="镜像类型。取值： - image：自定义镜像，当前仅支持image。")
    artifact_url: str = Field(..., alias="ArtifactUrl", description="镜像URL。格式为<host/namespace/repo:tag>的镜像地址。")
    client_token: Optional[str] = Field(default=None, alias="ClientToken", description="保证请求幂等性。由客户端自动生成一个参数值，确保不同请求间该参数值唯一，避免当调用API超时或服务器内部错误时，客户端多次重试导致重复性操作。 取值：仅支持ASCII字符，且不能超过64个字符。")
    description: Optional[str] = Field(default=None, alias="Description", description="运行时描述。 - 长度限制为 1000 以内的 Unicode 字符。 - 不填默认为空。")
    name: str = Field(..., alias="Name", description="运行时名称。 - 长度为4 ～ 64的字符串。 - 由字母、数字、“-”和“_”组成。")
    role_name: str = Field(..., alias="RoleName", description="运行时绑定的IAM角色名称。")
    authorizer_configuration: Optional[AuthorizerConfiguration] = Field(default=None, alias="AuthorizerConfiguration")
    envs: Optional[list[EnvsItem]] = Field(default=None, alias="Envs")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# CreateRuntime - Response
class CreateRuntimeResponse(BaseModel):
    runtime_id: Optional[str] = Field(default=None, alias="RuntimeId", description="运行时ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetRuntime - Request
class GetRuntimeRequest(BaseModel):
    runtime_id: str = Field(..., alias="RuntimeId", description="运行时ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetRuntime - Response
class GetRuntimeResponse(BaseModel):
    apmplus_enable: Optional[bool] = Field(default=None, alias="ApmplusEnable", description="是否开启APMPlus 服务。包括： - true：开启。 - false：不开启。")
    artifact_type: Optional[str] = Field(default=None, alias="ArtifactType", description="镜像类型。取值： - image：自定义镜像，当前仅支持image。")
    artifact_url: Optional[str] = Field(default=None, alias="ArtifactUrl", description="镜像URL。格式为<host/namespace/repo:tag>的镜像地址。")
    authorizer_configuration: Optional[AuthorizerConfigurationForGetRuntime] = Field(default=None, alias="AuthorizerConfiguration", description="运行时认证配置信息。目前只支持KeyAuth认证配置。")
    command: Optional[str] = Field(default=None, alias="Command", description="运行时启动命令。")
    cpu_milli: Optional[int] = Field(default=None, alias="CpuMilli", description="单实例最大CPU。单位：milli cpu。")
    created_at: Optional[str] = Field(default=None, alias="CreatedAt", description="运行时创建时间。")
    current_version_number: Optional[int] = Field(default=None, alias="CurrentVersionNumber", description="当前生效版本号。")
    description: Optional[str] = Field(default=None, alias="Description", description="运行时描述。")
    endpoint: Optional[str] = Field(default=None, alias="Endpoint", description="运行时访问域名。")
    envs: Optional[list[EnvsForGetRuntime]] = Field(default=None, alias="Envs", description="运行时环境变量。")
    failed_log_file_url: Optional[str] = Field(default=None, alias="FailedLogFileUrl")
    memory_mb: Optional[int] = Field(default=None, alias="MemoryMb", description="单实例最大内存，单位 MB。")
    name: Optional[str] = Field(default=None, alias="Name", description="运行时名称。")
    project_name: Optional[str] = Field(default=None, alias="ProjectName", description="运行时所属项目名称。")
    role_name: Optional[str] = Field(default=None, alias="RoleName", description="运行时绑定的IAM角色名称。")
    runtime_id: Optional[str] = Field(default=None, alias="RuntimeId", description="运行时ID。")
    status: Optional[str] = Field(default=None, alias="Status", description="运行时状态，取值： - Creating：正在创建中。 - Error： 错误。 - Releasing： 发布中。 - Ready： 运行中。 - Deleting： 删除中。 - Deleted： 已删除。 - Updating： 更新中。 - UnReleased： 未发布。")
    status_message: Optional[str] = Field(default=None, alias="StatusMessage", description="当前状态的详细信息，作为发布状态的补充。例如启动失败的原因。")
    updated_at: Optional[str] = Field(default=None, alias="UpdatedAt", description="运行时更新时间。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# UpdateRuntime - Request
class EnvsItem(BaseModel):
    key: str = Field(..., alias="Key", description="运行时环境变量的键。 - 1 ~ 63 个字符，字符中可包含英文、数字以及下划线（_），并且不能以数字开头。 - 同一运行时下 Key 唯一。")
    value: str = Field(..., alias="Value", description="运行时环境变量的值。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class UpdateRuntimeRequest(BaseModel):
    apmplus_enable: Optional[bool] = Field(default=None, alias="ApmplusEnable", description="是否开启APMPlus服务以提供对Runtime的监控。取值： - true：开启。 - false：不开启。")
    artifact_type: Optional[str] = Field(default=None, alias="ArtifactType")
    artifact_url: Optional[str] = Field(default=None, alias="ArtifactUrl", description="镜像URL。格式为<host/namespace/repo:tag>的镜像地址。")
    client_token: Optional[str] = Field(default=None, alias="ClientToken", description="保证请求幂等性。由客户端自动生成一个参数值，确保不同请求间该参数值唯一，避免当调用API超时或服务器内部错误时，客户端多次重试导致重复性操作。 取值：仅支持ASCII字符，且不能超过64个字符。")
    description: Optional[str] = Field(default=None, alias="Description", description="运行时描述。 - 长度限制为 1000 以内的 Unicode 字符。")
    release_enable: Optional[bool] = Field(default=None, alias="ReleaseEnable", description="更新完是否立即发布。取值： - true：立即发布。 - false：不立即发布。")
    role_name: Optional[str] = Field(default=None, alias="RoleName", description="运行时绑定的IAM角色名称。")
    runtime_id: str = Field(..., alias="RuntimeId", description="运行时ID。")
    envs: Optional[list[EnvsItem]] = Field(default=None, alias="Envs")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# UpdateRuntime - Response
class UpdateRuntimeResponse(BaseModel):
    runtime_id: Optional[str] = Field(default=None, alias="RuntimeId", description="运行时ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ReleaseRuntime - Request
class ReleaseRuntimeRequest(BaseModel):
    runtime_id: str = Field(..., alias="RuntimeId", description="运行时ID。")
    version_number: Optional[int] = Field(default=None, alias="VersionNumber", description="发布版本号，0：表示发布最新版本。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ReleaseRuntime - Response
class ReleaseRuntimeResponse(BaseModel):
    runtime_id: Optional[str] = Field(default=None, alias="RuntimeId", description="运行时ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetRuntimeCozeToken - Request
class GetRuntimeCozeTokenRequest(BaseModel):
    runtime_id: str = Field(..., alias="RuntimeId", description="运行时ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetRuntimeCozeToken - Response
class GetRuntimeCozeTokenResponse(BaseModel):
    jwt_token: Optional[str] = Field(default=None, alias="JwtToken", description="coze 私钥签发的秘钥。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListRuntimeVersions - Request
class ListRuntimeVersionsRequest(BaseModel):
    max_results: Optional[int] = Field(default=None, alias="MaxResults", description="分页查询时设置的每页行数。 - 最小值：1。 - 最大值：100。 - 默认值：10。")
    next_token: Optional[str] = Field(default=None, alias="NextToken", description="分页查询凭证，用于标记分页的位置，初次调用该接口时无需设置。下次查询时，取值为上一次API调用返回的`NextToken`参数值。")
    runtime_id: str = Field(..., alias="RuntimeId", description="运行时ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListRuntimeVersions - Response
class ListRuntimeVersionsResponse(BaseModel):
    agent_kit_runtime_versions: Optional[list[AgentKitRuntimeVersionsForListRuntimeVersions]] = Field(default=None, alias="AgentKitRuntimeVersions", description="运行时所有版本的详情。")
    next_token: Optional[str] = Field(default=None, alias="NextToken", description="本次调用返回的查询凭证值，返回为空表示该页为末页。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# DeleteRuntime - Request
class DeleteRuntimeRequest(BaseModel):
    client_token: Optional[str] = Field(default=None, alias="ClientToken", description="保证请求幂等性。由客户端自动生成一个参数值，确保不同请求间该参数值唯一，避免当调用API超时或服务器内部错误时，客户端多次重试导致重复性操作。 取值：仅支持ASCII字符，且不能超过64个字符。")
    runtime_id: str = Field(..., alias="RuntimeId", description="运行时ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# DeleteRuntime - Response
class DeleteRuntimeResponse(BaseModel):
    runtime_id: Optional[str] = Field(default=None, alias="RuntimeId", description="运行时ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListRuntimes - Request
class FiltersItem(BaseModel):
    name: Optional[str] = Field(default=None, alias="Name", description="精确过滤的字段名，取值： - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔，为“或”的关系。 - 取值： - Id：运行时ID。 - Name：运行时名称。 - Description：运行时描述。 - Status：运行时状态。 ::: tip 当`Filters.N.Name`和`Filters.N.NameContains`同时传入时，仅`Filters.N.Name`生效。 :::")
    name_contains: Optional[str] = Field(default=None, alias="NameContains", description="模糊过滤的字段名，取值： - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔，为“或”的关系。 - 取值： - Id：运行时ID。 - Name：运行时名称。 - Description：运行时描述。 - Status：运行时状态。 ::: tip 当`Filters.N.Name`和`Filters.N.NameContains`同时传入时，仅`Filters.N.Name`生效。 :::")
    values: Optional[list[str]] = Field(default=None, alias="Values", description="过滤字段的值。 - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔。 当过滤字段为Status时，取值： - Creating：正在创建中。 - Error： 不可用。 - Releasing： 发布中。 - Ready： 运行中。 - Deleting： 删除中。 - Deleted： 已删除。 - Updating： 更新中。 - UnReleased： 未发布")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class ListRuntimesRequest(BaseModel):
    create_time_after: Optional[str] = Field(default=None, alias="CreateTimeAfter", description="筛选该时间点后创建的运行时。（RFC3339格式）")
    create_time_before: Optional[str] = Field(default=None, alias="CreateTimeBefore", description="筛选该时间点前创建的运行时。（RFC3339格式）")
    max_results: Optional[int] = Field(default=None, alias="MaxResults", description="分页查询时设置的每页行数。 - 最小值：1。 - 最大值：100。 - 默认值：10。")
    next_token: Optional[str] = Field(default=None, alias="NextToken", description="分页查询凭证，用于标记分页的位置，初次调用该接口时无需设置。下次查询时，取值为上一次API调用返回的`NextToken`参数值。")
    update_time_after: Optional[str] = Field(default=None, alias="UpdateTimeAfter", description="筛选该时间点后更新的运行时。（RFC3339格式）")
    update_time_before: Optional[str] = Field(default=None, alias="UpdateTimeBefore", description="筛选该时间点前更新的运行时。（RFC3339格式）")
    filters: Optional[list[FiltersItem]] = Field(default=None, alias="Filters")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListRuntimes - Response
class ListRuntimesResponse(BaseModel):
    agent_kit_runtimes: Optional[list[AgentKitRuntimesForListRuntimes]] = Field(default=None, alias="AgentKitRuntimes", description="符合条件的运行时详情。")
    next_token: Optional[str] = Field(default=None, alias="NextToken", description="本次调用返回的查询凭证值，返回为空表示该页为末页。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }

